/*

    xpuyopuyo - poptions-gtk.c      Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org           http://chaos2.org/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <config.h>
#include <poptions-gtk.h>
#include <pdialog-gtk.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <psound.h>



typedef struct _poptions_config {
   int numcolors;
   int fieldwidth;
   int fieldheight;
   int fieldmatch;
   int dropspeed;
   double accel;
   bool restart;
   bool nullifyrocks;
   bool indestructibles;
   bool quiet;
   bool aiscore;
   bool aicandrop;
   #if USE_SOUND
      bool enablesound;
      bool usehqmixer;
   #endif /* Sound? */
} poptions_config;



static void p_options_check_set_active(GtkWidget *widget, gpointer data) {

   bool *chk = data;
   *chk = GTK_TOGGLE_BUTTON(widget)->active;
   return;
   
}



static void p_options_spin_set_value(GtkWidget *widget, gpointer data) {

   int *value = data;
   *value = GTK_ADJUSTMENT(widget)->value;
   return;
   
}



static void p_options_spin_set_valuef(GtkWidget *widget, gpointer data) {

   double *value = data;
   *value = GTK_ADJUSTMENT(widget)->value;
   return;
   
}



static void p_options_new_header(GtkWidget *grid, const char *name, int x, int y) {

   GtkWidget *label;

   label = gtk_label_new(name);
   gtk_table_attach(GTK_TABLE(grid), label, x,     x + 2, y, y + 1,  GTK_FILL, GTK_FILL, 2, 2);
   return;
   
}



static void p_options_new_check(GtkWidget *grid, const char *name, bool *value, int x, int y) {

   GtkWidget *check;
   GtkWidget *label;
   GtkWidget *align;

   align = gtk_alignment_new(1, 0.5, 0, 0);
   label = gtk_label_new(name);
   gtk_container_set_border_width(GTK_CONTAINER(align), 0);
   gtk_container_add(GTK_CONTAINER(align), label);

   check = gtk_check_button_new();
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), *value);
   gtk_signal_connect(GTK_OBJECT(check), "toggled", GTK_SIGNAL_FUNC(p_options_check_set_active), value);
   gtk_table_attach(GTK_TABLE(grid), align, x,     x + 1, y, y + 1,  GTK_FILL, GTK_FILL, 2, 2);
   gtk_table_attach(GTK_TABLE(grid), check, x + 1, x + 2, y, y + 1,  GTK_FILL, GTK_FILL, 2, 2);
   return;
   
}



static void p_options_new_spin(GtkWidget *grid, const char *name, int *value, int min, int max, int x, int y) {

   GtkAdjustment *spinadjust;
   GtkWidget *spin;
   GtkWidget *label;
   GtkWidget *align;

   align = gtk_alignment_new(1, 0.5, 0, 0);
   label = gtk_label_new(name);
   gtk_container_set_border_width(GTK_CONTAINER(align), 0);
   gtk_container_add(GTK_CONTAINER(align), label);

   spinadjust = (GtkAdjustment *)gtk_adjustment_new(*value, min, max, 1, 10, 10);
   spin = gtk_spin_button_new(spinadjust, 1, 0);
   gtk_spin_button_set_snap_to_ticks(GTK_SPIN_BUTTON(spin), TRUE);
   gtk_signal_connect(GTK_OBJECT(spinadjust), "value-changed", GTK_SIGNAL_FUNC(p_options_spin_set_value), value);
   gtk_table_attach(GTK_TABLE(grid), align, x,     x + 1, y, y + 1,  GTK_FILL, GTK_FILL, 2, 2);
   gtk_table_attach(GTK_TABLE(grid), spin,  x + 1, x + 2, y, y + 1,  GTK_FILL, GTK_FILL, 2, 2);
   return;
   
}



static void p_options_new_spinf(GtkWidget *grid, const char *name, double *value, double min, double max, int x, int y) {

   GtkAdjustment *spinadjust;
   GtkWidget *spin;
   GtkWidget *label;

   label = gtk_label_new(name);
   gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);

   spinadjust = (GtkAdjustment *)gtk_adjustment_new(*value, min, max, 0.005, 0.1, 0.1);
   spin = gtk_spin_button_new(spinadjust, 1, 3);
   gtk_spin_button_set_snap_to_ticks(GTK_SPIN_BUTTON(spin), FALSE);
   gtk_signal_connect(GTK_OBJECT(spinadjust), "value-changed", GTK_SIGNAL_FUNC(p_options_spin_set_valuef), value);
   gtk_table_attach(GTK_TABLE(grid), label, x,     x + 1, y, y + 1,  GTK_FILL, GTK_FILL, 2, 2);
   gtk_table_attach(GTK_TABLE(grid), spin,  x + 1, x + 2, y, y + 1,  GTK_FILL, GTK_FILL, 2, 2);
   return;
   
}



void p_options_apply(p_dialog_window *dw) {

   pwindow_gtk *w = dw->w;
   poptions_config *oc = dw->data;
   w->c->numcolors      = oc->numcolors;
   w->c->fieldwidth     = oc->fieldwidth;
   w->c->fieldheight    = oc->fieldheight;
   w->c->fieldmatch     = oc->fieldmatch;
   w->c->dropspeed      = oc->dropspeed;
   w->c->accel          = oc->accel;
   w->c->restart        = oc->restart;
   w->c->nullifyrocks   = oc->nullifyrocks;
   w->c->indestructibles= oc->indestructibles;
   w->c->quiet          = oc->quiet;
   w->c->aiscore        = oc->aiscore;
   w->c->aicandrop      = oc->aicandrop;

   #if USE_SOUND    
      if(w->c->enablesound != oc->enablesound || w->c->usehqmixer != oc->usehqmixer) {
         w->c->enablesound = oc->enablesound;
         w->c->usehqmixer = oc->usehqmixer;
         p_sound_config(&w->c->sound, w->c->enablesound, w->c->usehqmixer);
         p_sound_start(w->c->sound, P_MUSIC_PRELUDE);
      }
   #endif /* Sound? */

}



void p_options(pwindow_gtk *w) {

   poptions_config oc;
   p_dialog_window dw;
   GtkWidget *grid;
   int x;
   int y;

   oc.numcolors      = w->c->numcolors;
   oc.fieldwidth     = w->c->fieldwidth;
   oc.fieldheight    = w->c->fieldheight;
   oc.fieldmatch     = w->c->fieldmatch;
   oc.dropspeed      = w->c->dropspeed;
   oc.accel          = w->c->accel;
   oc.restart        = w->c->restart;
   oc.nullifyrocks   = w->c->nullifyrocks;
   oc.indestructibles= w->c->indestructibles;
   oc.quiet          = w->c->quiet;
   oc.aiscore        = w->c->aiscore;
   oc.aicandrop      = w->c->aicandrop;
   #if USE_SOUND
      oc.enablesound = w->c->enablesound;
      oc.usehqmixer  = w->c->usehqmixer;
   #endif /* Sound? */

   p_dialog_window_new(&dw, w, "Set Options", "Select new game options below:", P_DIALOG_QUERY);
   p_dialog_window_set_apply(&dw, p_options_apply);
   p_dialog_window_set_data(&dw, &oc);

   grid = gtk_table_new(16, 4, FALSE);
   gtk_box_pack_start(GTK_BOX(dw.container), grid, FALSE, FALSE, 0);

   x = 0;
   y = 2;

   p_options_new_header(grid, "Field Options:", x, y++);
   p_options_new_spin(grid,   "Number of colors",         &oc.numcolors,     P_COLORS_MIN,        P_COLORS_MAX,        x, y++);
   p_options_new_spin(grid,   "Field width",              &oc.fieldwidth,    P_FIELD_WIDTH_MIN,   P_FIELD_WIDTH_MAX,   x, y++);
   p_options_new_spin(grid,   "Field height",             &oc.fieldheight,   P_FIELD_WIDTH_MIN,   P_FIELD_WIDTH_MAX,   x, y++);
   p_options_new_spin(grid,   "Blobs required to match",  &oc.fieldmatch,    P_MATCH_MIN,         P_MATCH_MAX,         x, y++);

   p_options_new_header(grid, "Player Speed:", x, y++);
   p_options_new_spin(grid,   "Player speed (milliseconds/drop)", &oc.dropspeed, P_MINDROP_TIME, P_LONG_TIME, x, y++);
   p_options_new_spinf(grid,  "Player acceleration (% time lost/minute)", &oc.accel, P_ACCEL_OFF, P_ACCEL_MAX, x, y++);

   x = 2;
   y = 2;

   p_options_new_header(grid, "Toggle Options:", x, y++);   
   p_options_new_check(grid,  "Auto restart on game over",&oc.restart,       x, y++);
   p_options_new_check(grid,  "Rocks can nullify opponent's",&oc.nullifyrocks, x, y++);
   p_options_new_check(grid,  "Allow indestructible rocks", &oc.indestructibles, x, y++);
   p_options_new_check(grid,  "Be quiet (no output to stdout)", &oc.quiet, x, y++);
   
   p_options_new_header(grid, "AI Options:", x, y++);
   p_options_new_check(grid,  "Display AI threshold score",  &oc.aiscore,       x, y++);
   p_options_new_check(grid,  "AI can drop",                 &oc.aicandrop,     x, y++);
   
   #if USE_SOUND
      p_options_new_header(grid, "Sound Options:", x, y++);
      p_options_new_check(grid,  "Enable music/sound fx",       &oc.enablesound,   x, y++);
      p_options_new_check(grid,  "Use high-quality mixer",      &oc.usehqmixer,    x, y++);
   #endif /* Sound? */
   
   p_dialog_window_run(&dw);
   return;

}


