/*

    xpuyopuyo - pgraph-gtk.c           Copyright(c) 1999,2000 Justin David Smith
    justins@chaos2.org                 http://chaos2.org/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <pgraph-gtk.h>
#if !USE_LISP_AI

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <config.h>


typedef struct _pgraph_gtk {
   pwindow_gtk *w;
   GtkWidget *dialog;
   GtkWidget *da;
   GdkPixmap *buffer;
   int closed;
   int showai[P_AI_COUNT];
   GtkWidget *showck[P_AI_COUNT];
   int showcur;
   int showbase;
} pgraph_gtk;


static inline int y_to_row(int y, int h, int min, int max) {

   return(h - (y - min) * h / (max - min));

}


static void graph_draw_grid(pgraph_gtk *d) {

   char buf[P_GTK_STRING_BUFFER];
   const char *name;
   char *p;
   GdkColor gray;
   GdkColor aicolor;
   GdkFont *font;
   GdkGC   *gc;
   int value;
   int numai;
   int aiidx;
   int row;
   int lro;
   int rowb;
   int lrob;
   int min;
   int max;
   int wid;
   int i;
   int j;
   int w;
   int h;
   
   font  =  gdk_font_load("-*-helvetica-medium-r-*-*-*-80-*-*-*-*-*");
   gc    =  gdk_gc_new(d->da->window);
   
   w     =  d->da->allocation.width;
   h     =  d->da->allocation.height;
   
   min = 0;
   max = 1;
   
   for(i = 0; i < P_AI_COUNT; i++) {
      for(j = 0; j < P_AIS_NUM_RULES; j++) {
         value = p_ai_rule_of(d->w->c->airules, i, j);
         if(value > max) max = value;
         if(value < min) min = value;
         value = p_ai_default_rule_of(d->w->c->airules, i, j);
         if(value > max) max = value;
         if(value < min) min = value;
      }
   }

   if(max > 10000) max = 10000;
   if(min <-10000) min =-10000;
   /* Fill in with white */
   gdk_draw_rectangle(d->buffer, d->da->style->white_gc, TRUE, 0, 0, w - 1, h - 1);
   gdk_draw_rectangle(d->buffer, d->da->style->black_gc, FALSE,0, 0, w - 1, h - 1);

   /* Allocate colors */
   gray.red  = 0x8000;
   gray.green= 0x8000;
   gray.blue = 0x8000;
   gdk_colormap_alloc_color(gtk_widget_get_colormap(d->da), &gray, FALSE, TRUE);
   gdk_gc_set_foreground(gc, &gray);

   /* Left tickmarks */
   for(i = 0; i <= 10; i++) {
      value = min + (max - min) * i / 10;
      row = y_to_row(value, h, min, max);
      snprintf(buf, P_GTK_STRING_BUFFER, "%d", value);
      gdk_draw_line(d->buffer, d->da->style->black_gc, 0, row, 4, row);
      if(value >= 0) gdk_draw_string(d->buffer, font, gc, 2, row - 2, buf);
      else           gdk_draw_string(d->buffer, font, gc, 2, row + font->ascent + 2, buf);
   }
   row = y_to_row(0, h, min, max);
   gdk_draw_line(d->buffer, d->da->style->black_gc, 0, row, (P_AIS_NUM_RULES - 1) * w / P_AIS_NUM_RULES, row);
   gdk_draw_line(d->buffer, d->da->style->black_gc, (P_AIS_NUM_RULES - 1) * w / P_AIS_NUM_RULES, 0, (P_AIS_NUM_RULES - 1) * w / P_AIS_NUM_RULES, h);
   
   /* AI rule descriptions */
   for(j = 0; j < P_AIS_NUM_RULES; j++) {
      gdk_draw_line(d->buffer, d->da->style->black_gc, j * w / (P_AIS_NUM_RULES), h - 4, j * w / (P_AIS_NUM_RULES), h);
      strncpy(buf, p_ai_rule_name(j), P_GTK_STRING_BUFFER);
      p = buf + strlen(buf);
      while(gdk_string_width(font, buf) > w / (P_AIS_NUM_RULES) - 5 && p > buf) {
         p--;
         *p = '\0';
      }
      gdk_draw_string(d->buffer, font, gc, j * w / (P_AIS_NUM_RULES) + 2, h - 2, buf);
   }

   /* Draw AI Lines */
   for(i = 0, numai = 0; i < P_AI_COUNT; i++) {
      if(d->showai[i]) numai++;
   }
   for(i = 0, aiidx = 0; i < P_AI_COUNT; i++) {
      if(d->showai[i]) {
         aicolor.red  = (aiidx & 1)        * 0xa000;
         aicolor.green= ((aiidx >> 1) & 1) * 0x6000;
         aicolor.blue = ((aiidx >> 2) & 1) * 0xc000;
         gdk_colormap_alloc_color(gtk_widget_get_colormap(d->da), &aicolor, FALSE, TRUE);
         gdk_gc_set_foreground(gc, &aicolor);
         if(d->showbase) {
            gdk_gc_set_line_attributes(gc, 1, GDK_LINE_ON_OFF_DASH, GDK_CAP_ROUND, GDK_JOIN_ROUND);
            lrob = y_to_row(p_ai_default_rule_of(d->w->c->airules, i, 0), h, min, max);
            for(j = 1; j < P_AIS_NUM_RULES; j++) {
               rowb = y_to_row(p_ai_default_rule_of(d->w->c->airules, i, j), h, min, max);
               gdk_draw_line(d->buffer, gc, (j - 1) * w / (P_AIS_NUM_RULES), lrob, j * w / (P_AIS_NUM_RULES), rowb);
               lrob = rowb;
            }
            gdk_gc_set_line_attributes(gc, 1, GDK_LINE_SOLID, GDK_CAP_ROUND, GDK_JOIN_ROUND);
         }
         if(d->showcur) {
            lro = y_to_row(p_ai_rule_of(d->w->c->airules, i, 0), h, min, max);
            for(j = 1; j < P_AIS_NUM_RULES; j++) {
               row = y_to_row(p_ai_rule_of(d->w->c->airules, i, j), h, min, max);
               gdk_draw_line(d->buffer, gc, (j - 1) * w / (P_AIS_NUM_RULES), lro, j * w / (P_AIS_NUM_RULES), row);
               lro = row;
            }
         }
         name = p_ai_name_of(d->w->c->airules, i);
         strncpy(buf, name, P_GTK_STRING_BUFFER);
         p = buf + strlen(buf);
         while((wid = gdk_string_width(font, buf)) > w / (P_AIS_NUM_RULES) - 5 && p > buf) {
            p--;
            *p = '\0';
         }
         gdk_draw_string(d->buffer, font, gc, w - wid - 4, h - (numai - aiidx) * (font->ascent + font->descent) - 4, buf);
         aiidx++;
      }
   }
   
   gdk_gc_destroy(gc);
   gdk_font_unref(font);
   return;

}


static gint graph_area_configure(GtkWidget* graph_area, GdkEventConfigure* event, gpointer data) {
/* graph_area_configure */

   pgraph_gtk *d = data;
   
   /* Release any existing graph buffer */
   if (d->buffer != NULL) gdk_pixmap_unref(d->buffer);

   /* Construct new offscreen-drawable */
   d->buffer = gdk_pixmap_new(graph_area->window,
                              graph_area->allocation.width,
                              graph_area->allocation.height,
                              -1 /* Use depth of window */);
   return(TRUE);

}


static gint graph_area_expose(GtkWidget* widget, GdkEventExpose* event, gpointer data) {
/* graph_area_expose */

   pgraph_gtk *d = data;

   g_return_val_if_fail(d->buffer != NULL, FALSE);
   gdk_draw_pixmap(widget->window,                                /* Destination */
                   widget->style->fg_gc[GTK_WIDGET_STATE(widget)],/* What the hell? */
                   d->buffer,                                     /* Source */
                   event->area.x, event->area.y,                  /* src x, y */
                   event->area.x, event->area.y,                  /* Dest x, y */
                   event->area.width, event->area.height);        /* Size */
   return(FALSE);

}


static void p_graph_refresh(GtkWidget *w, gpointer data) {

   pgraph_gtk *d = data;

   graph_draw_grid(d);
   gtk_widget_queue_draw_area(d->da, 0, 0, d->da->allocation.width, d->da->allocation.height);

}


static void p_graph_close(GtkWidget *w, gpointer data) {

   pgraph_gtk *d = data;

   gtk_widget_destroy(d->dialog);

}


static void p_graph_destroy(GtkWidget *w, gpointer data) {

   pgraph_gtk *d = data;

   if (d->buffer != NULL) gdk_pixmap_unref(d->buffer);
   d->closed = 1;

}


static void toggle_show_ai(GtkWidget *w, gpointer data) {

   pgraph_gtk *d = data;
   int i;
   
   for(i = 0; i < P_AI_COUNT; i++) {
      if(d->showck[i] == w) {
         d->showai[i] = GTK_TOGGLE_BUTTON(w)->active;
         graph_draw_grid(d);
         gtk_widget_queue_draw_area(d->da, 0, 0, d->da->allocation.width, d->da->allocation.height);
         return;
      }
   }
   return;
   
}


static void p_graph_clear(GtkWidget *w, gpointer data) {

   pgraph_gtk *d = data;
   int i;
   
   for(i = 0; i < P_AI_COUNT; i++) {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(d->showck[i]), FALSE);
   }
   graph_draw_grid(d);

}


static void toggle_show_base(GtkWidget *w, gpointer data) {

   pgraph_gtk *d = data;
   
   d->showbase = GTK_TOGGLE_BUTTON(w)->active;
   graph_draw_grid(d);
   gtk_widget_queue_draw_area(d->da, 0, 0, d->da->allocation.width, d->da->allocation.height);
   return;
   
}


static void toggle_show_cur(GtkWidget *w, gpointer data) {

   pgraph_gtk *d = data;
   
   d->showcur = GTK_TOGGLE_BUTTON(w)->active;
   graph_draw_grid(d);
   gtk_widget_queue_draw_area(d->da, 0, 0, d->da->allocation.width, d->da->allocation.height);
   return;
   
}


void p_graph_ai(pwindow_gtk *w) {

   pgraph_gtk d;
   GtkWidget *button;
   GtkWidget *check;
   GtkWidget *hbox;
   GtkWidget *vbox;
   GtkWidget *vbox2;
   GtkWidget *scroll;
   int i;

   d.w      = w;
   d.buffer = NULL;
   d.dialog = gtk_dialog_new();

   d.da = gtk_drawing_area_new();
   gtk_container_set_border_width(GTK_CONTAINER(GTK_DIALOG(d.dialog)->vbox), 10);
   
   scroll=gtk_scrolled_window_new(NULL, NULL);
   hbox = gtk_hbox_new(FALSE, 0);
   vbox = gtk_vbox_new(FALSE, 0);
   vbox2= gtk_vbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(d.dialog)->vbox), hbox, FALSE, FALSE, 0);
   gtk_box_pack_start(GTK_BOX(hbox), d.da, FALSE, FALSE, 5);
   gtk_box_pack_start(GTK_BOX(hbox), vbox, FALSE, FALSE, 5);
   gtk_box_pack_start(GTK_BOX(vbox), scroll, FALSE, FALSE, 0);
   gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scroll), vbox2);
   gtk_widget_set_usize(scroll, 120, 300);

   gtk_widget_set_events(d.da, GDK_EXPOSURE_MASK);
   gtk_signal_connect(GTK_OBJECT(d.da), "expose_event",
                      GTK_SIGNAL_FUNC(graph_area_expose),
                      &d);
   gtk_signal_connect(GTK_OBJECT(d.da), "configure_event",
                      GTK_SIGNAL_FUNC(graph_area_configure),
                      &d);
   gtk_widget_set_usize(d.da, 600, 300);

   gtk_container_set_border_width(GTK_CONTAINER(GTK_DIALOG(d.dialog)->action_area), 10);
   
   for(i = 0; i < P_AI_COUNT; i++) {
      check = gtk_check_button_new_with_label(p_ai_name_of(w->c->airules, i));
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), TRUE);
      gtk_signal_connect(GTK_OBJECT(check), "toggled", GTK_SIGNAL_FUNC(toggle_show_ai), &d);
      gtk_box_pack_start(GTK_BOX(vbox2), check, FALSE, FALSE, 0);
      d.showai[i] = 1;
      d.showck[i] = check;
   }
   check = gtk_check_button_new_with_label("(Original)");
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), FALSE);
   gtk_signal_connect(GTK_OBJECT(check), "toggled", GTK_SIGNAL_FUNC(toggle_show_base), &d);
   gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 0);
   d.showbase = 0;
   check = gtk_check_button_new_with_label("(Current)");
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), TRUE);
   gtk_signal_connect(GTK_OBJECT(check), "toggled", GTK_SIGNAL_FUNC(toggle_show_cur), &d);
   gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 0);
   d.showcur = 1;
   
   button = gtk_button_new_with_label(" Refresh ");
   gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(p_graph_refresh), &d);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(d.dialog)->action_area), button, FALSE, FALSE, 0);
   button = gtk_button_new_with_label(" Clear Selection ");
   gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(p_graph_clear), &d);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(d.dialog)->action_area), button, FALSE, FALSE, 0);
   button = gtk_button_new_with_label(" Close ");
   gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(p_graph_close), &d);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(d.dialog)->action_area), button, FALSE, FALSE, 0);

   gtk_signal_connect(GTK_OBJECT(d.dialog), "destroy", GTK_SIGNAL_FUNC(p_graph_destroy), &d);
   gtk_window_set_modal(GTK_WINDOW(d.dialog), FALSE);
   gtk_widget_show_all(d.dialog);
   
   graph_draw_grid(&d);

   d.closed = 0;
   while(!d.closed) {
      p_window_idle((pwindow *)w);
   }

}

#endif /* !USE_LISP_AI */
