/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ X680x0 ANSI C݊Cu ]
 */

#ifdef HUMAN68K

#include <string.h>
#include <stdlib.h>
#include "xm7.h"
#include "68k.h"

/*-[ string.h ]-------------------------------------------------------------*/

/*
 *	memcpy
 *	Rs[
 */
void *memcpy(void *dst, const void *src, size_t size)
{
	char *d;
	char *s;
	size_t i;

	/* LXg */
	d = (char *)dst;
	s = (char *)src;

	/* Rs[ */
	for (i=0; i<size; i++) {
		*d++ = *s++;
	}

	/* ߂l͈ӖȂ */
	return NULL;
}

/*
 *	memset
 *	tB
 */
void *memset(void *dst, int_ dat, size_t size)
{
	unsigned char *d;
	size_t i;

	/* LXg */
	d = (unsigned char *)dst;

	/* Rs[ */
	for (i=0; i<size; i++) {
		*d++ = (unsigned char)dat;
	}

	/* ߂l͈ӖȂ */
	return NULL;
}

/*
 *	memcmp
 *	r
 */
int memcmp (const void *str1, const void *str2, size_t size)
{
	size_t i;
	unsigned char *src;
	unsigned char *dst;

	src = (unsigned char *)str1;
	dst = (unsigned char *)str2;

	for (i=0; i<size; i++) {
		if (*src++ != *dst++) {
			return 1;
		}
	}

	return 0;
}

/*
 *	strcpy
 *	Rs[
 */
char *strcpy(char *dst, const char *src)
{
	while ((*dst++ = *src++) != '\0') {
		;
	}

	/* ߂l͈ӖȂ */
	return NULL;
}

/*
 *	strcat
 *	Ayh
 */
char *strcat(char *dst, const char *src)
{
	/* I[T */
	while (*dst != '\0') {
		dst++;
	}

	/* Rs[ */
	while ((*dst++ = *src++) != '\0') {
		;
	}

	/* ߂l͈ӖȂ */
	return NULL;
}

/*
 *	strlen
 *	񒷂擾
 */
size_t strlen(const char *src)
{
	size_t ret;

	/* \0܂Œׂ */
	ret = 0;
	while(*src++ != '\0') {
		ret++;
	}

	return ret;
}

/*
 *	strcmp
 *	r
 */
int strcmp (const char *str1, const char *str2)
{
	for (;;) {
		if (*str1 != *str2) {
			return 1;
		}
		if (*str1 == '\0') {
			break;
		}
		str1++;
		str2++;
	}

	return 0;
}

/*-[ stdlib.h ]-------------------------------------------------------------*/

/*
 *	malloc
 *	m
 */
void *malloc(size_t size)
{
	return dos_malloc((int)size);
}

/*
 *	free
 *	J
 */
void free(void *ptr)
{
	dos_mfree(ptr);
}

#endif	/* HUMAN68K */
