/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ Win32 Xe[^Xr[ ]
 */

#ifdef _WIN32

#include <afxwin.h>
#include "xm7.h"
#include "display.h"
#include "subctrl.h"
#include "ttlpalet.h"
#include "keyboard.h"
#include "mainetc.h"
#include "multipag.h"
#include "fdc.h"
#include "kanji.h"
#include "tapelp.h"
#include "opn.h"
#include "win_view.h"
#include "win.h"
#include "resource.h"

/*-[ AhX̓_CAO ]-----------------------------------------------*/

/*
 *	AhX̓_CAO쐬
 */
CXM7AddrDlg::CXM7AddrDlg(CWnd *pParent, WORD *pAddr)
: CDialog(MAKEINTRESOURCE(IDD_ADDRDLG), pParent)
{
	// |C^LĂ
	m_pAddr = pAddr;
}

/*
 *	_CAO
 */
BOOL CXM7AddrDlg::OnInitDialog()
{
	char buffer[16];

	// EChE𒆉
	CenterWindow();

	// AhXݒ
	sprintf(buffer, "%04X", *m_pAddr);
	SetDlgItemText(IDC_ADDREDIT, buffer);

	return TRUE;
}

/*
 *	OK
 */
void CXM7AddrDlg::OnOK()
{
	WORD dat;
	char buffer[32];

	// f[^𓾂
	GetDlgItemText(IDC_ADDREDIT, buffer, sizeof(buffer) - 2);
	sscanf(buffer, "%4x", &dat);

	// f[^ݒ
	*m_pAddr = dat;

	// I
	CDialog::OnOK();
}

/*-[ r[EChE ]-----------------------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7ViewWnd, CWnd)
	ON_WM_CLOSE()
	ON_WM_CAPTURECHANGED()
	ON_WM_ENTERMENULOOP()
	ON_MESSAGE(WM_ENTERSIZEMOVE, OnEnterSizeMove)
	ON_WM_SYSCOMMAND()
END_MESSAGE_MAP()

/*
 *	r[EChE쐬
 */
CXM7ViewWnd::CXM7ViewWnd(CWnd **pNotify) : CWnd()
{
	// IuWFNgʒmp̃|C^L
	m_pNotify = pNotify;

	// IuWFNg쐬ʒm
	*m_pNotify = (CWnd *)this; 
}

/*
 *	EChEN[Y
 */
void CXM7ViewWnd::OnClose()
{
	CXM7Wnd *pMainWnd;

	// eEChEւ̃|C^ɑ΂āANULLŒʒm
	*m_pNotify = NULL;

	// CEChÉAEChEj[XV
	pMainWnd = (CXM7Wnd*)GetParent();
	pMainWnd->UpWndMenu();

	// EChE폜
	DestroyWindow();
}

/*
 *	IuWFNg폜
 */
void CXM7ViewWnd::PostNcDestroy()
{
	// IuWFNg폜
	delete this;
}

/*
 *	j[[vɓ
 */
void CXM7ViewWnd::OnEnterMenuLoop(BOOL bTrackFlag)
{
	CXM7Wnd *pMainWnd;

	// TEh~
	pMainWnd = (CXM7Wnd*)GetParent();
	pMainWnd->StopSnd();
	pMainWnd->m_bMenuFlag = TRUE;

	// {NX
	CWnd::OnEnterMenuLoop(bTrackFlag);
}

/*
 *	ړ[vɓ
 */
LONG CXM7ViewWnd::OnEnterSizeMove(UINT wParam, LONG lParam)
{
	CXM7Wnd *pMainWnd;

	// TEh~
	pMainWnd = (CXM7Wnd*)GetParent();
	pMainWnd->StopSnd();
	pMainWnd->m_bMenuFlag = TRUE;

	return 0;
}

/*
 *	VXeR}hs
 */
void CXM7ViewWnd::OnSysCommand(UINT nID, LPARAM lParam)
{
	CXM7Wnd *pMainWnd;

	// TEh~
	pMainWnd = (CXM7Wnd*)GetParent();
	pMainWnd->StopSnd();
	pMainWnd->m_bMenuFlag = TRUE;

	// {NX
	CWnd::OnSysCommand(nID, lParam);
}

/*
 *	tHg쐬
 */
CFont *CXM7ViewWnd::GetViewFont()
{
	CFont *pFont;
	LANGID lang;

	pFont = new CFont;
	lang = ::GetUserDefaultLangID();

	if ((lang & 0xff) == 0x11) {
		/* { */
		pFont->CreateFont(-16, 0, 0, 0, FW_DONTCARE, FALSE, FALSE, FALSE,
			SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
			DEFAULT_QUALITY, FIXED_PITCH, NULL);
	}
	else {
		/* p */
		pFont->CreateFont(-16, 0, 0, 0, FW_DONTCARE, FALSE, FALSE, FALSE,
			ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
			DEFAULT_QUALITY, FIXED_PITCH, NULL);
	}

	return pFont;
}

/*
 *	tHgTCY擾
 */
void CXM7ViewWnd::GetFontSize()
{
	CFont *pFont;
	CFont *pOldFont;
	CDC *pDC;
	TEXTMETRIC tm;

	// foCXReLXg擾
	pDC = GetDC();

	// tHg쐬AI
	pFont = GetViewFont();
	pOldFont = pDC->SelectObject(pFont);

	// eLXggbN擾AL
	pDC->GetTextMetrics(&tm);
	m_nCharWidth = tm.tmAveCharWidth;
	m_nCharHeight = tm.tmHeight + tm.tmExternalLeading;

	// ߂
	pDC->SelectObject(pOldFont);
	ReleaseDC(pDC);

	delete pFont;
}

/*
 *	EChETCY̕␳
 */
void CXM7ViewWnd::AdjustWindow(int width, int height)
{
	CRect mRect, cRect;
	int i;
	CXM7Wnd *pMainWnd;

	// tHgTCY擾
	GetFontSize();

	// TCY
	GetWindowRect(&mRect);
	GetClientRect(&cRect);
	mRect.right -= mRect.left;
	mRect.right -= (cRect.right - cRect.left);
	mRect.bottom -= mRect.top;
	mRect.bottom -= (cRect.bottom - cRect.top);
	mRect.right += width * m_nCharWidth;
	mRect.bottom += height * m_nCharHeight;

	// qEChEIDɂAʒu
	i = GetDlgCtrlID();
	ASSERT((i >= 0x4000) && (i < 0x4040));
	i -= 0x4000;
	mRect.top = (i * m_nCharHeight + (i * (m_nCharHeight / 4))) % 360;
	mRect.left = i * m_nCharWidth + (i * (m_nCharWidth / 4));

	SetWindowPos(&wndTop, mRect.left, mRect.top, mRect.right, mRect.bottom, 0);

	// ACRݒ
	SetIcon(AfxGetApp()->LoadIcon(MAKEINTRESOURCE(IDI_WINICON)), TRUE);
	SetIcon(AfxGetApp()->LoadIcon(MAKEINTRESOURCE(IDI_WINICON)), FALSE);

	// CEChÉAEChEj[XV
	pMainWnd = (CXM7Wnd*)GetParent();
	pMainWnd->UpWndMenu();

	// EChE\
	ShowWindow(SW_SHOW);
	UpdateWindow();
}

/*
 *	Lv`[ύX
 */
void CXM7ViewWnd::OnCaptureChanged(CWnd *pWnd)
{
	// Z̈ԎO֎Ă
	SetWindowPos(&wndTop, 0, 0, 128, 128, SWP_NOMOVE | SWP_NOSIZE);
}

/*
 *	g
 */
void CXM7ViewWnd::StringExt(char *pszStr, int width)
{
	int i;

	i = strlen(pszStr);

	if (i == width) {
		return;
	}

	if (i > width) {
		pszStr[width] = '\0';
		return;
	}

	memset(&pszStr[i], 0x20, width - i);
	pszStr[width] = '\0';
}

/*-[ WX^EChE ]---------------------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7RegWnd, CXM7ViewWnd)
	ON_WM_PAINT()
END_MESSAGE_MAP()

/*
 *	WX^EChE쐬
 */
CXM7RegWnd::CXM7RegWnd(CWnd **pNotify, CWnd *pParent, int cpu)
	: CXM7ViewWnd(pNotify)
{
	CRect rect;

	ASSERT(pParent);
	ASSERT((cpu == MAINCPU) || (cpu == SUBCPU));

	// TCYݒ
	rect.left = 0;
	rect.top = 0;
	rect.right = 128;
	rect.bottom = 128;

	// e
	if (cpu == MAINCPU) {
		m_pReg = &maincpu;
		Create(NULL, XM7REG_MNAME,
			WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS,
			rect, pParent, IDW_MAINREG, NULL);
	}
	else {
		m_pReg = &subcpu;
		Create(NULL, XM7REG_SNAME,
			WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS,
			rect, pParent, IDW_SUBREG, NULL);
	}

	// AWXg
	AdjustWindow(XM7REG_WIDTH, XM7REG_HEIGHT);
}

/*
 *	`
 */
void CXM7RegWnd::OnPaint()
{
	CDC *pDC;
	PAINTSTRUCT ps;
	CString str;
	CFont *pFont;
	CFont *pOldFont;
	int x, y;

	// DC̎󂯎AtHgw
	pDC = BeginPaint(&ps);
	pFont = GetViewFont();
	pOldFont = pDC->SelectObject(pFont);

	x = m_nCharWidth;
	y = m_nCharHeight;
	str.Format("CC   %02X   ", m_pReg->cc);
	pDC->TextOut(0 * x, 0 * y, str);
	str.Format("A    %02X   ", m_pReg->acc.h.a);
	pDC->TextOut(0 * x, 1 * y, str);
	str.Format("B    %02X   ", m_pReg->acc.h.b);
	pDC->TextOut(0 * x, 2 * y, str);
	str.Format("D  %04X   ", m_pReg->acc.d);
	pDC->TextOut(0 * x, 3 * y, str);
	str.Format("DP   %02X   ", m_pReg->dp);
	pDC->TextOut(0 * x, 4 * y, str);

	str.Format("X  %04X", m_pReg->x);
	pDC->TextOut(10 * x, 0 * y, str);
	str.Format("Y  %04X", m_pReg->y);
	pDC->TextOut(10 * x, 1 * y, str);
	str.Format("U  %04X", m_pReg->u);
	pDC->TextOut(10 * x, 2 * y, str);
	str.Format("S  %04X", m_pReg->s);
	pDC->TextOut(10 * x, 3 * y, str);
	str.Format("PC %04X", m_pReg->pc);
	pDC->TextOut(10 * x, 4 * y, str);

	// `I
	pDC->SelectObject(pOldFont);
	EndPaint(&ps);
	delete pFont;
}

/*-[ tAZu EChE ]----------------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7DisWnd, CXM7ViewWnd)
	ON_WM_PAINT()
	ON_WM_VSCROLL()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_CONTEXTMENU()
	ON_COMMAND(IDM_DISASMPC, OnPC)
	ON_COMMAND(IDM_DISASMGO, OnGo)
	ON_COMMAND(IDM_DISASMFIRQ, OnFIRQ)
	ON_COMMAND(IDM_DISASMIRQ, OnIRQ)
END_MESSAGE_MAP()

/*
 *	tAZuEChE쐬
 */
CXM7DisWnd::CXM7DisWnd(CWnd **pNotify, CWnd *pParent, int cpu)
	: CXM7ViewWnd(pNotify)
{
	CRect rect;
	SCROLLINFO si;

	ASSERT(pParent);
	ASSERT((cpu == MAINCPU) || (cpu == SUBCPU));

	// TCYݒ
	rect.left = 0;
	rect.top = 0;
	rect.right = 128;
	rect.bottom = 128;

	// e
	if (cpu == MAINCPU) {
		m_CPU = MAINCPU;
		m_addr = maincpu.pc;
		Create(NULL, XM7DIS_MNAME,
			WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS | WS_VSCROLL,
			rect, pParent, IDW_MAINDIS, NULL);
	}
	else {
		m_CPU = SUBCPU;
		m_addr = subcpu.pc;
		Create(NULL, XM7DIS_SNAME,
			WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS | WS_VSCROLL,
			rect, pParent, IDW_SUBDIS, NULL);
	}

	// AWXg
	AdjustWindow(XM7DIS_WIDTH, XM7DIS_HEIGHT);

	// XN[o[
	si.cbSize = sizeof(si);
	si.fMask = SIF_ALL;
	si.nMin = 0;
	si.nMax = 0xffff;
	si.nPage = XM7DIS_HEIGHT;
	si.nPos = m_addr;
	SetScrollInfo(SB_VERT, &si, TRUE);
}

/*
 *	`
 */
void CXM7DisWnd::OnPaint()
{
	CDC *pDC;
	PAINTSTRUCT ps;
	CString str;
	CFont *pFont;
	CFont *pOldFont;
	int y;

	WORD pc;
	char buffer[128];
	int add;
	int i;
	int j;
	int flag;
	BOOL bColor;

	// DC̎󂯎AtHgw
	pDC = BeginPaint(&ps);
	pFont = GetViewFont();
	pOldFont = pDC->SelectObject(pFont);

	y = m_nCharHeight;
	pc = m_addr;
	flag = FALSE;
	for (i=0; i<XM7DIS_HEIGHT; i++) {
		// tO`FbN
		if (flag == TRUE) {
			memset(buffer, 0x20, XM7DIS_WIDTH);
			buffer[XM7DIS_WIDTH] = '\0';
			pDC->SetBkColor(RGB(255, 255, 255));
			pDC->TextOut(0, i * y, buffer, strlen(buffer));
			continue;
		}

		// PstAZu
		add = disline(m_CPU, pc, buffer);

		// H
		j = strlen(buffer);
		if (j < XM7DIS_WIDTH) {
			memset(buffer + j, 0x20, XM7DIS_WIDTH - j);
			buffer[XM7DIS_WIDTH] = '\0';
		}

		// FA\
		pDC->SetBkColor(RGB(255, 255, 255));
		bColor = FALSE;
		for (j=0; j<BREAKP_MAX; j++) {
			if (breakp[j].flag == BREAKP_NOTUSE) {
				continue;
			}
			if (breakp[j].flag == BREAKP_DISABLED) {
				continue;
			}
			if (breakp[j].cpu == m_CPU) {
				if (breakp[j].addr == pc) {
					pDC->SetBkColor(RGB(223, 223, 223));
					bColor = TRUE;
				}
			}
		}

		if (((m_CPU == MAINCPU) && (maincpu.pc == pc))
			|| ((m_CPU == SUBCPU) && (subcpu.pc == pc))) {
			if (bColor) {
				pDC->SetBkColor(RGB(255, 207, 207));
			}
			else {
				pDC->SetBkColor(RGB(255, 239, 175));
			}
		}

		pDC->TextOut(0, i * y, buffer, strlen(buffer));

		// next`FbN
		if ((pc >= 0xff00) && ((WORD)(pc + add) <= 0x0100)) {
			flag = TRUE;
			continue;
		}
		pc += add;
	}

	// `I
	pDC->SelectObject(pOldFont);
	EndPaint(&ps);
	delete pFont;

	// XN[|WVݒ
	SetScrollPos(SB_VERT, m_addr, TRUE);
}

/*
 *	XN[
 */
void CXM7DisWnd::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar *pScrollBar)
{
	char buffer[128];
	int add;
	CXM7Wnd *pMainWnd;

	// TEh~
	pMainWnd = (CXM7Wnd*)GetParent();
	pMainWnd->StopSnd();
	pMainWnd->m_bMenuFlag = TRUE;

	switch (nSBCode) {
		// ԉփXN[
		case SB_BOTTOM:
			m_addr = 0xffff;
			break;
		// XN[I
		case SB_ENDSCROLL:
			return;
		// s
		case SB_LINEDOWN:
			// ۂɋtAZuĂ݂ȂƂ킩Ȃ
			add = disline(m_CPU, m_addr, buffer);
			if (m_addr >= 0xff00) {
				if ((WORD)(m_addr + add) <= 0x0100) {
					return;
				}
			}
			m_addr += add;
			break;
		// s
		case SB_LINEUP:
			if (m_addr == 0) {
				return;
			}
			m_addr--;
			break;
		// ubN
		case SB_PAGEDOWN:
			m_addr += XM7DIS_HEIGHT;
			break;
		// ubN
		case SB_PAGEUP:
			m_addr -= XM7DIS_HEIGHT;
			break;
		// wʒu
		case SB_THUMBPOSITION:
		case SB_THUMBTRACK:
			m_addr = (WORD)nPos;
			break;
		// ԏ
		case SB_TOP:
			m_addr = 0;
			break;
	}

	// ĕ`
	Invalidate();
}

/*
 *	{^
 */
void CXM7DisWnd::OnLButtonDown(UINT nFlags, CPoint point)
{
	int i;
	int y;
	WORD pc;
	int add;
	char buffer[128];
	CXM7Wnd *pParent;

	/* s𓾂 */
	y = point.y / m_nCharHeight;
	ASSERT((y >= 0) && (y < XM7DIS_HEIGHT));

	/* ۂɋtAZuAAhX𓾂 */
	pc = m_addr;
	for (i=0; i<y; i++) {
		add = disline(m_CPU, pc, buffer);
		pc += add;
	}

	/* Zbg */
	debug_setbreak(m_CPU, pc);

	/* ` */
	Invalidate();
	pParent = (CXM7Wnd*)GetParent();
	if (pParent->m_pBreakWnd) {
		pParent->m_pBreakWnd->Invalidate();
	}
}

/*
 *	_uNbN
 */
void CXM7DisWnd::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	OnLButtonDown(nFlags, point);
}

/*
 *	ReLXgj[
 */
void CXM7DisWnd::OnContextMenu(CWnd *pWnd, CPoint point)
{
	CRect rect;
	CMenu menu;
	CMenu *pMenu;
	CXM7Wnd *pMainWnd;

	// TEh~
	pMainWnd = (CXM7Wnd*)GetParent();
	pMainWnd->StopSnd();
	pMainWnd->m_bMenuFlag = TRUE;

	GetClientRect(&rect);
	ClientToScreen(&rect);

	// ʒu`FbNāAj[\
	if (rect.PtInRect(point)) {
		menu.LoadMenu(IDR_DISASM);
		pMenu = menu.GetSubMenu(0);

		pMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_RIGHTBUTTON,
			point.x, point.y, this, 0);
		return;
	}

	// e֓n
	CWnd::OnContextMenu(pWnd, point);
}

/*
 *	PCֈړ
 */
void CXM7DisWnd::OnPC()
{
	if (m_CPU == MAINCPU) {
		SetAddr(maincpu.pc);
	}
	else {
		SetAddr(subcpu.pc);
	}
}

/*
 *	AhXw_CAO
 */
void CXM7DisWnd::OnGo()
{
	CXM7AddrDlg dlg(this, &m_addr);

	if (dlg.DoModal() == IDOK) {
		Invalidate(FALSE);
	}
}

/*
 *	AhXw
 */
void CXM7DisWnd::SetAddr(WORD addr)
{
	m_addr = addr;

	Invalidate(FALSE);
}

/*
 *	FIRQxN^ֈړ
 */
void CXM7DisWnd::OnFIRQ()
{
	WORD addr;

	if (m_CPU == MAINCPU) {
		addr = mainmem_readb(0xfff6) * 256 + mainmem_readb(0xfff7);
	}
	else {
		addr = submem_readb(0xfff6) * 256 + submem_readb(0xfff7);
	}

	SetAddr(addr);
}

/*
 *	IRQxN^ֈړ
 */
void CXM7DisWnd::OnIRQ()
{
	WORD addr;

	if (m_CPU == MAINCPU) {
		addr = mainmem_readb(0xfff8) * 256 + mainmem_readb(0xfff9);
	}
	else {
		addr = submem_readb(0xfff8) * 256 + submem_readb(0xfff9);
	}

	SetAddr(addr);
}

/*-[ _vEChE ]-----------------------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7DumpWnd, CXM7ViewWnd)
	ON_WM_PAINT()
	ON_WM_VSCROLL()
	ON_WM_CONTEXTMENU()
	ON_COMMAND(IDM_DUMPGO, OnGo)
	ON_COMMAND(IDM_DUMPX, OnX)
	ON_COMMAND(IDM_DUMPY, OnY)
	ON_COMMAND(IDM_DUMPU, OnU)
	ON_COMMAND(IDM_DUMPS, OnS)
	ON_COMMAND(IDM_DUMPPC, OnPC)
	ON_COMMAND(IDM_DUMPDP, OnDP)
END_MESSAGE_MAP()

/*
 *	_vEChE쐬
 */
CXM7DumpWnd::CXM7DumpWnd(CWnd **pNotify, CWnd *pParent, int cpu)
	: CXM7ViewWnd(pNotify)
{
	CRect rect;
	SCROLLINFO si;

	ASSERT(pParent);
	ASSERT((cpu == MAINCPU) || (cpu == SUBCPU));

	// TCYݒ
	rect.top = 0;
	rect.left = 0;
	rect.right = 128;
	rect.bottom = 128;

	// e
	if (cpu == MAINCPU) {
		m_CPU = MAINCPU;
		m_addr = maincpu.pc & 0xfff0;
		Create(NULL, XM7DUMP_MNAME,
			WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS | WS_VSCROLL,
			rect, pParent, IDW_MAINDUMP, NULL);
	}
	else {
		m_CPU = SUBCPU;
		m_addr = subcpu.pc & 0xfff0;
		Create(NULL, XM7DUMP_SNAME,
			WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS | WS_VSCROLL,
			rect, pParent, IDW_SUBDUMP, NULL);
	}

	// AWXg
	AdjustWindow(XM7DUMP_WIDTH, XM7DUMP_HEIGHT);

	// XN[o[
	si.cbSize = sizeof(si);
	si.fMask = SIF_ALL;
	si.nMin = 0;
	si.nMax = 0xfff;
	si.nPage = XM7DUMP_HEIGHT;
	si.nPos = m_addr / 16;
	SetScrollInfo(SB_VERT, &si, TRUE);
}

/*
 *	`
 */
void CXM7DumpWnd::OnPaint()
{
	CDC *pDC;
	PAINTSTRUCT ps;
	CString str;
	CFont *pFont;
	CFont *pOldFont;
	int y;

	WORD pc;
	char buffer[128];
	char temp[32];
	int i;
	int j;
	int flag;

	// DC̎󂯎AtHgw
	pDC = BeginPaint(&ps);
	pFont = GetViewFont();
	pOldFont = pDC->SelectObject(pFont);

	y = m_nCharHeight;
	pc = m_addr;
	flag = FALSE;
	for (i=0; i<XM7DUMP_HEIGHT; i++) {
		// tO`FbN
		if (flag == TRUE) {
			memset(buffer, 0x20, XM7DUMP_WIDTH);
			buffer[XM7DUMP_WIDTH] = '\0';
			pDC->TextOut(0, i * y, buffer, strlen(buffer));
			continue;
		}
		else {
			// _vf[^쐬
			sprintf(buffer, "%04X: ", pc);
			for (j=0; j<16; j++) {
				if (m_CPU == MAINCPU) {
					sprintf(temp, "%02X ", mainmem_readbnio(pc + j));
				}
				else {
					sprintf(temp, "%02X ", submem_readbnio(pc + j));
				}
				strcat(buffer, temp);
			}
		}

		// FA\
		pDC->TextOut(0, i * y, buffer, strlen(buffer));

		// next`FbN
		if ((pc >= 0xff00) && ((WORD)(pc + 16) <= 0x0100)) {
			flag = TRUE;
			continue;
		}
		pc += 16;
	}

	// `I
	pDC->SelectObject(pOldFont);
	EndPaint(&ps);
	delete pFont;

	// XN[|WVݒ
	SetScrollPos(SB_VERT, m_addr >> 4, TRUE);
}

/*
 *	XN[
 */
void CXM7DumpWnd::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar *pScrollBar)
{
	CXM7Wnd *pMainWnd;

	// TEh~
	pMainWnd = (CXM7Wnd*)GetParent();
	pMainWnd->StopSnd();
	pMainWnd->m_bMenuFlag = TRUE;

	switch (nSBCode) {
		// ԉփXN[
		case SB_BOTTOM:
			m_addr = 0xff80;
			break;
		// XN[I
		case SB_ENDSCROLL:
			return;
		// s
		case SB_LINEDOWN:
			if (m_addr >= 0xff80) {
				return;
			}
			m_addr += 0x0010;
			break;
		// s
		case SB_LINEUP:
			if (m_addr == 0) {
				return;
			}
			m_addr -= 0x0010;
			break;
		// ubN
		case SB_PAGEDOWN:
			m_addr += XM7DUMP_HEIGHT * 16;
			break;
		// ubN
		case SB_PAGEUP:
			m_addr -= XM7DUMP_HEIGHT * 16;
			break;
		// wʒu
		case SB_THUMBPOSITION:
		case SB_THUMBTRACK:
			m_addr = (WORD)nPos * 16;
			break;
		// ԏ
		case SB_TOP:
			m_addr = 0;
			break;
	}

	// ĕ`
	Invalidate();
}

/*
 *	ReLXgj[
 */
void CXM7DumpWnd::OnContextMenu(CWnd *pWnd, CPoint point)
{
	CRect rect;
	CMenu menu;
	CMenu *pMenu;
	CXM7Wnd *pMainWnd;

	// TEh~
	pMainWnd = (CXM7Wnd*)GetParent();
	pMainWnd->StopSnd();
	pMainWnd->m_bMenuFlag = TRUE;

	GetClientRect(&rect);
	ClientToScreen(&rect);

	// ʒu`FbNāAj[\
	if (rect.PtInRect(point)) {
		menu.LoadMenu(IDR_DUMP);
		pMenu = menu.GetSubMenu(0);

		pMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_RIGHTBUTTON,
			point.x, point.y, this, 0);
		return;
	}

	// e֓n
	CWnd::OnContextMenu(pWnd, point);
}

/*
 *	AhXw_CAO
 */
void CXM7DumpWnd::OnGo()
{
	WORD addr;
	CXM7AddrDlg dlg(this, &addr);

	if (dlg.DoModal() == IDOK) {
		SetAddr(addr);
	}
}

/*
 *	XWX^w
 */
void CXM7DumpWnd::OnX()
{
	if (m_CPU == MAINCPU) {
		SetAddr(maincpu.x);
	}
	else {
		SetAddr(subcpu.x);
	}
}

/*
 *	YWX^w
 */
void CXM7DumpWnd::OnY()
{
	if (m_CPU == MAINCPU) {
		SetAddr(maincpu.y);
	}
	else {
		SetAddr(subcpu.y);
	}
}

/*
 *	UWX^w
 */
void CXM7DumpWnd::OnU()
{
	if (m_CPU == MAINCPU) {
		SetAddr(maincpu.u);
	}
	else {
		SetAddr(subcpu.u);
	}
}

/*
 *	SWX^w
 */
void CXM7DumpWnd::OnS()
{
	if (m_CPU == MAINCPU) {
		SetAddr(maincpu.s);
	}
	else {
		SetAddr(subcpu.s);
	}
}

/*
 *	PCWX^w
 */
void CXM7DumpWnd::OnPC()
{
	if (m_CPU == MAINCPU) {
		SetAddr(maincpu.pc);
	}
	else {
		SetAddr(subcpu.pc);
	}
}

/*
 *	DPWX^w
 */
void CXM7DumpWnd::OnDP()
{
	if (m_CPU == MAINCPU) {
		SetAddr((WORD)(maincpu.dp << 8));
	}
	else {
		SetAddr((WORD)(subcpu.dp << 8));
	}
}

/*
 *	AhXw
 */
void CXM7DumpWnd::SetAddr(WORD addr)
{
	m_addr = (WORD)(addr & 0xfff0);
	Invalidate(FALSE);
}

/*-[ 荞݃EChE ]---------------------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7IntWnd, CXM7ViewWnd)
	ON_WM_PAINT()
END_MESSAGE_MAP()

/*
 *	荞݃EChE쐬
 */
CXM7IntWnd::CXM7IntWnd(CWnd **pNotify, CWnd *pParent, int cpu)
	: CXM7ViewWnd(pNotify)
{
	CRect rect;

	ASSERT(pParent);

	rect.top = 0;
	rect.left = 0;
	rect.right = 128;
	rect.bottom = 128;

	if (cpu == MAINCPU) {
		m_CPU = MAINCPU;
		Create(NULL, XM7INT_MNAME,
			WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS,
			rect, pParent, IDW_MAININT, NULL);
		AdjustWindow(XM7INT_WIDTH, XM7INT_HEIGHT);
	}
	else {
		m_CPU = SUBCPU;
		Create(NULL, XM7INT_SNAME,
			WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS,
			rect, pParent, IDW_SUBINT, NULL);
		// Tu͊荞݂R̂
		AdjustWindow(XM7INT_WIDTH, 3);
	}
}

/*
 *	`Tu
 */
void CXM7IntWnd::PaintSub(CDC *pDC, UINT y, char *pszMsg,
	BOOL req_flag, BOOL mask_flag, WORD irq_flag)
{
	char buffer[128];

	/*  */
	strcpy(buffer, pszMsg);
	pDC->SetBkColor(RGB(255, 255, 255));

	if (mask_flag) {
		strcat(buffer, "   Mask");
	}
	else {
		if (!req_flag) {
			strcat(buffer, "       ");
		}
		else {
			if (irq_flag) {
				pDC->SetBkColor(RGB(223, 223, 223));
				strcat(buffer, "   Pend");
			}
			else {
				pDC->SetBkColor(RGB(255, 239, 175));
				strcat(buffer, "Request");
			}
		}
	}

	pDC->TextOut(0, y * m_nCharHeight, buffer, strlen(buffer));
}

/*
 *	`
 */
void CXM7IntWnd::OnPaint()
{
	CDC *pDC;
	PAINTSTRUCT ps;
	CFont *pFont;
	CFont *pOldFont;

	char buffer[128];
	// DC̎󂯎AtHgw
	pDC = BeginPaint(&ps);
	pFont = GetViewFont();
	pOldFont = pDC->SelectObject(pFont);

	if (m_CPU == MAINCPU) {
		// FIRQ (Break Key)
		PaintSub(pDC, 0, "FIRQ (Break Key)   ", break_flag, FALSE,
				 maincpu.cc & 0x40 );
		// FIRQ (Attention)
		PaintSub(pDC, 1, "FIRQ (Attention)   ", subattn_flag, FALSE,
				maincpu.cc & 0x40 );
		// IRQ (Key)
		PaintSub(pDC, 2, "IRQ  (Keyboard)    ", key_irq_flag, key_irq_mask,
				maincpu.cc & 0x10 );
		// IRQ (Timer)
		PaintSub(pDC, 3, "IRQ  (2.03ms Timer)", timer_irq_flag, timer_irq_mask,
				maincpu.cc & 0x10 );
		// IRQ (Printer)
		PaintSub(pDC, 4, "IRQ  (Printer)     ", lp_irq_flag, lp_irq_mask,
				maincpu.cc & 0x10 );
		// IRQ (FDC)
		PaintSub(pDC, 5, "IRQ  (FDC)         ", mfd_irq_flag, mfd_irq_mask,
				maincpu.cc & 0x10 );
		// IRQ (TxRDY)
		PaintSub(pDC, 6, "IRQ  (USART TxRdy) ", txrdy_irq_flag, txrdy_irq_mask,
				maincpu.cc & 0x10 );
		// IRQ (RxRDY)
		PaintSub(pDC, 7, "IRQ  (USART RxRdy) ", rxrdy_irq_flag, rxrdy_irq_mask,
				maincpu.cc & 0x10 );
		// IRQ (SYNDET)
		PaintSub(pDC, 8, "IRQ  (USART Sync)  ", syndet_irq_flag, syndet_irq_mask,
				maincpu.cc & 0x10 );
		// IRQ (OPN)
		PaintSub(pDC, 9, "IRQ  (OPN Timer)   ", opn_irq_flag, opn_irq_mask,
				maincpu.cc & 0x10 );
	}
	else {
		// Tu NMI
		strcpy(buffer, "NMI  (20ms Timer)  ");
		if (subcpu.intr & INTR_NMI) {
			pDC->SetBkColor(RGB(255, 239, 175));
			strcat(buffer, "Request");
		}
		else {
			pDC->SetBkColor(RGB(255, 255, 255));
			strcat(buffer, "       ");
		}
		pDC->TextOut(0, 0 * m_nCharHeight, buffer, strlen(buffer));

		// Tu FIRQ
		strcpy(buffer, "FIRQ (Keyboard)    ");
		if (!key_irq_mask && key_irq_flag) {
			if (subcpu.cc & 0x40) {
				pDC->SetBkColor(RGB(223, 223, 223));
				strcat(buffer, "   Pend");
			}
			else {
				pDC->SetBkColor(RGB(255, 239, 175));
				strcat(buffer, "Request");
			}
		}
		else {
			if (subcpu.cc & 0x40) {
				pDC->SetBkColor(RGB(223, 223, 223));
				strcat(buffer, "   Mask");
			}
			else {
				pDC->SetBkColor(RGB(255, 255, 255));
				strcat(buffer, "       ");
			}
		}
		pDC->TextOut(0, 1 * m_nCharHeight, buffer, strlen(buffer));

		// Tu IRQ
		strcpy(buffer, "IRQ  (Cancel)      ");
		if (subcancel_flag) {
			if (subcpu.cc & 0x10) {
				pDC->SetBkColor(RGB(223, 223, 223));
				strcat(buffer, "   Pend");
			}
			else {
				pDC->SetBkColor(RGB(255, 239, 175));
				strcat(buffer, "Request");
			}
		}
		else {
			if (subcpu.cc & 0x10) {
				pDC->SetBkColor(RGB(223, 223, 223));
				strcat(buffer, "   Mask");
			}
			else {
				pDC->SetBkColor(RGB(255, 255, 255));
				strcat(buffer, "       ");
			}
		}
		pDC->TextOut(0, 2 * m_nCharHeight, buffer, strlen(buffer));
	}

	// `I
	pDC->SelectObject(pOldFont);
	EndPaint(&ps);
	delete pFont;
}

/*-[ u[N|CgEChE ]-------------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7BreakWnd, CXM7ViewWnd)
	ON_WM_PAINT()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONDOWN()
	ON_WM_CONTEXTMENU()
	ON_COMMAND(IDM_BREAKEN, OnEnable)
	ON_COMMAND(IDM_BREAKDIS, OnDisable)
	ON_COMMAND(IDM_BREAKDEL, OnDelete)
	ON_COMMAND(IDM_BREAKCLR, OnClear)
END_MESSAGE_MAP()

/*
 *	u[N|CgEChE쐬
 */
CXM7BreakWnd::CXM7BreakWnd(CWnd **pNotify, CWnd *pParent)
	: CXM7ViewWnd(pNotify)
{
	CRect rect;

	ASSERT(pParent);

	rect.top = 0;
	rect.left = 0;
	rect.right = 128;
	rect.bottom = 128;

	Create(NULL, XM7BREAK_NAME,
		WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS,
		rect, pParent, IDW_BREAK, NULL);

	AdjustWindow(XM7BREAK_WIDTH, XM7BREAK_HEIGHT);
}

/*
 *	`
 */
void CXM7BreakWnd::OnPaint()
{
	CDC *pDC;
	PAINTSTRUCT ps;
	CFont *pFont;
	CFont *pOldFont;

	int y;
	int j;
	char buffer[128];

	// DC̎󂯎AtHgw
	pDC = BeginPaint(&ps);
	pFont = GetViewFont();
	pOldFont = pDC->SelectObject(pFont);

	// C[v
	for (y=0; y<XM7BREAK_HEIGHT; y++) {
		buffer[0] = '\0';

		/* F */
		switch (breakp[y].flag) {
			case BREAKP_NOTUSE:
			case BREAKP_DISABLED:
				pDC->SetBkColor(RGB(255, 255, 255));
				break;
			case BREAKP_ENABLED:
				pDC->SetBkColor(RGB(223, 223, 223));
				break;
			case BREAKP_STOPPED:
				pDC->SetBkColor(RGB(255, 207, 207));
				break;
			default:
				ASSERT(FALSE);
				break;
		}

		if (breakp[y].flag != BREAKP_NOTUSE) {

			if (breakp[y].cpu == MAINCPU) {
				sprintf(buffer, "M %04X", breakp[y].addr);
			}
			else {
				sprintf(buffer, "S %04X", breakp[y].addr);
			}

			strcat(buffer, "  ");
			switch (breakp[y].flag) {
				case BREAKP_DISABLED:
					strcat(buffer, "Disable");
					break;
				case BREAKP_ENABLED:
					strcat(buffer, " Enable");
					break;
				case BREAKP_STOPPED:
					strcat(buffer, "  Break");
					break;
			}
		}

		// H
		j = strlen(buffer);
		if (j < XM7BREAK_WIDTH) {
			memset(buffer + j, 0x20, XM7BREAK_WIDTH - j);
			buffer[XM7BREAK_WIDTH] = '\0';
		}

		pDC->TextOut(0, y * m_nCharHeight, buffer, strlen(buffer));
	}

	// `I
	pDC->SelectObject(pOldFont);
	EndPaint(&ps);
	delete pFont;
}

/*
 *	_uNbN
 */
void CXM7BreakWnd::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	int y;
	CXM7Wnd *pParent;

	/* s𓾂 */
	y = point.y / m_nCharHeight;
	ASSERT((y >= 0) && (y < XM7BREAK_HEIGHT));

	/* u[N|Cgf[^`FbN */
	if (breakp[y].flag == BREAKP_NOTUSE) {
		return;
	}

	/* e𓾂āAZbg */
	pParent = (CXM7Wnd*)GetParent();
	if (breakp[y].cpu == MAINCPU) {
		if (pParent->m_pDisMainWnd) {
			pParent->m_pDisMainWnd->SetAddr(breakp[y].addr);
		}
	}
	else {
		if (pParent->m_pDisSubWnd) {
			pParent->m_pDisSubWnd->SetAddr(breakp[y].addr);
		}
	}
}

/*
 *	NbN
 */
void CXM7BreakWnd::OnLButtonDown(UINT nFlags, CPoint point)
{
	OnLButtonDblClk(nFlags, point);
}

/*
 *	ReLXgj[
 */
void CXM7BreakWnd::OnContextMenu(CWnd *pWnd, CPoint point)
{
	CRect rect;
	CMenu menu;
	CMenu *pMenu;
	CXM7Wnd *pMainWnd;

	// TEh~
	pMainWnd = (CXM7Wnd*)GetParent();
	pMainWnd->StopSnd();
	pMainWnd->m_bMenuFlag = TRUE;

	GetClientRect(&rect);
	ClientToScreen(&rect);

	// ʒu`FbNāAj[\
	if (rect.PtInRect(point)) {
		// ΃C𓾂
		m_ContextLine = (point.y - rect.top) / m_nCharHeight;
		ASSERT((m_ContextLine >= 0) && (m_ContextLine < XM7BREAK_HEIGHT));

		// j[\
		menu.LoadMenu(IDR_BREAKP);
		pMenu = menu.GetSubMenu(0);

		pMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_RIGHTBUTTON,
			point.x, point.y, this, 0);
		return;
	}

	// e֓n
	CWnd::OnContextMenu(pWnd, point);
}

/*
 *	L
 */
void CXM7BreakWnd::OnEnable()
{
	CXM7Wnd *pXM7Wnd;

	if (breakp[m_ContextLine].flag != BREAKP_NOTUSE) {
		breakp[m_ContextLine].flag = BREAKP_ENABLED;
		Invalidate(FALSE);

		pXM7Wnd = (CXM7Wnd*)GetParent();
		if (pXM7Wnd->m_pDisMainWnd) {
			pXM7Wnd->m_pDisMainWnd->Invalidate(FALSE);
		}
		if (pXM7Wnd->m_pDisSubWnd) {
			pXM7Wnd->m_pDisSubWnd->Invalidate(FALSE);
		}
	}
}

/*
 *	
 */
void CXM7BreakWnd::OnDisable()
{
	CXM7Wnd *pXM7Wnd;

	if (breakp[m_ContextLine].flag != BREAKP_NOTUSE) {
		breakp[m_ContextLine].flag = BREAKP_DISABLED;
		Invalidate(FALSE);

		pXM7Wnd = (CXM7Wnd*)GetParent();
		if (pXM7Wnd->m_pDisMainWnd) {
			pXM7Wnd->m_pDisMainWnd->Invalidate(FALSE);
		}
		if (pXM7Wnd->m_pDisSubWnd) {
			pXM7Wnd->m_pDisSubWnd->Invalidate(FALSE);
		}
	}
}

/*
 *	폜
 */
void CXM7BreakWnd::OnDelete()
{
	CXM7Wnd *pXM7Wnd;

	if (breakp[m_ContextLine].flag != BREAKP_NOTUSE) {
		breakp[m_ContextLine].flag = BREAKP_NOTUSE;
		Invalidate(FALSE);

		pXM7Wnd = (CXM7Wnd*)GetParent();
		if (pXM7Wnd->m_pDisMainWnd) {
			pXM7Wnd->m_pDisMainWnd->Invalidate(FALSE);
		}
		if (pXM7Wnd->m_pDisSubWnd) {
			pXM7Wnd->m_pDisSubWnd->Invalidate(FALSE);
		}
	}
}

/*
 *	NA
 */
void CXM7BreakWnd::OnClear()
{
	CXM7Wnd *pXM7Wnd;

	memset(breakp, 0, sizeof(breakp));
	Invalidate(FALSE);

	pXM7Wnd = (CXM7Wnd*)GetParent();
	if (pXM7Wnd->m_pDisMainWnd) {
		pXM7Wnd->m_pDisMainWnd->Invalidate(FALSE);
	}
	if (pXM7Wnd->m_pDisSubWnd) {
		pXM7Wnd->m_pDisSubWnd->Invalidate(FALSE);
	}
}

/*-[ ROMo[WEChE ]----------------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7VerWnd, CXM7ViewWnd)
	ON_WM_PAINT()
END_MESSAGE_MAP()

/*
 *	ROMo[WEChE쐬
 */
CXM7VerWnd::CXM7VerWnd(CWnd **pNotify, CWnd *pParent)
	: CXM7ViewWnd(pNotify)
{
	CRect rect;

	ASSERT(pParent);

	rect.top = 0;
	rect.left = 0;
	rect.right = 128;
	rect.bottom = 128;

	Create(NULL, XM7VER_NAME,
		WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS,
		rect, pParent, IDW_VER, NULL);

	AdjustWindow(XM7VER_WIDTH, XM7VER_HEIGHT);
}

/*
 *	`
 */
void CXM7VerWnd::OnPaint()
{
	CDC *pDC;
	PAINTSTRUCT ps;
	CFont *pFont;
	CFont *pOldFont;

	char buffer[128];

	// DC̎󂯎AtHgw
	pDC = BeginPaint(&ps);
	pFont = GetViewFont();
	pOldFont = pDC->SelectObject(pFont);

	// F-BASICLE
	strcpy(buffer, "BASIC ROM    ");
	if (basicrom_en) {
		strcat(buffer, " Enable");
	}
	else {
		strcat(buffer, "Disable");
	}
	pDC->TextOut(0 * m_nCharWidth, 0 * m_nCharHeight, buffer, strlen(buffer));

	// BIOSo[W
	sprintf(buffer, "BIOS  Ver.      %c%c%c%c",
		basic_rom[0x7176], basic_rom[0x7177]+0x30,
		basic_rom[0x7178], basic_rom[0x7179]+0x30);
	pDC->TextOut(0 * m_nCharWidth, 1 * m_nCharHeight, buffer, strlen(buffer));

	// BIOSt
	sprintf(buffer, "BIOS  Date  %02x/%02x/%02x",
		basic_rom[0x717a], basic_rom[0x717b], basic_rom[0x717c]);
	pDC->TextOut(0 * m_nCharWidth, 2 * m_nCharHeight, buffer, strlen(buffer));

	// BASICo[W
	sprintf(buffer, "BASIC Ver.    V%c%c.%c%c",
		basic_rom[0x7ba5],
		basic_rom[0x7ba6],
		basic_rom[0x7ba7],
		basic_rom[0x7ba8]);
	pDC->TextOut(0 * m_nCharWidth, 3 * m_nCharHeight, buffer, strlen(buffer));

	// BASICt
	sprintf(buffer, "BASIC Date  %c%c/%c%c/%c%c",
		basic_rom[0x7ba9], basic_rom[0x7baa],
		basic_rom[0x7bab], basic_rom[0x7bac],
		basic_rom[0x7bad], basic_rom[0x7bae]);
	pDC->TextOut(0 * m_nCharWidth, 4 * m_nCharHeight, buffer, strlen(buffer));

	// `I
	pDC->SelectObject(pOldFont);
	EndPaint(&ps);
	delete pFont;
}

/*-[ TLLpbgEChE ]------------------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7TTLPalWnd, CXM7ViewWnd)
	ON_WM_PAINT()
END_MESSAGE_MAP()

/*
 *	TTLpbgEChE쐬
 */
CXM7TTLPalWnd::CXM7TTLPalWnd(CWnd **pNotify, CWnd *pParent)
	: CXM7ViewWnd(pNotify)
{
	CRect rect;

	ASSERT(pParent);

	rect.top = 0;
	rect.left = 0;
	rect.right = 128;
	rect.bottom = 128;

	Create(NULL, XM7TTLPAL_NAME,
		WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS,
		rect, pParent, IDW_TTLPAL, NULL);

	AdjustWindow(XM7TTLPAL_WIDTH, XM7TTLPAL_HEIGHT);
}

/*
 *	`
 */
void CXM7TTLPalWnd::OnPaint()
{
	CDC *pDC;
	PAINTSTRUCT ps;
	CFont *pFont;
	CFont *pOldFont;

	int i;
	char buffer[128];
	const char *table[8] = {
		"  Black",
		"   Blue",
		"    Red",
		"Magenta",
		"  Green",
		"   Cyan",
		" Yellow",
		"  White"
	};

	// DC̎󂯎AtHgw
	pDC = BeginPaint(&ps);
	pFont = GetViewFont();
	pOldFont = pDC->SelectObject(pFont);

	for (i=0; i<8; i++) {
		sprintf(buffer, "%1d    ", i);
		strcat(buffer, table[ttl_palet[i]]);
		pDC->TextOut(0, i * m_nCharHeight, buffer, strlen(buffer));
	}

	// `I
	pDC->SelectObject(pOldFont);
	EndPaint(&ps);
	delete pFont;
}

/*-[ }`y[WEChE ]-----------------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7MultiWnd, CXM7ViewWnd)
	ON_WM_PAINT()
END_MESSAGE_MAP()

/*
 *	}`y[WEChE쐬
 */
CXM7MultiWnd::CXM7MultiWnd(CWnd **pNotify, CWnd *pParent)
	: CXM7ViewWnd(pNotify)
{
	CRect rect;

	ASSERT(pParent);

	rect.top = 0;
	rect.left = 0;
	rect.right = 128;
	rect.bottom = 128;

	Create(NULL, XM7MULTI_NAME,
		WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS,
		rect, pParent, IDW_MULTI, NULL);

	AdjustWindow(XM7MULTI_WIDTH, XM7MULTI_HEIGHT);
}

/*
 *	`
 */
void CXM7MultiWnd::OnPaint()
{
	CDC *pDC;
	PAINTSTRUCT ps;
	CFont *pFont;
	CFont *pOldFont;

	int i;
	int dat;
	char buffer[128];

	// DC̎󂯎AtHgw
	pDC = BeginPaint(&ps);
	pFont = GetViewFont();
	pOldFont = pDC->SelectObject(pFont);

	// f[^擾
	dat = (int)multi_page;

	for (i=0; i<3; i++) {
		switch (i) {
			case 0:
				strcpy(buffer, "Blue ");
				break;
			case 1:
				strcpy(buffer, "Red  ");
				break;
			case 2:
				strcpy(buffer, "Green");
				break;
			default:
				ASSERT(FALSE);
				break;
		}

		strcat(buffer, "    ");
		// ANZX\
		if (dat & 0x01) {
			strcat(buffer, "      ");
		}
		else {
			strcat(buffer, "Active");
		}

		strcat(buffer, "  ");
		// \\
		if (dat & 0x10) {
			strcat(buffer, "       ");
		}
		else {
			strcat(buffer, "Visible");
		}

		// \
		pDC->TextOut(0, m_nCharHeight * i, buffer, strlen(buffer));

		// Vtg
		dat = dat >> 1;
	}

	// `I
	pDC->SelectObject(pOldFont);
	EndPaint(&ps);
	delete pFont;
}

/*-[ FDCEChE ]--------------------------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7FDCWnd, CXM7ViewWnd)
	ON_WM_PAINT()
END_MESSAGE_MAP()

/*
 *	FDCEChE쐬
 */
CXM7FDCWnd::CXM7FDCWnd(CWnd **pNotify, CWnd *pParent)
	: CXM7ViewWnd(pNotify)
{
	CRect rect;

	ASSERT(pParent);

	rect.top = 0;
	rect.left = 0;
	rect.right = 128;
	rect.bottom = 128;

	Create(NULL, XM7FDC_NAME,
		WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS,
		rect, pParent, IDW_FDC, NULL);

	AdjustWindow(XM7FDC_WIDTH, XM7FDC_HEIGHT);
}

/*
 *	`
 */
void CXM7FDCWnd::OnPaint()
{
	CDC *pDC;
	PAINTSTRUCT ps;
	CFont *pFont;
	CFont *pOldFont;

	// DC̎󂯎AtHgw
	pDC = BeginPaint(&ps);
	pFont = GetViewFont();
	pOldFont = pDC->SelectObject(pFont);

	// TuĂ
	CmdSub(pDC, 0, 0);
	Space(pDC, 18, 0, 2, 8);
	RegSub(pDC, 20, 0);
	Space(pDC, 34, 0, 2, 8);
	StatSub(pDC, 36, 0);

	// `I
	pDC->SelectObject(pOldFont);
	EndPaint(&ps);
	delete pFont;
}

/*
 *	Xy[X`
 */
void CXM7FDCWnd::Space(CDC *pDC, UINT x, UINT y, UINT w, UINT h)
{
	char buffer[128];
	int i;

	memset(buffer, 0x20, w);
	buffer[w] = '\0';

	for (i=0; i<(int)h; i++) {
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, w);
		y++;
	}
}

/*
 *	WX^n`
 */
void CXM7FDCWnd::RegSub(CDC *pDC, UINT x, UINT y)
{
	char buffer[128];

	sprintf(buffer, "Drive   %1d", fdc_drvreg);
	if (fdc_motor) {
		strcat(buffer, "( On)");
	}
	else {
		strcat(buffer, "(Off)");
	}
	pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
	y++;

	if (fdc_drvreg < FDC_DRIVES) {
		sprintf(buffer, "Track       %02X", fdc_track[fdc_drvreg]);
	}
	else {
		buffer[0] = '\0';
		StringExt(buffer, 16);
	}
	pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
	y++;

	sprintf(buffer, "Track  Reg. %02X", fdc_trkreg);
	pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
	y++;


	sprintf(buffer, "Sector Reg. %02X", fdc_secreg);
	pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
	y++;

	sprintf(buffer, "Side   Reg. %02X", fdc_sidereg);
	pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
	y++;

	sprintf(buffer, "Data   Reg. %02X", fdc_datareg);
	pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
	y++;

	if (fdc_drqirq & 0x80) {
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, "DRQ         On", 14);
	}
	else {
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, "DRQ        Off", 14);
	}
	y++;

	if (fdc_drqirq & 0x40) {
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, "IRQ         On", 14);
	}
	else {
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, "IRQ        Off", 14);
	}
	y++;
}

/*
 *	R}hn`
 */
void CXM7FDCWnd::CmdSub(CDC *pDC, UINT x, UINT y)
{
	BYTE high, low;
	char buffer[128];

	if (fdc_command == 0xff) {
		/* R}h */
		strcpy(buffer, "NO COMMAND");
		StringExt(buffer, 18);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		Space(pDC, x, y+1, 18, 7);
		return;
	}

	high = fdc_command >> 4;
	low = fdc_command & 0x0f;
	if (high < 8) {
		/* TYPE I */
		switch (high) {
			/* RESTORE */
			case 0:
				strcpy(buffer, "RESTORE");
				break;
			/* SEEK */
			case 1:
				strcpy(buffer, "SEEK");
				break;
			/* STEP */
			case 2:
			case 3:
				strcpy(buffer, "STEP");
				break;
			/* STEP IN */
			case 4:
			case 5:
				strcpy(buffer, "STEP IN");
				break;
			/* STEP IN */
			case 6:
			case 7:
				strcpy(buffer, "STEP OUT");
				break;
		}
		StringExt(buffer, 18);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		strcpy(buffer, "(TYPE I)");
		StringExt(buffer, 18);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		buffer[0] = '\0';
		StringExt(buffer, 18);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		strcpy(buffer, "Step Rate     ");
		switch (low & 0x03) {
			case 0:
				strcat(buffer, " 6ms");
				break;
			case 1:
				strcat(buffer, "12ms");
				break;
			case 2:
				strcat(buffer, "20ms");
				break;
			case 3:
				strcat(buffer, "30ms");
				break;
		}
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		strcpy(buffer, "Verify         ");
		if (low & 0x04) {
			strcat(buffer, " On");
		}
		else {
			strcat(buffer, "Off");
		}
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		strcpy(buffer, "Head        ");
		if (low & 0x08) {
			strcat(buffer, "  Load");
		}
		else {
			strcat(buffer, "Unload");
		}
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		if (high < 2) {
			buffer[0] = '\0';
			StringExt(buffer, 18);
		}
		else {
			strcpy(buffer, "Update Track   ");
			if (low & 0x04) {
				strcat(buffer, " On");
			}
			else {
				strcat(buffer, "Off");
			}
		}
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		buffer[0] = '\0';
		StringExt(buffer, 18);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;
		return;
	}

	if ((high & 0x0c) == 0x08) {
		/* TYPE II */
		if (high < 0x0a) {
			strcpy(buffer, "READ DATA");
		} else {
			strcpy(buffer, "WRITE DATA");
		}
		StringExt(buffer, 18);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		strcpy(buffer, "(TYPE II)");
		StringExt(buffer, 18);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		buffer[0] = '\0';
		StringExt(buffer, 18);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		strcpy(buffer, "Multi Sector   ");
		if (high & 0x01) {
			strcat(buffer, " On");
		}
		else {
			strcat(buffer, "Off");
		}
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		strcpy(buffer, "Compare Side   ");
		if (low & 0x02) {
			if (low & 0x08) {
				strcat(buffer, "  0");
			}
			else {
				strcat(buffer, "  1");
			}
		} else {
			strcat(buffer, "Off");
		}
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		strcpy(buffer, "Addr. Mark ");
		if (low & 0x01) {
			strcat(buffer, "Deleted");
		}
		else {
			strcat(buffer, " Normal");
		}
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		sprintf(buffer, "Total Bytes   %04X", fdc_totalcnt);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		sprintf(buffer, "Xfer. Bytes   %04X", fdc_nowcnt);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;
	}

	/* Type I, II͏I */
	if (high < 0x0c) {
		return;
	}

	/* Type IV */
	if (high == 0x0d) {
		strcpy(buffer, "FORCE INTERRUPT");
		StringExt(buffer, 18);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		strcpy(buffer, "(TYPE IV)");
		StringExt(buffer, 18);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		buffer[0] = '\0';
		StringExt(buffer, 18);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		strcpy(buffer, "READY  In      ");
		if (low & 0x01) {
			strcat(buffer, "IRQ");
		}
		else {
			strcat(buffer, "Off");
		}
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		strcpy(buffer, "READY Out      ");
		if (low & 0x02) {
			strcat(buffer, "IRQ");
		}
		else {
			strcat(buffer, "Off");
		}
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		strcpy(buffer, "INDEX          ");
		if (low & 0x04) {
			strcat(buffer, "IRQ");
		}
		else {
			strcat(buffer, "Off");
		}
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		strcpy(buffer, "One Shot       ");
		if (low & 0x08) {
			strcat(buffer, "IRQ");
		}
		else {
			strcat(buffer, "Off");
		}
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;
	}
	else {
		/* TYPE III */
		switch (high) {
			case 0x0c:
				strcpy(buffer, "READ ADDRESS");
				break;
			case 0x0e:
				strcpy(buffer, "READ TRACK");
				break;
			case 0x0f:
				strcpy(buffer, "WRITE TRACK");
				break;
		}
		StringExt(buffer, 18);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		strcpy(buffer, "(TYPE III)");
		StringExt(buffer, 18);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		buffer[0] = '\0';
		StringExt(buffer, 18);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		sprintf(buffer, "Total Bytes   %04X", fdc_totalcnt);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;

		sprintf(buffer, "Xfer. Bytes   %04X", fdc_nowcnt);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;
	}
}

/*
 *	Xe[^Xn`
 */
void CXM7FDCWnd::StatSub(CDC *pDC, UINT x, UINT y)
{
	int type;
	int i;
	BYTE dat;
	BYTE bit;
	char buffer[128];

	/* ^Cv */
	type = 0;
	if ((fdc_command & 0xe0) == 0x80) {
		/* READ DATA */
		type = 1;
	}
	if ((fdc_command & 0xe0) == 0xa0) {
		/* WRITE DATA */
		type = 2;
	}
	if ((fdc_command & 0xf0) == 0xc0) {
		/* READ ADDRESS */
		type = 1;
	}
	if ((fdc_command & 0xf0) == 0xe0) {
		/* READ TRACK */
		type = 1;
	}
	if ((fdc_command & 0xf0) == 0xf0) {
		/* WRITE TRACK */
		type = 2;
	}

	/* ݒ */
	dat = fdc_status;
	bit = 0x80;

	/* Wrbg[v */
	for (i=7; i>=0; i--) {
		sprintf(buffer, "bit%d ", i);
		if (dat & bit) {
			switch (i) {
				/* BUSY */
				case 0:
					strcat(buffer, "BUSY");
					break;
				/* INDEX or DATA REQUEST */
				case 1:
					if (type == 0) {
						strcat(buffer, "INDEX");
					}
					else {
						strcat(buffer, "DATA REQUEST");
					}
					break;
				/* TRACK00 or LOST DATA */
				case 2:
					if (type == 0) {
						strcat(buffer, "TRACK00");
					}
					else {
						strcat(buffer, "LOST DATA");
					}
					break;
				/* CRC ERROR */
				case 3:
					strcat(buffer, "CRC ERROR");
					break;
				/* SEEK ERROR or RECORD NOT FOUND */
				case 4:
					if (type == 0) {
						strcat(buffer, "SEEK ERROR");
					}
					else {
						strcat(buffer, "RECORD NOT FOUND");
					}
					break;
				/* HEAD ENGAGED or RECORD TYPE or WRITE FAULT */
				case 5:
					switch (type) {
						case 0:
							strcat(buffer, "HEAD ENGAGED");
							break;
						case 1:
							strcat(buffer, "RECORD TYPE");
							break;
						case 2:
							strcat(buffer, "WRITE FAULT");
							break;
					}
					break;
				/* WRITE PROTECT */
				case 6:
					strcat(buffer, "WRITE PROTECT");
					break;
				/* NOT READY */
				case 7:
					strcat(buffer, "NOT READY");
					break;
			}
		}
		else {
			strcat(buffer, "----------------");
		}
		bit >>= 1;
		StringExt(buffer, 21);
		pDC->TextOut(m_nCharWidth * x, m_nCharHeight * y, buffer, strlen(buffer));
		y++;
	}
}

/*-[ ROMEChE ]----------------------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7KnjWnd, CXM7ViewWnd)
	ON_WM_PAINT()
END_MESSAGE_MAP()

/*
 *	TuCPURg[EChE쐬
 */
CXM7KnjWnd::CXM7KnjWnd(CWnd **pNotify, CWnd *pParent)
	: CXM7ViewWnd(pNotify)
{
	CRect rect;

	ASSERT(pParent);

	rect.top = 0;
	rect.left = 0;
	rect.right = 128;
	rect.bottom = 128;

	Create(NULL, XM7KNJ_NAME,
		WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS,
		rect, pParent, IDW_KNJ, NULL);

	AdjustWindow(XM7KNJ_WIDTH, XM7KNJ_HEIGHT);
}

/*
 *	`
 */
void CXM7KnjWnd::OnPaint()
{
	CDC *pDC;
	PAINTSTRUCT ps;
	CFont *pFont;
	CFont *pOldFont;

	char buffer[128];
	int i, j;
	WORD addr;
	int index;
	WORD dat;

	// DC̎󂯎AtHgw
	pDC = BeginPaint(&ps);
	pFont = GetViewFont();
	pOldFont = pDC->SelectObject(pFont);

	// ROMCl[utO
	strcpy(buffer, "Function ");
	if (kanji_flag) {
		strcat(buffer, " Enable");
	}
	else {
		strcat(buffer, "Disable");
	}
	pDC->TextOut(0, m_nCharHeight * 0, buffer, strlen(buffer));

	// ROMAhX
	sprintf(buffer, "ROM Address %04X", kanji_addr);
	pDC->TextOut(0, m_nCharHeight * 1, buffer, strlen(buffer));

	// [v
	addr = kanji_addr & 0xfff0;
	index = addr >> 14;
	addr &= 0x3fff;
	addr <<= 1;
	for (i=0; i<16; i++) {
		if (!kanji_flag) {
			dat = 0xffff;
		}
		else {
			dat = kanji_rom[index][addr++];
			dat <<= 8;
			dat |= kanji_rom[index][addr++];
		}
		for (j=0; j<16; j++) {
			if (dat & 0x8000) {
				buffer[j] = 'X';
			}
			else {
				buffer[j] = ' ';
			}
			dat <<= 1;
		}
		pDC->TextOut(0, m_nCharHeight * (i + 2), buffer, 16);
	}

	// `I
	pDC->SelectObject(pOldFont);
	EndPaint(&ps);
	delete pFont;
}

/*-[ JZbge[vEChE ]---------------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7TapeWnd, CXM7ViewWnd)
	ON_WM_PAINT()
END_MESSAGE_MAP()

/*
 *	JZbge[vEChE쐬
 */
CXM7TapeWnd::CXM7TapeWnd(CWnd **pNotify, CWnd *pParent)
	: CXM7ViewWnd(pNotify)
{
	CRect rect;

	ASSERT(pParent);

	rect.top = 0;
	rect.left = 0;
	rect.right = 128;
	rect.bottom = 128;

	Create(NULL, XM7TAPE_NAME,
		WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS,
		rect, pParent, IDW_LP, NULL);

	AdjustWindow(XM7TAPE_WIDTH, XM7TAPE_HEIGHT);
}

/*
 *	`
 */
void CXM7TapeWnd::OnPaint()
{
	CDC *pDC;
	PAINTSTRUCT ps;
	CFont *pFont;
	CFont *pOldFont;

	char buffer[128];

	// DC̎󂯎AtHgw
	pDC = BeginPaint(&ps);
	pFont = GetViewFont();
	pOldFont = pDC->SelectObject(pFont);

	// [^
	strcpy(buffer, "Motor        ");
	if (tape_motor) {
		strcat(buffer, " On");
	}
	else {
		strcat(buffer, "Off");
	}
	pDC->TextOut(0, m_nCharHeight * 0, buffer, strlen(buffer));

	// ^
	strcpy(buffer, "Record       ");
	if (tape_rec) {
		strcat(buffer, " On");
	}
	else {
		strcat(buffer, "Off");
	}
	pDC->TextOut(0, m_nCharHeight * 1, buffer, strlen(buffer));

	// ̓f[^
	strcpy(buffer, "Input  Data    ");
	if (tape_in) {
		strcat(buffer, "1");
	}
	else {
		strcat(buffer, "0");
	}
	pDC->TextOut(0, m_nCharHeight * 2, buffer, strlen(buffer));

	// o̓f[^
	strcpy(buffer, "Output Data    ");
	if (tape_out) {
		strcat(buffer, "1");
	}
	else {
		strcat(buffer, "0");
	}
	pDC->TextOut(0, m_nCharHeight * 3, buffer, strlen(buffer));

	// TCNJE^
	sprintf(buffer, "Cycle Count %04X", tape_count);
	pDC->TextOut(0, m_nCharHeight * 4, buffer, strlen(buffer));

	// t@CItZbg
	sprintf(buffer, "File Offset %04X", tape_offset >> 4);
	pDC->TextOut(0, m_nCharHeight * 5, buffer, strlen(buffer));

	// `I
	pDC->SelectObject(pOldFont);
	EndPaint(&ps);
	delete pFont;
}

/*-[ Cv^EChE ]---------------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7LPWnd, CXM7ViewWnd)
	ON_WM_PAINT()
END_MESSAGE_MAP()

/*
 *	Cv^EChE쐬
 */
CXM7LPWnd::CXM7LPWnd(CWnd **pNotify, CWnd *pParent)
	: CXM7ViewWnd(pNotify)
{
	CRect rect;

	ASSERT(pParent);

	rect.top = 0;
	rect.left = 0;
	rect.right = 128;
	rect.bottom = 128;

	Create(NULL, XM7LP_NAME,
		WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS,
		rect, pParent, IDW_LP, NULL);

	AdjustWindow(XM7LP_WIDTH, XM7LP_HEIGHT);
}

/*
 *	`
 */
void CXM7LPWnd::OnPaint()
{
	CDC *pDC;
	PAINTSTRUCT ps;
	CFont *pFont;
	CFont *pOldFont;

	char buffer[128];

	// DC̎󂯎AtHgw
	pDC = BeginPaint(&ps);
	pFont = GetViewFont();
	pOldFont = pDC->SelectObject(pFont);

	// f[^
	sprintf(buffer, "Print Data    %02X", lp_data);
	pDC->TextOut(0, m_nCharHeight * 0, buffer, strlen(buffer));

	// Xg[utO
	strcpy(buffer, "Strobe       ");
	if (lp_strobe) {
		strcat(buffer, " On");
	}
	else {
		strcat(buffer, "Off");
	}
	pDC->TextOut(0, m_nCharHeight * 1, buffer, strlen(buffer));

	// t@Co̓tO
	strcpy(buffer, "File Output  ");
	if (lp_fileh != -1) {
		strcat(buffer, " On");
	}
	else {
		strcat(buffer, "Off");
	}
	pDC->TextOut(0, m_nCharHeight * 2, buffer, strlen(buffer));

	// `I
	pDC->SelectObject(pOldFont);
	EndPaint(&ps);
	delete pFont;
}

/*-[ OPNEChE ]--------------------------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7OPNWnd, CXM7ViewWnd)
	ON_WM_PAINT()
END_MESSAGE_MAP()

/*
 *	OPNEChE쐬
 */
CXM7OPNWnd::CXM7OPNWnd(CWnd **pNotify, CWnd *pParent)
	: CXM7ViewWnd(pNotify)
{
	CRect rect;

	ASSERT(pParent);

	rect.top = 0;
	rect.left = 0;
	rect.right = 128;
	rect.bottom = 128;

	Create(NULL, XM7OPN_NAME,
		WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS,
		rect, pParent, IDW_OPN, NULL);

	AdjustWindow(XM7OPN_WIDTH, XM7OPN_HEIGHT);
}

/*
 *	`
 */
void CXM7OPNWnd::OnPaint()
{
	CDC *pDC;
	PAINTSTRUCT ps;
	CFont *pFont;
	CFont *pOldFont;

	char buffer[128];
	char temp[3];
	int x, y;

	// DC̎󂯎AtHgw
	pDC = BeginPaint(&ps);
	pFont = GetViewFont();
	pOldFont = pDC->SelectObject(pFont);

	// ^C}[\
	sprintf(buffer, "Timer-A ( On) %3d.%02dms",
		opn_timera_tick / 100, opn_timera_tick % 100);
	if (!opn_timera) {
		buffer[9] = 'O';
		buffer[10] = 'f';
		buffer[11] = 'f';
	}
	StringExt(buffer, 32);
	pDC->TextOut(0, m_nCharHeight * 0, buffer, strlen(buffer));
	sprintf(buffer, "Timer-B ( On) %3d.%02dms",
		opn_timerb_tick / 100, opn_timerb_tick % 100);
	if (!opn_timerb) {
		buffer[9] = 'O';
		buffer[10] = 'f';
		buffer[11] = 'f';
	}
	StringExt(buffer, 32);
	pDC->TextOut(0, m_nCharHeight * 1, buffer, strlen(buffer));

	// vXP[\
	sprintf(buffer, "Pre-Scaler      1 / %1d", opn_scale);
	StringExt(buffer, 32);
	pDC->TextOut(0, m_nCharHeight * 2, buffer, strlen(buffer));

	// WX^\
	for (y=0; y<32; y++) {
		buffer[0] = '\0';
		for (x=0; x<16; x++) {
			sprintf(temp, "%02X", opn_reg[y * 16 + x]);
			strcat(buffer, temp);
		}
		pDC->TextOut(0, m_nCharHeight * (y + 3), buffer, strlen(buffer));
	}

	// `I
	pDC->SelectObject(pOldFont);
	EndPaint(&ps);
	delete pFont;
}

/*-[ TuCPURg[EChE ]----------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7SubWnd, CXM7ViewWnd)
	ON_WM_PAINT()
END_MESSAGE_MAP()

/*
 *	TuCPURg[EChE쐬
 */
CXM7SubWnd::CXM7SubWnd(CWnd **pNotify, CWnd *pParent)
	: CXM7ViewWnd(pNotify)
{
	CRect rect;

	ASSERT(pParent);

	rect.top = 0;
	rect.left = 0;
	rect.right = 128;
	rect.bottom = 128;

	Create(NULL, XM7SUB_NAME,
		WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS,
		rect, pParent, IDW_SUB, NULL);

	AdjustWindow(XM7SUB_WIDTH, XM7SUB_HEIGHT);
}

/*
 *	`
 */
void CXM7SubWnd::OnPaint()
{
	CDC *pDC;
	PAINTSTRUCT ps;
	CFont *pFont;
	CFont *pOldFont;

	char buffer[128];

	// DC̎󂯎AtHgw
	pDC = BeginPaint(&ps);
	pFont = GetViewFont();
	pOldFont = pDC->SelectObject(pFont);

	// HALTtO
	strcpy(buffer, "Sub Halt       ");
	if (subhalt_flag) {
		strcat(buffer, "Halt");
	}
	else {
		strcat(buffer, " Run");
	}
	pDC->TextOut(0, m_nCharHeight * 0, buffer, strlen(buffer));

	// BUSYtO
	strcpy(buffer, "Sub Busy      ");
	if (subbusy_flag) {
		strcat(buffer, " Busy");
	}
	else {
		strcat(buffer, "Ready");
	}
	pDC->TextOut(0, m_nCharHeight * 1, buffer, strlen(buffer));

	// LZtO
	strcpy(buffer, "Cancel IRQ    ");
	if (subcancel_flag) {
		strcat(buffer, "   On");
	}
	else {
		strcat(buffer, "  Off");
	}
	pDC->TextOut(0, m_nCharHeight * 2, buffer, strlen(buffer));

	// AeVtO
	strcpy(buffer, "Attention IRQ ");
	if (subattn_flag) {
		strcat(buffer, "   On");
	}
	else {
		strcat(buffer, "  Off");
	}
	pDC->TextOut(0, m_nCharHeight * 3, buffer, strlen(buffer));

	// `I
	pDC->SelectObject(pOldFont);
	EndPaint(&ps);
	delete pFont;
}

/*-[ L[{[hEChE ]-------------------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7KbdWnd, CXM7ViewWnd)
	ON_WM_PAINT()
END_MESSAGE_MAP()

/*
 *	L[{[hEChE쐬
 */
CXM7KbdWnd::CXM7KbdWnd(CWnd **pNotify, CWnd *pParent)
	: CXM7ViewWnd(pNotify)
{
	CRect rect;

	ASSERT(pParent);

	rect.top = 0;
	rect.left = 0;
	rect.right = 128;
	rect.bottom = 128;

	Create(NULL, XM7KBD_NAME,
		WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS,
		rect, pParent, IDW_KEYBOARD, NULL);

	AdjustWindow(XM7KBD_WIDTH, XM7KBD_HEIGHT);
}

/*
 *	`
 */
void CXM7KbdWnd::OnPaint()
{
	CDC *pDC;
	PAINTSTRUCT ps;
	CFont *pFont;
	CFont *pOldFont;

	char buffer[128];
	CXM7Wnd *pXM7Wnd;

	// DC̎󂯎AtHgw
	pDC = BeginPaint(&ps);
	pFont = GetViewFont();
	pOldFont = pDC->SelectObject(pFont);

	// eEChE󂯎
	pXM7Wnd = (CXM7Wnd*)GetParent();

	// FM-7 _R[h
	sprintf(buffer, "Logical  Code %04X", key_fm7);
	pDC->TextOut(0, m_nCharHeight * 0, buffer, strlen(buffer));

	// FM-7 R[h
	sprintf(buffer, "Physical Code   %02X", key_scan);
	pDC->TextOut(0, m_nCharHeight * 1, buffer, strlen(buffer));

	// CAP LED
	strcpy(buffer,  "CAP  LED       ");
	if (caps_flag) {
		strcat(buffer, " On");
	}
	else {
		strcat(buffer, "Off");
	}
	pDC->TextOut(0, m_nCharHeight * 2, buffer, strlen(buffer));

	// JiLED
	strcpy(buffer,  "KANA LED       ");
	if (kana_flag) {
		strcat(buffer, " On");
	}
	else {
		strcat(buffer, "Off");
	}
	pDC->TextOut(0, m_nCharHeight * 3, buffer, strlen(buffer));

	// INS LED
	strcpy(buffer,  "INS  LED       ");
	if (ins_flag) {
		strcat(buffer, " On");
	}
	else {
		strcat(buffer, "Off");
	}
	pDC->TextOut(0, m_nCharHeight * 4, buffer, strlen(buffer));

	// SHIFT
	strcpy(buffer,  "SHIFT          ");
	if (shift_flag) {
		strcat(buffer, " On");
	}
	else {
		strcat(buffer, "Off");
	}
	pDC->TextOut(0, m_nCharHeight * 5, buffer, strlen(buffer));

	// CTRL
	strcpy(buffer,  "CTRL           ");
	if (ctrl_flag) {
		strcat(buffer, " On");
	}
	else {
		strcat(buffer, "Off");
	}
	pDC->TextOut(0, m_nCharHeight * 6, buffer, strlen(buffer));

	// GRAPH
	strcpy(buffer,  "GRAPH          ");
	if (graph_flag) {
		strcat(buffer, " On");
	}
	else {
		strcat(buffer, "Off");
	}
	pDC->TextOut(0, m_nCharHeight * 7, buffer, strlen(buffer));

	// Break
	strcpy(buffer,  "BREAK          ");
	if (break_flag) {
		strcat(buffer, " On");
	}
	else {
		strcat(buffer, "Off");
	}
	pDC->TextOut(0, m_nCharHeight * 8, buffer, strlen(buffer));

	// `I
	pDC->SelectObject(pOldFont);
	EndPaint(&ps);
	delete pFont;
}

/*-[ CRTWX^EChE ]------------------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7CRTWnd, CXM7ViewWnd)
	ON_WM_PAINT()
END_MESSAGE_MAP()

/*
 *	CRTWX^EChE쐬
 */
CXM7CRTWnd::CXM7CRTWnd(CWnd **pNotify, CWnd *pParent)
	: CXM7ViewWnd(pNotify)
{
	CRect rect;

	ASSERT(pParent);

	rect.top = 0;
	rect.left = 0;
	rect.right = 128;
	rect.bottom = 128;

	Create(NULL, XM7CRT_NAME,
		WS_CHILD | WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPSIBLINGS,
		rect, pParent, IDW_CRT, NULL);

	AdjustWindow(XM7CRT_WIDTH, XM7CRT_HEIGHT);
}

/*
 *	`
 */
void CXM7CRTWnd::OnPaint()
{
	CDC *pDC;
	PAINTSTRUCT ps;
	CFont *pFont;
	CFont *pOldFont;

	char buffer[128];

	// DC̎󂯎AtHgw
	pDC = BeginPaint(&ps);
	pFont = GetViewFont();
	pOldFont = pDC->SelectObject(pFont);

	// CRTtO
	strcpy(buffer, "CRT Display     ");
	if (crt_flag) {
		strcat(buffer, " On");
	}
	else {
		strcat(buffer, "Off");
	}
	pDC->TextOut(0, m_nCharHeight * 0, buffer, strlen(buffer));

	// VRAMANZXtO
	strcpy(buffer, "VRAM Access     ");
	if (vrama_flag) {
		strcat(buffer, " On");
	}
	else {
		strcat(buffer, "Off");
	}
	pDC->TextOut(0, m_nCharHeight * 1, buffer, strlen(buffer));

	// VRAMItZbgWX^
	sprintf(buffer, "VRAM Offset    %04X", vram_offset);
	pDC->TextOut(0, m_nCharHeight * 2, buffer, strlen(buffer));

	// `I
	pDC->SelectObject(pOldFont);
	EndPaint(&ps);
	delete pFont;
}

#endif	/* _WIN32 */
