/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ Win16 ]
 */

#ifdef _WIN16

#ifndef _W16_H_
#define _W16_H_

#include "xm7.h"

/*
 *	ʎq
 */
#define XM7ICON		1
#define ABOUTDLG	2
#define DISKDLG		3
#define MAINMENU	200
#define CM_USER		100
#define CM_APPEXIT	101
#define CM_SYSRESET	102
#define CM_DRV1OPEN	103
#define CM_DRV0OPEN	104
#define CM_DRV0SEL	105
#define CM_KEY106	106
#define CM_APPABOUT	107
#define CM_DRV1SEL	108
#define CM_KEY98	109
#define IDC_LISTBOX	110
#define CM_KEYTOWNS	111

/*
 *	t[EChE NX
 */
class TXM7Window : public TFrameWindow {
public:
	/* K{ */
	TXM7Window();
	void SetupWindow();
	void CleanupWindow();
	BOOL CanClose();
	void EvUser();

	/* ` */
	void EvPaint();
	void EvDraw(HDC hDC);

	/* L[ */
	void EvKeyDown(UINT, UINT, UINT);
	void EvKeyUp(UINT, UINT, UINT);
	void EvSysKeyDown(UINT, UINT, UINT);
	void EvSysKeyUp(UINT, UINT, UINT);

	/* j[ */
	void EvReset();
	void EvResetEn(TCommandEnabler &ce);
	void EvExit();
	void EvDrvOpen(int drive);
	void EvDrv0Open();
	void EvDrv0OpenEn(TCommandEnabler &ce);
	void EvDrv0Sel();
	void EvDrv0SelEn(TCommandEnabler &ce);
	void EvDrv1Open();
	void EvDrv1OpenEn(TCommandEnabler &ce);
	void EvDrv1Sel();
	void EvDrv1SelEn(TCommandEnabler &ce);
	void EvKey106();
	void EvKey106En(TCommandEnabler& ce);
	void EvKey98();
	void EvKey98En(TCommandEnabler& ce);
	void EvKeyTowns();
	void EvKeyTownsEn(TCommandEnabler& ce);
	void EvAbout();

	/* j[XV */
	void UpdateMenu();

	UINT ErrorCode;
	UINT nTimerID;
	BOOL bTimerFlag;
	BOOL bReqPaint;
	BOOL bReqDraw;
	HGLOBAL hDIB[2];
	WORD IntrCnt;
	WORD ReDrawCnt;
	UINT m_nChar;
	UINT m_nFlags;
	UINT m_nKeyType;

	DECLARE_RESPONSE_TABLE(TXM7Window);
};

/*
 *	o[W_CAO NX
 */
class TAboutDlg : public TDialog {
public:
	TAboutDlg(TWindow *parent, TModule *module) :
		TDialog(parent, ABOUTDLG, module) {};
	virtual BOOL EvInitDialog(HWND);
};

/*
 *	fBXNI_CAO NX
 */
class TDiskDlg : public TDialog {
public:
	TDiskDlg(TWindow *parent, int drv, TModule *module);
	virtual BOOL EvInitDialog(HWND);
	virtual void Destroy(int retValue = IDCANCEL);

	TListBox *pListBox;
	int nDrive;
};

/*
 *	AvP[V NX
 */
class TXM7Application : public TApplication {
public:
	void InitInstance();
	void InitMainWindow();
};

/*
 *	O[o [N
 */
extern BOOL force_flag;
extern TXM7Window *pMainWindow;

#endif	/* _W16_H_ */
#endif	/* _WIN16 */
