/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ TTLpbg ]
 */

#include <assert.h>
#include <string.h>
#include "xm7.h"
#include "multipag.h"
#include "device.h"

/*
 *	O[o [N
 */
BYTE ttl_palet[8];			/* TTLpbgf[^ */

/*
 *	TTLpbg
 *	
 */
BOOL ttlpalet_init(void)
{
	return TRUE;
}

/*
 *	TTLpbg
 *	N[Abv
 */
void ttlpalet_cleanup(void)
{
}

/*
 *	TTLpbg
 *	Zbg
 */
void ttlpalet_reset(void)
{
	int i;
	
	/* ׂĂ̐F */
	for (i=0; i<8; i++) {
		ttl_palet[i] = i;
		/* foCXɒʒm */
		ttlpalet_setb(i, (BYTE)i);
	}
}

/*
 *	TTLpbg
 *	PoCgǂݏo
 */
BOOL ttlpalet_readb(WORD addr, BYTE *dat)
{
	/* ͈̓`FbNAǂݏo */
	if ((addr >= 0xfd38) && (addr <= 0xfd3f)) {
		ASSERT((WORD)(addr - 0xfd38) <= 7);

		/* ʃju0xF0 */
		*dat = ttl_palet[(WORD)(addr - 0xfd38)] | 0xf0;
		return TRUE;
	}

	return FALSE;
}

/*
 *	TTLpbg
 *	PoCg
 */
BOOL ttlpalet_writeb(WORD addr, BYTE dat)
{
	int no;
	
	/* ͈̓`FbNA */
	if ((addr >= 0xfd38) && (addr <= 0xfd3f)) {
		no = addr - 0xfd38;
		ttl_palet[no] = (BYTE)(dat & 0x07);

		/* }`y[W@\𗘗pĐݒ */
		multipag_writeb(0xfd37, multi_page);

		return TRUE;
	}

	return FALSE;
}

/*
 *	TTLpbg
 *	Z[u
 */
BOOL ttlpalet_save(int fileh)
{
	return file_write(fileh, ttl_palet, 8);
}

/*
 *	TTLpbg
 *	[h
 */
BOOL ttlpalet_load(int fileh, int ver)
{
	/* o[W`FbN */
	if (ver > 1) {
		return FALSE;
	}

	return file_read(fileh, ttl_palet, 8);
}
