// ---------------------------------------------------------------------------
//	PSG Sound Implementation
//	Copyright (C) cisc 1997, 1999.
// ---------------------------------------------------------------------------
//	$Id: psg.cpp,v 1.7 1999/09/25 03:15:16 cisc Exp $

#include "cisc.h"
#include "psg.h"

// ---------------------------------------------------------------------------
//	RXgN^EfXgN^
//
PSG::PSG()
{
	SetVolume(0);
	MakeNoiseTable();
	Reset();
	mask = 0x3f;
}

PSG::~PSG()
{

}

// ---------------------------------------------------------------------------
//	PSG (RESET) 
//
void PSG::Reset()
{
	for (int i=0; i<14; i++)
		SetReg(i, 0);
	SetReg(7, 0xff);
	SetReg(14, 0xff);
	SetReg(15, 0xff);
}

// ---------------------------------------------------------------------------
//	NbNg̐ݒ
//
void PSG::SetClock(int32 clock, int32 rate)
{
	double d;

	d = (double)clock;
	d /= rate;

	tperiodbase = 0x01000000L;
	tperiodbase = tperiodbase / 4 * d;
	eperiodbase = 0x00400000L;
	eperiodbase = eperiodbase / 4 * d;
	nperiodbase = (1 << noiseshift);
	nperiodbase = nperiodbase / 4 * d;

	// ef[^̍XV
	int32 tmp;
	tmp = ((reg[0] + reg[1] * 256) & 0xfff);
	speriod[0] = tmp ? tperiodbase / tmp : tperiodbase;
	tmp = ((reg[2] + reg[3] * 256) & 0xfff);
	speriod[1] = tmp ? tperiodbase / tmp : tperiodbase;
	tmp = ((reg[4] + reg[5] * 256) & 0xfff);
	speriod[2] = tmp ? tperiodbase / tmp : tperiodbase;
	tmp = reg[6] & 0x1f;
	nperiod = tmp ? nperiodbase / tmp / 2 : nperiodbase / 2;
	tmp = ((reg[11] + reg[12] * 256) & 0xffff);
	eperiod = tmp ? eperiodbase / tmp : eperiodbase * 2;
}

// ---------------------------------------------------------------------------
//	mCYe[u쐬
//
void PSG::MakeNoiseTable()
{
	if (!noisetable[0])
	{
		int32 noise = 14321;
		for (int i=0; i<noisetablesize; i++)
		{
			int n = 0;
			for (int j=0; j<32; j++)
			{
				n = n * 2 + (noise & 1);
				noise = (noise >> 1) | (((noise << 14) ^ (noise * 0x10000)) & 0x10000);
			}
			noisetable[i] = n;
		}
	}
}

// ---------------------------------------------------------------------------
//	o̓e[u쐬
//	fɃe[uŎقȃXy[XB
//
void PSG::SetVolume(int volume)
{
	double base = 0x4000 / 3.0 * pow(10.0, volume / 40.0);
	for (int i=31; i>=2; i--)
	{
		EmitTable[i] = int32(base);
		base /= 1.189207115;
	}
	EmitTable[1] = 0;
	EmitTable[0] = 0;
	MakeEnvelopTable();

	SetChannelMask(~mask);
}

void PSG::SetChannelMask(int c)
{ 
	mask = ~c;
	for (int i=0; i<3; i++)
		olevel[i] = mask & (1 << i) ? EmitTable[(reg[8+i] & 15) * 2 + 1] : 0;
}

// ---------------------------------------------------------------------------
//	Gx[vg`e[u
//
void PSG::MakeEnvelopTable()
{
	// 0 lo  1 up 2 down 3 hi
	static uint8 table1[16*2] =
	{
		2,0, 2,0, 2,0, 2,0, 1,0, 1,0, 1,0, 1,0,
		2,2, 2,0, 2,1, 2,3, 1,1, 1,3, 1,2, 1,0,
	};
	static uint8 table2[4] = {  0,  0, 31, 31 };
	static uint8 table3[4] = {  0,  1, -1,  0 };

	if (!enveloptable[0][0])
	{
		uint32* ptr = enveloptable[0];

		for (int i=0; i<16*2; i++)
		{
			uint8 v = table2[table1[i]];
			
			for (int j=0; j<32; j++)
			{
				*ptr++ = EmitTable[v];
				v += table3[table1[i]];
			}
		}
	}
}

// ---------------------------------------------------------------------------
//	PSG ̃WX^ɒlZbg
//	regnum		WX^̔ԍ (0 - 15)
//	data		Zbgl
//
void PSG::SetReg(uint8 regnum, uint8 data)
{
	if (regnum < 0x10)
	{
		reg[regnum] = data;
		switch (regnum)
		{
			int32 tmp;

		case 0:		// ChA Fine Tune
		case 1:		// ChA Coarse Tune
			tmp = ((reg[0] + reg[1] * 256) & 0xfff);
			speriod[0] = tmp ? tperiodbase / tmp : tperiodbase;
			break;
		
		case 2:		// ChB Fine Tune
		case 3:		// ChB Coarse Tune
			tmp = ((reg[2] + reg[3] * 256) & 0xfff);
			speriod[1] = tmp ? tperiodbase / tmp : tperiodbase;	  
			break;
		
		case 4:		// ChC Fine Tune
		case 5:		// ChC Coarse Tune
			tmp = ((reg[4] + reg[5] * 256) & 0xfff);
			speriod[2] = tmp ? tperiodbase / tmp : tperiodbase;	  
			break;

		case 6:		// Noise generator control
			data &= 0x1f;
			nperiod = data ? nperiodbase / data : nperiodbase;
			break;

		case 8:
			olevel[0] = mask & 1 ? EmitTable[(data & 15) * 2 + 1] : 0;
			break;

		case 9:
			olevel[1] = mask & 2 ? EmitTable[(data & 15) * 2 + 1] : 0;
			break;
		
		case 10:
			olevel[2] = mask & 4 ? EmitTable[(data & 15) * 2 + 1] : 0;
			break;

		case 11:	// Envelop period
		case 12:
			tmp = ((reg[11] + reg[12] * 256) & 0xffff);
			eperiod = tmp ? eperiodbase / tmp : eperiodbase * 2;
			break;

		case 13:	// Envelop shape
			ecount = 0;
			envelop = enveloptable[data & 15];
			break;
		}
	}
}

// ---------------------------------------------------------------------------
//	PCM f[^fo(2ch)
//	dest		PCM f[^WJ|C^
//	nsamples	WJ PCM ̃Tv
//
void PSG::Mix(Sample* dest, int nsamples)
{
	uint8 chenable[3], nenable[3];
	uint8 r7 = ~reg[7];

	if ((r7 & 0x3f) | ((reg[8] | reg[9] | reg[10]) & 0x1f))
	{
		chenable[0] = (r7 & 0x01) && (speriod[0] <= 0x01000000L);
		chenable[1] = (r7 & 0x02) && (speriod[1] <= 0x01000000L);
		chenable[2] = (r7 & 0x04) && (speriod[2] <= 0x01000000L);
		nenable[0]  = (r7 >> 3) & 1;
		nenable[1]  = (r7 >> 4) & 1;
		nenable[2]  = (r7 >> 5) & 1;
		
		int32 noise, sample;
		uint32 env;
		uint32* p1 = ((mask & 1) && (reg[ 8] & 0x10)) ? &env : &olevel[0];
		uint32* p2 = ((mask & 2) && (reg[ 9] & 0x10)) ? &env : &olevel[1];
		uint32* p3 = ((mask & 4) && (reg[10] & 0x10)) ? &env : &olevel[2];
		
		#define SCOUNT(ch)	(scount[ch] / 0x04000000L)

		if (p1 != &env && p2 != &env && p3 != &env)
		{
			// Gx[v
			if ((r7 & 0x38) == 0)
			{
				// mCY
				for (int i=0; i<nsamples; i++)
				{
					sample = 0;
					for (int j=0; j < (1 << oversampling); j++)
					{
						int32 x, y, z;
						x = (SCOUNT(0) & chenable[0]) - 1;
						sample += (olevel[0] + x) ^ x;
						scount[0] += speriod[0];
						y = (SCOUNT(1) & chenable[1]) - 1;
						sample += (olevel[1] + y) ^ y;
						scount[1] += speriod[1];
						z = (SCOUNT(2) & chenable[2]) - 1;
						sample += (olevel[2] + z) ^ z;
						scount[2] += speriod[2];
					}
					sample /= (1 << (oversampling + 1));

					*dest += sample;
					dest++;
				}
			}
			else
			{
				// mCYL
				for (int i=0; i<nsamples; i++)
				{
					sample = 0;
					for (int j=0; j < (1 << oversampling); j++)
					{
#ifdef _M_IX86
						noise = noisetable[(ncount >> (noiseshift+oversampling+6)) & (noisetablesize-1)] 
							>> (ncount >> (noiseshift+oversampling+1));
#else
					noise = noisetable[(ncount >> (noiseshift+oversampling+6)) & (noisetablesize-1)] 
						>> (ncount >> (noiseshift+oversampling+1) & 31);
#endif
						ncount += nperiod;

						int32 x, y, z;
						x = ((SCOUNT(0) & chenable[0]) | (nenable[0] & noise)) - 1;		// 0 or -1
						sample += (olevel[0] + x) ^ x;
						scount[0] += speriod[0];
						y = ((SCOUNT(1) & chenable[1]) | (nenable[1] & noise)) - 1;
						sample += (olevel[1] + y) ^ y;
						scount[1] += speriod[1];
						z = ((SCOUNT(2) & chenable[2]) | (nenable[2] & noise)) - 1;
						sample += (olevel[2] + z) ^ z;
						scount[2] += speriod[2];
					}
					sample /= (1 << (oversampling + 1));

					*dest += sample;
					dest++;
				}
			}

			// Gx[v̌vZڂK킹
			ecount = (ecount >> 8) + (eperiod >> (8-oversampling)) * nsamples;
			if (ecount >= (1L << (envshift+6+oversampling-8)))
			{
				if ((reg[0x0d] & 0x0b) != 0x0a)
					ecount |= (1L << (envshift+5+oversampling-8));
				ecount &= (1L << (envshift+6+oversampling-8)) - 1;
			}
			ecount <<= 8;
		}
		else
		{
			// Gx[v
			for (int i=0; i<nsamples; i++)
			{
				sample = 0;
				for (int j=0; j < (1 << oversampling); j++)
				{
					env = envelop[ecount >> (envshift+oversampling)];
					ecount += eperiod;
					if (ecount >= (1L << (envshift+6+oversampling)))
					{
						if ((reg[0x0d] & 0x0b) != 0x0a)
							ecount |= (1L << (envshift+5+oversampling));
						ecount &= (1L << (envshift+6+oversampling)) - 1;
					}
#ifdef _M_IX86
					noise = noisetable[(ncount >> (noiseshift+oversampling+6)) & (noisetablesize-1)] 
						>> (ncount >> (noiseshift+oversampling+1));
#else
					noise = noisetable[(ncount >> (noiseshift+oversampling+6)) & (noisetablesize-1)] 
						>> (ncount >> (noiseshift+oversampling+1) & 31);
#endif
					ncount += nperiod;

					int32 x, y, z;
					x = ((SCOUNT(0) & chenable[0]) | (nenable[0] & noise)) - 1;		// 0 or -1
					sample += (*p1 + x) ^ x;
					scount[0] += speriod[0];
					y = ((SCOUNT(1) & chenable[1]) | (nenable[1] & noise)) - 1;
					sample += (*p2 + y) ^ y;
					scount[1] += speriod[1];
					z = ((SCOUNT(2) & chenable[2]) | (nenable[2] & noise)) - 1;
					sample += (*p3 + z) ^ z;
					scount[2] += speriod[2];
				}
				sample /= (1 << (oversampling + 1));

				*dest += sample;
				dest++;
			}
		}
	}
}

// ---------------------------------------------------------------------------
//	e[u
//
uint32	PSG::noisetable[512] = { 0, };
int32	PSG::EmitTable[0x20] = { -1, };
uint32	PSG::enveloptable[16][64] = { 0, };
