/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ OPN(YM2203) ]
 */

#ifndef _opn_h_
#define _opn_h_

/*
 *	萔`
 */
#define OPN_INACTIVE		0x00			/* CANeBuR}h */
#define OPN_READDAT			0x01			/* [hf[^R}h */
#define OPN_WRITEDAT		0x02			/* Cgf[^R}h */
#define OPN_ADDRESS			0x03			/* b`AhXR}h */
#define OPN_READSTAT		0x04			/* [hXe[^XR}h */
#define OPN_JOYSTICK		0x09			/* WCXeBbNR}h */

#ifdef __cplusplus
extern "C" {
#endif
/*
 *	vGg
 */
BOOL opn_init(void);
										/*  */
void opn_cleanup(void);
										/* N[Abv */
void opn_reset(void);
										/* Zbg */
BOOL opn_readb(WORD addr, BYTE *dat);
										/* ǂݏo */
BOOL opn_writeb(WORD addr, BYTE dat);
										/*  */
BOOL opn_save(int fileh);
										/* Z[u */
BOOL opn_load(int fileh, int ver);
										/* [h */
void opn_timer(void);
										/* OPN^C}[ */

/*
 *	v[N
 */
extern BYTE opn_reg[256];
										/* OPNWX^ */
extern BOOL opn_timera;
										/* ^C}[AtO */
extern BOOL opn_timerb;
										/* ^C}[BtO */
extern WORD opn_timera_tick;
										/* ^C}[AԊu(10s) */
extern WORD opn_timerb_tick;
										/* ^C}[BԊu(10s) */
extern BYTE opn_scale;
										/* vXP[ */
#ifdef __cplusplus
}
#endif

#endif	/* _opn_h_ */
