// ---------------------------------------------------------------------------
//	FM Sound Generator
//	Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//	$Id: fmgeninl.h,v 1.6 1999/08/26 08:06:29 cisc Exp $

#ifndef FM_GEN_INL_H
#define FM_GEN_INL_H

// ---------------------------------------------------------------------------
//	Z̑ɃVtg𑽗pGWgp
//	Pentium nł͎኱ɂȂ邩Ȃ
//
#define FM_LIGHT		0

// ---------------------------------------------------------------------------
//	萔̂Q
//	
#define FM_PI			3.14159265358979323846

#define FM_CLBITS		10
#define FM_CLENTS		(1 << FM_CLBITS)

#define FM_EGCBITS		18			// eg  count ̃Vtgl
#define FM_LFOCBITS		20
#define FM_PGBITS		9

#define FM_ISHIFT		12

#define FM_RATIOBITS	8

// ---------------------------------------------------------------------------
//	Operator
//
inline Operator::Operator()
{
	// EG Part
	ar = dr = sr = rr = ksr = 0;

	// PG Part
	multiple = 0;
	detune = 0;
	
	Reset();
}

//	
inline void Operator::Reset()
{
	// EG part
	tllinear = 0;
	tl = tll = 127;
	ShiftPhase(off);

	// PG part
	pgcount = 0;

	// OP part
	out = out2 = 0;

	// Mute
	Mute(false);

	paramchanged = true;
}

//	tB[hobNobt@NA
inline void Operator::ResetFB()
{
	out = out2 = 0;
}

//	L[I
inline void Operator::KeyOn()
{
	if (phase == release || phase == off)
	{
		ShiftPhase(attack);
		out = out2 = 0;
		pgcount = 0;
	}
}

//	L[It
inline void	Operator::KeyOff()
{
	ShiftPhase(release);
}

//	Iy[^͏o͂𔭐Ă邩H
inline int Operator::IsOn()
{
	return phase - off;
}

//	Detune (0-7)
inline void Operator::SetDT(uint8 dt)
{
	detune = (dt * 0x20), paramchanged = true;
}

//	Multiple (0-15)
inline void Operator::SetMULTI(uint8 mul)
{ 
	multiple = mul, paramchanged = true;
}

//	Total Level (0-127) (0.75dB step)
inline void Operator::SetTL(uint8 _tl, bool csm)
{
	if (!csm)
		tl = _tl, paramchanged = true;
	tll = _tl;
}

//	Attack Rate (0-63)
inline void Operator::SetAR(uint8 _ar)
{
	ar = _ar; paramchanged = true;
}

//	Decay Rate (0-63)
inline void Operator::SetDR(uint8 _dr)
{ 
	dr = _dr; paramchanged = true;
}

//	Sustain Rate (0-63)
inline void Operator::SetSR(uint8 _sr)
{ 
	sr = _sr; paramchanged = true;
}

//	Sustain Level (0-127)
inline void Operator::SetSL(uint8 _sl)
{ 
	sl = _sl; paramchanged = true;
}

//	Release Rate (0-63)
inline void Operator::SetRR(uint8 _rr)
{ 
	rr = _rr; paramchanged = true;
}

//	Keyscale (0-3)
inline void Operator::SetKS(uint8 _ks)
{ 
	ks = _ks; paramchanged = true; 
}

//	SSG-type Envelop (0-15)
inline void Operator::SetSSGEC(uint8 ssgec)
{ 
	ssgtype = ssgec; 
}

inline void Operator::SetDPBN(uint32 _dp, uint16 _bn)
{
	dp = _dp, bn = _bn; paramchanged = true; 
}

inline void Operator::SetAMON(bool on)
{ 
	amon = on;
}

inline void Operator::Mute(bool m)
{
	mute = m;
	paramchanged = true;
}

// ---------------------------------------------------------------------------
//	4-op Channel

//	ZtEtB[hobN[g̐ݒ (0-7)
inline void Channel4::SetFB(uint8 feedback)
{
	fb = fbtable[feedback];
}

//	OPNA n LFO ̐ݒ
inline void Channel4::SetMS(uint ms)
{
	ams = amtable[(ms >> 4) & 3];
	pms = pmtable[ms & 7];
}

inline void Channel4::Mute(bool m)
{
	for (int i=0; i<4; i++)
		op[i].Mute(m);
}

#endif // FM_GEN_INL_H
