/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ fobK ]
 */

#include <string.h>
#include <assert.h>
#include "xm7.h"
#include "gui.h"
#include "subctrl.h"
#include "opn.h"
#include "device.h"

/*
 *	O[o [N
 */
BOOL run_flag;				/* 쒆tO */
BOOL stopreq_flag;			/* ~vtO */
breakp_t breakp[BREAKP_MAX];/* u[N|Cg f[^ */

/*
 *	fobK
 *	
 */
BOOL debug_init(void)
{
	run_flag = FALSE;
	stopreq_flag = FALSE;
	memset(breakp, 0, sizeof(breakp));

	return TRUE;
}

/*
 *	fobK
 *	N[Abv
 */
void debug_cleanup(void)
{
}

/*
 *	fobK
 *	Zbg
 */
void debug_reset(void)
{
	debug_runbreak();
}

/*
 *	
 */
void debug_run(void)
{
	int i;

	/* O */
	run_flag = TRUE;
	stopreq_flag = FALSE;
	debug_runbreak();
	keyboard_setled();

	/* C[v */
	for (;;) {
		/* CPU܂킷*/
		for (i=0; i<0x80; i++) {

			/* u[N */
#if defined(_WIN32)
			if (debug_chkbreak()) {
				stopreq_flag = TRUE;
			}
#endif
			if (stopreq_flag) {
				/* ㏈ */
				debug_stopbreak();
				run_flag = FALSE;
				return;
			}

			/* s */
			maincpu_exec();
			if ((!subhalt_flag) && (subfast_flag < 2)) {
				subcpu_exec();
			}
		}

		/* Cxgs */
		do_events();

		/* GUI(do_events()Ăяo) */
		if (gui_flag) {
			gui_run();
			continue;
		}
		/* CCPUx */
		if (maincpu.total >= cpu_speed) {
			while (!(maincpu.intr & INTR_RELOAD)) {
				do_events();
				if (gui_flag) {
					gui_run();
				}
			}
			maincpu.intr &= ~INTR_RELOAD;
			maincpu.total = 0;
		}
		/* TuCPU[h */
		if ((subbusy_flag) || (subfast_flag == 0)) {
			continue;
		}
		subfast_flag = 1;
		if ((subcpu.pc >= 0xe14d) || (subcpu.intr & INTR_NMI)) {
			continue;
		}
		if ((subcpu.intr & INTR_FIRQ) && !(subcpu.cc & 0x40)) {
			continue;
		}
		if ((subcpu.intr & INTR_IRQ) && !(subcpu.cc & 0x10)) {
			continue;
		}
		/* ROMłȂA荞݂Ȃ̂Sleep */
		subfast_flag = 2;
	}
}

/*
 *	g[X
 */
void debug_trace(void)
{
	debug_runbreak();

	maincpu_execline();
	if (!subhalt_flag) {
		subcpu_execline();
	}

	debug_stopbreak();
}

/*
 *	fobK
 *	10ms^C}[
 */
void debug_timer(void)
{
	ASSERT(run_flag);

	maincpu.intr |= INTR_RELOAD;
	subcpu.intr |= INTR_RELOAD;
}

/*
 *	fobK
 *	u[N|CgZbg(łɃZbgĂΏ)
 */
BOOL debug_setbreak(int cpu, WORD addr)
{
	int i;

	/* ܂ASẴu[N|CgA邩 */
	for (i=0; i<BREAKP_MAX; i++) {
		if (breakp[i].flag != BREAKP_NOTUSE) {
			if ((breakp[i].cpu == cpu) && (breakp[i].addr == addr)) {
				break;
			}
		}
	}
	/* ΁A폜 */
	if (i != BREAKP_MAX) {
		breakp[i].flag = BREAKP_NOTUSE;
		return TRUE;
	}	

	/* 󂫂𒲍 */
	for (i=0; i<BREAKP_MAX; i++) {
		if (breakp[i].flag == BREAKP_NOTUSE) {
			break;
		}
	}
	/* ׂĖ܂Ă邩 */
	if (i == BREAKP_MAX) {
		return FALSE;
	}	

	/* Zbg */
	breakp[i].flag = BREAKP_ENABLED;
	breakp[i].cpu = cpu;
	breakp[i].addr = addr;

	return TRUE;
}

/*
 *	fobK
 *	StoptONA
 */
BOOL debug_runbreak(void)
{
	int i;
	BOOL flag;

	/* ~ȂAL */
	for (i=0; i<BREAKP_MAX; i++) {
		if (breakp[i].flag == BREAKP_STOPPED) {
			breakp[i].flag = BREAKP_ENABLED;
		}
	}

	/* PłL */
	flag = FALSE;
	for (i=0; i<BREAKP_MAX; i++) {
		if (breakp[i].flag == BREAKP_ENABLED) {
			flag = TRUE;
		}
	}

	return flag;
}

/*
 *	fobK
 *	u[N`FbN
 */
BOOL debug_chkbreak(void)
{
	int i;

	for (i=0; i<BREAKP_MAX; i++) {
		if (breakp[i].flag == BREAKP_ENABLED) {
			if (breakp[i].cpu == MAINCPU) {
				if (breakp[i].addr == maincpu.pc) {
					return TRUE;
				}
			}
			else {
				if (breakp[i].addr == subcpu.pc) {
					return TRUE;
				}
			}
		}
	}

	return FALSE;
}

/*
 *	fobK
 *	StoptOݒ
 */
BOOL debug_stopbreak(void)
{
	int i;
	int ret;

	/* tO𗎂ƂĂ */
	ret = FALSE;

	for (i=0; i<BREAKP_MAX; i++) {
		if (breakp[i].flag == BREAKP_ENABLED) {
			if (breakp[i].cpu == MAINCPU) {
				if (breakp[i].addr == maincpu.pc) {
					breakp[i].flag = BREAKP_STOPPED;
					ret = TRUE;
				}
			}
			else {
				if (breakp[i].addr == subcpu.pc) {
					breakp[i].flag = BREAKP_STOPPED;
					ret = TRUE;
				}
			}
		}
	}

	return ret;
}

/*
 *	fobK
 *	Z[u
 */
BOOL debug_save(int fileh)
{
	int i;

	if (!file_bool_write(fileh, run_flag)) {
		return FALSE;
	}

	if (!file_bool_write(fileh, stopreq_flag)) {
		return FALSE;
	}

	/* u[N|Cg */
	for (i=0; i<BREAKP_MAX; i++) {
		if (!file_byte_write(fileh, (BYTE)breakp[i].flag)) {
			return FALSE;
		}
		if (!file_byte_write(fileh, (BYTE)breakp[i].cpu)) {
			return FALSE;
		}
		if (!file_word_write(fileh, breakp[i].addr)) {
			return FALSE;
		}
	}

	return TRUE;
}

/*
 *	fobK
 *	[h
 */
BOOL debug_load(int fileh, int ver)
{
	int i;
	BYTE tmp;

	/* o[W`FbN */
	if (ver > 1) {
		return FALSE;
	}

	if (!file_bool_read(fileh, &run_flag)) {
		return FALSE;
	}

	if (!file_bool_read(fileh, &stopreq_flag)) {
		return FALSE;
	}

	/* u[N|Cg */
	for (i=0; i<BREAKP_MAX; i++) {
		if (!file_byte_read(fileh, &tmp)) {
			return FALSE;
		}
		breakp[i].flag = (int)tmp;
		if (!file_byte_read(fileh, &tmp)) {
			return FALSE;
		}
		breakp[i].cpu = (int)tmp;
		if (!file_word_read(fileh, &breakp[i].addr)) {
			return FALSE;
		}
	}

	return TRUE;
}
