/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ PC-98 CvO ]
 */

#if defined(__MSDOS__) && defined(PC98)

#include <stdio.h>
#include <conio.h>
#include <assert.h>
#include <dos.h>
#include "xm7.h"
#include "fdc.h"
#include "mainetc.h"
#include "gui.h"
#include "98.h"

/*
 *	X^bNTCY
 */
extern unsigned _stksiz = 8192U;

/*
 *	O[o [N
 */
BOOL timer_flag;

/*
 *	^Cg
 */
char *pszTitle =
	 "FM-7 EMULATOR XM7 V1.0L20 (for PC-9801)  (C) 1999-2001 ohD";

/*
 *	FM-TOWNS(FM-R)`FbN
 */
static BOOL isfm_check(void)
{
	WORD far *p;

	p = (WORD far *)(0xffff0003L);
	if (*p == 0xfc00) {
		return TRUE;
	}

	return FALSE;
}

/*
 *	PC-98`FbN
 */
static BOOL is98_check(void)
{
	union REGS regs;

	regs.h.ah = 0x0f;
	int86(0x10, &regs, &regs);
	if (regs.h.ah == 0x0f) {
		return TRUE;
	}

	return FALSE;
}

/*
 *	PC-9801/E/F/M/U/LT/HA`FbN
 */
static BOOL machine_check(void)
{
	BYTE dat;

	dat = *(BYTE far *)0x00000500;
	if (!(dat & 0x01)) {
		return FALSE;
	}

	dat = *(BYTE far *)0x00000501;
	if (dat & 0x10) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	m[}EnC]`FbN
 */
static BOOL highres_check(void)
{
	BYTE dat;

	dat = *(BYTE far *)0x0000053c;
	if (dat < 0x80) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	16F{[h,GRCG`FbN
 */
static BOOL grp_check(void)
{
	BYTE dat;

	dat = *(BYTE far *)0x0000054c;
	if ((dat & 0x06) != 0x06) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	`FbN(C)
 */
static BOOL pc98_check(void)
{
	if (!machine_check()) {
		puts("PC-9801/E/F/M/U/LT/HAł͓삵܂");
		return FALSE;
	}

	if (!highres_check()) {
		puts("nC][hł͓삵܂");
		return FALSE;
	}

	if (!grp_check()) {
		puts("16F{[hĂ܂");
		return FALSE;
	}

	return TRUE;
}

/*
 *	Cxg
 */
void do_events(void)
{
	static BYTE count;

	/* XFER or NFERGUI */
	if ((kbd_map[0x06] & 0x20) || (kbd_map[0x0a] & 0x02)) {
		gui_start();
	}

	/* ^C}[ */
	if (timer_flag) {
		kbd_timer();
		count++;
		if (count & 1) {
			subcpu_nmi();
		}
		mainetc_timer();
		timer_flag  = FALSE;
	}
}

/*
 *	CvO
 */
int main(int argc, char *argv[])
{
	BOOL machine;

	puts(pszTitle);

	/* }V^Cv */
	machine = TRUE;
	if (isfm_check()) {
		machine = FALSE;
	}
	else {
		if (!is98_check()) {
			machine = FALSE;
		}
	}
	if (!machine) {
		puts("This program is designed for NEC PC-9801 architecture.");
		return 1;
	}

	if(!pc98_check()) {
		return 1;
	}

	if (!system_init()) {
		puts("ROMt@C܂");
		return 1;
	}

	if (argc >= 2) {
		fdc_setdisk(0, argv[1]);
	}
	if (argc >= 3) {
		fdc_setdisk(1, argv[2]);
	}
	else {
		if ((fdc_ready[0] == FDC_TYPE_D77) && (fdc_medias[0] >= 2)) {
			fdc_setdisk(1, argv[1]);
			fdc_setmedia(1, 1);
		}
	}

	scr_init();
	timer_init();
	kbd_init();
	snd_init();

	system_reset();
	debug_run();

	system_cleanup();
	snd_cleanup();
	kbd_cleanup();
	timer_cleanup();
	scr_cleanup();

	return 0;
}

#endif	/* __MSDOS__ && PC98 */
