/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ PC-98 ̑ ]
 */

#if defined(__MSDOS__) && defined(PC98)

#include <assert.h>
#include <dos.h>
#include <string.h>
#include "xm7.h"
#include "opn.h"
#include "98.h"
#include "device.h"
#include "mainetc.h"

/*
 *	O[o [N
 */
BOOL snd_flag;						/* OPN݃tO */

/*
 *	X^eBbN [N
 */
static DWORD boot_timervct;			/* ^C}荞݃xN^ */

/*
 *	^C}荞݃Gg
 */
void interrupt timer_entry(void)
{
	/* tOAbv */
	timer_flag = TRUE;

	/* EOIs */
	outp(0x00, 0x20);
}

/*
 *	^C} 
 */
void timer_init(void)
{
	BYTE dat;
	WORD clk;

	disable();

	/* xN^ݒ */
	boot_timervct = *(DWORD far *)0x00000020;
	*(DWORD far *)0x00000020 = (DWORD)timer_entry;

	/* VXeʈAVXeNbN擾 */
	dat = *(BYTE far *)0x00000501;
	if (dat < 0x80) {
		clk = 24576;
	}
	else {
		clk = 19968;
	}

	/* ^C}ݒ */
	outp(0x77, 0x36);
	outp(0x5f, 0);
	outp(0x71, clk & 0xff);
	outp(0x5f, 0);
	outp(0x71, clk >> 8);

	/* ^C}荞݋ */
	dat = inp(0x02);
	dat &= ~0x01;
	outp(0x02, dat);

	enable();
}

/*
 *	^C} N[Abv
 */
void timer_cleanup(void)
{
	BYTE dat;

	disable();

	/* ^C}荞݋֎~ */
	dat = inp(0x02);
	dat |= 0x01;
	outp(0x02, dat);

	/* 荞݃xN^A */
	*(DWORD far *)0x00000020 = boot_timervct;

	enable();
}

/*
 *	TEh
 *	
 */
void snd_init(void)
{
	int i;

	/* TEhȂƉ */
	snd_flag = FALSE;

	/* 256|[gǂݏoA݃`FbN */
	for (i=0; i<0x100; i++) {
		if (inp(0x188) != 0xff) {
			snd_flag = TRUE;
			break;
		}
		outp(0x5f, 0);
	}

	if (snd_flag) {
		/*  */
		opn_setb(0x07, 0x3f);
		opn_setb(0xb4, 0xc0);
		opn_setb(0xb5, 0xc0);
		opn_setb(0xb6, 0xc0);
	}
}

/*
 *	TEh
 *	N[Abv
 */
void snd_cleanup(void)
{
}

/*
 *	OPN
 *	ǂݏo
 */
BYTE opn_read(BYTE reg)
{
	BYTE dat;
	int i;

	while (inp(0x188) & 0x80) {
		;
	}

	outp(0x188, reg);
	for (i=0; i<4; i++) {
		outp(0x5f, 0);
	}

	while (inp(0x188) & 0x80) {
		;
	}

	dat = inp(0x18a);
	for (i=0; i<33; i++) {
		outp(0x5f, 0);
	}

	return dat;
}

/*
 *	OPN
 *	
 */
void opn_write(BYTE reg, BYTE dat)
{
	int i;

	while (inp(0x188) & 0x80) {
		;
	}

	outp(0x188, reg);
	for (i=0; i<4; i++) {
		outp(0x5f, 0);
	}

	while (inp(0x188) & 0x80) {
		;
	}

	outp(0x18a, dat);
	for (i=0; i<33; i++) {
		outp(0x5f, 0);
	}

	return;
}
/*
 *	OPN
 *	o
 */
void opn_setb(BYTE reg, BYTE dat)
{
	DWORD tmp;
	WORD oct;

	if (!snd_flag) {
		return;
	}

	if (reg < 6) {
		tmp = opn_reg[(reg & 6) + 1] * 256 + opn_reg[reg & 6];
		tmp &= 0xfff;
		tmp *= 2000;
		tmp /= 1229;
		opn_write((reg & 6) + 1, tmp >> 8);
		opn_write((reg & 6) + 0, tmp & 255);
		return;
	}

	if (reg == 7) {
		dat &= 0x3f;
		dat |= 0x80;
		opn_write(reg, dat);
		return;
	}

	if ((reg == 0x0b) || (reg == 0x0c)) {
		tmp = opn_reg[12] * 256 + opn_reg[11];
		if (tmp < 0x3c00) {
			tmp *= 2000;
			tmp /= 1229;
		}
		else {
			tmp = 0xffff;
		}
		opn_write(12, tmp >> 8);
		opn_write(11, tmp & 255);
		return;
	}

	if ((reg >= 0xa0) && (reg < 0xa8)) {
		tmp = opn_reg[0xa4 + (reg & 3)] * 256 + opn_reg[0xa0 + (reg & 3)];
		oct = tmp & 0x3800;
		tmp &= 0x7ff;
		tmp *= 1229;
		if (opn_scale != 2) {
			tmp /= 2000;
		}
		else {
			tmp /= 1333;
		}
		tmp |= oct;
		opn_write(0xa4 + (reg & 3), tmp >> 8);
		opn_write(0xa0 + (reg & 3), tmp & 255);
		return;
	}

	opn_write(reg, dat);
}

/*
 *	WCXeBbNǂݎ
 */
BYTE joy_getb(BYTE no)
{
	BYTE dat;

	if (!snd_flag) {
		return 0;
	}

	if (no == 0) {
		opn_write(0x0f, 0x80);
	}
	else {
		opn_write(0x0f, 0xc0);
	}

	dat = ~opn_read(0x0e);
	return (dat & 0x3f);
}

#endif	/* __MSDOS__  && PC98 */
