/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ PC-98 ʃTu[` ]
 */

#if defined(__MSDOS__) && defined(PC98)

#include <assert.h>
#include <dos.h>
#include <string.h>
#include "xm7.h"
#include "98.h"
#include "device.h"

/*
 *	fW^pbge[u
 */
const BYTE palet_table[] = {
	0x00, 0x00, 0x00,
	0x0f, 0x00, 0x00,
	0x00, 0x0f, 0x00,
	0x0f, 0x0f, 0x00,
	0x00, 0x00, 0x0f,
	0x0f, 0x00, 0x0f,
	0x00, 0x0f, 0x0f,
	0x0f, 0x0f, 0x0f
};

/*
 *	OtBbNʃNA
 */
void scr_clear(void)
{
	BYTE *p;
	BYTE *grcg;

	/* GRCGf[^L */
	grcg = (BYTE far *)(0x00000495);

	/* TDW[h */
	disable();
	outp(0x7c, 0x80);
	grcg[0] = 0x80;
	outp(0x7e, 0);
	outp(0x7e, 0);
	outp(0x7e, 0);
	outp(0x7e, 0);
	grcg[1] = 0x0;
	grcg[2] = 0x0;
	grcg[3] = 0x0;
	grcg[4] = 0x0;
	enable();

	/* NA */
	p = (BYTE far *)0xa8000000;
	memset(p, 0, 0x8000);
	p = (BYTE far *)0xa8008000;
	memset(p, 0, 0x8000);

	/* GRCG OFF */
	disable();
	outp(0x7c, 0x0);
	grcg[0] = 0;
	enable();
}

/*
 *	ʕ\ 
 */
void scr_init(void)
{
	int i;
	BYTE *p;
	union REGS regs;

	/* OtBbNOFF */
	regs.h.ah = 0x41;
	int86(0x18, &regs, &regs);

	/* eLXgOFF */
	regs.h.ah = 0x0d;
	int86(0x18, &regs, &regs);

	/* OtBbN[h */
	regs.h.ah = 0x42;
	regs.h.ch = 0xc0;
	int86(0x18, &regs, &regs);

	/* AiO[hɐݒ */
	outp(0x6a, 0x01);

	/* pbgݒ */
	for (i=0; i<8; i++) {
		ttlpalet_setb(i, i);
	}

	/* OtBbNNA */
	scr_clear();

	/* Iv[ݒ */
	p = (BYTE far *)(0xe0000000 + 0x0050);
	for (i=0; i<200; i++) {
		memset(p, 0xff, 0x50);
		p += 0x00a0;
	}
	ttlpalet_setb(8, 0);

	/* OtBbNON */
	regs.h.ah = 0x40;
	int86(0x18, &regs, &regs);
}

/*
 *	ʕ\ N[Abv
 */
void scr_cleanup(void)
{
	union REGS regs;
	int i;

	/* OtBbNOFF */
	regs.h.ah = 0x41;
	int86(0x18, &regs, &regs);

	/* OtBbNNA */
	scr_clear();

	/* pbgNA */
	for (i=0; i<16; i++) {
		ttlpalet_setb(i, 0);
	}

	/* eLXgON */
	regs.h.ah = 0x0c;
	int86(0x18, &regs, &regs);
}

/*
 *	fW^pbgݒ
 */
void ttlpalet_setb(int no, BYTE dat)
{
	BYTE *p;

	ASSERT((no >= 0) && (no < 16));
	ASSERT((dat >= 0) && (dat < 8));

	p = (BYTE *)&palet_table[dat * 3];

	/* CfbNXݒ */
	outp(0xa8, no);

	/* B,R,Gݒ */
	outp(0xae, *p++);
	outp(0xac, *p++);
	outp(0xaa, *p++);
}

/*
 *	uq`l
 */
void vram_setb(WORD addr, BYTE dat)
{
	_asm {
		push	es
		mov		ax,addr
		mov		bx,0a800h
		cmp		ax,4000h
		jc		vram_setb1
		add		bx,0800h
		cmp		ax,8000h
		jc		vram_setb1
		add		bx,0800h
vram_setb1:
		and		ax,3fffh
		mov		es,bx
		mov		bh,80
		div		bh
		mov		bl,ah
		xor		bh,bh
		mov		dh,160
		mul		dh
		add		bx,ax
		mov		al,dat
		mov		[es:bx],al
		pop		es
	}
}

/*
 *	uq`lItZbgWX^ݒ
 */
void vramoff_setw(WORD offset)
{
	_asm {
		pushf
		push	si
		push	di
		push	ds
		cld
		mov		ax,SEG vram_c
		mov		ds,ax
		mov		si,offset vram_c
		mov		bx,[si]
		mov		cx,[si+2]
		mov		si,bx
		mov		ds,cx

		mov		ax,0a800h
		mov		es,ax
		xor		di,di
		mov		bl,200
vramoff_setw1:
		mov		cx,40
		rep		movsw
		add		di,80
		dec		bl
		jnz		vramoff_setw1

		add		si,384

		mov		ax,0b000h
		mov		es,ax
		xor		di,di
		mov		bl,200
vramoff_setw2:
		mov		cx,40
		rep		movsw
		add		di,80
		dec		bl
		jnz		vramoff_setw2

		add		si,384

		mov		ax,0b800h
		mov		es,ax
		xor		di,di
		mov		bl,200
vramoff_setw3:
		mov		cx,40
		rep		movsw
		add		di,80
		dec		bl
		jnz		vramoff_setw3

		pop		ds
		pop		di
		pop		si
		popf
	}
}

/*
 *	L[{[hLED\
 */
void keyboard_setled(void)
{
}

#endif	/* __MSDOS__  && PC98 */
