/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 Toshio ISHIZAKA(vh6t-iszk@asahi-net.or.jp)
 *	[ X window main ]
 */

#include <X11/Xlib.h>
#include <signal.h>
#include "xm7.h"
#include "fdc.h"
#include "xw.h"
#include "gui.h"

/*
 *	title string
 */

char *titlestring =
	"FM-7 EMULATOR XM7 V1.0L20 (for X Window System)\n"\
	"  Copyright (C) 1999-2001 "\
	"\033\044\102\043\120\043\111\033\050\102. "\
	"\057\050"\
	"\033\044\102\074\167\033\050\102\051\124\115\n";
	// "У. / ()TM\n"; // in JIS!

void catch_sigint(int t){
/*	printf("caught sigint!\n"); */
    stopreq_flag = TRUE;
}


void catch_sigsegv(int t){
    printf("caught SIGSEGV\n");
    xwin_cleanup();
    exit(1);    
}

void catch_sigpipe(int t){
    printf("caught SIGPIPE\n");
    xwin_cleanup();
    exit(1);    
}

/*
 *	static work
 */

int no_shm = False;
int no_fm = False;

int main( int argc, char *argv[] ){
	int i, drv;

	fprintf( stderr, titlestring );
	
	if (!system_init()) {
		fprintf( stderr,"initialize error (Cannot allocate ROM file)\n" );
		goto fail_exit;
	}
	for( i = 1, drv = 0; i < argc; i++ ){
		if( argv[i][0]=='-' ){
			if( strcmp( argv[i], "-nofm" ) == 0 ){
				no_fm = TRUE;
			}
			if( strcmp( argv[i], "-noshm" ) == 0 ){
				no_shm = TRUE;
			}
		}else{
			if( drv < 2 ){
				fdc_setdisk( drv, argv[i] );
				drv++;
			}
		}
	}
	disp_init( &argc, argv ); /* modify argc,argv */
	
	signal( SIGINT, catch_sigint );
	signal( SIGPIPE, catch_sigpipe );
	signal( SIGSEGV, catch_sigsegv );

	snd_init();
	system_reset();
	timer_init();

	/* main VM loop here! */
	while( run_flag ){
		if( gui_flag ){
			gui_run();
		}
		usleep( 5000 );
	}
	disp_cleanup();
fail_exit:    
    system_cleanup();
    snd_cleanup();
    printf("exiting....\n");
    return 0;
}
