/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ IBM-PC ^C}[ ]
 */

#if defined(__MSDOS__) && defined(IBM)

#include <assert.h>
#include <dos.h>
#include "xm7.h"
#include "mainetc.h"
#include "device.h"
#include "ibm.h"

/*
 *	O[o [N
 */
BOOL timer_flag;						/* ^C}[mso߃tO */

/*
 *	X^eBbN [N
 */
static DWORD timer_vector;				/* ^C}[ IWixN^ */
static BYTE timer_count;				/* ^C}[JE^ */

/*
 *	^C}[荞
 */
static void interrupt timer_entry(void)
{
	/* tOAbv */
	timer_flag = TRUE;

	/* EOIs */
	outp(0x20, 0x20);
}

/*
 *	^C}[ 
 */
void timer_init(void)
{
	disable();
	timer_vector = *(DWORD *)(0x0008 * 4);
	*(DWORD *)(0x0008 * 4) = (DWORD)timer_entry;

	/* ^C}[ [h3 */
	outp(0x43, 0x36);
	/* 0x952 = 2ms */
	outp(0x40, 0x52);
	outp(0x40, 0x09);

	/* PICݒ */
	outp(0x21, inp(0x21) & 0xfe); 

	timer_flag = FALSE;
	enable();
}

/*
 *	^C}[ N[Abv
 */
void timer_cleanup(void)
{
	disable();
	*(DWORD *)(0x0008 * 4) = timer_vector;
	outp(0x43, 0x36);
	outp(0x40, 0);
	outp(0x40, 0);
	enable();
}

#endif	/* __MSDOS__ && IBM */
