/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ IBM-PC TEh ]
 */

#if defined(__MSDOS__) && defined(IBM)

#include <assert.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <dos.h>
#include "xm7.h"
#include "opn.h"
#include "mainetc.h"
#include "device.h"
#include "gui.h"
#include "ibm.h"
#include "cisc.h"
#include "opna.h"

/*
 *	O[o [N
 */
WORD snd_rate;							/* TEh[g */
WORD snd_bytes;							/* TEh\ */

/*
 *	X^eBbN [N
 */
static OPN *pOPN;						/* zOPN */
static BYTE *pBuffer;					/* o̓obt@ */
static BYTE InCount;					/* f[^}JE^ */
static BYTE* pLoad;						/* f[^] */
static BOOL bJoyRead;					/* WCXeBbNǂݍok */

/*
 *	TEhG[
 */
static BOOL snd_error(char *ptr)
{
	char c;

	/* \ */
	if (ptr) {
		printf(ptr);
	}
	else {
		printf("but not enough memory to play.");
	}

	/* Run anyway */
	printf(" Run anyway[Y/N] ? ");

	c = getch();
	if ((c == 'Y') || (c == 'y')) {
		return TRUE;
	}

	return FALSE;
}

/*
 *	TEh 
 */
BOOL snd_init(void)
{
	int i;

	/* [N */
	pBuffer = NULL;
	pLoad = NULL;
	pOPN = NULL;
	InCount = 0;

	/* WCXeBbNǂݍ */
	bJoyRead = TRUE;
	joy_getb(0);

	/* Sound Blaser */
	if (!blaster_init()) {
		if (!blaster_flag && (blaster_dsp >= 2)) {
			return snd_error(NULL);
		}
		else {
			return snd_error("No Sound Blaster is detected.");
		}
	}

	/* obt@m */
	pBuffer = (BYTE *)malloc(snd_rate * SND_TICK * snd_bytes);
	if (pBuffer == NULL) {
		return snd_error(NULL);
	}

	/* OPNjbg쐬 */
	pOPN = new OPN;
	if (pOPN == NULL) {
		return snd_error(NULL);
	}

	/* SBPro`FbN */
	if (snd_bytes == 1) {
		if (!snd_error("Quality of sound may be too low.")) {
			return FALSE;
		}
	}

	/*  */
	pOPN->Init(12288, snd_rate * 10, TRUE, NULL);
	pOPN->Reset();
	pOPN->SetReg(0x27, 0);
	pOPN->SetReg(0x2e, 0);

	/* tX^[g(TvnBsnd_bytes܂߂Ȃ) */
	blaster_start(snd_rate * SND_TICK);

	return TRUE;
}

/*
 *	TEh N[Abv
 */
void snd_cleanup(void)
{
	if (pOPN) {
		delete pOPN;
		pOPN = NULL;
	}

	if (pBuffer) {
		free(pBuffer);
		pBuffer = NULL;
	}

	blaster_cleanup();
}

/*
 *	OPNWX^ݒ
 */
void opn_setb(BYTE reg, BYTE dat)
{
	static BYTE pres = 3;

	if (!pOPN) {
		return;
	}

	/* vXP[̒ */
	if (opn_scale != pres) {
		pres = opn_scale;
		switch (pres) {
			case 2:
				pOPN->SetReg(0x2f, 0);
				break;
			case 3:
				pOPN->SetReg(0x2e, 0);
				break;
		}
	}

	pOPN->SetReg((uint8)reg, (uint8)dat);
}

/*
 *	BEEPǉ
 */
static void beep_sound(int32 *buf, int samples)
{
	static DWORD count;
	DWORD half;
	int i;

	// BEEPo̓`FbN
	if (!beep_flag || !speaker_flag) {
		return;
	}

	// n[tJE^Zo(0.4305ms)
	half = snd_rate;
	half *= 4305L;
	half /= 10000;

	for (i=0; i<samples; i++) {
		// Tv
		if (count < half) {
			*buf += 0x00000800L;
		}
		else {
			*buf -= 0x00000800L;
		}
		buf++;

		// JE^]
		count++;
		if (count >= (half * 2)) {
			count = 0;
		}
	}

}

/*
 *	obt@ւ̉ǉ
 */
static void add_sound(void)
{
	int32 buf[44 * TIMER_MS];
	BYTE *q;
	int i;
	int32 dat;
	WORD highlow;
	BYTE high;

	/* e|GA֍ */
	memset(buf, 0, sizeof(buf));
	pOPN->Mix(buf, snd_rate * TIMER_MS);
	beep_sound(buf, snd_rate * TIMER_MS);

	/* obt@֒ǉ */
	if (snd_bytes == 1) {
		/* 8bit */
		q = &pBuffer[InCount * snd_rate * TIMER_MS];
		for (i=0; i<(snd_rate * TIMER_MS); i++) {
			dat = buf[i];
			high = (BYTE)(dat >> 8);

			/* NbsO */
			if ((dat > 0) && (high >= 0x80)) {
				*q++ = 0xff;
				continue;
			}
			if ((dat < 0) && (high < 0x80)) {
				*q++ = 0;
				continue;
			}

			*q++ = (high + 0x80);
		}
	}
	else {
		/* 16bit */
		q = &pBuffer[InCount * snd_rate * TIMER_MS * 2];
		for (i=0; i<(snd_rate * TIMER_MS); i++) {
			dat = buf[i];
			highlow = (WORD)(dat & 0x0000ffffL);

			/* NbsO */
			if ((dat > 0) && (highlow >= 0x8000)) {
				*q++ = 0xff;
				*q++ = 0xff;
				continue;
			}
			else {
				if ((dat < 0) && (highlow < 0x8000)) {
					*q++ = 0;
					*q++ = 0;
					continue;
				}
			}

			highlow += 0x8000;

			/* f[^ݒ */
			*q++ = (BYTE)(highlow & 0xff);
			*q++ = (BYTE)(highlow >> 8);
		}
	}
}

/*
 *	^C}[
 */
void snd_timer(void)
{
	int32 *p;
	BYTE *q;
	int i;
	int32 dat;
	int32 tmp;
	static BYTE count;

	/* WCXeBbNǂݎ苖 */
	count++;
	if (count >= (10 / TIMER_MS)) {
		bJoyRead = TRUE;
		if (gui_flag) {
			joy_getb(0);
		}
		count = 0;
	}

	/* Kv`FbN */
	if (!pOPN || !pBuffer) {
		return;
	}

	/* [hvĂ΁A */
	disable();
	q = pLoad;
	if (q) {
		/* Ȃׂ~낵悢 */
		pLoad = NULL;
		enable();

		/* Ȃf[^쐬 */
		while (InCount < (SND_TICK / TIMER_MS)) {
			add_sound();
			InCount++;
		}

		/* f[^] */
		memcpy(q, pBuffer, snd_rate * SND_TICK * snd_bytes);

		InCount = 0;
	}
	else {
		enable();

		/* obt@ւ̒ǉ */
		if (InCount < (SND_TICK / TIMER_MS)) {
			add_sound();
			InCount++;
		}
	}
}

/*
 *	obt@[h
 */
void blaster_load(BYTE *p)
{
	pLoad = p;
}

/*
 *	WCXeBbN
 *
 *	bit5	gK2
 *	bit4	gK1
 *	bit3	
 *	bit2	
 *	bit1	
 *	bit0	
 *	ꂽ{^1ɂȂ
 */
BYTE joy_getb(BYTE port)
{
	WORD cnt;
	WORD x;
	WORD y;
	BOOL flag;
	BYTE dat, old;
	static BYTE ret;
	static WORD maxc[2];
	static WORD pnt1[2];
	static WORD pnt2[2];

	ASSERT(port <= 1);

	/* |[g1̂݃T|[g */
	if (port == 1) {
		return 0;
	}

	/* 10msɂP̂ݓǂݍ(Ԃ邽) */
	if (!bJoyRead) {
		return ret;
	}
	bJoyRead = FALSE;

	/* \tgEFAv̂ߊ荞݋֎~ */
	disable();

	/* ǂݎw */
	outp(0x201, 0);

	/*  */
	ret = 0;
	x = 0;
	y = 0;
	flag = FALSE;
	old = inp(0x201);

	/* v[v */
	for (cnt=0; cnt<1024; cnt++) {
		dat = inp(0x201);
		/* Q[|[g݂΁Af[^₪0ɂȂ */
		if (dat != old) {
			flag = TRUE;
		}
		/* bit0, bit1`FbN */
		if (dat & 0x01) {
			x++;
		}
		if (dat & 0x02) {
			y++;
		}
		/* ~Ă΁Aȏ荞܂Ȃ */
		if (!(dat & 0x03)) {
			break;
		}
	}

	/* 荞݋ */
	enable();

	/* |[g݂Ȃ0Ԃ */
	if (!flag) {
		return 0;
	}

	/* XXbVhEx */
	if (maxc[0] == 0) {
		x *= 2;
	}
	if (maxc[0] < x) {
		maxc[0] = x;
		pnt1[0] = (maxc[0] / 3);
		pnt2[0] = (maxc[0] - pnt1[0]);
	}

	/* X */
	if (x > pnt2[0]) {
		ret |= 0x08;
	}
	else {
		if (x < pnt1[0]) {
			ret |= 0x04;
		}
	}

	/* YXbVhEx */
	if (maxc[1] == 0) {
		y *= 2;
	}
	if (maxc[1] < y) {
		maxc[1] = y;
		pnt1[1] = (maxc[1] / 3);
		pnt2[1] = (maxc[1] - pnt1[1]);
	}

	/* Y */
	if (y > pnt2[1]) {
		ret |= 0x02;
	}
	else {
		if (y < pnt1[1]) {
			ret |= 0x01;
		}
	}

	/* {^̏ */
	if (!(old & 0x20)) {
		ret |= 0x10;
	}
	if (!(old & 0x10)) {
		ret |= 0x20;
	}

	return ret;
}

#endif	/* __MSDOS__ && IBM */
