/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ Sound BlasterhCo ]
 */

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include "xm7.h"
#include "ibm.h"

/*
 *	O[o [N
 */
BOOL blaster_flag;						/* Sound Blaster ݃tO */
BYTE blaster_dsp;						/* Sound Blaster DSPo[W */

/*
 *	X^eBbN [N
 */
static WORD blaster_port;				/* Sound Blaster |[g */
static BYTE blaster_irq;				/* Sound Blaster IRQ */
static BYTE blaster_dma;				/* Sound Blaster DMA */
static BYTE blaster_hdma;				/* Sound Blaster High-DMA */
static WORD blaster_off;				/* Sound Blaster IRQItZbg */
static WORD blaster_seg;				/* Sound Blaster IRQZOg */
static BYTE blaster_rate;				/* Sound Blaster TvO[g */
static BOOL blaster_mono;				/* Sound Blaster mtO */
static WORD blaster_len;				/* Sound Blaster f[^(PoN) */
static BYTE* blaster_buf;				/* Sound Blaster obt@AhX */
static BOOL blaster_bank;				/* Sound Blaster oNtO */
static WORD blaster_bufsize;			/* Sound Blaster obt@TCY */

/*
 *	Sound Blaster
 *	DMAe[u
 */
static WORD blaster_dma_table[] = {
	0x0087, 0x0083, 0x0081, 0x0082,
	0x008f, 0x008b, 0x0089, 0x008a
};

/*-[ Sound Blaster ჌x[` ]---------------------------------------*/

/*
 *	Sound Blaster
 *	Zbg
 */
static BOOL blaster_reset(void)
{
	int i;
	WORD cnt;
	BYTE dat;

	/* ZbgMo */
	outp(blaster_port + 6, 1);

	/* 3.3s҂ */
	for (i=0; i<256; i++) {
		inp(blaster_port + 6);
	}

	/* ZbgMƂ߂ */
	outp(blaster_port + 6, 0);

	/* 200gC */
	for (i=0; i<200; i++) {
		cnt = 0;
		/* ő10000ABUSY҂ */
		for (;;) {
			cnt++;
			if (cnt == 0) {
				return FALSE;
			}

			/* Ready`FbN */
			dat = inp(blaster_port + 0x0e);
			if (dat >= 0x80) {
				break;
			}
		}

		/* DSPǂݏoA0xaał邱Ƃm߂ */
		dat = inp(blaster_port + 0x0a);
		if (dat == 0xaa) {
			return TRUE;
		}
	}

	/* Zbgs */
	return FALSE;
}

/*
 *	Sound Blaster
 *	DSPǂݏo
 */
static BYTE blaster_read(void)
{
	WORD cnt;
	BYTE dat;

	cnt = 0;
	/* ő10000ABUSY҂ */
	for (;;) {
		cnt++;
		if (cnt == 0) {
			return 0;
		}

		/* Ready`FbN */
		dat = inp(blaster_port + 0x0e);
		if (dat >= 0x80) {
			break;
		}
	}

	/* f[^ǂݏo */
	dat = inp(blaster_port + 0x0a);
	return dat;
}

/*
 *	Sound Blaster
 *	DSP
 */
static void blaster_write(BYTE dat)
{
	WORD cnt;

	cnt = 0;
	/* ő10000ABUSY҂ */
	for (;;) {
		cnt++;
		if (cnt == 0) {
			return;
		}

		/* Ready`FbN */
		if (inp(blaster_port + 0x0c) < 0x80) {
			/*  */
			outp(blaster_port + 0x0c, dat);
			return;
		}
	}
}

/*
 *	Sound Blaster
 *	Xs[J
 */
static void blaster_speaker(BOOL enable)
{
	WORD cnt;

	if (enable) {
		/* Xs[JonR}h */
		blaster_write(0xd1);
	}
	else {
		/* Xs[JoffR}h */
		blaster_write(0xd3);
	}

	/* EFCg */
	cnt = 0;
	for (;;) {
		cnt++;
		if (cnt == 0) {
			return;
		}
		inp(blaster_port + 0x0c);
	}
}

/*
 *	Sound Blaster
 *	o[W擾
 */
static void blaster_ver(void)
{
	/* o[W擾R}h */
	blaster_write(0xe1);

	/* ʂ擾 */
	blaster_dsp = blaster_read();

	/* ʂǂݎ̂ */
	blaster_read();
}

/*
 *	Sound Blaster
 *	荞݃nhݒ
 */
static void blaster_isrset(DWORD handler)
{
	DWORD p;
	BYTE dat;

	/* xN^AhXZo */
	if (blaster_irq > 7) {
		p = (DWORD)(blaster_irq + 0x68);
	}
	else {
		p = (DWORD)(blaster_irq + 8);
	}
	p *= 4;

	/* ݒ */
	disable();
	blaster_off = *(WORD far *)(p);
	blaster_seg = *(WORD far *)(p + 2);
	*(DWORD *)(p) = handler;

	/* 8259ݒ */
	if (blaster_irq > 7) {
		dat = 1 << (blaster_irq - 8);
		outp(0xa1, inp(0xa1) & ~dat);
	}
	else {
		dat = 1 << blaster_irq;
		outp(0x21, inp(0x21) & ~dat);
	}
	enable();
}

/*
 *	Sound Blaster
 *	荞݃nhJ
 */
static void blaster_isrreset(void)
{
	DWORD p;
	BYTE dat;

	/* xN^AhXZo */
	if (blaster_irq > 7) {
		p = (DWORD)(blaster_irq + 0x68);
	}
	else {
		p = (DWORD)(blaster_irq + 8);
	}
	p *= 4;

	/* ݒ */
	disable();
	*(WORD far *)(p) = blaster_off;
	*(WORD far *)(p + 2) = blaster_seg;

	/* 8259ݒ */
	if (blaster_irq > 7) {
		dat = 1 << (blaster_irq - 8);
		outp(0xa1, inp(0xa1) | dat);
	}
	else {
		dat = 1 << blaster_irq;
		outp(0x21, inp(0x21) | dat);
	}
	enable();
}

/*
 *	Sound Blaster
 *	obt@m
 */
static BOOL blaster_malloc(void)
{
	BYTE *temp;
	WORD seg;
	WORD off;
	WORD cnt;

	temp = NULL;
	for (cnt=1;cnt<0x1000;cnt++) {
		/* mہAZOg */
		blaster_buf = (BYTE *)malloc(blaster_bufsize);
		if (blaster_buf == NULL) {
			if (temp != NULL) {
				free(temp);
				temp = NULL;
			}
			return FALSE;
		}
		seg = FP_SEG(blaster_buf);
		off = FP_OFF(blaster_buf);
		off >>= 4;
		seg += off;

		/* `FbNAI */
		if ((seg & 0xfff) < (0x1000 - ((blaster_bufsize) / 16))) {
			if (temp != NULL) {
				free(temp);
				temp = NULL;
			}
			return TRUE;
		}

		/* UJ */
		free(blaster_buf);
		blaster_buf = NULL;
		if (temp != NULL) {
			free(temp);
			temp = NULL;
		}

		/* cntpOtmۂ */
		temp = (BYTE *)malloc(cnt * 16);
		if (temp == NULL) {
			return FALSE;
		}
	}

	return FALSE;
}

/*
 *	Sound Blaster
 *	DMAZbgAbv
 */
static void blaster_dmaset(WORD offset, WORD length)
{
	WORD page;

	if (snd_bytes == 1) {
		/* DMA}XN */
		outp(0x0a, blaster_dma + 4);

		/* tbvtbvNA */
		outp(0x0c, 0);

		/* DMA[hݒ(Aǂݏo) */
		outp(0x0b, blaster_dma + 0x58);

		/* JnAhXݒ */
		page = (FP_SEG(blaster_buf) >> 12);
		outp(blaster_dma_table[blaster_dma], page);
		page = (FP_SEG(blaster_buf) << 4);
		page += (FP_OFF(blaster_buf) & 0x000f);
		page += offset;
		outp(blaster_dma * 2, page & 0xff);
		outp(blaster_dma * 2, page >> 8);

		/* ]ݒ */
		length--;
		outp(blaster_dma * 2 + 1, length & 0xff);
		outp(blaster_dma * 2 + 1, length >> 8);

		/* DMA */
		outp(0x0a, blaster_dma);
	}
	else {
		/* DMA}XN */
		outp(0xd4, (blaster_hdma - 4) + 4);

		/* tbvtbvNA */
		outp(0xd8, 0);

		/* DMA[hݒ(Aǂݏo) */
		outp(0xd6, (blaster_hdma - 4) + 0x58);

		/* JnAhXݒ */
		page = ((FP_SEG(blaster_buf) >> 12) & 0x0e);
		outp(blaster_dma_table[blaster_hdma], page);

		page = (FP_SEG(blaster_buf) << 4);
		page += (FP_OFF(blaster_buf) & 0x000f);
		page += offset;
		page >>= 1;
		if (FP_SEG(blaster_buf) & 0x1000) {
			page += 0x8000;
		}
		outp((blaster_hdma - 4) * 4 + 0xc0, page & 0xff);
		outp((blaster_hdma - 4) * 4 + 0xc0, page >> 8);

		/* ]ݒ */
		length--;
		outp((blaster_hdma - 4) * 4 + 0xc2, length & 0xff);
		outp((blaster_hdma - 4) * 4 + 0xc2, length >> 8);

		/* DMA */
		outp(0xd4, (blaster_hdma - 4));
	}
}

/*
 *	Sound Blaster
 *	tJn
 */
static void blaster_play(WORD length)
{
	if (snd_bytes == 1) {
		/* DMAubNTCY */
		length--;
		blaster_write(0x48);
		blaster_write(length & 0xff);
		blaster_write(length >> 8);

		/* 8bit DMA-DAC, Auto Init, High speed */
		blaster_write(0x90);
	}
	else {
		/* 16bit DMA-DAC, Auto Init, High speed */
		blaster_write(0xb6);
		blaster_write(0x00);
		length--;
		blaster_write(length & 0xff);
		blaster_write(length >> 8);
	}
}

/*-[ Sound Blaster ʃW[ ]-----------------------------------------*/

/*
 *	Sound Blaster
 *	TvOgݒ
 */
static void blaster_setrate(void)
{
	WORD dat;

	/* ݃`FbN */
	if (!blaster_flag) {
		return;
	}

	/* [gݒ */
	if (snd_bytes == 1) {
		blaster_write(0x40);
		switch (blaster_rate) {
			/* 11kHz */
			case 11:
				if (blaster_mono) {
					blaster_write(165);
				}
				else {
					blaster_write(211);
				}
				break;
			/* 22kHz */
			case 22:
				if (blaster_mono) {
					blaster_write(211);
				}
				else {
					blaster_write(233);
				}
				break;
			/* 44kHz */
			case 44:
				blaster_write(233);
				break;
		}
	}
	else {
		/* Sound Blaster16́Aꊇw */
		dat = snd_rate * 1000;
		blaster_write(0x41);
		blaster_write(dat >> 8);
		blaster_write(dat & 0xff);
	}
}

/*
 *	Sound Blaster
 *	p[^擾A݃`FbN
 */
static BOOL blaster_get(void)
{
	char *ptr;
	char c;

	/* p[^NA(݂Ȃlw肵Ă) */
	blaster_flag = FALSE;
	blaster_port = 0;
	blaster_irq = 0;
	blaster_dma = 8;
	blaster_hdma = 0;
	blaster_dsp = 0;

	/* BLASTER̕擾 */
	ptr = getenv("BLASTER");
	if (ptr == NULL) {
		return FALSE;
	}

	/* T[` */
	for (;;) {
		/* 擾 */
		c = *ptr++;

		/* I`FbN */
		if (c == '\0') {
			break;
		}

		/* Xy[Xȉ̓XLbv */
		if (c <= 0x20) {
			continue;
		}

		c |= 0x20;
		switch (c) {
			/* A:|[gAhXw */
			case 'a':
				blaster_port = strtol(ptr, &ptr, 16);
				break;
			/* I:荞ݎw */
			case 'i':
				blaster_irq = strtol(ptr, &ptr, 10);
				break;
			/* D:8bit DMAw */
			case 'd':
				blaster_dma = strtol(ptr, &ptr, 10);
				break;
			/* H:16bit DMAw */
			case 'h':
				blaster_hdma = strtol(ptr, &ptr, 10);
				break;
		}
	}

	/* |[g`FbN */
	if ((blaster_port < 0x200) || (blaster_port > 0x2ff)) {
		return FALSE;
	}
	if (blaster_port & 0x1f) {
		return FALSE;
	}

	/* IRQ`FbN */
	if ((blaster_irq < 3) || (blaster_irq > 15)) {
		return FALSE;
	}

	/* DMA`FbN */
	if (blaster_dma > 3) {
		return FALSE;
	}

	/* w肳ꂽ|[gŃZbg݂ */
	if (!blaster_reset()) {
		return FALSE;
	}

	/* DSPo[W擾 */
	blaster_ver();

	/* o[W`FbN */
	if (blaster_dsp < 2) {
		return FALSE;
	}

	/* blaster_dsp >= 4ȂAHDMAwK{ */
	if (blaster_dsp >= 4) {
		if ((blaster_hdma < 4) || (blaster_hdma > 7)) {
			blaster_dsp = 3;
		}
	}

	/* ok */
	blaster_flag = TRUE;
	return TRUE;
}

/*-[ Sound Blaster xhCo ]---------------------------------------*/

/*
 *	Sound Blaster
 *	荞݃nh
 */
static void interrupt blaster_isr(void)
{
	if (blaster_flag) {
		/* IRQ ACKʒm */
		if (snd_bytes == 1) {
			inp(blaster_port + 0x0e);
		}
		else {
			inp(blaster_port + 0x0f);
		}

		/* oNύX */
		if (blaster_bank) {
			blaster_bank = FALSE;
			blaster_load(blaster_buf);
		}
		else {
			blaster_bank = TRUE;
			blaster_load(&blaster_buf[blaster_len * snd_bytes]);
		}
	}

	/* EOIs */
	if (blaster_irq > 7) {
		outp(0xa0, 0x20);
	}
	outp(0x20, 0x20);
}

/*
 *	Sound Blaster
 *	Đp[^ݒ
 */
BOOL blaster_param(BYTE rate, BOOL mono)
{
	/* ݃`FbN */
	if (!blaster_flag) {
		return FALSE;
	}

	/*  */
	blaster_rate = 22;
	blaster_mono = TRUE;

	/* 44kHźAm̂݃T|[g */
	if ((rate == 44) && (!mono)) {
		return FALSE;
	}

	/* p[^󂯓 */
	blaster_rate = rate;
	blaster_mono = mono;

	/* TvO[gݒ */
	blaster_setrate();

	return TRUE;
}

/*
 *	Sound Blaster
 *	
 */
BOOL blaster_init(void)
{
	/*  */
	blaster_flag = FALSE;
	blaster_buf = NULL;
	blaster_bufsize = 0;

	/* ϐ`FbNA݃`FbN */
	blaster_get();

	/* TvO[g */
	switch (blaster_dsp) {
		case 0:
			return FALSE;
		case 3:
			printf("Sound Blaster (PORT%3x IRQ%d DMA%d) is detected.\n",
				blaster_port, blaster_irq, blaster_dma);
			snd_rate = 22;
			snd_bytes = 1;
			break;
		case 4:
			printf("Sound Blaster16 (PORT%3x IRQ%d DMA%d HDMA%d) is detected.\n",
				blaster_port, blaster_irq, blaster_dma, blaster_hdma);
			snd_rate = 44;
			snd_bytes = 2;
			break;
	}

	/* Ńobt@TCYm */
	blaster_bufsize = snd_rate * SND_TICK * snd_bytes * 2;

	/* Xs[Jon */
	blaster_speaker(TRUE);

	/* obt@m */
	if (!blaster_malloc()) {
		blaster_flag = FALSE;
		return FALSE;
	}

	/* p[^ݒ */
	blaster_param(snd_rate, TRUE);

	/* IRQnhݒ */
	blaster_isrset((DWORD)blaster_isr);

	return TRUE;
}

/*
 *	Sound Blaster
 *	N[Abv
 */
void blaster_cleanup(void)
{
	if (blaster_flag) {
		blaster_speaker(FALSE);
		if (snd_bytes == 1) {
			/* t~(8bit) */
			blaster_write(0xd0);
			blaster_write(0xda);
			blaster_write(0xd0);
		}
		else {
			/* t~(16bit) */
			blaster_write(0xd5);
			blaster_write(0xd9);
			blaster_write(0xd5);
		}

		/* n[hEFAZbg */
		blaster_reset();

		/* 荞݃nh */
		blaster_isrreset();
	}

	/* obt@ */
	if (blaster_buf != NULL) {
		free(blaster_buf);
	}
}

/*
 *	Sound Blaster
 *	obt@yщtJn
 */
void blaster_start(WORD length)
{
	if (!blaster_flag) {
		return;
	}

	/* OXL */
	blaster_len = length;

	/* obt@ */
	memset(blaster_buf, 0x80, blaster_bufsize);

	/* oNɃf[^ݒ */
	blaster_bank = TRUE;
	blaster_load(&blaster_buf[blaster_len * snd_bytes]);

	/* tJn */
	blaster_dmaset(0, length * 2);
	blaster_play(length);
}
