/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ IBM-PC L[{[h ]
 */

#if defined(__MSDOS__) && defined(IBM)

#include <assert.h>
#include <string.h>
#include <dos.h>
#include "xm7.h"
#include "keyboard.h"
#include "gui.h"
#include "device.h"
#include "ibm.h"

/*
 *	O[o [N
 */
BYTE kbd_map[256];						/* L[{[h }bv */
BOOL kbd_flag;							/* L[{[h tO */
DWORD kbd_vector;						/* int15h IWixN^ */

/*
 *	X^eBbN [N
 */
static BYTE kbd_work[256];				/* L[p */
static BYTE kbd_prefix;					/* vtBbNXtO */

/*
 *	荞݃Gg
 */
static void interrupt kbd_isr(void)
{
_asm {
		cmp		ah,4fh
		jz		kbd_isr_kbd
/* IWi֔΂ */
/* AH=4fhȊO̓IWi֔΂ */
kbd_isr_org:
		pop		bp
		add		sp,8
		pop		ds
		pop		es
		add		sp,12
/* EAXGAɁAxN^AhXݒ */
		push	ds
		push	ax
		push	bx
		push	bp
		mov		bp,sp
		mov		bx,seg kbd_vector
		mov		ds,bx
		mov		bx,offset kbd_vector
		mov		ax,[bx+2]
		mov		[bp+10],ax
		mov		ax,[bx]
		mov		[bp+8],ax
		pop		bp
		pop		bx
		pop		ax
		pop		ds
/* far jump */
		retf
kbd_isr_kbd:
/* int 15h, AH=4fh */
		mov		si,offset kbd_map
/* E0̓vtBbNX */
		cmp		al,0e0h
		jz		kbd_isr_prefix
/* CfbNXZo */
		mov		bx,ax
		and		bx,007fh
		mov		ah,[kbd_prefix]
		or		ah,ah
		jz		kbd_isr_check
		add		bx,0080h
/* Make/Break */
kbd_isr_check:
		or		al,al
		js		kbd_isr_break
/* Make */
kbd_isr_make:
		mov		byte ptr [bx+si],01h
		mov		[kbd_prefix],00h
		jmp		kbd_isr_cy
/* Break */
kbd_isr_break:
		mov		byte ptr [bx+si],00h
		mov		[kbd_prefix],00h
		jmp		kbd_isr_cy
/* vtBbNX */
kbd_isr_prefix:
		mov		[kbd_prefix],01h
/* CY~낵AL[͂BIOSɑ΂Ėɂ */
kbd_isr_cy:
		mov		bp,sp
		and		word ptr [bp+17 * 2],0fffeh
/* tOݒ */
		mov		[kbd_flag],01h
	}
}

/*
 *	L[{[h 
 */
void kbd_init(void)
{
	/* [NNA */
	memset(kbd_map, 0, sizeof(kbd_map));
	memset(kbd_work, 0, sizeof(kbd_work));
	kbd_prefix = 0;

	/* int 15htbN */
	disable();
	kbd_vector = *(DWORD *)(0x0015 * 4);
	*(DWORD *)(0x0015 * 4) = (DWORD)kbd_isr;
	enable();
}

/*
 *	L[{[h N[Abv
 */
void kbd_cleanup(void)
{
	/* int 15h𕜌 */
	disable();
	*(DWORD *)(0x0015 * 4) = (DWORD)kbd_vector;
	enable();
}

/*
 *	106L[{[hFM7 R[h
 *	R[hΏƕ\
 */
static BYTE jp106_key_table[] = {
	0x01, 0x5c,							/* Break (ESC)*/

	0x3b, 0x5d,							/* F1 */
	0x3c, 0x5e,							/* F2 */
	0x3d, 0x5f,							/* F3 */
	0x3e, 0x60,							/* F4 */
	0x3f, 0x61,							/* F5 */
	0x40, 0x62,							/* F6 */
	0x41, 0x63,							/* F7 */
	0x42, 0x64,							/* F8 */
	0x43, 0x65,							/* F9 */
	0x44, 0x66,							/* F10 */

	0x29, 0x01,							/* ESC (p/Sp) */
	0x02, 0x02,							/* 1 */
	0x03, 0x03,							/* 2 */
	0x04, 0x04,							/* 3 */
	0x05, 0x05,							/* 4 */
	0x06, 0x06,							/* 5 */
	0x07, 0x07,							/* 6 */
	0x08, 0x08,							/* 7 */
	0x09, 0x09,							/* 8 */
	0x0a, 0x0a,							/* 9 */
	0x0b, 0x0b,							/* 0 */
	0x0c, 0x0c,							/* - */
	0x0d, 0x0d,							/* ^ */
	0x7d, 0x0e,							/* \ */
	0x0e, 0x0f,							/* BS */

	0x0f, 0x10,							/* TAB */
	0x10, 0x11,							/* Q */
	0x11, 0x12,							/* W */
	0x12, 0x13,							/* E */
	0x13, 0x14,							/* R */
	0x14, 0x15,							/* T */
	0x15, 0x16,							/* Y */
	0x16, 0x17,							/* U */
	0x17, 0x18,							/* I */
	0x18, 0x19,							/* O */
	0x19, 0x1a,							/* P */
	0x1a, 0x1b,							/* @ */
	0x1b, 0x1c,							/* [ */
	0x1c, 0x1d,							/* CR */

	0x3a, 0x52,							/* CTRL */
	0x1e, 0x1e,							/* A */
	0x1f, 0x1f,							/* S */
	0x20, 0x20,							/* D */
	0x21, 0x21,							/* F */
	0x22, 0x22,							/* G */
	0x23, 0x23,							/* H */
	0x24, 0x24,							/* J */
	0x25, 0x25,							/* K */
	0x26, 0x26,							/* L */
	0x27, 0x27,							/* ; */
	0x28, 0x28,							/* : */
	0x2b, 0x29,							/* ] */

	0x2a, 0x53,							/* SHIFT */
	0x2c, 0x2a,							/* Z */
	0x2d, 0x2b,							/* X */
	0x2e, 0x2c,							/* C */
	0x2f, 0x2d,							/* V */
	0x30, 0x2e,							/* B */
	0x31, 0x2f,							/* N */
	0x32, 0x30,							/* M */
	0x33, 0x31,							/* , */
	0x34, 0x32,							/* . */
	0x35, 0x33,							/* / */
	0x73, 0x34,							/* _ */
	0x36, 0x54,							/* ESHIFT */

	0x1d, 0x55,							/* CAP (CTRL) */
	0x38, 0x56,							/* GRAPH (ALT) */
	0x39, 0x57,							/* SPACE (SPACE) */
	0x79, 0x58,							/* SPACE (ϊ) */
	0x70, 0x35,							/* ESPACE (Ђ炪) */
	0x1d+0x80, 0x5a,					/*  (ECTRL) */

	0x52+0x80, 0x48,					/* INS (Insert) */
	0x48+0x80, 0x4d,					/*  */
	0x53+0x80, 0x4b,					/* DEL (Delete) */
	0x4b+0x80, 0x4f,					/*  */
	0x50+0x80, 0x50,					/*  */
	0x4d+0x80, 0x51,					/*  */

	0x47+0x80, 0x49,					/* EL (Home) */
	0x49+0x80, 0x4a,					/* CLS (Page Up) */
	0x4f+0x80, 0x4c,					/* DUP (End) */
	0x51+0x80, 0x4e,					/* HOME (Page Down) */

	0x52, 0x46,							/* Tenkey 0 */
	0x53, 0x32,							/* Tenkey . */
	0x4f, 0x42,							/* Tenkey 1 */
	0x50, 0x43,							/* Tenkey 2 */
	0x51, 0x44,							/* Tenkey 3 */
	0x1c + 0x80, 0x45,					/* Tenkey CR */
	0x4b, 0x3e,							/* Tenkey 4 */
	0x4c, 0x3f,							/* Tenkey 5 */
	0x4d, 0x40,							/* Tenkey 6 */
	0x47, 0x3a,							/* Tenkey 7 */
	0x48, 0x3b,							/* Tenkey 8 */
	0x49, 0x3c							/* Tenkey 9 */
};

/*
 *	JP106L[R[hFM-7 R[hϊ
 */
static BYTE jp106_to_fm7(BYTE oem)
{
	int i;

	for (i=0; i<(sizeof(jp106_key_table) / 2); i++) {
		if (oem == jp106_key_table[i * 2]) {
			return jp106_key_table[i * 2 + 1];
		}
	}

	return 0;
}

/*
 *	L[{[h 荞݂󂯂Ă̏
 */
void kbd_check(void)
{
	BYTE kbd_tmp[256];
	BYTE fm7;
	int i;

	/* 荞݃[`Ƃ̓l */
	disable();
	kbd_flag = FALSE;
	memcpy(kbd_tmp, kbd_map, sizeof(kbd_map));
	enable();

	/* [NT[` */
	for (i=0; i<256; i++) {
		if (kbd_work[i] != kbd_tmp[i]) {
			fm7 = jp106_to_fm7(i);

			/* LȃL[ȂA */
			if (fm7 != 0) {
				if (kbd_tmp[i]) {
					/* Make */
					keyboard_make(fm7);
				}
				else {
					/* Break */
					keyboard_break(fm7);
				}
			}

			/* [F11][F12]GUIĂяo */
			if ((i == 0x57) && (kbd_tmp[0x57])) {
				gui_start();
			}
			if ((i == 0x58) && (kbd_tmp[0x58])) {
				gui_start();
			}
		}
	}

	/* [NXV */
	memcpy(kbd_work, kbd_tmp, sizeof(kbd_work));
}

#endif	/* __MSDOS__ && IBM */
