/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ FM-TOWNS ʕ\ ]
 */

#if defined(__MSDOS__) && defined(FMT)

#include <assert.h>
#include <dos.h>
#include <string.h>
#include "xm7.h"
#include "fmt.h"
#include "device.h"

/*
 *	fW^pbge[u
 */
BYTE palet_table[] = {
	0x00, 0x00, 0x00,
	0x00, 0x00, 0xff,
	0xff, 0x00, 0x00,
	0xff, 0x00, 0xff,
	0x00, 0xff, 0x00,
	0x00, 0xff, 0xff,
	0xff, 0xff, 0x00,
	0xff, 0xff, 0xff
};

/*
 *	fW^pbgݒ胏|N
 */
typedef struct {
	WORD size;
	WORD num;
	BYTE dmy;
	BYTE red;
	BYTE green;
	BYTE blue;
} palet_set_t;

static palet_set_t palet_work;

/*
 *	OtBbNʃNA
 */
void scr_clear(void)
{
	BYTE far *p;
	*(BYTE far *)0xc000ff81 = 0x0f;

	p = (BYTE far *)0xc0000000;
	memset(p, 0, 32000);
}

/*
 *	ʕ\ 
 */
void scr_init(void)
{
	union REGS regs;
	int i;
	BYTE far *p;

	/* GDS-BASE */
	regs.h.ah = 0x80;
	int86(0x92, &regs, &regs);

	/* 640x400ݒ */
	regs.h.ah = 0x81;
	regs.x.dx = 640;
	regs.x.cx = 400;
	int86(0x92, &regs, &regs);

	/* NA */
	scr_clear();

	/* wȉ */
	ttlpalet_setb(8, 0);
	*(BYTE far *)0xc000ff81 = 0x08;
	p = (BYTE far *)0xc0000000L;
	for (i=0; i<200; i++) {
		memset(&p[i * 160 + 80], 0xff, 80);
	}

	/* eLXgoff */
	regs.h.ah = 0x01;
	regs.h.al = 0x05;
	int86(0x91, &regs, &regs);

/*	*(BYTE far *)0xc000ff82 = 0x67; */
}

/*
 *	ʕ\ N[Abv
 */
void scr_cleanup(void)
{
	int i;
	union REGS regs;

	/* pbgNA */
	for (i=0; i<8; i++) {
		ttlpalet_setb(i, 0);
	}

	/* NA */
	scr_clear();

	/* eLXgon */
	regs.h.ah = 0x01;
	regs.h.al = 0x0a;
	int86(0x91, &regs, &regs);
}

/*
 *	fW^pbgݒ
 */
void ttlpalet_setb(int no, BYTE dat)
{
	BYTE *p;
	union REGS regs;

	p = &palet_table[dat * 3];

	palet_work.size = sizeof(palet_work);
	palet_work.num = no;
	palet_work.dmy = 0;
	palet_work.red = *p++;
	palet_work.green = *p++;
	palet_work.blue = *p++;

	regs.h.ah = 0x83;
	regs.x.di = FP_OFF(&palet_work);
	int86(0x92, &regs, &regs);
}

/*
 *	L[{[hLED\
 */
void keyboard_setled(void)
{
}

#endif	/* __MSDOS__  && FM-TOWNS */
