/*
** xipres.c for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 08:26:38 1999 
** Last update Thu Oct 28 20:24:00 1999 
*/
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "xipres.h"
#include "pat_pat.h"

extern t_boolean	verbose;
extern Widget		toplevel;

t_xip_resources		xip_resources;

XtResource		resources[] = 
{
#define RESSTRING(Name,Class,Field,Def) \
  {Name,		Class,		XtRString,\
   sizeof (xip_resources.Field),\
   XtOffset(t_xip_resources *,Field),	XtRString,	(Def)}

#define RESINT(Name,Class,Field,Def) \
  {Name,		Class,		XtRInt,\
   sizeof (xip_resources.Field),\
   XtOffset(t_xip_resources *,Field),	XtRImmediate,	(XtPointer)(Def)}

#define RESGC(Name,Class,Field,Def) \
  {Name,		Class,		XtRGC,\
   sizeof (xip_resources.Field),\
   XtOffset(t_xip_resources *,Field),	XtRString,	(Def)}

#define RESBOOLEAN(Name,Class,Field,Def) \
  {Name,		Class,		XtRBoolean,\
   sizeof (xip_resources.Field),\
   XtOffset(t_xip_resources *,Field),	XtRImmediate,	(XtPointer)(Def)}

  RESSTRING("binEditorPath","BinEditorPath",binEditorPath,"emacs"),
  RESSTRING("defaultColorName","DefaultColorName",
	    defaultColorName,"white"),
  RESSTRING("bodyColorName","BodyColorName",bodyColorName,"white"),
  RESSTRING("bodyBackgroundName","BodyBackgroundName",
	    bodyBackgroundName,"internal:gray.xbm"),
  RESSTRING("controlsColorName","ControlsColorName",
	    controlsColorName,"white"),
  RESINT("pktHelpOffset","PktHelpOffset",pktHelpOffset,8),
  RESBOOLEAN("pinMode","PinMode",pinMode,FALSE),
  RESBOOLEAN("helpMode","HelpMode",helpMode,TRUE),
  RESBOOLEAN("scrollMode","ScrollMode",scrollMode,TRUE),
  RESBOOLEAN("smoothScrollMode","SmoothScrollMode",smoothScrollMode,TRUE),
  RESINT("smoothScrollLimit","SmoothScrollLimit",smoothScrollLimit,8),
  RESINT("smoothScrollOffset","SmoothScrollOffset",smoothScrollOffset,1)
};

Cardinal		num_resources = XtNumber(resources);

t_dict			*xip_extra_vars = NULL;
char			*progname;
char			*progclass;

/* is a t_dict_walk_proc.
   Walks the "lay" dictionary to lookup associated Xrm resources. */
t_status		get_extra_vars_from_xrm_walk(he,db)
t_hash_elt		*he;
XrmDatabase		db;
{
  char			str_name[STR_BUFSIZ];
  char			str_class[STR_BUFSIZ];
  char			*str_type;
  XrmValue		xrmvalue;
  t_status		status;
  char			key[STR_BUFSIZ];

  str_name[0] = 0;
  if ((status = str_cat_fmt_va(str_name,
			       sizeof (str_name),
			       "%s.%sColor",
			       progname,
			       he->key)) != 0)
    return (status);
  str_class[0] = 0;
  if ((status = str_cat_fmt_va(str_class,
			       sizeof (str_class),
			       "%s.%sColor",
			       progclass,
			       he->key)) != 0)
    return (status);
  key[0] = 0;
  if ((status = str_cat_fmt_va(key,
			       sizeof (key),
			       "%sColor",
			       he->key)) != 0)
    return (status);
  if (!XrmGetResource(db,
		      str_name,
		      str_class,
		      &str_type,
		      &xrmvalue))
    {
      if (verbose)
	err_print(ERR_XIP_MISSING_VAR,"%s",str_name);
      return (dict_str_override(xip_extra_vars,
				key,
				xip_resources.defaultColorName));
    }
  if (strcmp(str_type,XtRString))
    {
      err_print(ERR_XIP_CANT_HANDLE,"Unknown Xrm type %s",str_type);
      return (0);
    }
  return (dict_str_override_with_len(xip_extra_vars,
				     key,
				     xrmvalue.addr,
				     xrmvalue.size));
}

/* Extracts variables from Xrm which will be used as "extravars" for
   packet templates.
   Returns 0 if OK, might return and print various errors. */
t_status		xip_extra_vars_get_from_xrm(VOID_DECL)
{
  XrmDatabase		db;
  t_status		status;

  if ((xip_extra_vars = XIP_DICT_NEW(HASH_SMALL_BASE,
				     VEC_BASE,
				     &status)) == NULL)
    return (status);
  db = XtDatabase(XtDisplay(toplevel));
  XtGetApplicationNameAndClass(XtDisplay(toplevel),
			       &progname,
			       &progclass);
  if ((status = dict_walk(pat_dict,
			  (t_dict_walk_proc)get_extra_vars_from_xrm_walk,
			  db)) != 0)
    return (status);
  if ((status = dict_str_add(xip_extra_vars,
			     "bodyColorName",
			     xip_resources.bodyColorName)) != 0)
    {
      err_print(status,"dict_str_add bodyColorName");
      return (0);
    }
  if ((status = dict_str_add(xip_extra_vars,
			     "bodyBackgroundName",
			     xip_resources.bodyBackgroundName)) != 0)
    {
      err_print(status,"dict_str_add bodyBackgroundName");
      return (0);
    }
  if ((status = dict_str_add(xip_extra_vars,
			     "controlsColorName",
			     xip_resources.controlsColorName)) != 0)
    {
      err_print(status,"dict_str_add controlsColorName");
      return (0);
    }
  return (0);
}

/* deletes "extravars" */
VOID_FUNC		xip_extra_vars_destroy(VOID_DECL)
{
  dict_str_delete(xip_extra_vars);
}
