/*
** pkt.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:46:09 1999 
** Last update Thu Oct 28 20:20:48 1999 
*/
#ifndef PKT_H
#define PKT_H	1

#include <sys/time.h>
#include "pat.h"

typedef struct			s_pkt
{
  t_pat				*pat;
  char				*buf;
  t_32				len;		/* the "captured" len	*/
  t_32				netlen;		/* the "real" len	*/
  struct timeval		timestamp;
} t_pkt;

typedef t_status		(*t_pkt_proc) P((t_pkt *pkt));

typedef t_status	(*t_pkt_get_field_to_str_proc) P((t_pkt *pkt,
							  char *field,
							  char *str,
							  int max_len));

typedef struct			s_pkt_format_do_data
{
  t_pkt				*pkt;
  t_boolean			do_opts;
  t_vec				*vec_prefixes;		/* MIGHT BE NULL */
  t_dict			*extra_vars;		/* MIGHT BE NULL */
  t_tmpl_do_proc		tmpl_do_proc;
  char				*htmlize_str;
  int				htmlize_max_len;
  t_pkt_get_field_to_str_proc	get_field_to_str_proc;
} t_pkt_format_do_data;

typedef t_status		(*t_pkt_walk_proc) P((t_pkt *pkt,
						      int level,
						      t_id *id,
						      VOID_PTR data));

typedef struct			s_pkt_on_data
{
  t_pkt_walk_proc		proc;
  VOID_PTR			data;
  char				*patname;
  int				patlen;	
} t_pkt_on_data;

typedef struct			s_pkt_get_tmpl_to_str_data
{
  char				*str;
  int				max_len;
} t_pkt_get_tmpl_to_str_data;

typedef struct			s_pkt_get_field_to_str_data
{
  char				*str;
  int				max_len;
  char				*field;
} t_pkt_get_field_to_str_data;

typedef struct			s_pkt_set_field_from_str_data
{
  char				*value;
  char				*field;
} t_pkt_set_field_from_str_data;

typedef struct			s_pkt_get_choices_data
{
  char				*field;
  t_vec				*vec_str;
  t_boolean			*do_sort_return;
} t_pkt_get_choices_data;

typedef struct			s_pkt_trunc_data
{
  char				*patname;
  t_pkt				*ref_pkt;
  t_alloc_proc			alloc_proc;
  t_free_proc			free_proc;
} t_pkt_trunc_data;

typedef struct			s_pkt_cut_data
{
  t_pkt				*cutbufpkt;
  t_boolean			fine;
  t_alloc_proc			alloc_proc;
  t_free_proc			free_proc;
} t_pkt_cut_data;

typedef struct			s_pkt_paste_data
{
  t_pkt				*ref_pkt;
  t_pkt				*cutbufpkt;
  t_boolean			fine;
  t_alloc_proc			alloc_proc;
  t_free_proc			free_proc;
} t_pkt_paste_data;

/* SHALLOW COPY */
#define PKT_COPY(Src,Dst)	FBCOPY((Src),(Dst),sizeof (t_pkt))

/* PROTO pkt.c */
/* pkt.c */
t_pkt *pkt_new P((int len, t_pat *pat, t_alloc_proc alloc_proc, t_free_proc free_proc, t_status *status));
t_status pkt_scratch P((t_pkt *src, t_pkt *dst, t_alloc_proc alloc_proc, t_free_proc free_proc));
t_pkt *pkt_dup P((t_pkt *pkt, t_alloc_proc alloc_proc, t_free_proc free_proc, t_status *status));
void pkt_delete P((t_pkt *pkt, t_free_proc free_proc));
t_status pkt_save_raw P((t_pkt *pkt, char *fname));
t_status pkt_load_raw P((t_pkt *pkt, char *fname, t_alloc_proc alloc_proc, t_free_proc free_proc));
t_status pkt_sub P((t_pkt *pkt, t_pkt *sub_pkt, t_id *id));
t_status pkt_walk_i P((t_pkt *pkt, t_boolean do_opts, int level, t_id *id, t_pkt_walk_proc proc, void *data));
t_status pkt_walk P((t_pkt *pkt, t_boolean do_opts, int level, t_pkt_walk_proc proc, void *data));
t_status pkt_on_i_walk P((t_pkt *pkt, int level, t_id *id, t_pkt_on_data *pod));
t_status pkt_on_i P((t_pkt *pkt, t_boolean do_opts, char *patname, int patlen, t_id *id, t_pkt_walk_proc proc, void *data));
t_status pkt_on P((t_pkt *pkt, t_boolean do_opts, char *patname, int patlen, t_pkt_walk_proc proc, void *data));
t_status pkt_sum P((t_pkt *pkt, t_pkt *up_pkt));
t_status pkt_adapt_len P((t_pkt *pkt));
t_status pkt_get_field_to_str_i_on P((t_pkt *pkt, int level, t_id *id, t_pkt_get_field_to_str_data *pgftsd));
t_status pkt_get_field_to_str_i P((t_pkt *pkt, char *fq_field, char *str, int max_len, t_id *id));
t_status pkt_get_field_to_str P((t_pkt *pkt, char *field, char *str, int max_len));
t_status pkt_set_field_from_str_i_on P((t_pkt *pkt, int level, t_id *id, t_pkt_set_field_from_str_data *psffsd));
t_status pkt_set_field_from_str_i P((t_pkt *pkt, char *fq_field, char *value, t_id *id));
t_status pkt_set_field_from_str P((t_pkt *pkt, char *field, char *value));
t_status pkt_get_choices_i_on P((t_pkt *pkt, int level, t_id *id, t_pkt_get_choices_data *pgcd));
t_status pkt_get_choices_i P((t_pkt *pkt, char *fq_field, t_vec *vec_str, t_boolean *do_sort_return, t_id *id));
t_status pkt_get_choices P((t_pkt *pkt, char *field, t_vec *vec_str, t_boolean *do_sort_return));
t_status pkt_get_tmpl_to_str_walk P((t_pkt *pkt, int level, t_id *id, t_pkt_get_tmpl_to_str_data *pgttsd));
t_status pkt_get_tmpl_to_str P((t_pkt *pkt, char *str, int max_len, t_boolean do_opts));
void timestamp_from_str P((char *str, struct timeval *tv));
t_status timestamp_to_str P((struct timeval *tv, int zone, char *str, int max_len, t_boolean resolve));
t_status local_to_str P((t_pkt *pkt, t_vec *vec_prefixes, char *str, int max_len, t_boolean remote, t_boolean resolve, t_pkt_get_field_to_str_proc get_field_to_str_proc));
t_status pkt_format_do P((t_bridled_str *bs, char *var, t_pkt_format_do_data *pfdd));
t_status pkt_format_htmlize_do P((t_bridled_str *bs, char *var, t_pkt_format_do_data *pfdd));
t_status pkt_format_html P((t_pkt *pkt, t_boolean do_opts, char *tmpl_str, t_vec *vec_prefixes, t_dict *extra_vars, char *str, int max_len, char *htmlize_str, int htmlize_max_len));
t_status pkt_trunc_on P((t_pkt *pkt, int level, t_id *id, t_pkt_trunc_data *ptd));
t_status pkt_trunc P((t_pkt *pkt, char *patname, t_alloc_proc alloc_proc, t_free_proc free_proc));
t_status pkt_extract_on P((t_pkt *pkt, int level, t_id *id, t_pkt_trunc_data *ptd));
t_status pkt_extract P((t_pkt *pkt, char *patname, t_alloc_proc alloc_proc, t_free_proc free_proc));
t_status pkt_pat_length_on P((t_pkt *pkt, int level, t_id *id, t_off *length_return));
t_status pkt_pat_length P((t_pkt *pkt, char *patname, t_off *length_return));
t_status pkt_subn P((t_pkt *pkt, t_pkt *subn_pkt, char *wanted_name, int wanted_name_len, t_boolean do_opts));
t_status pkt_cut_internal P((t_pkt *pkt, t_boolean fine, t_pkt *cutbufpkt, t_alloc_proc alloc_proc, t_free_proc free_proc));
t_status pkt_cut_on P((t_pkt *pkt, int level, t_id *id, t_pkt_cut_data *pcd));
t_status pkt_cut P((t_pkt *pkt, char *patname, t_pkt *cutbufpkt, t_boolean fine, t_alloc_proc alloc_proc, t_free_proc free_proc));
t_status pkt_paste_internal P((t_pkt *pkt, t_pkt *ref_pkt, t_boolean fine, t_pkt *cutbufpkt, t_alloc_proc alloc_proc, t_free_proc free_proc));
t_status pkt_paste_on P((t_pkt *pkt, int level, t_id *id, t_pkt_paste_data *ppd));
t_status pkt_paste P((t_pkt *pkt, char *patname, t_pkt *cutbufpkt, t_boolean fine, t_alloc_proc alloc_proc, t_free_proc free_proc));
#endif
