/*
** pat_sz.c for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:41:11 1999 
** Last update Thu Oct 28 20:19:34 1999 
*/
#include "pat.h"
#include "pat_sz.h"

int	sz_chan;

PAT_NAME_GENERIC(sz_pat_name,
		 (VOID_PTR)&sz_chan,
		 "sz")

PAT_EXTRACT_DECL(sz_pat_extract)
{
  int		i;
  t_boolean	found_zero;
  t_status	status;

  found_zero = FALSE;
  i = 0;
  while (i < len)
    {
      if (buf[i] == 0)
	{
	  found_zero = TRUE;
	  break ;
	}
      else
	if ((status = str_cat_char(str,
				   max_len,
				   buf[i])) != 0)
	  return (status);
      i++;
    }
  if (!found_zero)
    return (ERR_PAT_BAD_SZ);
  return (0);
}

PAT_INSERT_DECL(sz_pat_insert)
{
  t_status	status;	
  int		my_len;
  int		i;

  my_len = strlen(value);
  if (len < (my_len + 1))
    return (ERR_PAT_TRUNC_FIELD);
  i = 0;
  while (i < my_len)
    {
      buf[i] = value[i];
      i++;
    }
  buf[i] = 0;
  return (0);
}

PAT_OFF_DECL(sz_pat_off)
{
  int		i;
  t_boolean	found_zero;

  found_zero = FALSE;
  i = 0;
  while (i < len)
    {
      if (buf[i] == 0)
	{
	  found_zero = TRUE;
	  break ;
	}
      i++;
    }
  (*off_return) = i;
  if (!found_zero)
    return (ERR_PAT_BAD_SZ);
  (*off_return)++;
  return (0);
}

t_pat				sz_pat = 
{
  sz_pat_name,			/* t_pat_name_proc		*/
  sz_pat_off,			/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc		*/
  NULL,				/* t_pat_set_field_proc		*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  sz_pat_extract,		/* t_pat_extract_proc		*/
  sz_pat_insert,		/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};
