/*
** pat_seqack.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:47:36 1999 
** Last update Thu Oct 28 20:21:03 1999 
*/
#ifndef PAT_SEQACK_H
#define PAT_SEQACK_H	1

#include "pat.h"
#include "pat_tcp.h"

typedef struct			s_seq_ack_data
{
  t_in_addr			src;		/* ip.src */
  t_in_addr			dst;		/* ip.dst */
  t_u16				sport;		/* tcp.sport */
  t_u16				dport;		/* tcp.dport */
  t_u8				flags;		/* tcp.flags */
  int				datalen;	/* data.len */	
  t_boolean			seq_wanted;	/* seq or ack? */
} t_seq_ack_data;

typedef struct			s_seq_ack
{
  t_tcp_seq			seq;
  t_tcp_seq			ack;
} t_seq_ack;

typedef struct			s_seq_ack_key
{
  t_in_addr			src;
  t_in_addr			dst;
  t_u32				port;
} t_seq_ack_key;

typedef struct			s_seq_ack_hash
{
  struct s_seq_ack_hash		*next;
  t_seq_ack_key			key;
  t_tcp_seq			seq;
  t_tcp_seq			ack;
} t_seq_ack_hash;

extern t_pat			seqack_pat;

/* PROTO pat_seqack.c */
/* pat_seqack.c */
t_status seqack_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status seqack_pat_extract P((void *data, char *buf, int len, char *str, int max_len));
t_status seqack_pat_insert P((void *data, char *buf, int len, char *value));
t_status seqack_pat_off P((void *data, char *buf, int len, t_off *off_return));
#endif
