/*
** pat_inaddr.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:48:57 1999 
** Last update Thu Oct 28 20:21:19 1999 
*/
#ifndef PAT_INADDR_H
#define PAT_INADDR_H	1

#include "pat.h"

/* This is redefined to avoid some include problems */
typedef struct			s_in_addr
{
  t_u32				addr; /* do not use s_addr here! because
					 it is a macro on solaris.
					 Gilbert Ramirez <gram@xiexie.org> */
} t_in_addr;

extern t_pat			inaddr_pat;
extern t_pat			inaddr_resolved_pat;
extern t_pat			inaddrmask_pat;
extern t_pat			inaddrrouter_pat;

/* PROTO pat_inaddr.c */
/* pat_inaddr.c */
int inaddr_cmp P((struct in_addr *addr1, struct in_addr *addr2));
t_status inaddr_from_str P((char *str, struct in_addr *mba_inaddr, t_boolean resolve));
t_status inaddr_to_str P((struct in_addr *mba_inaddr, char *str, int max_len, t_boolean resolve));
t_status inaddr_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status inaddr_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status inaddr_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status inaddr_pat_get_fields P((void *data, t_vec *vec_str));
t_status inaddr_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status inaddr_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status inaddr_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status inaddr_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status inaddr_pat_extract P((void *data, char *buf, int len, char *str, int max_len));
t_status inaddr_pat_insert P((void *data, char *buf, int len, char *value));
t_status inaddr_resolved_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status inaddr_resolved_pat_extract P((void *data, char *buf, int len, char *str, int max_len));
t_status inaddr_resolved_pat_insert P((void *data, char *buf, int len, char *value));
t_status inaddr_resolved_pat_get_choices P((void *data, char *buf, int len, t_vec *vec_str, t_boolean *do_sort_return));
t_status inaddrmask_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status inaddrmask_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status inaddrmask_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status inaddrmask_pat_get_fields P((void *data, t_vec *vec_str));
t_status inaddrmask_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status inaddrmask_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status inaddrmask_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status inaddrmask_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status inaddrrouter_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status inaddrrouter_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status inaddrrouter_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status inaddrrouter_pat_get_fields P((void *data, t_vec *vec_str));
t_status inaddrrouter_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status inaddrrouter_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status inaddrrouter_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status inaddrrouter_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
#endif
