/*
** pat_ieee802.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:49:10 1999 
** Last update Thu Oct 28 20:21:21 1999 
*/
#ifndef PAT_IEEE802_H
#define PAT_IEEE802_H	1

#include "pat.h"
#include "pat_ethaddr.h"

typedef struct		s_llc
{
  t_u8			dsap;
  t_u8			ssap;
  t_u8			cntl;
} t_llc;

#define LLC_HLEN	3

#define PAT_LLC_CHECK(llcpar,bufpar,lenpar) \
	if ((lenpar) < LLC_HLEN)\
		return (ERR_PAT_TRUNC_PAT);\
	(llcpar) = (t_llc *)(bufpar);

typedef struct		s_snap
{
  t_u8			orgcode[3];
  t_u16			type;		/* warning: unaligned */
} t_snap;

#define SNAP_HLEN	5

#define PAT_SNAP_CHECK(snappar,bufpar,lenpar) \
	if ((lenpar) < SNAP_HLEN)\
		return (ERR_PAT_TRUNC_PAT);\
	(snappar) = (t_snap *)(bufpar);

#define LLCSAP_SNAP	0xaa

#define LLC_UI		0x03

extern t_pat		llc_pat;
extern t_pat		snap_pat;

/* PROTO pat_ieee802.c */
/* pat_ieee802.c */
t_status llc_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status llc_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status llc_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status llc_pat_get_fields P((void *data, t_vec *vec_str));
t_status llc_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status llc_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status llc_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status llc_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
int snap_get_type P((t_snap *snap));
t_status snap_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status snap_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status snap_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status snap_pat_get_fields P((void *data, t_vec *vec_str));
t_status snap_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status snap_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status snap_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status snap_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
#endif
