/*
** pat_ieee802.c for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:43:12 1999 
** Last update Thu Oct 28 20:20:00 1999 
*/
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "pat_ether.h"
#include "pat_ieee802.h"
#include "pat_ip.h"
#include "pat_arp.h"
#include "pat_data.h"
#include "pat_16.h"
#include "pat_8.h"
#include "pat_buf.h"

t_assoc			llcsap_assocs[] = 
{
  {"null",		(VOID_PTR)0},
  {"global",		(VOID_PTR)0xff},
  {"8021b_i",		(VOID_PTR)0x02},
  {"8021b_g",		(VOID_PTR)0x03},
  {"ip",		(VOID_PTR)0x06},
  {"prowaynm",		(VOID_PTR)0x02},
  {"8021d",		(VOID_PTR)0x42},
  {"rs511",		(VOID_PTR)0x4e},
  {"iso8208",		(VOID_PTR)0x7e},
  {"proway",		(VOID_PTR)0x8e},
  {"snap",		(VOID_PTR)LLCSAP_SNAP},
  {"isons",		(VOID_PTR)0xfe},
  {NULL,		NULL},	
};

t_assoc			llcui_assocs[] = 
{
  {"ui",		(VOID_PTR)LLC_UI},
  {"ua",		(VOID_PTR)0x63},
  {"disc",		(VOID_PTR)0x43},
  {"dm",		(VOID_PTR)0x0f},
  {"sabme",		(VOID_PTR)0x6f},
  {"test",		(VOID_PTR)0xe3},
  {"xid",		(VOID_PTR)0xaf},
  {"frmr",		(VOID_PTR)0x87},
  {NULL,		NULL},
};

t_field				llc_fields[] = 
{
  {"dsap",	OFFSET(t_llc *,dsap),	&u8_pat,		NULL},
  {"Dsap",	OFFSET(t_llc *,dsap),	&u8assoc_pat,  llcsap_assocs},
  {"ssap",	OFFSET(t_llc *,ssap),	&u8_pat,		NULL},
  {"Ssap",	OFFSET(t_llc *,ssap),	&u8assoc_pat,  llcsap_assocs},
  {"cntl",	OFFSET(t_llc *,cntl),	&u8_pat,		NULL},
  {"Cntl",	OFFSET(t_llc *,cntl),	&u8assoc_pat,   llcui_assocs},
  NULL_FIELD
};

char				*llc_itmpl = "\n\
<table _name=llc[%i%] width=100%%%% bgcolor=\"%%llcColor%%\">\n\
<tr>\n\
<td align=center width=33%%%%>\n\
<a href=\"set(llc[%i%].Dsap)\">%%llc[%i%].Dsap%%</a>\n\
(<a href=\"set(llc[%i%].dsap)\">%%llc[%i%].dsap%%</a>)\n\
</td>\n\
<td align=center width=33%%%%>\n\
<a href=\"set(llc[%i%].Ssap)\">%%llc[%i%].Ssap%%</a>\n\
(<a href=\"set(llc[%i%].ssap)\">%%llc[%i%].ssap%%</a>)\n\
</td>\n\
<td align=center width=33%%%%>\n\
<a href=\"set(llc[%i%].Cntl)\">%%llc[%i%].Cntl%%</a>\n\
(<a href=\"set(llc[%i%].cntl)\">%%llc[%i%].cntl%%</a>)\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

int	llc_chan;

PAT_NAME_GENERIC(llc_pat_name,
		 (VOID_PTR)&llc_chan,
		 "llc")

PAT_GET_FIELD_GENERIC(llc_pat_get_field,
		      llc_fields)

PAT_SET_FIELD_GENERIC(llc_pat_set_field,
		      llc_fields)

PAT_GET_FIELDS_GENERIC(llc_pat_get_fields,
		       llc_fields)

PAT_GET_FIELD_PAT_GENERIC(llc_pat_get_field_pat,
			  llc_fields)

PAT_GET_TMPL_GENERIC(llc_pat_get_tmpl,
		     (VOID_PTR)&llc_chan,
		     llc_itmpl)

PAT_OFF_GENERIC(llc_pat_off,
		LLC_HLEN)

PAT_SUB_DECL(llc_pat_sub)
{
  t_llc			*llc;
  int			type;

  PAT_LLC_CHECK(llc,buf,len);
  if (llc->ssap == LLCSAP_SNAP && 
      llc->dsap == LLCSAP_SNAP &&
      llc->cntl == LLC_UI)
    {
      (*pat_return) = &snap_pat;
      return (0);
    }
  (*pat_return) = &data_pat;
  return (0);
}

t_pat				llc_pat = 
{
  llc_pat_name,			/* t_pat_name_proc		*/
  llc_pat_off,			/* t_pat_off_proc		*/
  llc_pat_sub,			/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  llc_pat_get_field,		/* t_pat_get_field_proc		*/
  llc_pat_set_field,		/* t_pat_set_field_proc		*/
  llc_pat_get_fields,		/* t_pat_get_fields_proc	*/
  llc_pat_get_tmpl,		/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  llc_pat_get_field_pat,	/* t_pat_get_field_pat_proc	*/
  NULL,				/* t_pat_extract_proc		*/
  NULL,				/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

int			snap_get_type(snap)
t_snap			*snap;
{
  char			*buf;

  buf = (char *)snap; 
  return (safe_ntohs((t_u16 *)(buf + 3))); /* unaligned */
}

t_field				snap_fields[] = 
{
  {"orgcode",	0,	       &buf_pat,	 (VOID_PTR)3},
  {"type",	3,	       &nu16_pat,		NULL},
  {"Type",	3,	       &nu16assoc_pat,ethertype_assocs},
  NULL_FIELD
};

char				*snap_itmpl = "\n\
<table _name=snap[%i%] width=100%%%% bgcolor=\"%%snapColor%%\">\n\
<tr>\n\
<td align=center width=60%%%%>\n\
<a href=\"set(snap[%i%].orgcode)\">%%snap[%i%].orgcode%%</a>\n\
</td>\n\
<td align=center width=40%%%%>\n\
<a href=\"set(snap[%i%].Type)\">%%snap[%i%].Type%%</a>\n\
(<a href=\"set(snap[%i%].type)\">%%snap[%i%].type%%</a>)\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

int	snap_chan;

PAT_NAME_GENERIC(snap_pat_name,
		 (VOID_PTR)&snap_chan,
		 "snap")

PAT_GET_FIELD_GENERIC(snap_pat_get_field,
		      snap_fields)

PAT_SET_FIELD_GENERIC(snap_pat_set_field,
		      snap_fields)

PAT_GET_FIELDS_GENERIC(snap_pat_get_fields,
		       snap_fields)

PAT_GET_FIELD_PAT_GENERIC(snap_pat_get_field_pat,
			  snap_fields)

PAT_GET_TMPL_GENERIC(snap_pat_get_tmpl,
		     (VOID_PTR)&snap_chan,
		     snap_itmpl)

PAT_OFF_GENERIC(snap_pat_off,
		SNAP_HLEN)

PAT_SUB_DECL(snap_pat_sub)
{
  t_snap		*snap;
  int			type;
  
  PAT_SNAP_CHECK(snap,buf,len);
  type = snap_get_type(snap);
  switch (type)
    {
    case ETHERTYPE_IP:
      (*pat_return) = &ip_pat;
      return (0);
    case ETHERTYPE_ARP:
      (*pat_return) = &arp_pat;
      return (0);
    }
  (*pat_return) = &data_pat;
  return (0);
}

t_pat				snap_pat = 
{
  snap_pat_name,		/* t_pat_name_proc		*/
  snap_pat_off,			/* t_pat_off_proc		*/
  snap_pat_sub,			/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  snap_pat_get_field,		/* t_pat_get_field_proc		*/
  snap_pat_set_field,		/* t_pat_set_field_proc		*/
  snap_pat_get_fields,		/* t_pat_get_fields_proc	*/
  snap_pat_get_tmpl,		/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  snap_pat_get_field_pat,	/* t_pat_get_field_pat_proc	*/
  NULL,				/* t_pat_extract_proc		*/
  NULL,				/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};
