/*
** pat_bootp.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:50:16 1999 
** Last update Thu Oct 28 20:21:34 1999 
*/
#ifndef PAT_BOOTP_H
#define PAT_BOOTP_H	1

#include "pat.h"
#include "pat_inaddr.h"

typedef struct		s_bootp
{
  t_u8			op;
  t_u8			htype;
  t_u8			hlen;
  t_u8			hops;
  t_u32			xid;
  t_u16			secs;
  t_u16			unused;
  t_in_addr		caddr;
  t_in_addr		yaddr;
  t_in_addr		saddr;
  t_in_addr		gaddr;
  t_u8			chaddr[16];
  t_u8			sname[64];
  t_u8			file[128];
  t_u8			vendor[64];
} t_bootp;

#define BOOTP_HLEN	(sizeof (t_bootp)) /* aligned */   

#define BOOTPS_PORT	67
#define BOOTPC_PORT	68

#define PAT_BOOTP_CHECK(bootppar,bufpar,lenpar) \
	if ((lenpar) < BOOTP_HLEN)\
		return (ERR_PAT_TRUNC_PAT);\
	(bootppar) = (t_bootp *)(bufpar);

#define RFC2132OPT_PAD	0
#define RFC2132OPT_END	255

extern t_pat		rfc2132optdata_pat;
extern t_pat		rfc2132opt_pat;
extern t_pat		rfc1048opt_pat;
extern t_pat		bootp_pat;
extern t_pat		dhcptype_pat;
extern t_pat		netbiostype_pat;
extern t_pat		dhcpoverload_pat;
extern t_pat		dhcpparam_pat;

extern t_boolean	pat_bootp_do_vendor;
extern t_boolean	pat_bootp_vendor_gt_64;

/* PROTO pat_bootp.c */
/* pat_bootp.c */
t_status rfc2132optdata_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status rfc2132optdata_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status dhcptype_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status dhcptype_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status dhcptype_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status dhcptype_pat_get_fields P((void *data, t_vec *vec_str));
t_status dhcptype_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status dhcptype_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status dhcptype_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status dhcptype_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status netbiostype_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status netbiostype_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status netbiostype_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status netbiostype_pat_get_fields P((void *data, t_vec *vec_str));
t_status netbiostype_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status netbiostype_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status netbiostype_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status netbiostype_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status dhcpoverload_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status dhcpoverload_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status dhcpoverload_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status dhcpoverload_pat_get_fields P((void *data, t_vec *vec_str));
t_status dhcpoverload_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status dhcpoverload_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status dhcpoverload_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status dhcpoverload_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status dhcpparam_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status dhcpparam_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status dhcpparam_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status dhcpparam_pat_get_fields P((void *data, t_vec *vec_str));
t_status dhcpparam_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status dhcpparam_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status dhcpparam_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status dhcpparam_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_field *rfc2132opt_get_fields P((char *buf, int len, t_status *status));
char *rfc2132opt_get_itmpl P((char *buf, int len, t_status *status));
t_status rfc2132opt_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status rfc2132opt_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status rfc2132opt_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status rfc2132opt_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status rfc2132opt_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status rfc2132opt_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status rfc2132opt_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status rfc2132opt_pat_has_opt P((void *data, char *buf, int len, t_boolean *has_opt_return, t_off *opt_off_return, int *opt_len_return, t_pat **opt_pat_return, void **opt_data_return));
t_status bootp_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status bootp_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status bootp_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status bootp_pat_get_fields P((void *data, t_vec *vec_str));
t_status bootp_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status bootp_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status bootp_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status bootp_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status bootp_pat_has_opt P((void *data, char *buf, int len, t_boolean *has_opt_return, t_off *opt_off_return, int *opt_len_return, t_pat **opt_pat_return, void **opt_data_return));
#endif
