/*
** pat_arp.c for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:44:38 1999 
** Last update Thu Oct 28 20:20:16 1999 
*/
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "patdef.h"	
#include "pat_arp.h"
#include "pat_ip.h"
#include "pat_ether.h"
#include "pat_data.h"
#include "pat_16.h"
#include "pat_8.h"
#include "pat_inaddr.h"
#include "pat_ethaddr.h"
#include "pat_mac.h"

t_field				arpethip_fields[] = 
{
  {"sha",	OFFSET(t_arpethip *,sha), &etheraddr_pat,	NULL},
  {"Sha",	OFFSET(t_arpethip *,sha), &mac_pat,		NULL},
  {"spa",	OFFSET(t_arpethip *,spa), &inaddr_pat,		NULL},
  {"Spa",	OFFSET(t_arpethip *,spa), &inaddr_resolved_pat,	NULL},
  {"tha",	OFFSET(t_arpethip *,tha), &etheraddr_pat,	NULL},
  {"Tha",	OFFSET(t_arpethip *,tha), &mac_pat,		NULL},
  {"tpa",	OFFSET(t_arpethip *,tpa), &inaddr_pat,		NULL},
  {"Tpa",	OFFSET(t_arpethip *,tpa), &inaddr_resolved_pat,	NULL},
  NULL_FIELD
};

char				*arpethip_itmpl = "\n\
<table _name=arpethip[%i%] width=100%%%% bgcolor=\"%%arpethipColor%%\">\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"set(arpethip[%i%].sha)\">%%arpethip[%i%].sha%%</a>\n\
<_tiny>\n\
<a href=\"set(arpethip[%i%].Sha)\">%%arpethip[%i%].Sha%%</a>\n\
</_tiny>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"set(arpethip[%i%].Spa)\">%%arpethip[%i%].Spa%%</a>\n\
(<a href=\"set(arpethip[%i%].spa)\">%%arpethip[%i%].spa%%</a>)\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"set(arpethip[%i%].tha)\">%%arpethip[%i%].tha%%</a>\n\
<_tiny>\n\
<a href=\"set(arpethip[%i%].Tha)\">%%arpethip[%i%].Tha%%</a>\n\
</_tiny>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"set(arpethip[%i%].Tpa)\">%%arpethip[%i%].Tpa%%</a>\n\
(<a href=\"set(arpethip[%i%].tpa)\">%%arpethip[%i%].tpa%%</a>)\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

int	arpethip_chan;

PAT_NAME_GENERIC(arpethip_pat_name,
		 (VOID_PTR)&arpethip_chan,
		 "arpethip")

PAT_OFF_GENERIC(arpethip_pat_off,
		ARPETHIP_HLEN)

PAT_SUB_GENERIC(arpethip_pat_sub,
		&data_pat)

PAT_GET_FIELD_GENERIC(arpethip_pat_get_field,
		      arpethip_fields)

PAT_SET_FIELD_GENERIC(arpethip_pat_set_field,
		      arpethip_fields)

PAT_GET_FIELDS_GENERIC(arpethip_pat_get_fields,
		       arpethip_fields)

PAT_GET_TMPL_GENERIC(arpethip_pat_get_tmpl,
		     (VOID_PTR)&arpethip_chan,
		     arpethip_itmpl)

PAT_GET_FIELD_PAT_GENERIC(arpethip_pat_get_field_pat,
			  arpethip_fields)

t_pat				arpethip_pat = 
{
  arpethip_pat_name,		/* t_pat_name_proc		*/
  arpethip_pat_off,		/* t_pat_off_proc		*/
  arpethip_pat_sub,		/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  arpethip_pat_get_field,	/* t_pat_get_field_proc		*/
  arpethip_pat_set_field,	/* t_pat_set_field_proc		*/
  arpethip_pat_get_fields,	/* t_pat_get_fields_proc	*/
  arpethip_pat_get_tmpl,	/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  arpethip_pat_get_field_pat,	/* t_pat_get_field_pat_proc	*/
  NULL,				/* t_pat_extract_proc		*/
  NULL,				/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

t_assoc			arphrd_assocs[] = 
{
  {"ether",		(VOID_PTR)ARPHRD_ETHER},
  {"802",		(VOID_PTR)ARPHRD_802},
  NULL_ASSOC
};

t_assoc			arpop_assocs[] = 
{
  {"request",		(VOID_PTR)ARPOP_REQUEST},
  {"reply",		(VOID_PTR)ARPOP_REPLY},
  {"rarp_request",	(VOID_PTR)3},
  {"rarp_reply",	(VOID_PTR)4},
  {"dyn_rarp_request",	(VOID_PTR)5},
  {"dyn_rarp_reply",	(VOID_PTR)6},
  {"dyn_rarp_error",	(VOID_PTR)7},
  {"inarp_request",	(VOID_PTR)8},
  {"inarp_reply",	(VOID_PTR)9},
  NULL_ASSOC
};

VOID_FUNC	arp_set_hrd(arp,hrd)
t_arp		*arp;
int		hrd;
{
  safe_htons(hrd,(&arp->hrd));
}

int		arp_get_hrd(arp)
t_arp		*arp;
{
  return (safe_ntohs(&(arp->hrd)));
}

VOID_FUNC	arp_set_pro(arp,pro)
t_arp		*arp;
int		pro;
{
  safe_htons(pro,&(arp->pro));
}

int		arp_get_pro(arp)
t_arp		*arp;
{
  return (safe_ntohs(&(arp->pro)));
}

VOID_FUNC	arp_set_hln(arp,hln)
t_arp		*arp;
int		hln;
{
  arp->hln = hln;
}

int		arp_get_hln(arp)
t_arp		*arp;
{
  return (arp->hln);
}

VOID_FUNC	arp_set_pln(arp,pln)
t_arp		*arp;
int		pln;
{
  arp->pln = pln;
}

int		arp_get_pln(arp)
t_arp		*arp;
{
  return (arp->pln);
}

VOID_FUNC	arp_set_op(arp,op)
t_arp		*arp;
int		op;
{
  safe_htons(op,&(arp->op));
}

int		arp_get_op(arp)
t_arp		*arp;
{
  return (safe_ntohs(&(arp->op)));
}

t_field				arp_fields[] = 
{
  {"hrd",	OFFSET(t_arp *,hrd),	&nu16_pat,		NULL},
  {"Hrd",	OFFSET(t_arp *,hrd),	&nu16assoc_pat,		arphrd_assocs},
  {"pro",	OFFSET(t_arp *,pro),	&nu16_pat,		NULL},
  {"Pro",	OFFSET(t_arp *,pro),	&nu16assoc_pat,	     ethertype_assocs},
  {"hln",	OFFSET(t_arp *,hln),	&u8_pat,		NULL},
  {"pln",	OFFSET(t_arp *,pln),	&u8_pat,		NULL},
  {"op",	OFFSET(t_arp *,op),	&nu16_pat,		NULL},
  {"Op",	OFFSET(t_arp *,op),	&nu16assoc_pat,		arpop_assocs},
  NULL_FIELD
};

char				*arp_itmpl = "\n\
<table _name=arp[%i%] width=100%%%% bgcolor=\"%%arpColor%%\">\n\
<tr>\n\
<td align=center width=50%%%%>\n\
<a href=\"set(arp[%i%].Hrd)\">%%arp[%i%].Hrd%%</a>\n\
(<a href=\"set(arp[%i%].hrd)\">%%arp[%i%].hrd%%</a>)\n\
</td>\n\
<td align=center width=50%%%%>\n\
<a href=\"set(arp[%i%].Pro)\">%%arp[%i%].Pro%%</a>\n\
(<a href=\"set(arp[%i%].pro)\">%%arp[%i%].pro%%</a>)\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=25%%%%>\n\
<a href=\"set(arp[%i%].hln)\">%%arp[%i%].hln%%</a>\n\
</td>\n\
<td align=center width=25%%%%>\n\
<a href=\"set(arp[%i%].pln)\">%%arp[%i%].pln%%</a>\n\
</td>\n\
<td align=center width=50%%%%>\n\
<a href=\"set(arp[%i%].Op)\">%%arp[%i%].Op%%</a>\n\
(<a href=\"set(arp[%i%].op)\">%%arp[%i%].op%%</a>)\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

int	arp_chan;

PAT_NAME_GENERIC(arp_pat_name,
		 (VOID_PTR)&arp_chan,
		 "arp")

PAT_OFF_GENERIC(arp_pat_off,
		ARP_HLEN)

PAT_SUB_DECL(arp_pat_sub)
{
  t_arp		*arp;

  PAT_ARP_CHECK(arp,buf,len);
  if (arp_get_hrd(arp) == ARPHRD_ETHER &&
      arp_get_pro(arp) == ETHERTYPE_IP)
    {
      (*pat_return) = &arpethip_pat;
      return (0);
    }
  else
    {
      (*pat_return) = &data_pat;
      return (0);
    }
}

PAT_GET_FIELD_GENERIC(arp_pat_get_field,
		      arp_fields)

PAT_SET_FIELD_GENERIC(arp_pat_set_field,
		      arp_fields)

PAT_GET_FIELDS_GENERIC(arp_pat_get_fields,
		       arp_fields)

PAT_GET_TMPL_GENERIC(arp_pat_get_tmpl,
		     (VOID_PTR)&arp_chan,
		     arp_itmpl)

PAT_GET_FIELD_PAT_GENERIC(arp_pat_get_field_pat,
			  arp_fields)

t_pat				arp_pat = 
{
  arp_pat_name,			/* t_pat_name_proc		*/
  arp_pat_off,			/* t_pat_off_proc		*/
  arp_pat_sub,			/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  arp_pat_get_field,		/* t_pat_get_field_proc		*/
  arp_pat_set_field,		/* t_pat_set_field_proc		*/
  arp_pat_get_fields,		/* t_pat_get_fields_proc	*/
  arp_pat_get_tmpl,		/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  arp_pat_get_field_pat,	/* t_pat_get_field_pat_proc	*/
  NULL,				/* t_pat_extract_proc		*/
  NULL,				/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};
