/*
** pat_8.c for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:44:45 1999 
** Last update Thu Oct 28 20:20:18 1999 
*/
#include <ctype.h>
#include "pat.h"
#include "pat_8.h"
#include "pat_data.h"

t_bit_field	u8bit0 = {0,0};
t_bit_field	u8bit1 = {1,1};
t_bit_field	u8bit2 = {2,2};
t_bit_field	u8bit3 = {3,3};
t_bit_field	u8bit4 = {4,4};
t_bit_field	u8bit5 = {5,5};
t_bit_field	u8bit6 = {6,6};
t_bit_field	u8bit7 = {7,7};

t_field			eight_fields[] = 
{
  {"ascii",	0,      &ascii_pat,              NULL},
  {"signed",	0,	&s8_pat,		NULL},
  {"unsigned",	0,	&u8_pat,		NULL},
  {"bit0",	0,	&u8bitfield_pat,	&u8bit0},
  {"bit1",	0,	&u8bitfield_pat,	&u8bit1},
  {"bit2",	0,	&u8bitfield_pat,	&u8bit2},
  {"bit3",	0,	&u8bitfield_pat,	&u8bit3},
  {"bit4",	0,	&u8bitfield_pat,	&u8bit4},
  {"bit5",	0,	&u8bitfield_pat,	&u8bit5},
  {"bit6",	0,	&u8bitfield_pat,	&u8bit6},
  {"bit7",	0,	&u8bitfield_pat,	&u8bit7},
  NULL_FIELD
};

t_assoc		ascii_assocs[] = 
{
  {"nul",	(VOID_PTR)0},  {"soh",		(VOID_PTR)1},
  {"stx",	(VOID_PTR)2},  {"etx",		(VOID_PTR)3},
  {"eot",	(VOID_PTR)4},  {"enq",		(VOID_PTR)5},
  {"ack",	(VOID_PTR)6},  {"bel",		(VOID_PTR)7},
  {"bs",	(VOID_PTR)8},  {"ht",		(VOID_PTR)9},
  {"nl",	(VOID_PTR)10},  {"vt",		(VOID_PTR)11},
  {"np",	(VOID_PTR)12},  {"cr",		(VOID_PTR)13},
  {"so",	(VOID_PTR)14},  {"si",		(VOID_PTR)15},
  {"dle",	(VOID_PTR)16},  {"dc1",		(VOID_PTR)17},
  {"dc2",	(VOID_PTR)18},  {"dc3",		(VOID_PTR)19},
  {"dc4",	(VOID_PTR)20},  {"nak",		(VOID_PTR)21},
  {"syn",	(VOID_PTR)22},  {"etb",		(VOID_PTR)23},
  {"can",	(VOID_PTR)24},  {"em",		(VOID_PTR)25},
  {"sub",	(VOID_PTR)26},  {"esc",		(VOID_PTR)27},
  {"fs",	(VOID_PTR)28},  {"gs",		(VOID_PTR)29},
  {"rs",	(VOID_PTR)30},  {"us",		(VOID_PTR)31},
  {" ",		(VOID_PTR)32},  {"!",		(VOID_PTR)33},
  {"\"",	(VOID_PTR)34},  {"#",		(VOID_PTR)35},
  {"$",		(VOID_PTR)36},  {"%",		(VOID_PTR)37},
  {"&",		(VOID_PTR)38},  {"'",		(VOID_PTR)39},
  {"(",		(VOID_PTR)40},  {")",		(VOID_PTR)41},
  {"*",		(VOID_PTR)42},  {"+",		(VOID_PTR)43},
  {",",		(VOID_PTR)44},  {"-",		(VOID_PTR)45},
  {".",		(VOID_PTR)46},  {"/",		(VOID_PTR)47},
  {"0",		(VOID_PTR)48},  {"1",		(VOID_PTR)49},
  {"2",		(VOID_PTR)50},  {"3",		(VOID_PTR)51},
  {"4",		(VOID_PTR)52},  {"5",		(VOID_PTR)53},
  {"6",		(VOID_PTR)54},  {"7",		(VOID_PTR)55},
  {"8",		(VOID_PTR)56},  {"9",		(VOID_PTR)57},
  {":",		(VOID_PTR)58},  {";",		(VOID_PTR)59},
  {"<",		(VOID_PTR)60},  {"=",		(VOID_PTR)61},
  {">",		(VOID_PTR)62},  {"?",		(VOID_PTR)63},
  {"@",		(VOID_PTR)64},  {"A",		(VOID_PTR)65},
  {"B",		(VOID_PTR)66},  {"C",		(VOID_PTR)67},
  {"D",		(VOID_PTR)68},  {"E",		(VOID_PTR)69},
  {"F",		(VOID_PTR)70},  {"G",		(VOID_PTR)71},
  {"H",		(VOID_PTR)72},  {"I",		(VOID_PTR)73},
  {"J",		(VOID_PTR)74},  {"K",		(VOID_PTR)75},
  {"L",		(VOID_PTR)76},  {"M",		(VOID_PTR)77},
  {"N",		(VOID_PTR)78},  {"O",		(VOID_PTR)79},
  {"P",		(VOID_PTR)80},  {"Q",		(VOID_PTR)81},
  {"R",		(VOID_PTR)82},  {"S",		(VOID_PTR)83},
  {"T",		(VOID_PTR)84},  {"U",		(VOID_PTR)85},
  {"V",		(VOID_PTR)86},  {"W",		(VOID_PTR)87},
  {"X",		(VOID_PTR)88},  {"Y",		(VOID_PTR)89},
  {"Z",		(VOID_PTR)90},  {"[",		(VOID_PTR)91},
  {"\\",	(VOID_PTR)92},  {"]",		(VOID_PTR)93},
  {"^",		(VOID_PTR)94},  {"_",		(VOID_PTR)95},
  {"`",		(VOID_PTR)96},  {"a",		(VOID_PTR)97},
  {"b",		(VOID_PTR)98},  {"c",		(VOID_PTR)99},
  {"d",		(VOID_PTR)100},  {"e",		(VOID_PTR)101},
  {"f",		(VOID_PTR)102},  {"g",		(VOID_PTR)103},
  {"h",		(VOID_PTR)104},  {"i",		(VOID_PTR)105},
  {"j",		(VOID_PTR)106},  {"k",		(VOID_PTR)107},
  {"l",		(VOID_PTR)108},  {"m",		(VOID_PTR)109},
  {"n",		(VOID_PTR)110},  {"o",		(VOID_PTR)111},
  {"p",		(VOID_PTR)112},  {"q",		(VOID_PTR)113},
  {"r",		(VOID_PTR)114},  {"s",		(VOID_PTR)115},
  {"t",		(VOID_PTR)116},  {"u",		(VOID_PTR)117},
  {"v",		(VOID_PTR)118},  {"w",		(VOID_PTR)119},
  {"x",		(VOID_PTR)120},  {"y",		(VOID_PTR)121},
  {"z",		(VOID_PTR)122},  {"{",		(VOID_PTR)123},
  {"|",		(VOID_PTR)124},  {"}",		(VOID_PTR)125},
  {"~",		(VOID_PTR)126},  {"del",	(VOID_PTR)127},
  NULL_ASSOC
};

char			*ascii_itmpl = "\n\
<table _name=ascii[%i%] bgcolor=\"%%asciiColor%%\" width=100%%%%>\n\
<tr>\n\
<td align=center>\n\
<code>\n\
<a href=\"set(ascii[%i%].ascii)\">%%ascii[%i%].ascii%%</a>\n\
</code>\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

PAT_OFF_GENERIC(eight_pat_off,
		1)

int	ascii_chan;

PAT_NAME_GENERIC(ascii_pat_name,
		 (VOID_PTR)&ascii_chan,
		 "ascii")

PAT_GET_FIELD_GENERIC(ascii_pat_get_field,
		      eight_fields)

PAT_SET_FIELD_GENERIC(ascii_pat_set_field,
		      eight_fields)

PAT_GET_FIELDS_GENERIC(ascii_pat_get_fields,
		       eight_fields)

PAT_GET_TMPL_GENERIC(ascii_pat_get_tmpl,
		     (VOID_PTR)&ascii_chan,
		     ascii_itmpl)

PAT_GET_FIELD_PAT_GENERIC(ascii_pat_get_field_pat,
			  eight_fields)

PAT_SUB_GENERIC(ascii_pat_sub,
		&ascii_pat)

PAT_EXTRACT_DECL(ascii_pat_extract)
{
  t_u8		c;
  t_assoc	*assoc;

  if (len < sizeof (t_u8))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&c,sizeof (t_u8));
  if (assoc = assoc_str_int_from_right(ascii_assocs,
				       (int)c))
    {
      return (str_cat_fmt_va(str,
			     max_len,
			     "%3s",
			     assoc->left));
    }
  return (str_cat_fmt_va(str,
			 max_len,
			 "  %c",
			 c));
}

PAT_INSERT_DECL(ascii_pat_insert)
{
  t_u8		c;
  t_assoc	*assoc;

  if (len < sizeof (t_u8))
    return (ERR_PAT_TRUNC_FIELD);
  if (assoc = assoc_str_ptr_from_left(ascii_assocs,
				      value))
    {
      c = (t_u8)(t_u32)(assoc->right);
      FBCOPY(&c,buf,sizeof (c));
      return (0);
    }
  return (ERR_PAT_INVAL);
}

PAT_GET_CHOICES_DECL(ascii_pat_get_choices)
{
  t_status	status;
  t_assoc	*assoc;
  
  assoc = ascii_assocs;
  while (assoc->left)
    {
      if ((status = vec_str_add(vec_str,
				assoc->left)) != 0)
	return (status);
      assoc++;
    }
  (*do_sort_return) = FALSE;
  return (0);
}

t_pat				ascii_pat = 
{
  ascii_pat_name,		/* t_pat_name_proc		*/
  eight_pat_off,		/* t_pat_off_proc		*/
  ascii_pat_sub,		/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  ascii_pat_get_field,		/* t_pat_get_field_proc	*/
  ascii_pat_set_field,		/* t_pat_set_field_proc	*/
  ascii_pat_get_fields,		/* t_pat_get_fields_proc	*/
  ascii_pat_get_tmpl,		/* t_pat_get_tmpl_proc	*/
  NULL,				/* t_pat_get_tmpl2_proc	*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc	*/
  ascii_pat_get_field_pat,	/* t_pat_get_field_pat_proc	*/
  ascii_pat_extract,		/* t_pat_extract_proc		*/
  ascii_pat_insert,		/* t_pat_insert_proc		*/
  ascii_pat_get_choices,	/* t_pat_get_choices_proc	*/
};

char			*s8_itmpl = "\n\
<table _name=s8[%i%] bgcolor=\"%%s8Color%%\" width=100%%%%>\n\
<tr>\n\
<td align=center>\n\
<code>\n\
<a href=\"set(s8[%i%].signed)\">%%s8[%i%].signed%%</a>\n\
</code>\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

int	s8_chan;

PAT_NAME_GENERIC(s8_pat_name,
		 (VOID_PTR)&s8_chan,
		 "s8")

PAT_EXTRACT_DECL(s8_pat_extract)
{
  t_s8		c;
  
  if (len < sizeof (t_s8))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&c,sizeof (t_s8));
  return (long_to_str((signed long)c,
		      pat_base,
		      str,
		      max_len));
}

PAT_INSERT_DECL(s8_pat_insert)
{
  t_s8		c;
  
  if (len < sizeof (t_s8))
    return (ERR_PAT_TRUNC_FIELD);
  c = atoi(value);
  FBCOPY(&c,buf,sizeof (t_s8));
  return (0);
}

PAT_GET_FIELD_GENERIC(s8_pat_get_field,
		      eight_fields)

PAT_SET_FIELD_GENERIC(s8_pat_set_field,
		      eight_fields)

PAT_GET_FIELDS_GENERIC(s8_pat_get_fields,
		       eight_fields)

PAT_GET_TMPL_GENERIC(s8_pat_get_tmpl,
		     (VOID_PTR)&s8_chan,
		     s8_itmpl)

PAT_GET_FIELD_PAT_GENERIC(s8_pat_get_field_pat,
			  eight_fields)

PAT_SUB_GENERIC(s8_pat_sub,
		&s8_pat)

t_pat				s8_pat = 
{
  s8_pat_name,			/* t_pat_name_proc		*/
  eight_pat_off,		/* t_pat_off_proc		*/
  s8_pat_sub,			/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  s8_pat_get_field,		/* t_pat_get_field_proc	*/
  s8_pat_set_field,		/* t_pat_set_field_proc	*/
  s8_pat_get_fields,		/* t_pat_get_fields_proc	*/
  s8_pat_get_tmpl,		/* t_pat_get_tmpl_proc	*/
  NULL,				/* t_pat_get_tmpl2_proc	*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc	*/
  s8_pat_get_field_pat,		/* t_pat_get_field_pat_proc	*/
  s8_pat_extract,		/* t_pat_extract_proc		*/
  s8_pat_insert,		/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

char			*u8_itmpl = "\n\
<table _name=u8[%i%] bgcolor=\"%%u8Color%%\" width=100%%%%>\n\
<tr>\n\
<td align=center>\n\
<code>\n\
<a href=\"set(u8[%i%].unsigned)\">%%u8[%i%].unsigned%%</a>\n\
</code>\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

int	u8_chan;

PAT_NAME_GENERIC(u8_pat_name,
		 (VOID_PTR)&u8_chan,
		 "u8")

PAT_EXTRACT_DECL(u8_pat_extract)
{
  t_u8		c;
  
  if (len < sizeof (t_u8))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&c,sizeof (t_u8));
  return (ulong_to_str((unsigned long)c,
		       pat_base,
		       str,
		       max_len));
}
 
PAT_INSERT_DECL(u8_pat_insert)
{
  t_u8		c;
  
  if (len < sizeof (t_u8))
    return (ERR_PAT_TRUNC_FIELD);
  c = atoi(value);
  FBCOPY(&c,buf,sizeof (t_u8));
  return (0);
}

PAT_GET_FIELD_GENERIC(u8_pat_get_field,
		      eight_fields)

PAT_SET_FIELD_GENERIC(u8_pat_set_field,
		      eight_fields)

PAT_GET_FIELDS_GENERIC(u8_pat_get_fields,
		       eight_fields)

PAT_GET_TMPL_GENERIC(u8_pat_get_tmpl,
		     (VOID_PTR)&u8_chan,
		     u8_itmpl)

PAT_GET_FIELD_PAT_GENERIC(u8_pat_get_field_pat,
			  eight_fields)

PAT_SUB_GENERIC(u8_pat_sub,
		&u8_pat)

t_pat				u8_pat = 
{
  u8_pat_name,			/* t_pat_name_proc		*/
  eight_pat_off,		/* t_pat_off_proc		*/
  u8_pat_sub,			/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  u8_pat_get_field,		/* t_pat_get_field_proc	*/
  u8_pat_set_field,		/* t_pat_set_field_proc	*/
  u8_pat_get_fields,		/* t_pat_get_fields_proc	*/
  u8_pat_get_tmpl,		/* t_pat_get_tmpl_proc	*/
  NULL,				/* t_pat_get_tmpl2_proc	*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc	*/
  u8_pat_get_field_pat,		/* t_pat_get_field_pat_proc	*/
  u8_pat_extract,		/* t_pat_extract_proc		*/
  u8_pat_insert,		/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

int	u8assoc_chan;
PAT_NAME_GENERIC(u8assoc_pat_name,
		 (VOID_PTR)&u8assoc_chan,
		 "u8assoc")

PAT_EXTRACT_DECL(u8assoc_pat_extract)
{
  t_u8			c;
  t_assoc		*assocs;
  t_assoc		*assoc;
  
  if ((assocs = (t_assoc *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < sizeof (t_u8))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&c,sizeof (t_u8));
  if (assoc = assoc_str_int_from_right(assocs,(int)c))
    return (str_cat_str(str,
			max_len,
			assoc->left));
  else
    return (ulong_to_str((unsigned long)c,
			 pat_base,
			 str,
			 max_len));
}

PAT_INSERT_DECL(u8assoc_pat_insert)
{
  t_u8			c;
  t_assoc		*assocs;
  t_assoc		*assoc;

  if ((assocs = (t_assoc *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < sizeof (t_u8))
    return (ERR_PAT_TRUNC_FIELD);
  if (assoc = assoc_str_ptr_from_left(assocs,value))
    c = (t_u8)(t_u32)(assoc->right);
  else
    c = atoi(value);
  FBCOPY(&c,buf,sizeof (t_u8));
  return (0);
}

PAT_GET_CHOICES_DECL(u8assoc_pat_get_choices)
{
  t_assoc		*assocs;
  t_assoc		*assoc;
  t_status		status;

  if ((assocs = (t_assoc *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  assoc = assocs;
  while (assoc->left)
    {
      if ((status = vec_str_add(vec_str,assoc->left)) != 0)
	return (status);
      assoc++;
    }
  return (0);
}

t_pat				u8assoc_pat = 
{
  u8assoc_pat_name,		/* t_pat_name_proc		*/
  eight_pat_off,		/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc		*/
  NULL,				/* t_pat_set_field_proc		*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  u8assoc_pat_extract,		/* t_pat_extract_proc		*/
  u8assoc_pat_insert,		/* t_pat_insert_proc		*/
  u8assoc_pat_get_choices,	/* t_pat_get_choices_proc	*/
};

char			*u8bitfield_itmpl = "\n\
<table _name=u8bitfield[%i%] bgcolor=\"%%u8bitfieldColor%%\" width=100%%%%>\n\
<tr>\n\
<td align=center>\n\
<small>\n\
<a href=\"set(u8bitfield[%i%].bit0)\">%%u8bitfield[%i%].bit0%%</a>\n\
<a href=\"set(u8bitfield[%i%].bit1)\">%%u8bitfield[%i%].bit1%%</a>\n\
<a href=\"set(u8bitfield[%i%].bit2)\">%%u8bitfield[%i%].bit2%%</a>\n\
<a href=\"set(u8bitfield[%i%].bit3)\">%%u8bitfield[%i%].bit3%%</a>\n\
<a href=\"set(u8bitfield[%i%].bit4)\">%%u8bitfield[%i%].bit4%%</a>\n\
<a href=\"set(u8bitfield[%i%].bit5)\">%%u8bitfield[%i%].bit5%%</a>\n\
<a href=\"set(u8bitfield[%i%].bit6)\">%%u8bitfield[%i%].bit6%%</a>\n\
<a href=\"set(u8bitfield[%i%].bit7)\">%%u8bitfield[%i%].bit7%%</a>\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

int	u8bitfield_chan;

PAT_NAME_GENERIC(u8bitfield_pat_name,
		 (VOID_PTR)&u8bitfield_chan,
		 "u8bitfield")

PAT_GET_FIELD_GENERIC(u8bitfield_pat_get_field,
		      eight_fields)

PAT_SET_FIELD_GENERIC(u8bitfield_pat_set_field,
		      eight_fields)

PAT_GET_FIELDS_GENERIC(u8bitfield_pat_get_fields,
		       eight_fields)

PAT_GET_TMPL_GENERIC(u8bitfield_pat_get_tmpl,
		     (VOID_PTR)&u8bitfield_chan,
		     u8bitfield_itmpl)

PAT_GET_FIELD_PAT_GENERIC(u8bitfield_pat_get_field_pat,
			  eight_fields)

PAT_SUB_GENERIC(u8bitfield_pat_sub,
		&u8bitfield_pat)

PAT_EXTRACT_DECL(u8bitfield_pat_extract)
{
  t_u8		u8;
  t_u8		u8ret;
  t_bit_field	*bf;

  if ((bf = (t_bit_field *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < sizeof (u8))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u8,sizeof (u8));
  bit_field_u8_get(&u8,
		   &u8ret,
		   bf->from,
		   bf->to);
  return (ulong_to_str((unsigned long)u8ret,
		       pat_base,
		       str,
		       max_len));
}
 
PAT_INSERT_DECL(u8bitfield_pat_insert)
{
  t_u8		u8;
  t_u8		u8value;
  t_bit_field	*bf;

  if ((bf = (t_bit_field *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < sizeof (u8))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u8,sizeof (u8));
  u8value = atoi(value);
  bit_field_u8_set(&u8,
		   bf->from,
		   bf->to,
		   u8value);
  FBCOPY(&u8,buf,sizeof (u8));
  return (0);
}

t_pat				u8bitfield_pat = 
{
  u8bitfield_pat_name,		/* t_pat_name_proc		*/
  eight_pat_off,		/* t_pat_off_proc		*/
  u8bitfield_pat_sub,		/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  u8bitfield_pat_get_field,	/* t_pat_get_field_proc		*/
  u8bitfield_pat_set_field,	/* t_pat_set_field_proc		*/
  u8bitfield_pat_get_fields,	/* t_pat_get_fields_proc	*/
  u8bitfield_pat_get_tmpl,	/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  u8bitfield_pat_get_field_pat,	/* t_pat_get_field_pat_proc	*/
  u8bitfield_pat_extract,	/* t_pat_extract_proc		*/
  u8bitfield_pat_insert,	/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

int	u8bitfieldassoc_chan;
PAT_NAME_GENERIC(u8bitfieldassoc_pat_name,
		 (VOID_PTR)&u8bitfieldassoc_chan,
		 "u8bitfieldassoc")

PAT_EXTRACT_DECL(u8bitfieldassoc_pat_extract)
{
  t_u8				u8;
  t_u8				u8ret;
  t_bit_field_assocs_data	*bfad;
  t_assoc			*assoc;

  if ((bfad = (t_bit_field_assocs_data *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < sizeof (u8))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u8,sizeof (u8));
  bit_field_u8_get(&u8,
		   &u8ret,
		   bfad->bit_field->from,
		   bfad->bit_field->to);
  if (assoc = assoc_str_int_from_right(bfad->assocs,(int)u8ret))
    return (str_cat_str(str,
			max_len,
			assoc->left));
  else
    return (ulong_to_str((unsigned long)u8ret,
			 pat_base,
			 str,
			 max_len));
}
 
PAT_INSERT_DECL(u8bitfieldassoc_pat_insert)
{
  t_u8				u8;
  t_u8				u8value;
  t_bit_field_assocs_data	*bfad;
  t_assoc			*assoc;

  if ((bfad = (t_bit_field_assocs_data *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < sizeof (u8))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u8,sizeof (u8));
  if (assoc = assoc_str_ptr_from_left(bfad->assocs,value))
    u8value = (t_u8)(t_u32)(assoc->right);
  else
    u8value = atoi(value);
  bit_field_u8_set(&u8,
		   bfad->bit_field->from,
		   bfad->bit_field->to,
		   u8value);
  FBCOPY(&u8,buf,sizeof (u8));
  return (0);
}

PAT_GET_CHOICES_DECL(u8bitfieldassoc_pat_get_choices)
{
  t_bit_field_assocs_data	*bfad;
  t_assoc			*assoc;
  t_status			status;

  if ((bfad = (t_bit_field_assocs_data *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  assoc = bfad->assocs;
  while (assoc->left)
    {
      if ((status = vec_str_add(vec_str,assoc->left)) != 0)
	return (status);
      assoc++;
    }
  return (0);
}

t_pat				u8bitfieldassoc_pat = 
{
  u8bitfieldassoc_pat_name,	/* t_pat_name_proc		*/
  eight_pat_off,		/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc		*/
  NULL,				/* t_pat_set_field_proc		*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  u8bitfieldassoc_pat_extract,	/* t_pat_extract_proc		*/
  u8bitfieldassoc_pat_insert,	/* t_pat_insert_proc		*/
  u8bitfieldassoc_pat_get_choices,/* t_pat_get_choices_proc	*/
};

int	u8mask_chan;

PAT_NAME_GENERIC(u8mask_pat_name,
		 (VOID_PTR)&u8mask_chan,
		 "u8mask")

PAT_EXTRACT_DECL(u8mask_pat_extract)
{
  t_u8		c;
  t_mask_def	*mask_defs;
	
  if ((mask_defs = (t_mask_def *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < sizeof (t_u8))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&c,sizeof (t_u8));
  return (mask_to_str(mask_defs,
		      c,
		      "|",
		      pat_base,
		      str,
		      max_len));
}

PAT_INSERT_DECL(u8mask_pat_insert)
{
  t_u8		c;
  t_mask_def	*mask_defs;
  t_vec		*vec_str;
  t_mask	mask;
  t_status	status;

  if ((mask_defs = (t_mask_def *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < sizeof (t_u8))
    return (ERR_PAT_TRUNC_FIELD);
  if ((vec_str = PAT_VEC_NEW(&status)) == NULL)
    return (status);
  if ((status = vec_str_split(vec_str,
			      value,
			      '|')) != 0)
    {
      vec_str_delete(vec_str);
      return (status);
    }
  mask = 0;
  if ((status = mask_from_vec_str(mask_defs,
				  vec_str,
				  &mask)) != 0)
    {
      vec_str_delete(vec_str);
      return (status);
    }
  c = (t_u8)mask;
  FBCOPY(&c,buf,sizeof (t_u8));
  vec_str_delete(vec_str);
  return (0);
}

t_pat				u8mask_pat = 
{
  u8mask_pat_name,		/* t_pat_name_proc		*/
  eight_pat_off,		/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc		*/
  NULL,				/* t_pat_set_field_proc		*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  u8mask_pat_extract,		/* t_pat_extract_proc		*/
  u8mask_pat_insert,		/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};
