/*
** pat_32.c for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:44:53 1999 
** Last update Thu Oct 28 20:20:19 1999 
*/
#include "pat.h"
#include "pat_32.h"

t_bit_field	u32bit0 = {0,0};
t_bit_field	u32bit1 = {1,1};
t_bit_field	u32bit2 = {2,2};
t_bit_field	u32bit3 = {3,3};
t_bit_field	u32bit4 = {4,4};
t_bit_field	u32bit5 = {5,5};
t_bit_field	u32bit6 = {6,6};
t_bit_field	u32bit7 = {7,7};
t_bit_field	u32bit8 = {8,8};
t_bit_field	u32bit9 = {9,9};
t_bit_field	u32bit10 = {10,10};
t_bit_field	u32bit11 = {11,11};
t_bit_field	u32bit12 = {12,12};
t_bit_field	u32bit13 = {13,13};
t_bit_field	u32bit14 = {14,14};
t_bit_field	u32bit15 = {15,15};
t_bit_field	u32bit16 = {16,16};
t_bit_field	u32bit17 = {17,17};
t_bit_field	u32bit18 = {18,18};
t_bit_field	u32bit19 = {19,19};
t_bit_field	u32bit20 = {20,20};
t_bit_field	u32bit21 = {21,21};
t_bit_field	u32bit22 = {22,22};
t_bit_field	u32bit23 = {23,23};
t_bit_field	u32bit24 = {24,24};
t_bit_field	u32bit25 = {25,25};
t_bit_field	u32bit26 = {26,26};
t_bit_field	u32bit27 = {27,27};
t_bit_field	u32bit28 = {28,28};
t_bit_field	u32bit29 = {29,29};
t_bit_field	u32bit30 = {30,30};
t_bit_field	u32bit31 = {31,31};

t_field			thirtytwo_fields[] = 
{
  {"unsigned",	0,	&u32_pat,		NULL},
  {"nsigned",	0,	&ns32_pat,		NULL},
  {"nunsigned",0,	&nu32_pat,		NULL},
  NULL_FIELD
};

t_u32			safe_ntohl(p_nu32)
t_u32			*p_nu32;	/* Pointer to network unsigned long */
{
  t_u32			a_u32;
  
  FBCOPY(p_nu32,&a_u32,sizeof (t_u32));
  return (UNSAFE_NTOHL(a_u32));
}

VOID_FUNC		safe_htonl(a_u32,p_nu32)
t_u32			a_u32;		/* Aligned host unsigned long */
t_u32			*p_nu32;	/* Pointer to network unsigned long */
{
  a_u32 = UNSAFE_HTONL(a_u32);  
  FBCOPY(&a_u32,p_nu32,sizeof (t_u32));
}

PAT_OFF_GENERIC(thirtytwo_pat_off,4)

int	ns32_chan;

PAT_NAME_GENERIC(ns32_pat_name,
		 (VOID_PTR)&ns32_chan,
		 "ns32")

PAT_EXTRACT_DECL(ns32_pat_extract)
{
  t_s32				s32;
	
  if (len < sizeof (s32))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&s32,sizeof (s32));
  s32 = UNSAFE_NTOHL(s32);
  return (long_to_str((signed long)s32,
		      pat_base,
		      str,
		      max_len));
}

PAT_INSERT_DECL(ns32_pat_insert)
{
  t_s32				s32;
  t_status			status;	
  int				basenum;
  signed long			num;
  
  if (len < sizeof (s32))
    return (ERR_PAT_TRUNC_FIELD);
  if ((status = long_from_str(value,
			      &basenum,
			      &num)) != 0)
    return (status);
  s32 = (t_s32)num;
  s32 = UNSAFE_HTONL(s32);
  FBCOPY(&s32,buf,sizeof (s32));
  return (0);
}

t_pat				ns32_pat = 
{
  ns32_pat_name,		/* t_pat_name_proc		*/
  thirtytwo_pat_off,		/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc	*/
  NULL,				/* t_pat_set_field_proc	*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc	*/
  NULL,				/* t_pat_get_tmpl2_proc	*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc	*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  ns32_pat_extract,		/* t_pat_extract_proc		*/
  ns32_pat_insert,		/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

char			*nu32_itmpl = "\n\
<table _name=nu32[%i%] bgcolor=\"%%nu32Color%%\" width=100%%%%>\n\
<tr>\n\
<td align=center>\n\
<code>\n\
<a href=\"set(nu32[%i%].nunsigned)\">%%nu32[%i%].nunsigned%%</a>\n\
</code>\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

int	nu32_chan;

PAT_NAME_GENERIC(nu32_pat_name,
		 (VOID_PTR)&nu32_chan,
		 "nu32")

PAT_EXTRACT_DECL(nu32_pat_extract)
{
  t_u32				u32;
  
  if (len < sizeof (u32))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u32,sizeof (u32));
  u32 = UNSAFE_NTOHL(u32);
  return (ulong_to_str((unsigned long)u32,
		       pat_base,
		       str,
		       max_len));
}

PAT_INSERT_DECL(nu32_pat_insert)
{
  t_u32				u32;
  t_status			status;	
  int				basenum;
  unsigned long			num;
  
  if (len < sizeof (u32))
    return (ERR_PAT_TRUNC_FIELD);
  if ((status = ulong_from_str(value,
			       &basenum,
			       &num)) != 0)
    return (status);
  u32 = (t_u32)num;
  u32 = UNSAFE_HTONL(u32);
  FBCOPY(&u32,buf,sizeof (u32));
  return (0);
}

PAT_GET_FIELD_GENERIC(nu32_pat_get_field,
		      thirtytwo_fields)

PAT_SET_FIELD_GENERIC(nu32_pat_set_field,
		      thirtytwo_fields)

PAT_GET_FIELDS_GENERIC(nu32_pat_get_fields,
		       thirtytwo_fields)

PAT_GET_TMPL_GENERIC(nu32_pat_get_tmpl,
		     (VOID_PTR)&nu32_chan,
		     nu32_itmpl)

PAT_GET_FIELD_PAT_GENERIC(nu32_pat_get_field_pat,
			  thirtytwo_fields)

PAT_SUB_GENERIC(nu32_pat_sub,
		&nu32_pat)

t_pat				nu32_pat = 
{
  nu32_pat_name,		/* t_pat_name_proc		*/
  thirtytwo_pat_off,		/* t_pat_off_proc		*/
  nu32_pat_sub,			/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  nu32_pat_get_field,		/* t_pat_get_field_proc	*/
  nu32_pat_set_field,		/* t_pat_set_field_proc	*/
  nu32_pat_get_fields,		/* t_pat_get_fields_proc	*/
  nu32_pat_get_tmpl,		/* t_pat_get_tmpl_proc	*/
  NULL,				/* t_pat_get_tmpl2_proc	*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc	*/
  nu32_pat_get_field_pat,	/* t_pat_get_field_pat_proc	*/
  nu32_pat_extract,		/* t_pat_extract_proc		*/
  nu32_pat_insert,		/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

int	u32_chan;
PAT_NAME_GENERIC(u32_pat_name,
		 (VOID_PTR)&u32_chan,
		 "u32")

PAT_EXTRACT_DECL(u32_pat_extract)
{
  t_u32				u32;

  if (len < sizeof (u32))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u32,sizeof (u32));
  return (ulong_to_str((unsigned long)u32,
		       pat_base,
		       str,
		       max_len));
}

PAT_INSERT_DECL(u32_pat_insert)
{
  t_u32				u32;
  t_status			status;	
  int				basenum;
  unsigned long			num;

  if (len < sizeof (u32))
    return (ERR_PAT_TRUNC_FIELD);
  if ((status = ulong_from_str(value,
			       &basenum,
			       &num)) != 0)
    return (status);
  u32 = (t_u32)num;
  FBCOPY(&u32,buf,sizeof (u32));
  return (0);
}

t_pat				u32_pat = 
{
  u32_pat_name,			/* t_pat_name_proc		*/
  thirtytwo_pat_off,		/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc	*/
  NULL,				/* t_pat_set_field_proc	*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc	*/
  NULL,				/* t_pat_get_tmpl2_proc	*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc	*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  u32_pat_extract,		/* t_pat_extract_proc		*/
  u32_pat_insert,		/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

int	nu32assoc_chan;
PAT_NAME_GENERIC(nu32assoc_pat_name,
		 (VOID_PTR)&nu32assoc_chan,
		 "nu32assoc")

PAT_EXTRACT_DECL(nu32assoc_pat_extract)
{
  t_u32				u32;
  t_assoc			*assocs;
  t_assoc			*assoc;
  
  assocs = (t_assoc *)(data);
  if (len < sizeof (u32))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u32,sizeof (u32));
  u32 = UNSAFE_NTOHL(u32);
  if (assoc = assoc_str_int_from_right(assocs,(int)u32))
    return (str_cat_str(str,
			max_len,
			assoc->left));
  else
    return (ulong_to_str((unsigned long)u32,
			 pat_base,
			 str,
			 max_len));
}

PAT_INSERT_DECL(nu32assoc_pat_insert)
{
  t_u32				u32;
  t_status			status;	
  t_assoc			*assocs;
  t_assoc			*assoc;
  
  assocs = (t_assoc *)(data);
  if (len < sizeof (u32))
    return (ERR_PAT_TRUNC_FIELD);
  if (assoc = assoc_str_ptr_from_left(assocs,value))
    u32 = (t_u32)(t_u32)(assoc->right);
  else
    {
      int			basenum;
      unsigned long		num;
      
      if ((status = ulong_from_str(value,
				   &basenum,
				   &num)) != 0)
	return (status);
      u32 = (t_u32)num;
    }
  u32 = UNSAFE_HTONL(u32);
  FBCOPY(&u32,buf,sizeof (u32));
  return (0);
}

PAT_GET_CHOICES_DECL(nu32assoc_pat_get_choices)
{
  t_assoc			*assocs;
  t_assoc			*assoc;
  t_status			status;

  assocs = (t_assoc *)(data);
  assoc = assocs;
  while (assoc->left)
    {
      if ((status = vec_str_add(vec_str,assoc->left)) != 0)
	return (status);
      assoc++;
    }
  return (0);
}

t_pat				nu32assoc_pat = 
{
  nu32assoc_pat_name,		/* t_pat_name_proc		*/
  thirtytwo_pat_off,		/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc	*/
  NULL,				/* t_pat_set_field_proc	*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc	*/
  NULL,				/* t_pat_get_tmpl2_proc	*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc	*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  nu32assoc_pat_extract,	/* t_pat_extract_proc		*/
  nu32assoc_pat_insert,		/* t_pat_insert_proc		*/
  nu32assoc_pat_get_choices,	/* t_pat_get_choices_proc	*/
};

int	u32assoc_chan;
PAT_NAME_GENERIC(u32assoc_pat_name,
		 (VOID_PTR)&u32assoc_chan,
		 "u32assoc")

PAT_EXTRACT_DECL(u32assoc_pat_extract)
{
  t_u32				u32;
  t_assoc			*assocs;
  t_assoc			*assoc;
  
  assocs = (t_assoc *)(data);
  if (len < sizeof (u32))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u32,sizeof (u32));
  if (assoc = assoc_str_int_from_right(assocs,(int)u32))
    return (str_cat_str(str,
			max_len,
			assoc->left));
  else
    return (ulong_to_str((unsigned long)u32,
			 pat_base,
			 str,
			 max_len));
}

PAT_INSERT_DECL(u32assoc_pat_insert)
{
  t_u32				u32;
  t_status			status;	
  t_assoc			*assocs;
  t_assoc			*assoc;

  assocs = (t_assoc *)(data);
  if (len < sizeof (u32))
    return (ERR_PAT_TRUNC_FIELD);
  if (assoc = assoc_str_ptr_from_left(assocs,value))
    u32 = (t_u32)(t_u32)(assoc->right);
  else
    {
      int			basenum;
      unsigned long		num;
      
      if ((status = ulong_from_str(value,
				   &basenum,
				   &num)) != 0)
	return (status);
      u32 = (t_u32)num;
    }
  FBCOPY(&u32,buf,sizeof (u32));
  return (0);
}

PAT_GET_CHOICES_DECL(u32assoc_pat_get_choices)
{
  t_assoc			*assocs;
  t_assoc			*assoc;
  t_status			status;

  assocs = (t_assoc *)(data);
  assoc = assocs;
  while (assoc->left)
    {
      if ((status = vec_str_add(vec_str,assoc->left)) != 0)
	return (status);
      assoc++;
    }
  return (0);
}

t_pat				u32assoc_pat = 
{
  u32assoc_pat_name,		/* t_pat_name_proc		*/
  thirtytwo_pat_off,		/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc	*/
  NULL,				/* t_pat_set_field_proc	*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc	*/
  NULL,				/* t_pat_get_tmpl2_proc	*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc	*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  u32assoc_pat_extract,		/* t_pat_extract_proc		*/
  u32assoc_pat_insert,		/* t_pat_insert_proc		*/
  u32assoc_pat_get_choices,	/* t_pat_get_choices_proc	*/
};

int	u32mask_chan;
PAT_NAME_GENERIC(u32mask_pat_name,
		 (VOID_PTR)&u32mask_chan,
		 "u32mask")

PAT_EXTRACT_DECL(u32mask_pat_extract)
{
  t_u32				u32;
  t_mask_def			*mask_defs;
	
  mask_defs = (t_mask_def *)(data);
  if (len < sizeof (t_u32))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u32,sizeof (t_u32));
  return (mask_to_str(mask_defs,
		      u32,
		      "|",
		      pat_base,
		      str,
		      max_len));
}

PAT_INSERT_DECL(u32mask_pat_insert)
{
  t_u32				u32;
  t_mask_def			*mask_defs;
  t_vec				*vec_str;
  t_mask			mask;
  t_status			status;

  mask_defs = (t_mask_def *)(data);
  if (len < sizeof (t_u32))
    return (ERR_PAT_TRUNC_FIELD);
  if ((vec_str = PAT_VEC_NEW(&status)) == NULL)
    return (status);
  if ((status = vec_str_split(vec_str,
			      value,
			      '|')) != 0)
    {
      vec_str_delete(vec_str);
      return (status);
    }
  mask = 0;
  if ((status = mask_from_vec_str(mask_defs,
				  vec_str,
				  &mask)) != 0)
    {
      vec_str_delete(vec_str);
      return (status);
    }
  u32 = (t_u32)mask;
  FBCOPY(&u32,buf,sizeof (t_u32));
  vec_str_delete(vec_str);
  return (0);
}

t_pat				u32mask_pat = 
{
  u32mask_pat_name,		/* t_pat_name_proc		*/
  thirtytwo_pat_off,		/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc	*/
  NULL,				/* t_pat_set_field_proc	*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc	*/
  NULL,				/* t_pat_get_tmpl2_proc	*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc	*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  u32mask_pat_extract,		/* t_pat_extract_proc		*/
  u32mask_pat_insert,		/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};
