/*
** pat_16.c for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:45:00 1999 
** Last update Thu Oct 28 20:20:21 1999 
*/
#include "pat.h"
#include "pat_16.h"

t_bit_field	u16bit0 = {0,0};
t_bit_field	u16bit1 = {1,1};
t_bit_field	u16bit2 = {2,2};
t_bit_field	u16bit3 = {3,3};
t_bit_field	u16bit4 = {4,4};
t_bit_field	u16bit5 = {5,5};
t_bit_field	u16bit6 = {6,6};
t_bit_field	u16bit7 = {7,7};
t_bit_field	u16bit8 = {8,8};
t_bit_field	u16bit9 = {9,9};
t_bit_field	u16bit10 = {10,10};
t_bit_field	u16bit11 = {11,11};
t_bit_field	u16bit12 = {12,12};
t_bit_field	u16bit13 = {13,13};
t_bit_field	u16bit14 = {14,14};
t_bit_field	u16bit15 = {15,15};

t_field			sixteen_fields[] = 
{
  {"unsigned",	0,	&u16_pat,		NULL},
  {"signed",	0,	&s16_pat,		NULL},
  {"nsigned",	0,	&ns16_pat,		NULL},
  {"nunsigned",0,	&nu16_pat,		NULL},
  {"bit0",	0,	&u16bitfield_pat,	&u16bit0},
  {"bit1",	0,	&u16bitfield_pat,	&u16bit1},
  {"bit2",	0,	&u16bitfield_pat,	&u16bit2},
  {"bit3",	0,	&u16bitfield_pat,	&u16bit3},
  {"bit4",	0,	&u16bitfield_pat,	&u16bit4},
  {"bit5",	0,	&u16bitfield_pat,	&u16bit5},
  {"bit6",	0,	&u16bitfield_pat,	&u16bit6},
  {"bit7",	0,	&u16bitfield_pat,	&u16bit7},
  {"bit8",	0,	&u16bitfield_pat,	&u16bit8},
  {"bit9",	0,	&u16bitfield_pat,	&u16bit9},
  {"bit10",	0,	&u16bitfield_pat,	&u16bit10},
  {"bit11",	0,	&u16bitfield_pat,	&u16bit11},
  {"bit12",	0,	&u16bitfield_pat,	&u16bit12},
  {"bit13",	0,	&u16bitfield_pat,	&u16bit13},
  {"bit14",	0,	&u16bitfield_pat,	&u16bit14},
  {"bit15",	0,	&u16bitfield_pat,	&u16bit15},
  {"nbit0",	0,	&nu16bitfield_pat,	&u16bit0},
  {"nbit1",	0,	&nu16bitfield_pat,	&u16bit1},
  {"nbit2",	0,	&nu16bitfield_pat,	&u16bit2},
  {"nbit3",	0,	&nu16bitfield_pat,	&u16bit3},
  {"nbit4",	0,	&nu16bitfield_pat,	&u16bit4},
  {"nbit5",	0,	&nu16bitfield_pat,	&u16bit5},
  {"nbit6",	0,	&nu16bitfield_pat,	&u16bit6},
  {"nbit7",	0,	&nu16bitfield_pat,	&u16bit7},
  {"nbit8",	0,	&nu16bitfield_pat,	&u16bit8},
  {"nbit9",	0,	&nu16bitfield_pat,	&u16bit9},
  {"nbit10",	0,	&nu16bitfield_pat,	&u16bit10},
  {"nbit11",	0,	&nu16bitfield_pat,	&u16bit11},
  {"nbit12",	0,	&nu16bitfield_pat,	&u16bit12},
  {"nbit13",	0,	&nu16bitfield_pat,	&u16bit13},
  {"nbit14",	0,	&nu16bitfield_pat,	&u16bit14},
  {"nbit15",	0,	&nu16bitfield_pat,	&u16bit15},
  NULL_FIELD
};

t_u16				safe_ntohs(p_nu16)
t_u16				*p_nu16;/* Pointer to network unsigned short */
{
  t_u16				a_u16;
  
  FBCOPY(p_nu16,&a_u16,sizeof (t_u16));
  return (UNSAFE_NTOHS(a_u16));
}

VOID_FUNC			safe_htons(a_u16,p_nu16)
t_u16				a_u16;	/* Aligned host unsigned short */
t_u16				*p_nu16;/* Pointer to network unsigned short */
{
  a_u16 = UNSAFE_HTONS(a_u16);  
  FBCOPY(&a_u16,p_nu16,sizeof (t_u16));
}

PAT_OFF_GENERIC(sixteen_pat_off,
		2)

int ns16_chan;
PAT_NAME_GENERIC(ns16_pat_name,
		 (VOID_PTR)&ns16_chan,
		 "ns16")

PAT_EXTRACT_DECL(ns16_pat_extract)
{
  t_s16				s16;
	
  if (len < sizeof (s16))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&s16,sizeof (s16));
  s16 = UNSAFE_NTOHS(s16);
  return (long_to_str((signed long)s16,
		      pat_base,
		      str,
		      max_len));
}

PAT_INSERT_DECL(ns16_pat_insert)
{
  t_s16				s16;
  t_status			status;	
  int				basenum;
  signed long			num;
  
  if (len < sizeof (s16))
    return (ERR_PAT_TRUNC_FIELD);
  if ((status = long_from_str(value,
			      &basenum,
			      &num)) != 0)
    return (status);
  s16 = (t_s16)num;
  s16 = UNSAFE_HTONS(s16);
  FBCOPY(&s16,buf,sizeof (s16));
  return (0);
}

t_pat				ns16_pat = 
{
  ns16_pat_name,		/* t_pat_name_proc		*/
  sixteen_pat_off,		/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc	*/
  NULL,				/* t_pat_set_field_proc	*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc	*/
  NULL,				/* t_pat_get_tmpl2_proc	*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc	*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  ns16_pat_extract,		/* t_pat_extract_proc		*/
  ns16_pat_insert,		/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

char			*nu16_itmpl = "\n\
<table _name=nu16[%i%] bgcolor=\"%%nu16Color%%\" width=100%%%%>\n\
<tr>\n\
<td align=center>\n\
<code>\n\
<a href=\"set(nu16[%i%].nunsigned)\">%%nu16[%i%].nunsigned%%</a>\n\
</code>\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

int nu16_chan;

PAT_NAME_GENERIC(nu16_pat_name,
		 (VOID_PTR)&nu16_chan,
		 "nu16")

PAT_EXTRACT_DECL(nu16_pat_extract)
{
  t_u16				u16;

  if (len < sizeof (u16))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u16,sizeof (u16));
  u16 = UNSAFE_NTOHS(u16);
  return (ulong_to_str((unsigned long)u16,
		       pat_base,
		       str,
		       max_len));
}

PAT_INSERT_DECL(nu16_pat_insert)
{
  t_u16				u16;
  t_status			status;	
  int				basenum;
  unsigned long			num;
  
  if (len < sizeof (u16))
    return (ERR_PAT_TRUNC_FIELD);
  if ((status = ulong_from_str(value,
			       &basenum,
			       &num)) != 0)
    return (status);
  u16 = (t_u16)num;
  u16 = UNSAFE_HTONS(u16);
  FBCOPY(&u16,buf,sizeof (u16));
  return (0);
}

PAT_GET_FIELD_GENERIC(nu16_pat_get_field,
		      sixteen_fields)

PAT_SET_FIELD_GENERIC(nu16_pat_set_field,
		      sixteen_fields)

PAT_GET_FIELDS_GENERIC(nu16_pat_get_fields,
		       sixteen_fields)

PAT_GET_TMPL_GENERIC(nu16_pat_get_tmpl,
		     (VOID_PTR)&nu16_chan,
		     nu16_itmpl)

PAT_GET_FIELD_PAT_GENERIC(nu16_pat_get_field_pat,
			  sixteen_fields)

PAT_SUB_GENERIC(nu16_pat_sub,
		&nu16_pat)

t_pat				nu16_pat = 
{
  nu16_pat_name,		/* t_pat_name_proc		*/
  sixteen_pat_off,		/* t_pat_off_proc		*/
  nu16_pat_sub,			/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  nu16_pat_get_field,		/* t_pat_get_field_proc	*/
  nu16_pat_set_field,		/* t_pat_set_field_proc	*/
  nu16_pat_get_fields,		/* t_pat_get_fields_proc	*/
  nu16_pat_get_tmpl,		/* t_pat_get_tmpl_proc	*/
  NULL,				/* t_pat_get_tmpl2_proc	*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc	*/
  nu16_pat_get_field_pat,	/* t_pat_get_field_pat_proc	*/
  nu16_pat_extract,		/* t_pat_extract_proc		*/
  nu16_pat_insert,		/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

int	u16_chan;

PAT_NAME_GENERIC(u16_pat_name,
		 (VOID_PTR)&u16_chan,
		 "u16")

PAT_EXTRACT_DECL(u16_pat_extract)
{
  t_u16				u16;

  if (len < sizeof (u16))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u16,sizeof (u16));
  return (ulong_to_str((unsigned long)u16,
		       pat_base,
		       str,
		       max_len));
}

PAT_INSERT_DECL(u16_pat_insert)
{
  t_u16				u16;
  t_status			status;	
  int				basenum;
  unsigned long			num;

  if (len < sizeof (u16))
    return (ERR_PAT_TRUNC_FIELD);
  if ((status = ulong_from_str(value,
			       &basenum,
			       &num)) != 0)
    return (status);
  u16 = (t_u16)num;
  FBCOPY(&u16,buf,sizeof (u16));
  return (0);
}

t_pat				u16_pat = 
{
  u16_pat_name,			/* t_pat_name_proc		*/
  sixteen_pat_off,		/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc	*/
  NULL,				/* t_pat_set_field_proc	*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc	*/
  NULL,				/* t_pat_get_tmpl2_proc	*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc	*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  u16_pat_extract,		/* t_pat_extract_proc		*/
  u16_pat_insert,		/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

int s16_chan;

PAT_NAME_GENERIC(s16_pat_name,
		 (VOID_PTR)&s16_chan,
		 "s16")

PAT_EXTRACT_DECL(s16_pat_extract)
{
  t_s16				s16;

  if (len < sizeof (s16))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&s16,sizeof (s16));
  return (long_to_str((signed long)s16,
		      pat_base,
		      str,
		      max_len));
}

PAT_INSERT_DECL(s16_pat_insert)
{
  t_s16				s16;
  t_status			status;	
  int				basenum;
  signed long			num;

  if (len < sizeof (s16))
    return (ERR_PAT_TRUNC_FIELD);
  if ((status = long_from_str(value,
			      &basenum,
			      &num)) != 0)
    return (status);
  s16 = (t_s16)num;
  FBCOPY(&s16,buf,sizeof (s16));
  return (0);
}

t_pat				s16_pat = 
{
  s16_pat_name,			/* t_pat_name_proc		*/
  sixteen_pat_off,		/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc	*/
  NULL,				/* t_pat_set_field_proc	*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc	*/
  NULL,				/* t_pat_get_tmpl2_proc	*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc	*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  s16_pat_extract,		/* t_pat_extract_proc		*/
  s16_pat_insert,		/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

int	nu16assoc_chan;

PAT_NAME_GENERIC(nu16assoc_pat_name,
		 (VOID_PTR)&nu16assoc_chan,
		 "nu16assoc")

PAT_EXTRACT_DECL(nu16assoc_pat_extract)
{
  t_u16				u16;
  t_assoc			*assocs;
  t_assoc			*assoc;

  if ((assocs = (t_assoc *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < sizeof (u16))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u16,sizeof (u16));
  u16 = UNSAFE_NTOHS(u16);
  if (assoc = assoc_str_int_from_right(assocs,(int)u16))
    return (str_cat_str(str,
			max_len,
			assoc->left));
  else
    return (ulong_to_str((unsigned long)u16,
			 pat_base,
			 str,
			 max_len));
}

PAT_INSERT_DECL(nu16assoc_pat_insert)
{
  t_u16				u16;
  t_status			status;	
  t_assoc			*assocs;
  t_assoc			*assoc;
  
  if ((assocs = (t_assoc *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < sizeof (u16))
    return (ERR_PAT_TRUNC_FIELD);
  if (assoc = assoc_str_ptr_from_left(assocs,value))
    u16 = (t_u16)(t_u32)(assoc->right);
  else
    {
      int			basenum;
      unsigned long		num;
      
      if ((status = ulong_from_str(value,
				   &basenum,
				   &num)) != 0)
	return (status);
      u16 = (t_u16)num;
    }
  u16 = UNSAFE_HTONS(u16);
  FBCOPY(&u16,buf,sizeof (u16));
  return (0);
}

PAT_GET_CHOICES_DECL(nu16assoc_pat_get_choices)
{
  t_assoc		*assocs;
  t_assoc		*assoc;
  t_status		status;

  if ((assocs = (t_assoc *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  assoc = assocs;
  while (assoc->left)
    {
      if ((status = vec_str_add(vec_str,assoc->left)) != 0)
	return (status);
      assoc++;
    }
  return (0);
}

t_pat				nu16assoc_pat = 
{
  nu16assoc_pat_name,		/* t_pat_name_proc		*/
  sixteen_pat_off,		/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc	*/
  NULL,				/* t_pat_set_field_proc	*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc	*/
  NULL,				/* t_pat_get_tmpl2_proc	*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc	*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  nu16assoc_pat_extract,	/* t_pat_extract_proc		*/
  nu16assoc_pat_insert,		/* t_pat_insert_proc		*/
  nu16assoc_pat_get_choices,	/* t_pat_get_choices_proc	*/
};

char			*nu16bitfield_itmpl = "\n\
<table _name=nu16bitfield[%i%] bgcolor=\"%%nu16bitfieldColor%%\" width=100%%%%>\n\
<tr>\n\
<td align=center>\n\
<small>\n\
<a href=\"set(nu16bitfield[%i%].nbit0)\">%%nu16bitfield[%i%].nbit0%%</a>\n\
<a href=\"set(nu16bitfield[%i%].nbit1)\">%%nu16bitfield[%i%].nbit1%%</a>\n\
<a href=\"set(nu16bitfield[%i%].nbit2)\">%%nu16bitfield[%i%].nbit2%%</a>\n\
<a href=\"set(nu16bitfield[%i%].nbit3)\">%%nu16bitfield[%i%].nbit3%%</a>\n\
<a href=\"set(nu16bitfield[%i%].nbit4)\">%%nu16bitfield[%i%].nbit4%%</a>\n\
<a href=\"set(nu16bitfield[%i%].nbit5)\">%%nu16bitfield[%i%].nbit5%%</a>\n\
<a href=\"set(nu16bitfield[%i%].nbit6)\">%%nu16bitfield[%i%].nbit6%%</a>\n\
<a href=\"set(nu16bitfield[%i%].nbit7)\">%%nu16bitfield[%i%].nbit7%%</a>\n\
<a href=\"set(nu16bitfield[%i%].nbit8)\">%%nu16bitfield[%i%].nbit8%%</a>\n\
<a href=\"set(nu16bitfield[%i%].nbit9)\">%%nu16bitfield[%i%].nbit9%%</a>\n\
<a href=\"set(nu16bitfield[%i%].nbit10)\">%%nu16bitfield[%i%].nbit10%%</a>\n\
<a href=\"set(nu16bitfield[%i%].nbit11)\">%%nu16bitfield[%i%].nbit11%%</a>\n\
<a href=\"set(nu16bitfield[%i%].nbit12)\">%%nu16bitfield[%i%].nbit12%%</a>\n\
<a href=\"set(nu16bitfield[%i%].nbit13)\">%%nu16bitfield[%i%].nbit13%%</a>\n\
<a href=\"set(nu16bitfield[%i%].nbit14)\">%%nu16bitfield[%i%].nbit14%%</a>\n\
<a href=\"set(nu16bitfield[%i%].nbit15)\">%%nu16bitfield[%i%].nbit15%%</a>\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

int nu16bitfield_chan;

PAT_NAME_GENERIC(nu16bitfield_pat_name,
		 (VOID_PTR)&nu16bitfield_chan,
		 "nu16bitfield")

PAT_EXTRACT_DECL(nu16bitfield_pat_extract)
{
  t_u16			u16;
  t_u16			u16ret;
  t_bit_field		*bf;

  if ((bf = (t_bit_field *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < sizeof (u16))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u16,sizeof (u16));
  u16 = UNSAFE_NTOHS(u16);
  bit_field_u16_get(&u16,
		    &u16ret,
		    bf->from,
		    bf->to);
  return (ulong_to_str((unsigned long)u16ret,
		       pat_base,
		       str,
		       max_len));
}

PAT_INSERT_DECL(nu16bitfield_pat_insert)
{
  t_u16				u16;
  t_u16				u16value;
  t_bit_field			*bf;
  int				basenum;
  unsigned long			num;
  t_status			status;

  if ((bf = (t_bit_field *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < sizeof (u16))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u16,sizeof (u16));
  u16 = UNSAFE_NTOHS(u16); 
  if ((status = ulong_from_str(value,
			       &basenum,
			       &num)) != 0)
    return (status);
  u16value = (t_u16)num;
  bit_field_u16_set(&u16,bf->from,
		    bf->to,
		    u16value);
  u16 = UNSAFE_HTONS(u16); 
  FBCOPY(&u16,buf,sizeof (u16));
  return (0);
}

PAT_GET_FIELD_GENERIC(nu16bitfield_pat_get_field,
		      sixteen_fields)

PAT_SET_FIELD_GENERIC(nu16bitfield_pat_set_field,
		      sixteen_fields)

PAT_GET_FIELDS_GENERIC(nu16bitfield_pat_get_fields,
		       sixteen_fields)

PAT_GET_TMPL_GENERIC(nu16bitfield_pat_get_tmpl,
		     (VOID_PTR)&nu16bitfield_chan,
		     nu16bitfield_itmpl)

PAT_GET_FIELD_PAT_GENERIC(nu16bitfield_pat_get_field_pat,
			  sixteen_fields)

PAT_SUB_GENERIC(nu16bitfield_pat_sub,
		&nu16bitfield_pat)

t_pat				nu16bitfield_pat = 
{
  nu16bitfield_pat_name,	/* t_pat_name_proc		*/
  sixteen_pat_off,		/* t_pat_off_proc		*/
  nu16bitfield_pat_sub,		/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  nu16bitfield_pat_get_field,	/* t_pat_get_field_proc	*/
  nu16bitfield_pat_set_field,	/* t_pat_set_field_proc	*/
  nu16bitfield_pat_get_fields,	/* t_pat_get_fields_proc	*/
  nu16bitfield_pat_get_tmpl,	/* t_pat_get_tmpl_proc	*/
  NULL,				/* t_pat_get_tmpl2_proc	*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc	*/
  nu16bitfield_pat_get_field_pat,/* t_pat_get_field_pat_proc	*/
  nu16bitfield_pat_extract,	/* t_pat_extract_proc		*/
  nu16bitfield_pat_insert,	/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

char			*u16bitfield_itmpl = "\n\
<table _name=u16bitfield[%i%] bgcolor=\"%%u16bitfieldColor%%\" width=100%%%%>\n\
<tr>\n\
<td align=center>\n\
<small>\n\
<a href=\"set(u16bitfield[%i%].bit0)\">%%u16bitfield[%i%].bit0%%</a>\n\
<a href=\"set(u16bitfield[%i%].bit1)\">%%u16bitfield[%i%].bit1%%</a>\n\
<a href=\"set(u16bitfield[%i%].bit2)\">%%u16bitfield[%i%].bit2%%</a>\n\
<a href=\"set(u16bitfield[%i%].bit3)\">%%u16bitfield[%i%].bit3%%</a>\n\
<a href=\"set(u16bitfield[%i%].bit4)\">%%u16bitfield[%i%].bit4%%</a>\n\
<a href=\"set(u16bitfield[%i%].bit5)\">%%u16bitfield[%i%].bit5%%</a>\n\
<a href=\"set(u16bitfield[%i%].bit6)\">%%u16bitfield[%i%].bit6%%</a>\n\
<a href=\"set(u16bitfield[%i%].bit7)\">%%u16bitfield[%i%].bit7%%</a>\n\
<a href=\"set(u16bitfield[%i%].bit8)\">%%u16bitfield[%i%].bit8%%</a>\n\
<a href=\"set(u16bitfield[%i%].bit9)\">%%u16bitfield[%i%].bit9%%</a>\n\
<a href=\"set(u16bitfield[%i%].bit10)\">%%u16bitfield[%i%].bit10%%</a>\n\
<a href=\"set(u16bitfield[%i%].bit11)\">%%u16bitfield[%i%].bit11%%</a>\n\
<a href=\"set(u16bitfield[%i%].bit12)\">%%u16bitfield[%i%].bit12%%</a>\n\
<a href=\"set(u16bitfield[%i%].bit13)\">%%u16bitfield[%i%].bit13%%</a>\n\
<a href=\"set(u16bitfield[%i%].bit14)\">%%u16bitfield[%i%].bit14%%</a>\n\
<a href=\"set(u16bitfield[%i%].bit15)\">%%u16bitfield[%i%].bit15%%</a>\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

int u16bitfield_chan;

PAT_NAME_GENERIC(u16bitfield_pat_name,
		 (VOID_PTR)&u16bitfield_chan,
		 "u16bitfield")

PAT_EXTRACT_DECL(u16bitfield_pat_extract)
{
  t_u16			u16;
  t_u16			u16ret;
  t_bit_field		*bf;

  if ((bf = (t_bit_field *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < sizeof (u16))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u16,sizeof (u16));
  bit_field_u16_get(&u16,
		    &u16ret,
		    bf->from,
		    bf->to);
  return (ulong_to_str((unsigned long)u16ret,
		       pat_base,
		       str,
		       max_len));
}

PAT_INSERT_DECL(u16bitfield_pat_insert)
{
  t_u16				u16;
  t_u16				u16value;
  t_bit_field			*bf;
  int				basenum;
  unsigned long			num;
  t_status			status;

  if ((bf = (t_bit_field *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < sizeof (u16))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u16,sizeof (u16));
  if ((status = ulong_from_str(value,
			       &basenum,
			       &num)) != 0)
    return (status);
  u16value = (t_u16)num;
  bit_field_u16_set(&u16,bf->from,
		    bf->to,
		    u16value);
  FBCOPY(&u16,buf,sizeof (u16));
  return (0);
}

PAT_GET_FIELD_GENERIC(u16bitfield_pat_get_field,
		      sixteen_fields)

PAT_SET_FIELD_GENERIC(u16bitfield_pat_set_field,
		      sixteen_fields)

PAT_GET_FIELDS_GENERIC(u16bitfield_pat_get_fields,
		       sixteen_fields)

PAT_GET_TMPL_GENERIC(u16bitfield_pat_get_tmpl,
		     (VOID_PTR)&u16bitfield_chan,
		     u16bitfield_itmpl)

PAT_GET_FIELD_PAT_GENERIC(u16bitfield_pat_get_field_pat,
			  sixteen_fields)

PAT_SUB_GENERIC(u16bitfield_pat_sub,
		&u16bitfield_pat)

t_pat				u16bitfield_pat = 
{
  u16bitfield_pat_name,		/* t_pat_name_proc		*/
  sixteen_pat_off,		/* t_pat_off_proc		*/
  u16bitfield_pat_sub,		/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  u16bitfield_pat_get_field,	/* t_pat_get_field_proc	*/
  u16bitfield_pat_set_field,	/* t_pat_set_field_proc	*/
  u16bitfield_pat_get_fields,	/* t_pat_get_fields_proc	*/
  u16bitfield_pat_get_tmpl,	/* t_pat_get_tmpl_proc	*/
  NULL,				/* t_pat_get_tmpl2_proc	*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc	*/
  u16bitfield_pat_get_field_pat,/* t_pat_get_field_pat_proc	*/
  u16bitfield_pat_extract,	/* t_pat_extract_proc		*/
  u16bitfield_pat_insert,	/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};

int nu16bitfieldassoc_chan;

PAT_NAME_GENERIC(nu16bitfieldassoc_pat_name,
		 (VOID_PTR)&nu16bitfieldassoc_chan,
		 "nu16bitfieldassoc")

PAT_EXTRACT_DECL(nu16bitfieldassoc_pat_extract)
{
  t_u16				u16;
  t_u16				u16ret;
  t_bit_field_assocs_data	*bfad;
  t_assoc			*assoc;

  if ((bfad = (t_bit_field_assocs_data *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < sizeof (u16))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u16,sizeof (u16));
  u16 = UNSAFE_NTOHS(u16);
  bit_field_u16_get(&u16,
		    &u16ret,
		    bfad->bit_field->from,
		    bfad->bit_field->to);
  if (assoc = assoc_str_int_from_right(bfad->assocs,(int)u16ret))
    return (str_cat_str(str,
			max_len,
			assoc->left));
  else
    return (ulong_to_str((unsigned long)u16ret,
			 pat_base,
			 str,
			 max_len));
}

PAT_INSERT_DECL(nu16bitfieldassoc_pat_insert)
{
  t_u16				u16;
  t_u16				u16value;
  t_bit_field_assocs_data	*bfad;
  t_assoc			*assoc;
  t_status		status;
  
  if ((bfad = (t_bit_field_assocs_data *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  if (len < sizeof (u16))
    return (ERR_PAT_TRUNC_FIELD);
  FBCOPY(buf,&u16,sizeof (u16));
  u16 = UNSAFE_NTOHS(u16); 
  if (assoc = assoc_str_ptr_from_left(bfad->assocs,value))
    u16value = (t_u16)(t_u32)(assoc->right);
  else
    {
      int		basenum;
      unsigned long	num;
      
      if ((status = ulong_from_str(value,
				   &basenum,
				   &num)) != 0)
	return (status);
      u16value = (t_u16)num;
    }
  bit_field_u16_set(&u16,
		    bfad->bit_field->from,
		    bfad->bit_field->to,
		    u16value);
  u16 = UNSAFE_HTONS(u16); 
  FBCOPY(&u16,buf,sizeof (u16));
  return (0);
}

PAT_GET_CHOICES_DECL(nu16bitfieldassoc_pat_get_choices)
{
  t_bit_field_assocs_data	*bfad;
  t_assoc			*assoc;
  t_status			status;

  if ((bfad = (t_bit_field_assocs_data *)(data)) == NULL)
    return (ERR_PAT_NULL_DATA);
  assoc = bfad->assocs;
  while (assoc->left)
    {
      if ((status = vec_str_add(vec_str,assoc->left)) != 0)
	return (status);
      assoc++;
    }
  return (0);
}

t_pat				nu16bitfieldassoc_pat = 
{
  nu16bitfieldassoc_pat_name,	/* t_pat_name_proc		*/
  sixteen_pat_off,		/* t_pat_off_proc		*/
  NULL,				/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  NULL,				/* t_pat_get_field_proc	*/
  NULL,				/* t_pat_set_field_proc	*/
  NULL,				/* t_pat_get_fields_proc	*/
  NULL,				/* t_pat_get_tmpl_proc	*/
  NULL,				/* t_pat_get_tmpl2_proc	*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc	*/
  NULL,				/* t_pat_get_field_pat_proc	*/
  nu16bitfieldassoc_pat_extract,/* t_pat_extract_proc		*/
  nu16bitfieldassoc_pat_insert,	/* t_pat_insert_proc		*/
  nu16bitfieldassoc_pat_get_choices,/* t_pat_get_choices_proc	*/
};
