/*
** pat.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:51:01 1999 
** Last update Thu Oct 28 20:21:42 1999 
*/
#ifndef PAT_H
#define PAT_H	1

#include "paterr.h"
#include "patdef.h"

#ifdef DEBUG_MALLOC
# include "gdm.h"
# define PAT_ALLOC_ALGORITHM	gdm_alloc_algorithm 
# define PAT_ALLOC_PROC		gdm_alloc
# define PAT_REALLOC_PROC	gdm_realloc
# define PAT_FREE_PROC		gdm_free
#else
# define PAT_ALLOC_ALGORITHM	alloc_algorithm_factor2
# define PAT_ALLOC_PROC		alloc_malloc
# define PAT_REALLOC_PROC	realloc_realloc
# define PAT_FREE_PROC		free_free
#endif

#define PAT_VEC_NEW(statusp)	vec_new(VEC_BASE,\
					FALSE,\
					PAT_ALLOC_ALGORITHM,\
					PAT_ALLOC_PROC,\
					PAT_REALLOC_PROC,\
					PAT_FREE_PROC,\
					"pat_vec",\
					(statusp))

#define PAT_DICT_NEW(HashBase,VecBase,StatusPtr) dict_new((HashBase),\
								  (VecBase),\
						 dict_hash_code_public,\
						  PAT_ALLOC_ALGORITHM,\
						  PAT_ALLOC_PROC,\
						  PAT_REALLOC_PROC,\
						  PAT_FREE_PROC,\
								"pat_dict",\
								  (StatusPtr))

#define PAT_ID_NEW(statusp)	id_new(HASH_BASE,\
				       VEC_BASE,\
				       PAT_ALLOC_ALGORITHM,\
				       PAT_ALLOC_PROC,\
				       PAT_REALLOC_PROC,\
				       PAT_FREE_PROC,\
				       "pat_id",\
				       (statusp))

#define PAT_TINY_ID_NEW(statusp)	id_new(HASH_TINY_BASE,\
					       VEC_BASE,\
					       PAT_ALLOC_ALGORITHM,\
					       PAT_ALLOC_PROC,\
					       PAT_REALLOC_PROC,\
					       PAT_FREE_PROC,\
					       "pat_tiny_id",\
					       (statusp))

extern t_boolean		pat_resolve;
extern t_32			pat_base;
extern t_32			pat_verb_level;
extern t_32			pat_zone;
extern t_mask_def		pat_verb_level_mask_defs[];

#ifdef DEBUG
# define VERB_PAT_NBSTUFF	(1L<<0)
# define VERB_PAT_PKT		(1L<<1)
# define VERB_PAT_PKTSAV	(1L<<2)
# define VERB_PAT_PKTIO		(1L<<3)
# define VERB_PAT_PKTSUB	(1L<<4)
# define VERB_PAT_PKTWALK	(1L<<5)

# define PAT_VERB(level)	((pat_verb_level != 0L)?\
				 (level) & pat_verb_level:FALSE) 
#endif

/* PROTO pat.c */
/* pat.c */
t_status pat_init P((void));
void pat_destroy P((void));
void pat_debug_init P((void));
#endif
