/*
** mg_parse.h for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 12:04:58 1999 vianney rancurel
** Last update Thu Oct 28 20:17:29 1999 
*/
#ifndef MG_PARSE_H
#define MG_PARSE_H	1

#include "mg.h"

typedef struct		s_parse_lines_context
{
  t_vec			*vec;			/* MUST BE SET		*/
  char			*wordbuf;		/* MUST BE SET		*/
  int			wordbuflen;		/* MUST BE SET		*/
  char			*wordseps;		/* MUST BE SET		*/
  char			*lineseps;		/* MUST BE SET		*/
  t_vec			*subvec;
  t_boolean		comment;
} t_parse_lines_context;

typedef struct		s_bufferize_context
{
  int			fd;			/* MUST BE SET		*/
  char			*buf;			/* MUST BE SET		*/
  int			buflen;			/* MUST BE SET		*/
  t_vec			*vec_buf;
  int			len;
} t_bufferize_context;

typedef t_status	(*t_tmpl_do_proc) P((VOID_PTR do_data,
					     char *var,
					     VOID_PTR data));
typedef t_status	(*t_tmpl_write_proc) P((VOID_PTR write_data,
						char *buf,
						int len,
						VOID_PTR data));	

typedef struct		s_tmpl_context
{
  char			*varbuf;		/* MUST BE SET		*/
  int			varbuflen;		/* MUST BE SET		*/
  int			left_sep;		/* MUST BE SET		*/
  int			right_sep;
  t_tmpl_do_proc	do_proc;		/* MUST BE SET		*/
  VOID_PTR		do_data;		/* MUST BE SET		*/
  t_tmpl_write_proc	write_proc;		/* MUST BE SET		*/
  VOID_PTR		write_data;		/* MUST BE SET		*/
  VOID_PTR		data;			/* MUST BE SET		*/
  int			varlen;
  t_boolean		invar;
} t_tmpl_context;
						 
/* PROTO mg_parse.c */
/* mg_parse.c */
t_status parse_vars P((int fd, int sep, t_dict *dict, t_dict_str_add_proc proc));
t_status parse_lines_init P((t_parse_lines_context *plc));
t_status parse_lines_finnish P((t_parse_lines_context *plc));
t_status parse_lines P((t_parse_lines_context *plc, char *buf, int len));
t_status bufferize_init P((t_bufferize_context *bc));
void bufferize_destroy P((t_bufferize_context *bc));
char *get_next_line P((t_bufferize_context *bc, t_status *status));
t_status bufferize P((t_bufferize_context *bc));
t_status tmpl_context_init P((t_tmpl_context *tc));
t_status tmpl_finnish P((t_tmpl_context *tc));
t_status tmpl_replace P((t_tmpl_context *tc, char *buf, int len));
t_status tmpl_str_write P((t_bridled_str *bs, char *buf, int len, void *data));
t_status tmpl_str_to_str P((char *tmpl, t_tmpl_do_proc do_proc, void *data, char *str, int max_len));
t_status tmpl_file_write P((FILE *ofile, char *buf, int len, void *data));
t_status tmpl_file_to_file P((FILE *ifile, t_tmpl_do_proc do_proc, void *data, FILE *ofile));
#endif
