/*
** mg_id_ptr.c for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 16:25:36 1999 vianney rancurel
** Last update Thu Oct 28 20:16:01 1999 
*/
#include "mg.h"

/* is a t_hash_destroy_proc.
   It is used internally by id_ptr_delete(3). */
VOID_FUNC		id_ptr_destroy_elt(he,id)
t_hash_elt		*he;
t_id			*id;
{
  id->ht->free_proc(he->value,
		    id->ht->comment,
		    "*:ptr");
}

/* deletes an id and performs a free(3) (a free_proc) for each value. 
   It assumes that every value of an association points to a valid
   memory zone. */
VOID_FUNC		id_ptr_delete(id)
t_id			*id;
{
  t_free_proc		free_proc;
  char			*comment;

  free_proc = id->ht->free_proc;
  comment = id->ht->comment;
  hash_delete(id->ht,
	      (t_hash_destroy_proc)id_ptr_destroy_elt,
	      id);
  free_proc(id,
	    comment,
	    "*:id");
}
