/*
** mg_err.h for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 12:06:28 1999 vianney rancurel
** Last update Thu Oct 28 20:17:53 1999 
*/
#ifndef MG_ERR_H
#define MG_ERR_H	1

#include "mg.h"

#define ERR_MAGIC_SYS		65535

#define ERR_LOOKUP_ERRNO(Err)	((Err) > ERR_MAGIC_SYS)

#define ERR_MG_START		0
#define ERR_MG_END		255

#define ERR_MG_ERROR_ZERO	(ERR_MG_START + 0)
#define ERR_MG_ZERO_LEN		(ERR_MG_START + 1)
#define ERR_MG_TRUNC		(ERR_MG_START + 2)
#define ERR_MG_BO		(ERR_MG_START + 3)
#define ERR_MG_SYNTAX		(ERR_MG_START + 4)
#define ERR_MG_INVAL		(ERR_MG_START + 5)
#define ERR_MG_BAD_ASCII_VEC	(ERR_MG_START + 6)
#define ERR_MG_EXIST		(ERR_MG_START + 7)
#define ERR_MG_BREAK		(ERR_MG_START + 8)
#define ERR_MG_NOT_FOUND	(ERR_MG_START + 9)
#define ERR_MG_IDENTICAL	(ERR_MG_START + 10)
#define ERR_MG_NO_SUCH_KEY	(ERR_MG_START + 11)
#define ERR_MG_NOENT		(ERR_MG_START + 12)
#define ERR_MG_NO_SUCH_BASE	(ERR_MG_START + 13)
#define ERR_MG_UNRECOG_BASE	(ERR_MG_START + 14)
#define ERR_MG_NEED_MORE	(ERR_MG_START + 15)
#define ERR_MG_TOO_MANY		(ERR_MG_START + 16)
#define ERR_MG_BAD_MATCH	(ERR_MG_START + 17)
#define ERR_MG_BAD_FMT		(ERR_MG_START + 18)
#define ERR_MG_DIV_BY_ZERO	(ERR_MG_START + 19)
#define ERR_MG_READ		(ERR_MG_START + 20 + ERR_MAGIC_SYS)
#define ERR_MG_NO_MEM		(ERR_MG_START + 21 + ERR_MAGIC_SYS)
#define ERR_MG_BOOLEAN_SYNTAX	(ERR_MG_START + 22)
#define ERR_MG_PRINTF_END	(ERR_MG_START + 23)
#define ERR_MG_PRINTF_BAD_FMT	(ERR_MG_START + 24)
#define ERR_MG_PRINTF_NULL	(ERR_MG_START + 25)
#define ERR_MG_UNDEF		(ERR_MG_START + 26)

extern t_id			*err_id;

/* PROTO mg_err.c */
/* mg_err.c */
t_status err_init P((void));
char *err_msg P((t_status errcode));
void err_print P((int errcode, char *fmt, ...));
#endif
