/*
** mg_dyn_str.h for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 12:06:39 1999 vianney rancurel
** Last update Thu Oct 28 20:17:56 1999 
*/
#ifndef MG_DYN_STR_H
#define MG_DYN_STR_H	1

#include "mg.h"

typedef struct			s_dyn_str
{
  char				*str;
  int				len;		/* without final zero */
  size_t			base;
  size_t			allocated; 
  t_alloc_algorithm_proc	alloc_algorithm_proc;
  t_alloc_proc			alloc_proc;
  t_realloc_proc		realloc_proc;
  t_free_proc			free_proc;
  char				*comment;
} t_dyn_str;

#define DYN_STR_LEN(DS)		((DS)->len)

#define DYN_STR_MK_STATIC(DS,Str,MaxLen)	{\
    (DS)->str = (Str);\
    (DS)->len = strlen(Str);\
    (DS)->base = 0;\
    (DS)->allocated = (MaxLen);\
    (DS)->alloc_algorithm_proc = alloc_algorithm_none;\
    (DS)->alloc_proc = NULL;\
    (DS)->realloc_proc = NULL;\
    (DS)->free_proc = NULL;\
    (DS)->comment = NULL;}

/* PROTO mg_dyn_str.c */
/* mg_dyn_str.c */
t_status dyn_str_alloc P((t_dyn_str *ds, size_t n));
t_dyn_str *dyn_str_new P((size_t base, t_boolean now, t_alloc_algorithm_proc alloc_algorithm_proc, t_alloc_proc alloc_proc, t_realloc_proc realloc_proc, t_free_proc free_proc, char *comment, t_status *status));
t_status dyn_str_cat_char P((t_dyn_str *ds, int c));
t_status dyn_str_cat_str P((t_dyn_str *ds, char *str));
t_status dyn_str_cat_fmt_va_printf P((t_dyn_str *ds, char *buf, int len));
t_status dyn_str_cat_fmt_va_list P((t_dyn_str *ds, char *fmt, va_list args));
t_status dyn_str_cat_fmt_va P((t_dyn_str *ds, char *fmt, ...));
#endif
