/*
** mg_arr_char.c for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 12:17:00 1999 vianney rancurel
** Last update Thu Oct 28 20:16:33 1999 
*/
#include "mg.h"

/* adds a buffer to an array of char.
   The memory is of course allocated according to the strategy.
   Returns 0 or various errors */
t_status		arr_char_add_buf(arr,buf,len)
t_arr			*arr;		/* Array of char	*/
char			*buf;
int			len;
{
  t_status		status;

  if (arr->allocated < (arr->count + len))
    if ((status = arr_alloc(arr,arr->count + len)) != 0)
      return (status);
  bcopy(buf,ARR_CHAR_BUF(arr) + arr->count * arr->eltsize,len); 
  arr->count += len;
  return (0);
}

/* adds zeros to an arrays of char.
   It adds len zeros to the array.
   Returns 0 or various errors */
t_status		arr_char_add_zeros(arr,len)
t_arr			*arr;
int			len;		/* Number of zeros to add	*/
{
  t_status		status;
  
  if (arr->allocated < (arr->count + len))
    if ((status = arr_alloc(arr,arr->count + len)) != 0)
      return (status);
  bzero(ARR_CHAR_BUF(arr) + arr->count * arr->eltsize,len); 
  arr->count += len;
  return (0);
}

/* "extracts" a buffer from the array.
   Discards the off first bytes of the array.
   Returns 0 or various errors */
t_status		arr_char_extract_from(arr,off)
t_arr			*arr;
t_off			off;
{
  int			new_count;

  if ((new_count = arr->count - off) < 0)
    return (ERR_MG_TRUNC);
  bcopy(ARR_CHAR_BUF(arr) + off * arr->eltsize,
	ARR_CHAR_BUF(arr),
	new_count);
  arr->count = new_count;
  return (0);
}
