##
## aclocal.m4 for xipdump
## 
## Made by vianney rancurel
## Login   <vianney@epita.fr>
## 
## Started on  Wed Aug 25 11:35:41 1999 vianney rancurel
Last update Wed Nov 17 04:47:16 1999 
##

# Local additions to Autoconf macros.
# Copyright (C) 1992, 1994 Free Software Foundation, Inc.
# Francois Pinard <pinard@iro.umontreal.ca>, 1992.

# @defmac AC_PROG_CC_STDC
# @maindex PROG_CC_STDC
# @ovindex CC
# If the C compiler in not in ANSI C mode by default, try to add an option
# to output variable @code{CC} to make it so.  This macro tries various
# options that select ANSI C on some system or another.  It considers the
# compiler to be in ANSI C mode if it defines @code{__STDC__} to 1 and
# handles function prototypes correctly.
# 
# If you use this macro, you should check after calling it whether the C
# compiler has been set to accept ANSI C; if not, the shell variable
# @code{ac_cv_prog_cc_stdc} is set to @samp{no}.  If you wrote your source
# code in ANSI C, you can make an un-ANSIfied copy of it by using the
# program @code{ansi2knr}, which comes with Ghostscript.
# @end defmac

define(FP_PROG_CC_STDC,
[AC_MSG_CHECKING(for ${CC-cc} option to accept ANSI C)
AC_CACHE_VAL(ac_cv_prog_cc_stdc,
[ac_cv_prog_cc_stdc=no
ac_save_CFLAGS="$CFLAGS"
# Don't try gcc -ansi; that turns off useful extensions and
# breaks some systems' header files.
# AIX			-qlanglvl=ansi
# Ultrix and OSF/1	-std1
# HP-UX			-Aa -D_HPUX_SOURCE
# SVR4			-Xc
for ac_arg in "" -qlanglvl=ansi -std1 "-Aa -D_HPUX_SOURCE" -Xc
do
  CFLAGS="$ac_save_CFLAGS $ac_arg"
  AC_TRY_COMPILE(
[#if !defined(__STDC__) || __STDC__ != 1
choke me
#endif	
], [int test (int i, double x);
struct s1 {int (*f) (int a);};
struct s2 {int (*f) (double a);};],
[ac_cv_prog_cc_stdc="$ac_arg"; break])
done
CFLAGS="$ac_save_CFLAGS"
])
AC_MSG_RESULT($ac_cv_prog_cc_stdc)
case "x$ac_cv_prog_cc_stdc" in
  x|xno) ;;
  *) CC="$CC $ac_cv_prog_cc_stdc" ;;
esac
])

# Check for function prototypes.

AC_DEFUN(FP_C_PROTOTYPES,
[AC_REQUIRE([FP_PROG_CC_STDC])
AC_MSG_CHECKING([for function prototypes])
if test "$ac_cv_prog_cc_stdc" != no; then
  AC_MSG_RESULT(yes)
  AC_DEFINE(HAVE_PROTOTYPES)
  U= ANSI2KNR=
else
  AC_MSG_RESULT(no)
  U=_ ANSI2KNR=ansi2knr
fi
AC_SUBST(U)dnl
AC_SUBST(ANSI2KNR)dnl
])

# Check for ansi cpp

AC_DEFUN(MG_C_ANSI_CPP,
[AC_MSG_CHECKING([for ansi cpp])
AC_CACHE_VAL(ac_cv_c_ansi_cpp,
[AC_TRY_RUN(
[#define QUOTE(expr) #expr
int main()
{
exit(strcmp("a",QUOTE(a)));
}],ac_cv_c_ansi_cpp=yes,ac_cv_c_ansi_cpp=no,:)
])
AC_MSG_RESULT($ac_cv_c_ansi_cpp)
if test "$ac_cv_c_ansi_cpp" != no
then
	AC_DEFINE(HAVE_ANSI_CPP)
fi
])

AC_DEFUN(MG_WITH_EXTRA_INCLUDE,
[AC_MSG_CHECKING(for extra include)
AC_ARG_WITH(extra_include,
[  --with-extra-include=DIR
                          add an extra include dir],
[if test ! -z "$withval"; then
  AC_MSG_RESULT($withval)
  INCLUDES="$INCLUDES -I$withval"
else
  AC_MSG_RESULT(none)
fi], [AC_MSG_RESULT(none)])])

# Check for extra libpath

AC_DEFUN(MG_WITH_EXTRA_LIBPATH,
[AC_MSG_CHECKING(for extra libpath)
AC_ARG_WITH(extra_libpath,
[  --with-extra-libpath=DIR
                          add an extra libpath],
[if test ! -z "$withval"; then
  AC_MSG_RESULT($withval)
  LDFLAGS="$LDFLAGS -L$withval"
else
  AC_MSG_RESULT(none)
fi], [AC_MSG_RESULT(none)])])

# Check for kludge

AC_DEFUN(MG_WITH_KLUDGE,
[AC_MSG_CHECKING(if kludge is wanted)
AC_ARG_WITH(kludge,
[  --with-kludge            compile with KLUDGE],
[if test "$withval" = yes; then
  AC_MSG_RESULT(yes)
  AC_DEFINE(WITH_KLUDGE)
else
  AC_MSG_RESULT(no)
fi], [AC_MSG_RESULT(no)])])

dnl
dnl Look for libpcap in .. 
dnl Use the installed libpcap if there is no local version
dnl Taken from AC_LBL_LIBPCAP
dnl
dnl usage:
dnl
dnl	MG_LIBPCAP(pcap_dep,pcap_inclpath,pcap_libpath)
dnl
AC_DEFUN(MG_LIBPCAP,
    [AC_MSG_CHECKING(for local pcap library)
    libpcap=FAIL
    lastdir=FAIL
    places=`ls .. | sed -e 's,/$,,' -e 's,^,../,' | \
	egrep '/libpcap-[[0-9]]*\.[[0-9]]*(\.[[0-9]]*)?([[ab]][[0-9]]*)?$'`
    for dir in $places ../libpcap libpcap ; do
	    basedir=`echo $dir | sed -e 's/[[ab]][[0-9]]*$//'`
	    if test $lastdir = $basedir ; then
		    dnl skip alphas when an actual release is present
		    continue;
	    fi
	    lastdir=$dir
	    if test -r $dir/pcap.c ; then
		    libpcap=$dir/libpcap.a
		    d=$dir
		    dnl continue and select the last one that exists
	    fi
    done
    if test $libpcap = FAIL ; then
	    AC_MSG_RESULT(not found)
	    AC_CHECK_LIB(pcap, main, libpcap="-lpcap")
	    if test $libpcap = FAIL ; then
		    AC_MSG_ERROR(get it at ftp://ftp.ee.lbl.gov)
	    fi
    else
	    $1=$libpcap
	    $2=$d
	    $3=$d
	    AC_MSG_RESULT($libpcap)
    fi])

dnl
dnl Look for libnet in .. 
dnl Use the installed libnet if there is no local version
dnl
dnl usage:
dnl
dnl	MG_LIBNET(libnet_dep,libnet_inclpath,libnet_libpath)
dnl
AC_DEFUN(MG_LIBNET,
    [AC_MSG_CHECKING(for local libnet library)
    libnet=FAIL
    lastdir=FAIL
    places=`ls .. | sed -e 's,/$,,' -e 's,^,../,' | \
	egrep '/Libnet-.*$'`
    for dir in $places ../libnet libnet $prefix; do
	    lastdir=$dir
	    if test -r $dir/include/libnet.h ; then
		    libnet=$dir/lib/libnet.a
		    d=$dir
		    dnl continue and select the last one that exists
	    fi
    done
    if test $libnet = FAIL ; then
	    AC_MSG_ERROR(get it at http://www.packetfactory.net/libnet)
    else
	    $1=$libnet
	    $2=$d/include
	    $3=$d/lib
	    AC_MSG_RESULT($libnet)
    fi])
