/*
** XmgMessage.c for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 14:14:26 1999 vianney rancurel
** Last update Thu Oct 28 20:22:23 1999 
*/
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Viewport.h>
#include "XmgMacro.h"
#include "XmgPrompt.h"

extern Widget	toplevel;

VOID_FUNC	XmgMessageBoxCallback(w,shell,p)
Widget		w;
Widget		shell;
XtPointer	p;
{
  XtDestroyWidget(shell);
}

/* shows an autonmous message box. 
   It also creates a ok command widget to discard the message */
VOID_FUNC	XmgShowMessageBox(parent,str)
Widget		parent;
char		*str;		/* The string to display */
{
  Widget	shell;
  Widget	label;

  INTERFACE(parent,
            GETCHILDSHELL(shell)
            ("xmgMessageBox",transientShellWidgetClass,
             XtNmappedWhenManaged,	False,
	     XtNtransientFor,		parent,
	     CHILD("form",formWidgetClass,
                   GETCHILD(label)
                   ("label",labelWidgetClass,
                    XtNlabel,		str,
                    END),
                   CHILD("ok",commandWidgetClass,
                         XtNfromHoriz,	label,
                         CALLBACK(XtNcallback,
				  XmgMessageBoxCallback,
				  shell),
                         END),
                   END),
             MANAGE,
             END),
            ENDINTERFACE);
  XmgCenterWidget(shell);
  XmgSetDestroyOnDelete(shell);
  XtPopup(shell,XtGrabNone);
}

/* varargs version of XmgShowMessageBox(3) */
#ifdef HAVE_STDARG_H
VOID_FUNC	XmgShowMessageBoxFmtVa(Widget parent,char *fmt,...)
#else
VOID_FUNC	XmgShowMessageBoxFmtVa(parent,fmt,va_alist)
Widget		parent;
char		*fmt;
va_dcl
#endif
{
  va_list	ap;
  char		buf[BUFSIZ];
  
  assert(fmt);
#ifdef HAVE_STDARG_H
  va_start(ap,fmt);
#else
  va_start(ap);
  va_arg(ap,Widget);
  va_arg(ap,char *);
#endif
  vsnprintf(buf,sizeof (buf),fmt,ap);
  XmgShowMessageBox(parent,buf);
  va_end(ap);
}
