/*
** XmgMacro.h for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 14:17:51 1999 vianney rancurel
** Last update Wed Aug 25 14:17:55 1999 vianney rancurel
*/
/*
 * XtMacro Copyright Olivier Raoul (C) 1995
 */

#ifndef XMGMACRO_H
#define XMGMACRO_H

#include <X11/Intrinsic.h>
#include "mg.h"

typedef VOID_FUNC	(*XmgMacroMultiCallbackProc) P((Widget w,
							t_vec *args,
							XtPointer cbs));

typedef struct				_XmgMacroMethodDataRec
{
  Widget				dst;
  String				src_res;
  String				dst_res;
} XmgMacroMethodDataRec; 

typedef struct				_XmgMacroTraceDataRec
{
  String				res;
  XtPointer				var;
} XmgMacroTraceDataRec;

typedef struct				_XmgMacroMultiDataRec
{
  XmgMacroMultiCallbackProc		proc;
  t_vec					*args;
} XmgMacroMultiDataRec;

extern VOID_FUNC			_XtVaToTypedArgList();
extern Widget				_XtCreateWidget();
extern Widget				_XtCreatePopupShell();
extern VOID_FUNC			_XtCountVaList();

#define CHILDGENERIC(FooBar)		NULL),FooBar XmgMacroCreateWidget

#define CHILD				CHILDGENERIC( )

#define CHILDGENERICSHELL(FooBar)	NULL),FooBar XmgMacroCreateShellWidget

#define CHILDSHELL			CHILDGENERICSHELL( )

#define GETCHILDSHELL(FooBar)		CHILDGENERICSHELL((FooBar) =)

#define GETCHILD(FooBar)		CHILDGENERIC((FooBar) =)
#define GETCHILD2(Foo,Bar)		CHILDGENERIC(Foo = Bar =)

#define END				NULL),XmgMacroPopChild(),\
					XmgMacroNothing( XmgMacroNothing(

#define INTERFACE			XmgMacroPushChild

#define ENDINTERFACE			NULL),XmgMacroPopChild(),\
					XmgMacroLookupChild(

#define GETPARENT			XmgMacroLookupChild()

#define DO				NULL)

#define DONE				XmgMacroNothing( NULL

#define CALLBACK(Nam,Fun,Dat)		DO,XtAddCallback(GETPARENT,\
					(Nam),(XtCallbackProc)(Fun),\
					(XtPointer)(Dat)),DONE

#define MCALLBACK			DO,XmgMacroAddMultiCallback

#define EVENTHANDLER(Nam,Msk,Fun,Dat)	DO,\
					XtAddEventHandler(GETPARENT,\
					(Nam),(Msk),(XtEventHandler)(Fun),\
					(XtPointer)(Dat)),DONE

#define CALLTRACE(Cback,Res,Val)	DO,\
					XmgMacroDoMethodTrace\
					(GETPARENT,\
					(Cback),(Res),(Val)),DONE

#define SETTO(Target,Cback,Res)		DO,XmgMacroDoMethod(\
					GETPARENT,\
					(Cback),(Res),(Rarget),(Res)),DONE

#define GETFROM(Src,Cback,Res)		DO,XmgMacroDoMethod((Src),\
					(Cback),(Res),\
					GETPARENT,(Res)),DONE

#define LINKVAR(Wid,Cback,Res)		SETTO((Wid),(Cback),(Res)),\
					GETFROM((Wid),(Cback),(Res))

#define APPINITIALIZE			XmgMacroAppInitialize

#define REALIZE				NULL),\
					XtRealizeWidget(GETPARENT),\
					XmgMacroNothing( NULL

#define MANAGE				NULL),XtManageChild(\
					GETPARENT),\
					XmgMacroNothing( NULL

#define POPUP(Typ)			NULL),XtPopup(GETPARENT,\
					(Typ)),XmgMacroNothing( NULL

#define MAINLOOP			DO,XtAppMainLoop(\
					XtWidgetToApplicationContext(\
					GETPARENT)),DONE

#define INSERTCODE(x)			DO;x;DONE
					
/* PROTO XmgMacro.c */
/* include/XmgFancyI.h */
/* include/XmgI.h */
/* XmgMacro.c */
t_status XmgMacroInit P((void));
void XmgMacroDestroy P((void));
void XmgMacroPushChild P((Widget w, ...));
Widget XmgMacroLookupChild P((void));
void XmgMacroPopChild P((void));
Widget XmgMacroVaCreateWidget P((Widget (*f)(void), String name, WidgetClass widget_class, Widget parent, va_list var, int count));
Widget XmgMacroCreateWidget P((char *name, WidgetClass widget_class, ...));
Widget XmgMacroCreateShellWidget P((char *name, WidgetClass widget_class, ...));
Widget XmgMacroAppInitialize P((XtAppContext *app_context_return, String application_class, XrmOptionDescList options, Cardinal num_options, int *argc_in_out, String *argv_in_out, String *fallback_resources, ...));
void XmgMacroMethodProcessCallback P((Widget src, XmgMacroMethodDataRec *md, XtPointer p));
void XmgMacroTraceProcessCallback P((Widget src, XmgMacroTraceDataRec *td, XtPointer p));
void XmgMacroMethodDestroyCallback P((Widget src, XmgMacroMethodDataRec *md, XtPointer p));
void XmgMacroDoMethod P((Widget src, String callback, String src_res, Widget dst, String dst_res));
void XmgMacroDoMethodDouble P((Widget src, String callback, String src_res, Widget dst, String dst_res));
void XmgMacroDoMethodTrace P((Widget src, String callback, String res, XtPointer var));
void XmgMacroMultiCallbackCallback P((Widget w, XmgMacroMultiDataRec *md, XtPointer cbs));
void XmgMacroMultiDestroyCallback P((Widget w, XmgMacroMultiDataRec *md));
void XmgMacroAddMultiCallback P((char *name, XmgMacroMultiCallbackProc proc, ...));
#endif
