/*
** XmgI.c for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 14:14:42 1999 vianney rancurel
** Last update Thu Oct 28 20:22:29 1999 
*/
#include "XmgI.h"

#ifdef DEBUG
t_mask			xmg_verb_level;

t_mask_def		xmg_verb_level_defs[] = 
{
  {"xmgmacro",		VERB_XMG_MACRO},
  {"fancy",		VERB_XMG_FANCY},
  {"cvt",		VERB_XMG_CVT},
  {"all",		~0L},
  {NULL,		0}
};

/* initializes the Xmg debug env. 
   This is a debug function */
VOID_FUNC		XmgDebugInit(VOID_DECL)
{
  char			*str;

  if (str = getenv("XMG_VERB_LEVEL"))
    {
      t_vec		*vec;
      t_status		status;

      vec = XMG_VEC_NEW(&status);
      assert(vec);
      if ((status = vec_str_split(vec,str,'|')) != 0)
	{
	  err_print(status,"XmgDebugInit");
	  abort();
	}
      if ((status = mask_from_vec_str(xmg_verb_level_defs,
				      vec,
				      &xmg_verb_level)) != 0)
	{
	  err_print(status,"XmgDebugInit");
	  abort();
	}
      vec_str_delete(vec);
    }
}
#endif
