/*
** XmgErr.c for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 14:15:04 1999 vianney rancurel
** Last update Thu Oct 28 20:22:33 1999 
*/
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "XmgMessage.h"
#include "XmgErr.h"

char		*err_xmg_list[] = 
{
  "Error 0",					/* 0 */
  "No entry",					/* 1 */
  "Invalid argument",				/* 2 */
  "Not implemented",				/* 3 */
  "Open error",					/* 4 */
  "Read error",					/* 5 */
  "Syntax error",				/* 6 */
  "Bad backslash",				/* 7 */
  "Buffer overflow",				/* 8 */
  "Trailing backslash",				/* 9 */
  "Bad arguments",				/* 10 */
};

t_status	err_xmg_init(VOID_DECL)
{
  t_status	status;
  int		i;

  assert(err_id);
  i = 0;
  while (i < ARRAY_COUNT(err_xmg_list))
    {
      if ((status = id_add(err_id,
			   (VOID_PTR)(ERR_XMG_START + i),
			   err_xmg_list[i])) != 0)
	return (status);
      i++;
    }
  return (0);
}

/* popups an autonomous error message box.
   This is the X version of err_print(3).
   It calls XmgShowMessageBoxFmtVa(3) */
#ifdef HAVE_STDARG_H
VOID_FUNC	XmgErrPrint(Widget parent,int errcode,char *fmt,...)
#else
VOID_FUNC	XmgErrPrint(parent,errcode,fmt,va_alist)
Widget		parent;
t_status	errcode;
char		*fmt;
va_dcl
#endif
{
  va_list	ap;
  char		buf[BUFSIZ];
  char		*err;
    
  assert(errcode >= 0);
  assert(fmt);
#ifdef HAVE_STDARG_H
  va_start(ap,fmt);
#else
  va_start(ap);
  va_arg(ap,int);
  va_arg(ap,char *);
#endif
  vsnprintf(buf,sizeof (buf),fmt,ap);
  if (err = err_msg(errcode))
    {
      if (ERR_LOOKUP_ERRNO(errcode))
	XmgShowMessageBoxFmtVa(parent,
			       "%s: %s (%d): %s",
			       buf,
			       err_msg(errcode),
			       errcode,
			       strerror(errno));
      else
	XmgShowMessageBoxFmtVa(parent,
			       "%s: %s (%d)",
			       buf,
			       err_msg(errcode),
			       errcode);
    }
  else
    {
      if (ERR_LOOKUP_ERRNO(errcode))
	XmgShowMessageBoxFmtVa(parent,
			       "%s: (%d): %s",
			       buf,
			       errcode,
			       strerror(errno));
      else
	XmgShowMessageBoxFmtVa(parent,
			       "%s: (%d)",
			       buf,
			       errcode);
    }
  va_end(ap);
}

