@class Group(Composite) @file=Group @nodoc

@public
@var int				numCols = 1
@var int				margin = 1
@var int				space = 1

@private
@var Dimension				max_width
@var Dimension				max_height

@methods

@proc					initialize
{
  $max_width = 0;
  $max_height = 0;
}

@proc					calc_geometry($)
{
  int					i;
  int					width;
  int					height;
  
  width = height = 0;
  for (i = 0;i < $num_children;i++)
    {
      Widget				child;
      int				dim;
      
      child = $children[i];
      if (XtIsManaged(child) == False)
	continue;
      dim = $child$width + 2 * $child$border_width;
      if (dim > width)
	width = dim;
      dim = $child$height + 2 * $child$border_width;
      if (dim > height)
	height = dim;
    }
  $max_width = width;
  $max_height = height;
}

@proc					set_geometry($)
{
  Position				x;
  Position				y;
  int					i;
  int					j;
  int					index;

  x = y = 0;
  index = 0;
  for (i = 0;;i++)
    for (j = 0;j < $numCols;j++)
      {
	Widget				child;
	Dimension			width;
	Dimension			height;
	
	while (1)
	  {
	    if (index >= $num_children)
	      return;
	    child = $children[index++];
	    if ($child$managed == False)
	      continue;
	    x = ($max_width + $space) * j + $margin;
	    y = ($max_height + $space) * i + $margin;
	    width = $max_width - 2 * $child$border_width;
	    height = $max_height - 2 * $child$border_width;
	    XtConfigureWidget(child,
			      x,
			      y,
			      width,
			      height,
			      $child$border_width);
	    break;
	  }
      }
}

@proc					change_managed
{
  XtWidgetGeometry			request;
  XtWidgetGeometry			reply;
  
  calc_geometry($);
  set_geometry($);
  query_geometry($,
		 NULL,
		 &request);
  XtMakeGeometryRequest($,
			&request,
			&reply);
}

@proc					geometry_manager
{
  if (request->request_mode & ~(XtCWQueryOnly|CWWidth|CWHeight))
    return (XtGeometryNo);
  reply->width = $max_width - 2 * $child$border_width;
  reply->height = $max_height - 2 * $child$border_width;
  reply->request_mode = CWWidth|CWHeight;
  if (!(request->request_mode & XtCWQueryOnly))
    {
      XtResizeWidget(child,
		     reply->width,
		     reply->height,
		     $child$border_width);
    }
  return (XtGeometryAlmost);
}

@proc					query_geometry
{
  int					i;
  int					count;

  count = 0;
  for (i = 0;i < $num_children;i++)
    if (XtIsManaged($children[i])) 
      count++;
  calc_geometry($);
  reply->width = $max_width * $numCols + 
    ($numCols - 1) * $space + 
    2 * $margin;
  reply->height = $max_height * ((count + $numCols - 1) / $numCols) +
    (((count + $numCols - 1) / $numCols) - 1) * $space + 
    2 * $margin;
  reply->request_mode = CWWidth|CWHeight;
  return (XtGeometryAlmost);
}
