/*
 * Copyright (c) 1995, 1996, 1997, 1998, 1999, 2000, 2001, 2001, 2001, Mark Buser.
 * Copyright  2001, 2001, 2001, 2003, 2004, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/xinvest.c,v 2.60 2004/05/01 14:09:53 danny Exp $
 */
static char id[] = "$Header: /pack/anoncvs/xinvest/src/xinvest.c,v 2.60 2004/05/01 14:09:53 danny Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <X11/Xlib.h>
#include <Xm/XmAll.h>

#ifdef EDITRES
#include <X11/Xmu/Editres.h>
#endif

#include "account.h"
#include "calendar.h"
#include "color.h"
#include "drawing.h"
#include "edit.h"
#include "fileXi.h"
#include "graph.h"
#include "nav.h"
#include "pixmap.h"
#include "pref.h"
#include "rate.h"
#include "remoteXi.h"
#include "report.h"
#include "resource.h"
#include "session.h"
#include "status.h"
#include "tooltips.h"
#include "util.h"
#include "xinvest.h"
#include "xinvestP.h"
#include "xutil.h"

#ifdef	HAVE_LIBDT
#include <Dt/Print.h>
#endif

/* Menu & button callbacks */
       void toolCB ();
extern void accountCB();
extern void statusCB();
extern void helpCB();

char version[] = "Xinvest 2.6.9";

static char *portoptmenu[] = { "Display",
				"Root",
				"Accounts",
				"Flatten" };

static char *calcfuncs[] =   { "Function",
				"Future Value (Lump)", 
                               "Future Value (Series)",
				"Periodic Payment", 
                               "Present Value",
				"Rate" };

       char *calcparams[] =  { "Present Value",
				"Future Value",
				"Rate", 
				"Compounded",
				"Years",
				"Payment"};
static char *calccompnd[] =  { "",
				"Daily",
				"Weekly",
				"Monthly",
				"Quarterly", 
				"Bi-annually",
				"Annually",
				"180/365",
				"360/365" };

static MENUITEMS file[] = {
 { "button_0",    XmVaPUSHBUTTON, fileCB },
 { "button_1",    XmVaPUSHBUTTON, fileCB },
 { "button_2",    XmVaPUSHBUTTON, fileCB },
 { "button_3",    XmVaPUSHBUTTON, fileCB },
 { "button_4",    XmVaPUSHBUTTON, fileCB },
 { "separator_0", XmVaSEPARATOR,  NULL },
 { "button_5",    XmVaPUSHBUTTON, fileCB },
 { "separator_1", XmVaSEPARATOR,  NULL },
 { "button_6",    XmVaPUSHBUTTON, fileCB }
};

static MENUITEMS edit[] = {
 { "button_0",    XmVaPUSHBUTTON, editCB },
 { "button_1",    XmVaPUSHBUTTON, editCB },
 { "button_2",    XmVaPUSHBUTTON, editCB },
 { "separator_0", XmVaSEPARATOR,  NULL },
 { "button_3",    XmVaPUSHBUTTON, editCB },
};

static MENUITEMS tool[] = {
 { "button_0",    XmVaRADIOBUTTON, toolCB },
 { "button_1",    XmVaRADIOBUTTON, toolCB },
 { "button_2",    XmVaRADIOBUTTON, toolCB },
 { "button_3",    XmVaRADIOBUTTON, toolCB },
 { "button_4",    XmVaRADIOBUTTON, toolCB },
 { "button_5",    XmVaRADIOBUTTON, toolCB },
};

static MENUITEMS account[] = {
 { "button_0",    XmVaPUSHBUTTON, accountCB },
 { "button_1",    XmVaPUSHBUTTON, accountCB },
 { "button_2",    XmVaPUSHBUTTON, accountCB },
 { "separator_0", XmVaSEPARATOR,   NULL }
};

static MENUITEMS log[] = {
 { "button_0",    XmVaPUSHBUTTON, statusCB }
};

static MENUITEMS option[] = {
 { "button_0",    XmVaCHECKBUTTON, graph_option },
 { "button_1",    XmVaCHECKBUTTON, graph_option },
 { "button_2",    XmVaCHECKBUTTON, graph_option }
};

static MENUITEMS help[] = {
 { "button_0",    XmVaPUSHBUTTON, helpCB }
};

static void PrintXpCB(Widget, XtPointer, XtPointer);

static BUTTONITEMS toolbar[] = {
  { "About", XmVaPUSHBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, toolCB, NULL 
  },
  { "Edit", XmVaPUSHBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, toolCB, NULL 
  },
  { "Gain", XmVaPUSHBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, toolCB, NULL 
  },
  { "Graphbut",	XmVaPUSHBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, toolCB, NULL 
  },
  { "Portfolio", XmVaPUSHBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, toolCB, NULL 
  },
  { "Calculate", XmVaPUSHBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, toolCB, NULL 
  },
  { "Quit", XmVaPUSHBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, toolCB, NULL 
  },
#ifdef HAVE_LIBDT
  { "Print", XmVaPUSHBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, PrintXpCB, NULL
  },
#endif
};

static BUTTONITEMS acctbar[] = {
  { "button_0", XmVaTOGGLEBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, reportSetAccount, NULL 
  },
  { "button_1", XmVaTOGGLEBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, reportSetAccount, NULL 
  },
  { "button_2", XmVaTOGGLEBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, reportSetAccount, NULL 
  }
};

static BUTTONITEMS timesbar[] = {
  { "button_0", XmVaTOGGLEBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, reportSetTime, NULL 
  },
  { "button_1", XmVaTOGGLEBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, reportSetTime, NULL 
  },
  { "button_2", XmVaTOGGLEBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, reportSetTime, NULL 
  },
  { "button_3", XmVaTOGGLEBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, reportSetTime, NULL 
  },
  { "button_4", XmVaTOGGLEBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, reportSetTime, NULL 
  },
  { "button_5", XmVaTOGGLEBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, reportSetTime, NULL 
  }
};
static BUTTONITEMS timelbar[] = {
  { "button_0", XmVaTOGGLEBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, reportSetTime, NULL 
  },
  { "button_1", XmVaTOGGLEBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, reportSetTime, NULL 
  },
  { "button_2", XmVaTOGGLEBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, reportSetTime, NULL 
  },
  { "button_3", XmVaTOGGLEBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, reportSetTime, NULL 
  },
  { "button_4", XmVaTOGGLEBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, reportSetTime, NULL 
  },
  { "button_5", XmVaTOGGLEBUTTON, (Pixmap)NULL, (Pixmap)NULL, (Pixmap)NULL,
    (XtPointer)NULL, NULL, reportSetTime, NULL 
  }
};

PerDisplay	Global[2];
PerDisplay	*per = &Global[0];
/* application resources */
AppData appdata;

int main (int argc, char **argv)
{

  XtAppContext app;

  XmFontContext   fontContext;

  /* Main Window Widgets */
/*Widget per->Toplevel; */
  Widget Mainform;
   Widget Menubar;
/*   Widget Filemenu; */
/*   Widget Editmenu; */
/*   Widget Toolmenu; */
/*   Widget Accountmenu; */
/*   Widget Optionmenu; */
   Widget Workform;
    Widget HPane;    /* manages left side of Workform */
     Widget VPane;   /* manages left side of Workform */
/*    Widget Translabel; */
/*    Widget Transtext; */
      Widget Graphframe;
        Widget Graph;   
     Widget Midform; /* manages center of Workform */
       Widget Fileframe;
/*     Widget Filecwdlabel; */
         Widget Fileform;
/*        Widget Listfile; */
/*        Widget Savebut; */
          Widget Newbut;
          Widget Openbut;
/*        Widget Prevbut; */
/*        Widget Nextebut; */
       Widget Actframe;
         Widget Actform; /* The following share the same screen area */
/*        Widget Infoframe; */
/*        Widget Reportform; */
          Widget ReportInnerform;
           Widget Screenbut;
           Widget Timeframe;
            Widget Timerow;
/*           Widget Timesform; */
/*           Widget Timelform; */
           Widget Valframe;
/*          Widget Valrow; */
           Widget Acctframe;
            Widget Acctform;
           Widget Reportbut;
/*        Widget Graphform; */
            Widget Graphpframe;
              Widget Graphprow;
            Widget Graphhframe;
              Widget Graphhrow;
            Widget Graphvframe;
              Widget Graphvform;
                Widget Graphvscroll;
/*              Widget Graphcform; */
                  Widget Graphvtext1;
                  Widget Graphvlabel; 
                  Widget Graphvtext2;
/*              Widget Graphscale; */
                Widget Graphslabel;
/*        Widget Portform; */
           Widget Portselrow;
            Widget Portframe;
             Widget Portbutform;
/*            Widget Portpbut; */
/*            Widget Portmbut; */
/*            Widget Portabut; */
/*            Widget Portcbut; */
           Widget Portscrform;
            Widget Portpercentlabel;
/*          Widget Portpercentlist; */
/*          Widget Portoptmenu; */
/*          Widget Portvaluelabel; */
/*        Widget Calcform; */
           Widget Calcoptmenu;
           Widget Calcframe;
/*           Widget Calclabel; */
           Widget Calcrow;
/*	    Widget Calclabels[5]; */
/*	    Widget Calctext[3]; */
            Widget Calccmpdmenu;
     Widget Butform;

  /* X strings */
  XmString Temp[ XtNumber (calccompnd)];

  /* array of resources */
  int n;
  Arg args[15];

  char  dir[BUFSIZ];

  int    i;  /* ubiquitous i */
  Widget w;  /* temporary widget handle */

  /* Initialize toolkit */
  XtSetLanguageProc (NULL, NULL, NULL);

  /* Clear global structures */
  memset(&Global[0], 0, sizeof(PerDisplay));
  memset(&Global[1], 0, sizeof(PerDisplay));

#if !defined(CDE) && XtSpecificationRelease > 5
  /* R6 session shell supports session management */
  per->Toplevel = XtVaOpenApplication( &app, "Xinvest",
                                  options, XtNumber(options), 
                                  &argc, argv, 
                                  getFallbackResource(), 
                                  sessionShellWidgetClass, NULL);
  /* These callbacks are required */
  XtAddCallback (per->Toplevel, XtNsaveCallback, sessSave, 0);
  XtAddCallback (per->Toplevel, XtNcancelCallback, sessResume, 0);
  XtAddCallback (per->Toplevel, XtNsaveCompleteCallback, sessResume, 0);
  XtAddCallback (per->Toplevel, XtNdieCallback, sessDie, 0);

  {
	/* FIX ME not sure whether to do this here. */
     Atom XaWmDeleteWindow = XmInternAtom ( XtDisplay (per->Toplevel), 
		                            "WM_DELETE_WINDOW", False);
     XmAddWMProtocols ( per->Toplevel, &XaWmDeleteWindow, 1);
     XmAddWMProtocolCallback ( per->Toplevel, XaWmDeleteWindow, deleteWindow, 0);
  }
#else
  /* Old style WM_SAVE_YOURSELF property method of save state notification */
  per->Toplevel = XtVaAppInitialize( &app, "Xinvest",
                                options, XtNumber(options), &argc, argv, 
                                getFallbackResource(), NULL);
  {
     Atom XaWmSaveYourself = XmInternAtom ( XtDisplay (per->Toplevel), 
		                            "WM_SAVE_YOURSELF", False);
     XmAddWMProtocols ( per->Toplevel, &XaWmSaveYourself, 1);
     XmAddWMProtocolCallback ( per->Toplevel, XaWmSaveYourself, sessSave, 0);
  }
  {
     Atom XaWmDeleteWindow = XmInternAtom ( XtDisplay (per->Toplevel), 
		                            "WM_DELETE_WINDOW", False);
     XmAddWMProtocols ( per->Toplevel, &XaWmDeleteWindow, 1);
     XmAddWMProtocolCallback ( per->Toplevel, XaWmDeleteWindow, deleteWindow, 0);
  }
#endif

  XmRepTypeInstallTearOffModelConverter();
  XtVaGetApplicationResources ( per->Toplevel, 
                                &appdata, 
                                resources, 
                                XtNumber( resources ),
                                NULL );

  /* If help, print syntax and exit */
  if (appdata.help) {
    syntax (argc, argv);
    exit(0);
  }

#ifdef EDITRES
  XtAddEventHandler( per->Toplevel, 0, True, _XEditResCheckMessages, NULL);
#endif

  per->dpy = XtDisplay(per->Toplevel);
  per->win = RootWindowOfScreen(XtScreen(per->Toplevel));
  per->cmap = DefaultColormapOfScreen(XtScreen(per->Toplevel));
  per->gc = XCreateGC(per->dpy, per->win, 0, NULL );
  per->attrib = 0;

#ifdef DEBUG
  fprintf(stderr, "Initial cmap %p\n", per->cmap);	/* Danny */
#endif

  /**********************/

  /* Get a color map */
  if (appdata.install) {
    per->cmap = NewColormap (per->dpy, per->cmap );
#ifdef DEBUG
    fprintf(stderr, "Initial installed cmap %p\n", per->cmap);	/* Danny */
#endif
  }

  /* Application resource colors get added to color list. */
    per->color[0] = GetNamedColor(per, appdata.color0);
    per->color[1] = GetNamedColor(per, appdata.color1);
    per->color[2] = GetNamedColor(per, appdata.color2);
    per->color[3] = GetNamedColor(per, appdata.color3);
    per->color[4] = GetNamedColor(per, appdata.color4);
    per->color[5] = GetNamedColor(per, appdata.color5);
    per->color[6] = GetNamedColor(per, appdata.color6);
    per->color[7] = GetNamedColor(per, appdata.color7);
    per->color[8] = GetNamedColor(per, appdata.colorRed);
    per->color[9] = GetNamedColor(per, appdata.colorGreen);
    per->color[10] = GetNamedColor(per, appdata.colorGrey);
    per->color[11] = GetNamedColor(per, appdata.colorWhite);
    per->color[12] = GetNamedColor(per, appdata.colorBlack);
    per->color[13] = GetNamedColor(per, appdata.colorPrintForeground);
    per->color[14] = GetNamedColor(per, appdata.colorPrintBackground);
    per->color[15] = GetNamedColor(per, appdata.colorPrintIllustrations);

    per->cmap = InitColor(per->Toplevel, per->cmap, per->color);
#ifdef DEBUG
    fprintf(stderr, "Colors initialised cmap %p\n", per->cmap);	/* Danny */
#endif

    if ( per->cmap == (Colormap)NULL) {
       fprintf( stderr, "Error: can't create XColor colormap, exiting.\n");
       exit(1);
    }

  /* Set the colormap */
  XtVaSetValues ( per->Toplevel, XmNcolormap, per->cmap, NULL );


  /* Create the main window */
  Mainform = XtVaCreateWidget(  "Mainform", xmFormWidgetClass, per->Toplevel, 
                                 XmNresizable, True,
        			 NULL );

  /* Load up all of the pixmaps. Why here? Because Toplevel may have a
  ** bogus background color.  We can't load a "good" colormap till after
  ** its up.  This is the first widget with a likely allocated bg color. 
  */
  per->cmap = InitPixmaps(Mainform, per->cmap);
#ifdef DEBUG
  fprintf(stderr, "Pixmaps loaded cmap %p\n", per->cmap);	/* Danny */
#endif

  if ( per->cmap == (Colormap)NULL) {
     fprintf( stderr, "Error: can't create Pixmap colormap, exiting.\n");
     exit(1);
  }

  /* Set the icon */
  MakeIconWindow ( per->Toplevel );

  /**********************/
 
  /* Create menu bar and pulldown menus */
  n = 0;
  XtSetArg(args[n], XmNtopAttachment,   XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftAttachment,   XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNrightAttachment,   XmATTACH_FORM); n++;
  Menubar =  XmCreateMenuBar ( Mainform, "menubar", args, n );

  XtVaCreateManagedWidget("button_0", xmCascadeButtonGadgetClass,Menubar, NULL);
  XtVaCreateManagedWidget("button_1", xmCascadeButtonGadgetClass,Menubar, NULL);
  XtVaCreateManagedWidget("button_2", xmCascadeButtonGadgetClass,Menubar, NULL);
  XtVaCreateManagedWidget("button_3", xmCascadeButtonGadgetClass,Menubar, NULL);
  XtVaCreateManagedWidget("button_4", xmCascadeButtonGadgetClass,Menubar, NULL);
  XtVaCreateManagedWidget("button_5", xmCascadeButtonGadgetClass,Menubar, NULL);
  XtVaCreateManagedWidget("button_6", xmCascadeButtonGadgetClass,Menubar, NULL);

  /* Set help menu */
  if ( (w = XtNameToWidget (Menubar, "button_6")) )
    XtVaSetValues( Menubar, XmNmenuHelpWidget, w, NULL);

  /* 
  ** File menu 
  */
  Filemenu = makeMenuPulldown ( Menubar, "Filemenu", 0, file, XtNumber(file) );
  /* Some don't make sense til file loaded*/
  if ( (w = XtNameToWidget (Filemenu, "button_2")) )   /* close */
     XtVaSetValues( w, XmNsensitive, False, NULL);
  if ( (w = XtNameToWidget (Filemenu, "button_3")) )   /* save */
     XtVaSetValues( w, XmNsensitive, False, NULL);

  /*
  ** Edit menu
  */
  Editmenu = makeMenuPulldown ( Menubar, "Editmenu", 1, edit, XtNumber(edit) );
  /* Some don't make sense til file loaded*/
  if ( (w = XtNameToWidget (Editmenu, "button_0")) )   /* copy */
     XtVaSetValues( w, XmNsensitive, False, NULL);
  if ( (w = XtNameToWidget (Editmenu, "button_1")) )   /* cut */
     XtVaSetValues( w, XmNsensitive, False, NULL);

  /* 
  ** Tool menu 
  */
  Toolmenu = makeMenuPulldown ( Menubar, "Toolmenu", 2, tool, XtNumber(tool) );
  /* Some don't make sense til file loaded */
  if ( (w = XtNameToWidget (Toolmenu, "button_1")) )   /* edit transaction */
     XtVaSetValues( w, XmNsensitive, False, NULL);
  if ( (w = XtNameToWidget (Toolmenu, "button_2")) )   /* total return */
     XtVaSetValues( w, XmNsensitive, False, NULL);
  if ( (w = XtNameToWidget (Toolmenu, "button_3")) )   /* plot */
     XtVaSetValues( w, XmNsensitive, False, NULL);
  if ( (w = XtNameToWidget (Toolmenu, "button_4")) )   /* portfolio */
     XtVaSetValues( w, XmNsensitive, False, NULL);

  /* 
  ** Option menu 
  */
  Optionmenu = makeMenuPulldown ( Menubar, "Optionmenu", 3, 
                                  option, XtNumber(option) );
  if ( (w = XtNameToWidget (Optionmenu, "button_0")) )   /* zoom */
     XtVaSetValues( w, XmNsensitive, False, NULL);
  if ( (w = XtNameToWidget (Optionmenu, "button_1")) )   /* show points */
     XtVaSetValues( w, XmNsensitive, False, NULL);
  if ( (w = XtNameToWidget (Optionmenu, "button_2")) )   /* show grid */
     XtVaSetValues( w, XmNsensitive, False, NULL);

  /* 
  ** Account menu 
  */
  Accountmenu = makeMenuPulldown ( Menubar, "Accountmenu", 4,
                                   account, XtNumber(account) );
  /* Some don't make sense til file loaded*/
  if ( (w = XtNameToWidget (Accountmenu, "button_0")) )   /* previous */
     XtVaSetValues( w, XmNsensitive, False, NULL);
  if ( (w = XtNameToWidget (Accountmenu, "button_1")) )   /* next */
     XtVaSetValues( w, XmNsensitive, False, NULL);
  if ( (w = XtNameToWidget (Accountmenu, "button_2")) )   /* apply changes */
     XtVaSetValues( w, XmNsensitive, False, NULL);

  /* 
  ** Log menu 
  */
  makeMenuPulldown ( Menubar, "Viewmenu", 5, log, XtNumber(log) );

  /* 
  ** Help menu 
  */
  makeMenuPulldown ( Menubar, "Helpmenu", 6, help, XtNumber(help) );

  XtManageChild (Menubar);
   
  /* Set "about" as initial selection */
  w = XtNameToWidget ( Toolmenu, "button_0" );
  XtVaSetValues ( w, XmNset, True, NULL);

  /**********************/

  /* Create work area form */
  Workform = XtVaCreateWidget ( "Workform", xmFormWidgetClass, Mainform, 
			        XmNtopAttachment,    XmATTACH_WIDGET,
                                XmNtopWidget,        Menubar,
			        XmNleftAttachment,   XmATTACH_FORM,
			        XmNrightAttachment,  XmATTACH_FORM,
                                XmNbottomAttachment, XmATTACH_FORM,
			        NULL );
  /**********************/

#if XmVERSION > 1
  /* Create pane for left and center areas */
  HPane = XtVaCreateWidget ( "HPane", xmPanedWindowWidgetClass, Workform,
                             XmNorientation,      XmHORIZONTAL,
			     XmNtopAttachment,    XmATTACH_FORM,
                             XmNbottomAttachment, XmATTACH_FORM,
			     XmNleftAttachment,   XmATTACH_FORM,
	               	     NULL ); 
  /* Create pane for text and graph */
  VPane = XtVaCreateWidget ( "VPane", xmPanedWindowWidgetClass, HPane,
                            XmNorientation,     XmVERTICAL,
	               	    NULL ); 
#else
  /* Create pane for text and graph */
  VPane = XtVaCreateWidget ( "VPane", xmPanedWindowWidgetClass, Workform,
		            XmNtopAttachment,    XmATTACH_FORM,
			    XmNleftAttachment,   XmATTACH_FORM,
		            XmNbottomAttachment, XmATTACH_FORM,
	               	    NULL ); 
#endif
  /*********************/

  Translabel = XtVaCreateManagedWidget("Translabel",
                          xmLabelWidgetClass, VPane,
                          NULL);
  {
    Dimension height, margin;
    XtVaGetValues (Translabel, XmNheight, &height,
                               XmNmarginHeight, &margin,
                   NULL);
    XtVaSetValues (Translabel, XmNpaneMinimum, height + 2*margin,
                               XmNpaneMaximum, height + 2*margin,
                   NULL); 
  }
  /*********************/

  /* Scrolled text widget holding transaction history*/
  n = 0;
  XtSetArg(args[n], XmNeditMode,  XmMULTI_LINE_EDIT); n++;
  Transtext = XmCreateScrolledText( VPane, "Transtext", args, n);
  XtAddCallback( Transtext, XmNgainPrimaryCallback,
                 (XtCallbackProc) editSelectionCB, (XtPointer) NULL);
  XtAddCallback( Transtext, XmNmotionVerifyCallback,
                 (XtCallbackProc) editSelectionCB, (XtPointer) NULL);
  XtAddCallback( Transtext, XmNlosePrimaryCallback,
                 (XtCallbackProc) editSelectionCB, (XtPointer) NULL);

  XtManageChild (Transtext);
  XtSetSensitive (Transtext, False);
  /*******************/

  /* Drawing area to graph cost */
  Graphframe = XtVaCreateManagedWidget( "Graphframe", 
					xmFrameWidgetClass, VPane,
					NULL);

  Graph = XtVaCreateWidget ( "Graph", 
                             xmDrawingAreaWidgetClass, Graphframe, 
                             NULL );

  XtAddCallback( Graph, XmNexposeCallback, 
                   (XtCallbackProc) redrawDrawing, (XtPointer) 1);

  /* Set gc for Xlib drawing */
  XtVaSetValues ( Graph, XmNuserData, per->gc, NULL );

  /* tell drawing routines where the drawing area is */
  setDrawingArea ( Graph );

  /* Get fonts for graph titles, etc. */

  per->small = per->large = NULL;

  /* Get fonts for display */
  if (XmFontListInitFontContext(&fontContext, appdata.graph_font_list) == True) 
  {
    XmFontListEntry entry;
    XmFontType      fonttype =  XmFONT_IS_FONT;
    char *tag;
    
    while ((entry = XmFontListNextEntry(fontContext)) != NULL) {
      tag = XmFontListEntryGetTag ( entry );
      if ( strcmp( tag, "small") == 0 )
        per->small = (XFontStruct *) XmFontListEntryGetFont (entry, &fonttype);
       if ( strcmp( tag, "large") == 0 )
         per->large = (XFontStruct *) XmFontListEntryGetFont (entry, &fonttype);

       if ( tag != NULL )
         XtFree (tag);
    }

    XmFontListFreeFontContext ( fontContext );
  }

  if ( per->small == NULL || per->large == NULL ) {
    fprintf (stderr, "Error: unable to load drawing area fonts. \n");
    fprintf (stderr, "Xinvest will crash on a graph operation! \n");
  }
       
  XtManageChild(Graph);

  /******************/


  /* Create form to keep file action and status forms tidy */
#if XmVERSION > 1
  Midform = XtVaCreateWidget ( "Midform", xmFormWidgetClass, HPane, 
			        NULL );
#else
  Midform = XtVaCreateWidget ( "Midform", xmFormWidgetClass, Workform, 
			       	XmNtopAttachment,    XmATTACH_FORM,
			       	XmNbottomAttachment, XmATTACH_FORM,
			        NULL );
 
  /* Now we have a Midform, attach Pane to it */
  XtVaSetValues ( VPane, XmNrightAttachment,  XmATTACH_WIDGET,
                         XmNrightWidget,      Midform,
                  NULL );
#endif

  /* File area frame */
  Fileframe = XtVaCreateManagedWidget( "Fileframe", 
					xmFrameWidgetClass, Midform,
			       		XmNtopAttachment,   XmATTACH_FORM,
			       		XmNleftAttachment,  XmATTACH_FORM,
			       		XmNrightAttachment, XmATTACH_FORM,
			         	NULL );
  /* title for frame */
  Filecwdlabel = XtVaCreateManagedWidget("File Manager",
                          xmLabelGadgetClass, Fileframe,
                          XmNchildType, XmFRAME_TITLE_CHILD,
                          XmNchildVerticalAlignment, XmALIGNMENT_CENTER,
                          NULL);
  
  /* File area form */
  Fileform = XtVaCreateWidget ( "Fileform", xmFormWidgetClass, Fileframe, 
			        NULL );
  /**********************/

  /* Create new file button */
  Newbut =  XtVaCreateManagedWidget( "New",
         xmPushButtonWidgetClass, Fileform,
         XmNlabelType,            XmPIXMAP,
         XmNlabelPixmap,          GetPixmap(PNEW, NORMAL, per->dpy),
         XmNlabelInsensitivePixmap,   GetPixmap(PNEW, INSENS, per->dpy), 
         XmNsensitive,            True,
         XmNtopAttachment,        XmATTACH_FORM,       
         XmNleftAttachment,       XmATTACH_FORM,       
         NULL);
  XtAddCallback ( Newbut, XmNactivateCallback, fileCB, (XtPointer) 0);
  installToolTips (Newbut);

  /* Create open file button */
  Openbut =  XtVaCreateManagedWidget( "Open",
         xmPushButtonWidgetClass,  Fileform,
         XmNlabelType,             XmPIXMAP,
         XmNlabelPixmap,           GetPixmap(POPEN, NORMAL, per->dpy),
         XmNlabelInsensitivePixmap,   GetPixmap(POPEN, INSENS, per->dpy), 
         XmNsensitive,             True,
         XmNtop,                   XmATTACH_FORM,       
         XmNleftAttachment,        XmATTACH_WIDGET,       
         XmNleftWidget,            Newbut,       
         NULL);
  XtAddCallback ( Openbut, XmNactivateCallback, fileCB, (XtPointer) 1);
  installToolTips (Openbut);

  /* Create save file button */
  Savebut =  XtVaCreateManagedWidget( "Save",
         xmPushButtonWidgetClass, Fileform,
         XmNlabelType,            XmPIXMAP,
         XmNlabelPixmap,          GetPixmap(PSAVE, NORMAL, per->dpy),
         XmNlabelInsensitivePixmap,   GetPixmap(PSAVE, INSENS, per->dpy), 
         XmNsensitive,            False,
         XmNtopAttachment,        XmATTACH_WIDGET,       
         XmNtopWidget,            Openbut,       
         XmNleftAttachment,       XmATTACH_FORM,       
         NULL);
  /* So we can sensitize the menu, when we do the button */
  if ( (w = XtNameToWidget (Filemenu, "button_3")) )   /* save */
     XtVaSetValues( Savebut, XmNuserData, w, NULL);
  XtAddCallback ( Savebut, XmNactivateCallback, fileCB, (XtPointer) 3);
  installToolTips (Savebut);

  /* Create prev account button */
  Prevbut =  XtVaCreateManagedWidget( "Prevbut",
         xmPushButtonWidgetClass, Fileform,
         XmNlabelType,            XmPIXMAP,
         XmNlabelPixmap,          GetPixmap(PPREV, NORMAL, per->dpy),
         XmNlabelInsensitivePixmap,   GetPixmap(PPREV, INSENS, per->dpy), 
         XmNsensitive,            False,
         XmNtopAttachment,        XmATTACH_WIDGET,       
         XmNtopWidget,            Savebut,       
         XmNleftAttachment,       XmATTACH_FORM,       
         NULL);

  /* We can sensitize the menu, when we do the button */
  if ( (w = XtNameToWidget (Accountmenu, "button_0")) )   /* cycle */
     XtVaSetValues( Prevbut, XmNuserData, w, NULL);
  XtAddCallback ( Prevbut, XmNactivateCallback, accountCB, (XtPointer)0 );
  installToolTips (Prevbut);

  /* Create next account button */
  Nextbut =  XtVaCreateManagedWidget( "Nextbut",
         xmPushButtonWidgetClass, Fileform,
         XmNlabelType,            XmPIXMAP,
         XmNlabelPixmap,          GetPixmap(PNEXT, NORMAL, per->dpy),
         XmNlabelInsensitivePixmap,   GetPixmap(PNEXT, INSENS, per->dpy), 
         XmNsensitive,            False,
         XmNtopAttachment,        XmATTACH_OPPOSITE_WIDGET,       
         XmNtopWidget,            Prevbut,       
         XmNleftAttachment,       XmATTACH_WIDGET,       
         XmNleftWidget,           Prevbut,       
         NULL);

  /* We can sensitize the menu, when we do the button */
  if ( (w = XtNameToWidget (Accountmenu, "button_1")) )   /* cycle */
     XtVaSetValues( Nextbut, XmNuserData, w, NULL);
  XtAddCallback ( Nextbut, XmNactivateCallback, accountCB, (XtPointer)1 );
  installToolTips (Nextbut);

  /* Create file list window */
  n = 0;
  XtSetArg(args[n], XmNselectionPolicy,  XmBROWSE_SELECT); n++;
  XtSetArg(args[n], XmNtopAttachment,    XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftAttachment,   XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNleftWidget,       Openbut); n++;
  XtSetArg(args[n], XmNrightAttachment,  XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNuserData,         NULL); n++;
  Listfile = XmCreateScrolledList(Fileform, "Listfile", args, n);
  XtAddCallback ( Listfile, XmNdefaultActionCallback, fileCB, (XtPointer) 1);
  XtManageChild(Listfile);

  if ( getcwd( dir, BUFSIZ) )
    loadfile( dir );

  /**************************/


  /* Action area form */
  Actframe = XtVaCreateManagedWidget( "Actframe", 
				      xmFrameWidgetClass, Midform,
			              XmNleftAttachment,  XmATTACH_FORM,
				      XmNrightAttachment, XmATTACH_FORM,
				      XmNbottomAttachment, XmATTACH_FORM,
                                      NULL);

  /* Now we have a Actframe, attach Fileframe to it */
  XtVaSetValues ( Fileframe, XmNbottomAttachment,  XmATTACH_WIDGET,
                             XmNbottomWidget,      Actframe,
                  NULL );

  /* title for frame */
  XtVaCreateManagedWidget("Tool Manager",
                          xmLabelGadgetClass, Actframe,
                          XmNchildType, XmFRAME_TITLE_CHILD,
                          XmNchildVerticalAlignment, XmALIGNMENT_CENTER,
                          NULL);
  
  Actform = XtVaCreateWidget ( "Actform", xmFormWidgetClass, Actframe, 
                                NULL );
  /**********************/

  /* 
  ** The info label 
  */
  Infoframe = XtVaCreateManagedWidget( "Infoframe", 
		    xmFrameWidgetClass, Actform,
		    XmNtopAttachment,   XmATTACH_SELF,
		    XmNleftAttachment,  XmATTACH_SELF,
                    NULL);
  XtVaCreateManagedWidget( "Infolabel",
                  xmLabelWidgetClass, Infoframe,
                  XmNlabelType, XmPIXMAP,
                  XmNlabelPixmap, GetPixmap(PINFO, NORMAL, per->dpy),
                  XmNlabelInsensitivePixmap, GetPixmap(PINFO, NORMAL, per->dpy),
                  NULL);
  
  /* 
  ** Make the graph selection area for actform
  */
  Graphform = XtVaCreateWidget ( "Graphform", xmFormWidgetClass, Actform, 
                    XmNtopAttachment,  XmATTACH_SELF,
                    XmNleftAttachment, XmATTACH_SELF,
                    NULL );

  /* account or portfolio choices */
  Graphpframe = XtVaCreateManagedWidget( "Graphpframe", 
		    xmFrameWidgetClass, Graphform,
                    XmNtopAttachment,  XmATTACH_FORM,
                    XmNleftAttachment, XmATTACH_FORM,
		    NULL);

  XtVaCreateManagedWidget("GraphMode",
                    xmLabelGadgetClass, Graphpframe,
                    XmNchildType, XmFRAME_TITLE_CHILD,
                    NULL);

  Graphprow = XmVaCreateSimpleRadioBox ( Graphpframe, "Graphprow", 0,
                    graph_pselect,
                    XmVaRADIOBUTTON, NULL, NULL, NULL, NULL,
                    XmVaRADIOBUTTON, NULL, NULL, NULL, NULL,
                    NULL);

  if ( (w = XtNameToWidget ( Graphprow, "button_0" )) != NULL)
    XtVaSetValues ( w,
                    XmNlabelType, XmPIXMAP,
                    XmNlabelPixmap, GetPixmap (PACCT, NORMAL, 
                                               per->dpy),
                    NULL);
  if ( (w = XtNameToWidget ( Graphprow, "button_1" )) != NULL)
    XtVaSetValues ( w,
                    XmNlabelType, XmPIXMAP,
                    XmNlabelPixmap, GetPixmap (PACCTS, NORMAL, 
                                               per->dpy),
                    NULL);
  XtManageChild( Graphprow );

  /* horizontal choices */
  Graphhframe = XtVaCreateManagedWidget( "Graphhframe", 
		    xmFrameWidgetClass, Graphform,
                    XmNtopAttachment,  XmATTACH_FORM,
                    XmNleftAttachment, XmATTACH_WIDGET,
                    XmNleftWidget, Graphpframe,
		    NULL);

  XtVaCreateManagedWidget("GraphType",
                    xmLabelGadgetClass, Graphhframe,
                    XmNchildType, XmFRAME_TITLE_CHILD,
                    NULL);

  Graphhrow = XmVaCreateSimpleRadioBox ( Graphhframe, "Graphhrow", 0,
                    graph_hselect,
                    XmVaRADIOBUTTON, NULL, NULL, NULL, NULL,
                    XmVaRADIOBUTTON, NULL, NULL, NULL, NULL,
                    NULL);
  if ( (Graphhbar = XtNameToWidget ( Graphhrow, "button_0" )) != NULL)
    XtVaSetValues ( Graphhbar,
                  XmNlabelType, XmPIXMAP,
                  XmNlabelPixmap, GetPixmap (PBAR, NORMAL, per->dpy),
                  XmNlabelInsensitivePixmap, GetPixmap (PBAR, INSENS, per->dpy),
                  NULL);
  if ( (Graphhline = XtNameToWidget ( Graphhrow, "button_1" )) != NULL)
    XtVaSetValues ( Graphhline,
                    XmNlabelType, XmPIXMAP,
                    XmNlabelPixmap, GetPixmap (PLINE, NORMAL, per->dpy),
                    NULL);
  XtManageChild( Graphhrow );
  
  /* vertical choices */
  Graphvframe = XtVaCreateManagedWidget( "Graphvframe", 
		    xmFrameWidgetClass, Graphform,
                    XmNtopAttachment,  XmATTACH_WIDGET,
                    XmNtopWidget,      Graphpframe,
                    XmNleftAttachment, XmATTACH_FORM,
		    NULL);

  XtVaCreateManagedWidget("GraphVar",
                    xmLabelGadgetClass, Graphvframe,
                    XmNchildType, XmFRAME_TITLE_CHILD,
                    NULL);

  Graphvform  = XtVaCreateWidget ( "Graphvform", xmFormWidgetClass, 
                                   Graphvframe, NULL );


{
  Widget row, form, button;
  Pixel  background;
  Pixmap legendoff, legendon;

  /* Make a scrolled window with a checkbox in it holding all variables
  ** we are willing to plot. */
  Graphvscroll = XtVaCreateManagedWidget ( "Graphvscroll", 
                                 xmScrolledWindowWidgetClass, Graphvform,
                                 XmNscrollingPolicy, XmAUTOMATIC,
                                 XmNtopAttachment, XmATTACH_FORM,
                                 XmNleftAttachment, XmATTACH_FORM,
                                 NULL);
  XtAddCallback ( Graphvscroll, 
                  XmNtraverseObscuredCallback, graphTraverse,
                  NULL );

  row = XtVaCreateWidget ( "Graphvrow", xmRowColumnWidgetClass, Graphvscroll,
                                 XmNnumColumns, NUM_PLOTS,
                                 XmNorientation, XmHORIZONTAL,
                                 XmNpacking, XmPACK_COLUMN,
                                 XmNuserData, 0,
                                 NULL );

  legendoff = XCreatePixmap ( XtDisplay(per->Toplevel),
                              RootWindowOfScreen( XtScreen(per->Toplevel) ),
                              LEGEND_WIDTH, LEGEND_HEIGHT,
                              DefaultDepthOfScreen( XtScreen(per->Toplevel) ) );

  /* Use this color for legend background */
  XtVaGetValues ( Graph, XmNbackground, &background, NULL);

  for (i = 0; i < NUM_PLOTS; i++) {
    char name[10];

    sprintf( name, "form_%d", i);
    form  = XtVaCreateWidget ( name, 
                               xmFormWidgetClass, row, 
                               XmNnavigationType, XmNONE,
                               NULL);

    legendon = XCreatePixmap ( per->dpy,
                               RootWindowOfScreen( XtScreen(per->Toplevel) ),
                               LEGEND_WIDTH, LEGEND_HEIGHT,
                               DefaultDepthOfScreen( XtScreen(per->Toplevel) ) );


    sprintf( name, "button_%d", i);
    button = XtVaCreateManagedWidget ( name,
                          xmToggleButtonWidgetClass, form,
                          XmNindicatorType,  XmN_OF_MANY,
                          XmNlabelType, XmPIXMAP,
                          XmNlabelPixmap, legendoff,
                          XmNlabelInsensitivePixmap, legendoff,
                          XmNselectPixmap, legendon,
                          XmNuserData, i,
                          XmNleftAttachment, XmATTACH_FORM,
                          XmNtopAttachment, XmATTACH_FORM,
                          XmNbottomAttachment, XmATTACH_FORM,
             NULL );
    XtAddCallback ( button, XmNvalueChangedCallback,
                    (XtCallbackProc) graph_vselect, (XtPointer) i );

    makeLegend ( button, LEGEND_INIT, background);

    /* Label describing which plot type this toggle is for */
    sprintf( name, "label_%d", i);
    XtVaCreateManagedWidget ( name,
                          xmLabelWidgetClass, form,
                          XmNtraversalOn, False,
                          XmNleftAttachment, XmATTACH_WIDGET,
                          XmNleftWidget, button,
                          XmNtopAttachment, XmATTACH_FORM,
                          XmNbottomAttachment, XmATTACH_FORM,
                          NULL);

    XtManageChild (form);
  }

  if ( (GraphconstToggle = XtNameToWidget (row, "form_7")) )   /* constant */
     XtSetSensitive ( GraphconstToggle, False);

  XtManageChild (row);

}
  /* Make a form so that the all widgets end up the same height */
  Graphcform  = XtVaCreateWidget ( "Graphcform", 
                                  xmFormWidgetClass, Graphform, 
                                  XmNnavigationType, XmNONE,
                                  XmNsensitive,       False,
                                  XmNtopAttachment,  XmATTACH_WIDGET,
                                  XmNtopWidget,      Graphvframe,
                                  XmNleftAttachment, XmATTACH_FORM,
                NULL );

  Graphvlabel = XtVaCreateManagedWidget( "Graphvlabel", 
			        xmLabelWidgetClass, Graphcform,
                                XmNbottomAttachment, XmATTACH_FORM,
                                XmNtopAttachment,    XmATTACH_FORM,
                                XmNleftAttachment,   XmATTACH_FORM,
               NULL );

  Graphvtext1 = XtVaCreateManagedWidget ("Graphvstart", xmTextFieldWidgetClass, 
                                Graphcform,
                                XmNeditable,         True,
                                XmNtopAttachment,    XmATTACH_FORM,
                                XmNbottomAttachment, XmATTACH_FORM,
                                XmNleftAttachment,   XmATTACH_WIDGET,
                                XmNleftWidget,       Graphvlabel,
                NULL );
  XtAddCallback ( Graphvtext1, XmNactivateCallback, 
                  (XtCallbackProc) const_change, (XtPointer) 0);

  Graphvlabel = XtVaCreateManagedWidget( "Graphvlabel", 
			        xmLabelWidgetClass, Graphcform,
			        XtVaTypedArg, XmNlabelString, XmRString,
			        "@", sizeof("@"),  
                                XmNbottomAttachment, XmATTACH_FORM,
                                XmNtopAttachment,    XmATTACH_FORM,
                                XmNleftAttachment,   XmATTACH_WIDGET,
                                XmNleftWidget,       Graphvtext1,
               NULL );

  Graphvtext2 = XtVaCreateManagedWidget ("Graphvrate", xmTextFieldWidgetClass, 
                                Graphcform,
                                XmNeditable,         True,
                                XmNtopAttachment,    XmATTACH_FORM,
                                XmNbottomAttachment, XmATTACH_FORM,
                                XmNleftAttachment,   XmATTACH_WIDGET,
                                XmNleftWidget,       Graphvlabel,
               NULL );
  XtAddCallback ( Graphvtext2, XmNactivateCallback, 
                    (XtCallbackProc) const_change, (XtPointer) 0);

  XtManageChild( Graphcform );

  /* Units for the scale, weeks or transactions */
  Graphslabel = XtVaCreateManagedWidget( "Graphslabel", 
	       xmLabelWidgetClass, Graphform,
               XmNtopAttachment,     XmATTACH_OPPOSITE_WIDGET,
               XmNtopWidget,         Graphvframe,
               XmNrightAttachment,   XmATTACH_FORM,
               XmNleftAttachment,    XmATTACH_WIDGET,
               XmNleftWidget,        Graphvframe,
               NULL);

  /* The horizontal control can change the labelString */
  XtVaSetValues ( Graphhrow, XmNuserData, Graphslabel, NULL);

  Graphscale = XtVaCreateManagedWidget ("Graphscale", 
               xmScaleWidgetClass,   Graphform, 
               XmNtopAttachment,     XmATTACH_WIDGET,
               XmNtopWidget,         Graphslabel,
               XmNleftAttachment,    XmATTACH_WIDGET,
               XmNleftWidget,        Graphvframe,
               XmNrightAttachment,   XmATTACH_FORM,
               XmNbottomAttachment,  XmATTACH_OPPOSITE_WIDGET,
               XmNbottomWidget,      Graphvframe,
               NULL);
  XtAddCallback ( Graphscale, XmNvalueChangedCallback, 
                    (XtCallbackProc) graph_slide, (XtPointer) 0);
  XtSetSensitive ( Graphscale, False );


  XtManageChild( Graphvform );


  /* 
  ** The total return action area
  */
  Reportform = XtVaCreateWidget ( 
                 "Reportform", xmFormWidgetClass, Actform,
                 XmNtopAttachment,  XmATTACH_SELF,
                 XmNleftAttachment, XmATTACH_SELF,
               NULL );

  ReportInnerform = XtVaCreateWidget ( 
                 "ReportInnerform", xmFormWidgetClass, Reportform,
                 XmNtopAttachment,  XmATTACH_FORM,
                 XmNleftAttachment, XmATTACH_FORM,
               NULL );

  /* Time frame */
  Timeframe = XtVaCreateManagedWidget( 
                "Timeframe", xmFrameWidgetClass, ReportInnerform,
	      	XmNtopAttachment,   XmATTACH_FORM,
	   	XmNleftAttachment,  XmATTACH_FORM,
	      NULL );
  XtVaCreateManagedWidget("TimeLabel", xmLabelGadgetClass, Timeframe,
                          XmNchildType, XmFRAME_TITLE_CHILD, NULL);
  timesbar[0].sens = GetPixmap (PDAY, NORMAL, per->dpy);
  timesbar[1].sens = GetPixmap (PWEEK, NORMAL, per->dpy);
  timesbar[2].sens = GetPixmap (PMONTH, NORMAL, per->dpy);
  timesbar[3].sens = GetPixmap (PQTR, NORMAL, per->dpy);
  timesbar[4].sens = GetPixmap (PYTD, NORMAL, per->dpy);
  timesbar[5].sens = GetPixmap (PYEAR, NORMAL, per->dpy);
  timelbar[0].sens = GetPixmap (P2YEAR, NORMAL, per->dpy);
  timelbar[1].sens = GetPixmap (P3YEAR, NORMAL, per->dpy);
  timelbar[2].sens = GetPixmap (P5YEAR, NORMAL, per->dpy);
  timelbar[3].sens = GetPixmap (P10YEAR, NORMAL, per->dpy);
  timelbar[4].sens = GetPixmap (PFIRST, NORMAL, per->dpy);
  timelbar[5].sens = GetPixmap (PPICK, NORMAL, per->dpy);
  /* Button bar made below */


  /* Report account frame */
  Acctframe = XtVaCreateManagedWidget( 
                "Acctframe", xmFrameWidgetClass, ReportInnerform,
	      	XmNtopAttachment,  XmATTACH_WIDGET,
	      	XmNtopWidget,      Timeframe,
	   	XmNleftAttachment, XmATTACH_FORM,
	      NULL );
  XtVaCreateManagedWidget("AcctLabel", xmLabelGadgetClass, Acctframe,
                          XmNchildType, XmFRAME_TITLE_CHILD, NULL);

  /* account/accounts/portfolio */
  acctbar[0].sens = GetPixmap( PACCT, NORMAL, per->dpy);
  acctbar[1].sens = GetPixmap( PACCTS, NORMAL, per->dpy);
  acctbar[2].sens = GetPixmap( PFOLD, NORMAL, per->dpy);

  Acctform = makeButtonbar ( Acctframe, "Acctform", XmHORIZONTAL, 
                             acctbar, XtNumber(acctbar) );
  XtManageChild ( Acctform );

  /* Report option frame */
  Valframe = XtVaCreateManagedWidget( 
                "Valframe", xmFrameWidgetClass, ReportInnerform,
	      	XmNtopAttachment,   XmATTACH_WIDGET,
	      	XmNtopWidget,       Timeframe,
	   	XmNleftAttachment,  XmATTACH_WIDGET,
	   	XmNleftWidget,      Acctframe,
	      NULL );
  XtVaCreateManagedWidget("ValLabel", xmLabelGadgetClass, Valframe,
                          XmNchildType, XmFRAME_TITLE_CHILD, NULL);
  Valrow = XmVaCreateSimpleCheckBox ( Valframe, "Valrow", reportSetValue,
             XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,
             XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,
             XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,
            NULL);
  XtManageChild (Valrow);

  Reportbut = XtVaCreateManagedWidget(
                  "Reportbut", xmPushButtonWidgetClass, ReportInnerform,
                  XmNlabelType,   XmPIXMAP,
                  XmNlabelPixmap, GetPixmap(PCHECK,NORMAL, per->dpy),
                  XmNlabelInsensitivePixmap, GetPixmap(PCHECK,INSENS, per->dpy),
                  XmNsensitive,   False,
                  XmNleftAttachment,  XmATTACH_POSITION,
                  XmNrightAttachment, XmATTACH_POSITION,
                  XmNtopAttachment, XmATTACH_WIDGET,
                  XmNtopWidget,     Valframe,
                  NULL);
  XtAddCallback (Reportbut, XmNactivateCallback, 
                 (XtCallbackProc) reportGenerate, (XtPointer) NULL);  
  /* One of the params to whether Reportbut is sensitive */
  XtVaSetValues (Acctform, XmNuserData, Reportbut, NULL);

  /* next/previous screen */
  Screenbut = XtVaCreateManagedWidget (
                "Screenbut", xmPushButtonWidgetClass, ReportInnerform,
                XmNlabelType,    XmPIXMAP,
                XmNlabelPixmap,  GetPixmap(PNEXT,NORMAL, per->dpy),
                XmNlabelInsensitivePixmap, GetPixmap(PNEXT,INSENS, per->dpy),
                XmNsensitive,    False,
                XmNbottomAttachment, XmATTACH_FORM,
                XmNrightAttachment, XmATTACH_FORM,
                NULL);
  installToolTips (Screenbut);
  XtAddCallback (Screenbut, XmNactivateCallback, 
                 (XtCallbackProc)reportCustomTime, (XtPointer)ReportInnerform);  
  /* Moved from above so we can pass button widget */
  timelbar[5].userdata = (XtPointer) Screenbut;

  /* One of the params to whether Reportbut is sensitive */
  Timerow = XtVaCreateManagedWidget ("Timerow", xmRowColumnWidgetClass, 
                                     Timeframe, XmNuserData, Reportbut, NULL);
  Timesform = makeButtonbar (Timerow, "Timesform", XmHORIZONTAL, 
                             timesbar, XtNumber(timesbar));
  /* Row 0 of time frames */
  XtVaSetValues (Timesform, XmNuserData, 0, NULL);
  XtManageChild (Timesform);

  Timelform = makeButtonbar (Timerow, "Timelform", XmHORIZONTAL, 
                            timelbar, XtNumber(timelbar));
  /* Row 1 of time frames */
  XtVaSetValues (Timelform, XmNuserData, 1, NULL);
  XtManageChild (Timelform);

  
  XtManageChild (ReportInnerform);

  /* Any report specific initialization */
  reportInit (per->Toplevel, argv[0]);
  /********************/
    

  /* Make the portfolio action area */
  Portform = XtVaCreateWidget ( "Portform", xmFormWidgetClass, Actform, 
                               XmNtopAttachment,  XmATTACH_SELF,
                               XmNleftAttachment, XmATTACH_SELF,
                               NULL );

  /* Row column for the two button areas */
  Portselrow = XtVaCreateWidget ( "Portselrow", xmRowColumnWidgetClass, 
                                  Portform,
                                  XmNtopAttachment,  XmATTACH_FORM,
                                  XmNleftAttachment, XmATTACH_FORM,
                                  XmNrightAttachment,XmATTACH_FORM,
                                  NULL );

  /* Each button area is a frame, rowcolumn and two buttons */
  /* Frame and form for single account buttons */
  Portframe = XtVaCreateManagedWidget( "Portframe", xmFrameWidgetClass,
                                       Portselrow,
                                       NULL);
 
  XtVaCreateManagedWidget("PortAccount",
                          xmLabelGadgetClass, Portframe,
                          XmNchildType, XmFRAME_TITLE_CHILD,
                          NULL);

  Portbutform = XtVaCreateWidget ( "Portbutform", xmFormWidgetClass, 
                                   Portframe,
                                   NULL );

  /* + or - for current account */
  Portpbut =  XtVaCreateManagedWidget ( "Add", 
                 xmPushButtonWidgetClass, Portbutform, 
                 XmNlabelType, XmPIXMAP,
                 XmNlabelPixmap, GetPixmap(PCHECK, NORMAL, per->dpy),
                 XmNlabelInsensitivePixmap, GetPixmap(PCHECK, INSENS, per->dpy),
                 XmNsensitive, True,
                 XmNtopAttachment, XmATTACH_FORM,
                 XmNleftAttachment, XmATTACH_POSITION,
                 XmNrightAttachment, XmATTACH_POSITION,
                 NULL );
  XtAddCallback ( Portpbut, XmNactivateCallback, 
                 (XtCallbackProc) portAddSubList, (XtPointer) 0);  

  Portmbut =  XtVaCreateManagedWidget ( "Remove", 
                    xmPushButtonWidgetClass, Portbutform, 
                    XmNlabelType, XmPIXMAP,
                    XmNlabelPixmap, GetPixmap(PX, NORMAL, per->dpy),
                    XmNlabelInsensitivePixmap, GetPixmap(PX, INSENS, per->dpy),
                    XmNsensitive, False,
                    XmNtopAttachment, XmATTACH_FORM,
                    XmNleftAttachment, XmATTACH_POSITION,
                    XmNrightAttachment, XmATTACH_POSITION,
                    NULL );
  XtAddCallback ( Portmbut, XmNactivateCallback, 
                 (XtCallbackProc) portAddSubList, (XtPointer) 1);  

  XtManageChild ( Portbutform );


  /* Frame and form for all accounts buttons */
  Portframe = XtVaCreateManagedWidget( "Portframe", xmFrameWidgetClass,
                                       Portselrow,
                                       NULL);
 
  XtVaCreateManagedWidget("PortAccounts",
                          xmLabelGadgetClass, Portframe,
                          XmNchildType, XmFRAME_TITLE_CHILD,
                          NULL);

  Portbutform = XtVaCreateWidget ( "Portbutform", xmFormWidgetClass, 
                                   Portframe,
                                   NULL );

  Portabut = XtVaCreateManagedWidget ( "AddAll", 
                 xmPushButtonWidgetClass, Portbutform, 
                 XmNsensitive, True,
                 XmNlabelType, XmPIXMAP,
                 XmNlabelPixmap, GetPixmap(PCHECK, NORMAL, per->dpy),
                 XmNlabelInsensitivePixmap, GetPixmap(PCHECK, INSENS, per->dpy),
                 XmNtopAttachment,        XmATTACH_FORM,
                 XmNleftAttachment,       XmATTACH_POSITION,
                 XmNrightAttachment,      XmATTACH_POSITION,
                 NULL );
  XtAddCallback ( Portabut, XmNactivateCallback, 
                 (XtCallbackProc) portAddSubList, (XtPointer) 2);  

  Portcbut =  XtVaCreateManagedWidget ( "Clear", 
                     xmPushButtonWidgetClass, Portbutform, 
                     XmNsensitive, True,
                     XmNlabelType, XmPIXMAP,
                     XmNlabelPixmap, GetPixmap(PX, NORMAL, per->dpy),
                     XmNlabelInsensitivePixmap, GetPixmap(PX, INSENS, per->dpy),
                     XmNtopAttachment,        XmATTACH_FORM,
                     XmNleftAttachment,       XmATTACH_POSITION,
                     XmNrightAttachment,      XmATTACH_POSITION,
                     NULL );
  XtAddCallback ( Portcbut, XmNactivateCallback, 
                 (XtCallbackProc) portAddSubList, (XtPointer) 3);  

  XtManageChild ( Portbutform );
  XtManageChild ( Portselrow );


  /* Now create the list areas */
  Portscrform = XtVaCreateWidget ( "Portscrform", xmFormWidgetClass, Portform, 
                                 XmNtopAttachment,    XmATTACH_WIDGET,
                                 XmNtopWidget,        Portselrow,
                                 XmNleftAttachment,   XmATTACH_FORM,
                                 XmNrightAttachment,  XmATTACH_FORM,
                                 XmNbottomAttachment, XmATTACH_FORM,
                                 NULL );

  Portpercentlabel = XtVaCreateManagedWidget( "Portpercentlabel", 
			        xmLabelWidgetClass, Portscrform,
                                XmNtopAttachment,    XmATTACH_FORM,
                                XmNleftAttachment,   XmATTACH_FORM,
                                XmNrightAttachment,  XmATTACH_FORM,
                                NULL );
  
  /* Create percentage list window */
  n = 0;
  XtSetArg(args[n], XmNselectionPolicy,  XmSINGLE_SELECT); n++;
  XtSetArg(args[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNtopWidget,        Portpercentlabel); n++;
  XtSetArg(args[n], XmNleftAttachment,   XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNrightAttachment,  XmATTACH_FORM); n++;
  Portpercentlist = XmCreateScrolledList ( Portscrform, "Portpercentlist", 
                                           args, n);

  XtAddCallback ( Portpercentlist, XmNdefaultActionCallback, 
                  (XtCallbackProc) portTraverse, NULL);

  { /* Set list width, because it will not be resizable later */
    XmFontList      fontlist;
    XmFontContext   context;
    XmFontListEntry entry;
    XmFontType fonttype = XmFONT_IS_FONT;
    XFontStruct *font = NULL;

    XtVaGetValues ( Portpercentlist, XmNfontList, &fontlist, NULL);

    if (fontlist) {
      if ( XmFontListInitFontContext ( &context, fontlist) ) {
        entry = XmFontListNextEntry ( context );
        if (entry)
           font = (XFontStruct *) XmFontListEntryGetFont ( entry, &fonttype );
        XmFontListFreeFontContext ( context );
      }
    }

    if (font)
      XtVaSetValues ( Portpercentlist,
                      XmNwidth, 36*font->max_bounds.width,
                      NULL);
  }

  XtManageChild ( Portpercentlist );

  /* Option menu for moving around the percentage tree */
  for (i=0; i < XtNumber(portoptmenu); i++)
    Temp[i] = XmStringCreateLocalized( portoptmenu[i] );

  Portoptmenu = XmVaCreateSimpleOptionMenu( Portscrform, "Portoptmenu", 
                     Temp[0], (KeySym)'P' , 0, (XtCallbackProc) portTraverse,
                     XmVaPUSHBUTTON, Temp[1], 'R', NULL, NULL,
                     XmVaPUSHBUTTON, Temp[2], 'F', NULL, NULL,
                     XmVaPUSHBUTTON, Temp[3], 'A', NULL, NULL,
                     XmNtopAttachment,        XmATTACH_WIDGET,
                     XmNtopWidget,            XtParent(Portpercentlist),
                     XmNleftAttachment,       XmATTACH_FORM,
                     NULL);
  XtManageChild ( Portoptmenu );
  XtSetSensitive ( Portoptmenu, False );

  for (i=0; i < XtNumber(portoptmenu); i++)
    XmStringFree ( Temp[i] );


  Portvaluelabel = XtVaCreateManagedWidget( "Portvaluelabel", 
			        xmLabelWidgetClass, Portscrform,
			        XtVaTypedArg, XmNlabelString, XmRString,
			          "Total Portfolio Value: $0", 
                                  sizeof( "Total Portfolio Value: $0" ),  
                                XmNtopAttachment,    XmATTACH_WIDGET,
                                XmNtopWidget,        Portoptmenu,
                                XmNleftAttachment,   XmATTACH_FORM,
                                XmNrightAttachment,  XmATTACH_FORM,
                                XmNbottomAttachment, XmATTACH_FORM,
                                NULL );
  XtManageChild ( Portscrform );
  
  /********************/
    
  /* Make the calculator action area */
  Calcform = XtVaCreateWidget ( "Calcform", xmFormWidgetClass, Actform,
                                 XmNtopAttachment,        XmATTACH_SELF,
                                 XmNleftAttachment,       XmATTACH_SELF,
                                 NULL );

  for (i=0; i < XtNumber(calcfuncs); i++)
    Temp[i] = XmStringCreateLocalized( calcfuncs[i] );

  Calcoptmenu = XmVaCreateSimpleOptionMenu( Calcform, "Calcoptmenu", 
                     Temp[0], (KeySym)'u' , 0, (XtCallbackProc) calcFuncSel,
                     XmVaPUSHBUTTON, Temp[1], 'F', NULL, NULL,
                     XmVaPUSHBUTTON, Temp[2], 'u', NULL, NULL,
                     XmVaPUSHBUTTON, Temp[3], 'P', NULL, NULL,
                     XmVaPUSHBUTTON, Temp[4], 'e', NULL, NULL,
                     XmVaPUSHBUTTON, Temp[5], 'R', NULL, NULL,
                     XmNtopAttachment,    XmATTACH_FORM,
                     XmNleftAttachment,   XmATTACH_FORM,
                     NULL);
  XtManageChild ( Calcoptmenu );

  for (i=0; i < XtNumber(calcfuncs); i++)
    XmStringFree ( Temp[i] );

  Calcframe = XtVaCreateManagedWidget( "Calcframe", xmFrameWidgetClass,
                                Calcform,
                                XmNtopAttachment,    XmATTACH_WIDGET,
                                XmNtopWidget,        Calcoptmenu,
                                XmNleftAttachment,   XmATTACH_FORM,
                                NULL);

  Calclabel = XtVaCreateManagedWidget( "Calclabel", 
		               xmLabelWidgetClass, Calcframe,
                               XmNlabelType, XmPIXMAP,
                               XmNlabelPixmap, GetPixmap(PFV, NORMAL, per->dpy),
                               NULL );
  

  /* Option menu for selecting the function  */
  Calcrow = XtVaCreateWidget ( "Calcrow", xmRowColumnWidgetClass, Calcform,
                               XmNnavigationType, XmNONE,
                               XmNtopAttachment,  XmATTACH_WIDGET,
                               XmNtopWidget,      Calcframe,
                               XmNleftAttachment, XmATTACH_FORM,
                               NULL );

  /* There are only ever four parameters, we'll switch labels as we need to */
  for (i=0; i < 4; i++) {
    Calclabels[i] = XtVaCreateManagedWidget ( calcparams[i],
                              xmLabelGadgetClass, Calcrow,
                              NULL );
    if ( i < 3 ) {
      /* Text widgets for number entry */
      Calctext[i] = XtVaCreateManagedWidget ( calcparams[i], 
                                xmTextFieldWidgetClass, Calcrow,
                                XmNnavigationType, XmNONE,
                                NULL );
      XtAddCallback ( Calctext[i], XmNactivateCallback, 
                      (XtCallbackProc) calcTextSel, (XtPointer) i ); 
    } else {
      /* Option menu for selecting compounding */
      for (i=0; i < XtNumber(calccompnd); i++)
        Temp[i] = XmStringCreateLocalized( calccompnd[i] );

      Calccmpdmenu = XmVaCreateSimpleOptionMenu( Calcrow, "Calccmpdmenu", 
                         Temp[0], (KeySym)0 , 2, (XtCallbackProc) calcCompSel,
                         XmVaPUSHBUTTON, Temp[1], 'D', NULL, NULL,
                         XmVaPUSHBUTTON, Temp[2], 'W', NULL, NULL,
                         XmVaPUSHBUTTON, Temp[3], 'M', NULL, NULL,
                         XmVaPUSHBUTTON, Temp[4], 'Q', NULL, NULL,
                         XmVaPUSHBUTTON, Temp[5], 'B', NULL, NULL,
                         XmVaPUSHBUTTON, Temp[6], 'A', NULL, NULL,
                         XmVaPUSHBUTTON, Temp[7], '1', NULL, NULL,
                         XmVaPUSHBUTTON, Temp[8], '3', NULL, NULL,
                         XmNbottomAttachment,     XmATTACH_OPPOSITE_WIDGET,
                         XmNbottomWidget,         Calcrow,
                         XmNleftAttachment,       XmATTACH_WIDGET,
                         XmNleftWidget,           Calcrow,
                      NULL);
      XtManageChild ( Calccmpdmenu );

      for (i=0; i < XtNumber(calccompnd); i++)
        XmStringFree ( Temp[i] );
    }
  }
  XtManageChild ( Calcrow );

  /* Get a default of the first function. Side effect is setting labels, text
  ** and result string */
  calcFuncSel ( NULL, 0, NULL ); 

  /********************/

  /* Button area form */
  /* Point to pixmaps we want */
  toolbar[0].sens = GetPixmap( PABOUT, NORMAL, per->dpy);
  toolbar[1].sens = GetPixmap( PEDIT, NORMAL, per->dpy);
  toolbar[1].insens = GetPixmap( PEDIT, INSENS, per->dpy);
  toolbar[2].sens = GetPixmap( PRETURN, NORMAL, per->dpy);
  toolbar[2].insens = GetPixmap( PRETURN, INSENS, per->dpy);
  toolbar[3].sens = GetPixmap( PGRAPH, NORMAL, per->dpy);
  toolbar[3].insens = GetPixmap( PGRAPH, INSENS, per->dpy);
  toolbar[4].sens = GetPixmap( PPORTFOLIO, NORMAL, per->dpy);
  toolbar[4].insens = GetPixmap( PPORTFOLIO, INSENS, per->dpy);
  toolbar[5].sens = GetPixmap( PCALC, NORMAL, per->dpy);
  toolbar[6].sens = GetPixmap( PSTOP, NORMAL, per->dpy);
#ifdef HAVE_LIBDT
  toolbar[7].sens = GetPixmap( PPRINT, NORMAL, per->dpy);
#endif

  toolbar[1].userdata = (XtPointer) XtNameToWidget (Toolmenu, "button_1");
  toolbar[2].userdata = (XtPointer) XtNameToWidget (Toolmenu, "button_2");
  toolbar[3].userdata = (XtPointer) XtNameToWidget (Toolmenu, "button_3");
  toolbar[4].userdata = (XtPointer) XtNameToWidget (Toolmenu, "button_4");

  /* Make the button bar */
  Butform = makeButtonbar ( Workform, "Butform", XmVERTICAL, 
                            toolbar, XtNumber(toolbar) );

  /* Add some constraints */
  XtVaSetValues ( Butform,
                  XmNtopAttachment,    XmATTACH_FORM,
                  XmNrightAttachment,  XmATTACH_FORM,
                  XmNbottomAttachment, XmATTACH_FORM,
                  XmNfractionBase,     XtNumber(toolbar),
                  NULL); 

  /* Temporary setting of globals.  Should be replaced by macro or access 
     routine */
  Editbut = XtNameToWidget (Butform, "Edit");
  Gainbut = XtNameToWidget (Butform, "Gain");
  Graphbut = XtNameToWidget (Butform, "Graphbut");
  Portbut = XtNameToWidget (Butform, "Portfolio");

#if XmVERSION > 1
  /* Now we have a Butform, attach Midform to it */
  XtVaSetValues ( HPane, XmNrightAttachment,  XmATTACH_WIDGET,
                         XmNrightWidget,      Butform,
                  NULL );
#else
  /* Now we have a Butform, attach Midform to it */
  XtVaSetValues ( Midform, XmNrightAttachment,  XmATTACH_WIDGET,
                           XmNrightWidget,      Butform,
                  NULL );
#endif
  /**********************/


  /* Manage children and off we go */
  XtManageChild( Butform ); 
  XtManageChild( Fileform ); 

  XtVaSetValues (Reportform, XmNmappedWhenManaged, False, NULL );
  XtManageChild (Reportform );
  XtVaSetValues (Reportform, XmNresizable, False, NULL );

  XtVaSetValues ( Graphform, XmNmappedWhenManaged, False, NULL );
  XtManageChild( Graphform );

  XtVaSetValues ( Portform, XmNmappedWhenManaged, False, NULL );
  XtManageChild( Portform );

  XtVaSetValues ( Calcform, XmNmappedWhenManaged, False, NULL );
  XtManageChild( Calcform );

  XtManageChild( Actform ); 
  XtManageChild( Midform );
  XtManageChild( VPane );
#if XmVERSION > 1
  XtManageChild( HPane );
#endif
  XtManageChild( Workform );
  XtManageChild( Mainform );

  XtRealizeWidget ( per->Toplevel );

  /* Stop midform from resizing */
  XtVaSetValues (Midform, XmNresizable, False, NULL );

  /* Set Margins of children so they are centered in Actform */
  /* Toplevel must be realized for this to work */
  CenterWidget (Actform, Infoframe);
  CenterWidget (Actform, Reportform);
  CenterWidget (Actform, Graphform);
  CenterWidget (Actform, Portform);
  CenterWidget (Actform, Calcform);

  /* Initialize preferences from resources before any -restore */
  prefInitState(argv[0]);

  if (appdata.restore)
    restoreState (appdata.restore);

  /* Communication with Xquote */
  remoteInit (per->Toplevel);

  /* 
  ** If any options left, they must be data files beginning with -f. 
  ** There may be more than one -f option and each can have zero or more
  ** filenames [-f filename(s) -f filename(s) ...].
  */
  if (argc > 1)
    processFileOption ( argc, argv );

  XtAppMainLoop ( app );

  return (0);
}

void PageCB(Widget w, XtPointer client, XtPointer call)
{
	XmPrintShellCallbackStruct *cbp = (XmPrintShellCallbackStruct *)call;

	per = &Global[1];
	redrawDrawing(per->draw, 1, NULL);
	per = &Global[0];

	cbp->last_page = True;
}

void PrintCB(Widget w, XtPointer client, XtPointer call)
{
#ifdef	XPRINT
#ifdef	HAVE_LIBDT
	DtPrintSetupCallbackStruct	*pbs = call;
	Screen				*scr;
	Display				*pdpy;
	unsigned short			wid, ht;
	XRectangle			rect;
	Widget				ps;
	Arg				al[5];
	int				ac;

	/* Get the info from the widget */
	pdpy = pbs->print_data->print_display;
	scr = DefaultScreenOfDisplay(pdpy);

	/* Initialize the printing global variables */
	per = &Global[1];

	per->dpy = pdpy;
	per->win = RootWindowOfScreen(scr);
	per->_cmap = per->cmap = DefaultColormapOfScreen(scr);
	per->gc = XCreateGC(per->dpy, per->win, 0, NULL);
	per->pctxt = pbs->print_data->print_context;

#ifdef DEBUG
	fprintf(stderr, "Print dft cmap %p\n", per->cmap);	/* Danny */
#endif

#if 0
	/*
	 * Before this can work, we need to create appdata.print_font_list
	 * by means of the print Display, not the video display.
	 */

  /* Get fonts for printing */
	if (XmFontListInitFontContext(&fontContext, appdata.print_font_list) == True) {
		XmFontListEntry entry;
		XmFontType      fonttype =  XmFONT_IS_FONT;
		char *tag;

		while ((entry = XmFontListNextEntry(fontContext)) != NULL) {
			tag = XmFontListEntryGetTag ( entry );
			if ( strcmp( tag, "small") == 0 )
			    per->small = (XFontStruct *)XmFontListEntryGetFont(entry, &fonttype);
			if ( strcmp( tag, "large") == 0 )
			    per->large = (XFontStruct *)XmFontListEntryGetFont(entry, &fonttype);

			if ( tag != NULL )
			    XtFree (tag);
		}

		XmFontListFreeFontContext ( fontContext );
	}
#else
	/* Hack for now */
	per->small = XLoadQueryFont(pdpy,
/*		"-adobe-courier-medium-r-normal--*-120-1200-1200-p-1190-iso8859-1"	*/
		"-adobe-courier-medium-r-normal--*-24-1200-1200-p-1190-iso8859-1"
	);
	per->large = XLoadQueryFont(pdpy,
		"-adobe-courier-medium-r-normal--*-48-1200-1200-p-1190-iso8859-1");
#endif

	if (! XpGetPageDimensions(pdpy, per->pctxt, &wid, &ht, &rect)) {
		/*
		 * FIX ME how do I indicate failure in a decent way ?
		 */
		fprintf(stderr, "Couldn't figure out paper size\n");

		return;
	}

	ac = 0;
	XtSetArg(al[ac], XmNheight, ht); ac++;
	XtSetArg(al[ac], XmNwidth, wid); ac++;
	per->Toplevel = ps = XmPrintSetup(w, scr, "printShell", al, ac);
	XtAddCallback(ps, XmNpageSetupCallback, PageCB, NULL);

	InitPixmaps(ps, DefaultColormapOfScreen(XtScreen(ps)));
	AllocateAllColors();

	XpStartJob(XtDisplay(ps), XPSpool);	/* FIX ME need to change for print to file */

	XFlush(XtDisplay(ps));

	/* Create a widget, draw in it */
	per->draw = XtVaCreateWidget("Graph", xmDrawingAreaWidgetClass, ps, NULL);
	XtManageChild(per->draw);
	XtVaSetValues(per->draw, XmNuserData, per->gc, NULL);	/* Set gc for Xlib drawing */
	setDrawingArea(per->draw);	/* tell drawing routines where the drawing area is */

	XtRealizeWidget(ps);

	per = &Global[0];
#endif
#endif
}

void PrintXpCB(Widget w, XtPointer client, XtPointer call)
{
#ifdef	HAVE_LIBDT
	static Widget	print = NULL;
	Arg	al[10];
	int	ac;

	if (!print) {
		ac = 0;
		print = DtCreatePrintSetupDialog(per->Toplevel, "printDialog", al, ac);
		XtAddCallback(print, DtNprintCallback, PrintCB, NULL);
	}
	XtManageChild(print);
#endif
}

/* ARGSUSED */
void toolCB ( Widget w, XtPointer client_data, XtPointer call_data)
{
  int which = (int) client_data;
  static int last = 0;

  if (which != 6) {  /* Don't ignore/unmap if it's the quit action */
    if (which == last)
      return;
    last = which;

    XtSetMappedWhenManaged (Reportform, False);
    XtSetMappedWhenManaged (Graphform, False);
    XtSetMappedWhenManaged (Portform,  False);
    XtSetMappedWhenManaged (Calcform,  False);
    XtSetMappedWhenManaged (Infoframe, False);
  }

  switch ( which ) {

  case 2:   /* Return report */
            setLastGraph(NOTHING);
            XtSetMappedWhenManaged ( Reportform, True );
            break;
  case 3:   /* Graph */
            setLastGraph(PLOT);
            XtSetMappedWhenManaged ( Graphform, True );
            break;
  case 4:   /* Portfolio */
            setLastGraph(PORTFOLIO);
            XtSetMappedWhenManaged ( Portform, True );
            break;
  case 5:   /* Financial Calculator */
            setLastGraph(FUNCCALC);
            XtSetMappedWhenManaged ( Calcform, True );
            break;
  case 6:   /* Quit */
            fileCB (w, (XtPointer)6, (XtPointer)NULL);
            break;

  case 7:	/* Print something */
		PrintXpCB(w, NULL, NULL);
		break;

  case 0:   /* About */
  case 1:   /* Edit */
  default:
            setLastGraph(NOTHING);
            XtSetMappedWhenManaged ( Infoframe, True );
            break;
  } 

  /* make new menu the default. */
  {
    extern Widget Toolmenu;
    WidgetList buttons;
    int numbuttons, i;

    XtVaGetValues ( Toolmenu, 
                    XmNchildren, &buttons, 
                    XmNnumChildren, &numbuttons, 
                    NULL );

    /* Don't touch the option buttons. This works because there is a separator 
    ** in the menu before the option buttons. */
    for (i = 0; i < numbuttons; i++)
      XmToggleButtonSetState ( buttons[i], (which == i)?True:False, False);

    /* If plot is on, turn on plot options */
    graphSense( which==3 );
     
  }

  /* sigh */
  drawDrawingArea();
}
