/*
 * Copyright (c) 1994, 1995, 1996, 1997, 1998, 1999, 2000, Mark Buser.
 * Copyright (c) 2003, 2004, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/trans.h,v 2.15 2004/04/18 10:58:37 danny Exp $
 */
#define T_BUY 	      1  /* For access routines, types of transactions */
#define T_SELL        2
#define T_DIST        3
#define T_PRICE       4
#define T_SPLIT       5
#define T_CURR        6
#define T_PERC        7
#define T_TITLE       8
#define T_TICK        9
#define T_CTICK      10
#define T_REINV      11
#define T_ESOP       12

#define T_NEW      1      /* For rd_trans, start new transaction history */
#define T_SAME     0      /* For rd_trans, add to existing history */

/* Access routines */
int AreTrans();           /* Are there any transactions, returns how many */

/* Parse transaction line, new file if int is non-zero */
char *rd_trans(int, char *, int);

void *GetTrans();    /* Return pointer to current transactions, NULL on none */

char *GetTransTitle();      /* Return title, NULL on none                */
char *GetTransTicker();     /* Return ticker symbol, NULL on none        */ 
char *GetTransCurrTicker(); /* Return exchange rate ticker, NULL on none */ 
char *GetTransETicker();     /* Return ticker modifier, NULL on none        */ 
char *GetTransCurrETicker(); /* Return exchange rate modifier, NULL on none */ 

/* The first param of the following is pointer to a TRANS structure,
** the second, the tranaction number of interest.                     */

char *GetTransDate( void *, int);    /* Date of transaction...as char */ 
long GetTransLDate( void *, int);    /* Date of transaction...as long */ 
int  GetTransType( void *, int);     /* Type of transaction e.g.T_BUY */
double GetTransNav( void *, int);    /* NAV of transaction            */
double GetTransCurrency( void *, int);  /* Currency exchange rate     */
double GetTransShares( void *, int); /* Number of transaction shares  */
double GetTransLoad( void *, int);   /* Load of transaction           */

#define TRANS_REINVEST 1
int GetTransFlag (void *, int, int); /* Value of requested flag       */

#define TRANS_MAJOR 1
#define TRANS_MINOR 2
int GetTransSplit (void *, int, int);/* Value of requested split.     */
long GetLastLDate(int acc);

