/*
 * Copyright (c) 1996, 1998, Mark Buser.
 * Copyright (c) 2003, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/graphP.h,v 2.7 2003/11/19 19:35:10 danny Exp $
 */
#define MAVGS       (0x1F << (PRICE_MAVG-1))
#define CONSTS      (1 << (CONST-1))

#define PLOT_ACTIVE(plot) ((graphVar->valid) & (1 << (plot-1)))

#define PIXELS_PER_VDIV 20
#define PIXELS_PER_HDIV 50

#define MAX_OR_MIN(value,scale)    {      \
        if (plot->min > (value)*(scale))  \
           plot->min = (value)*(scale);   \
        if (plot->max < (value)*(scale))  \
           plot->max = (value)*(scale); }

struct line_attrib {
  Pixel color;
  char *dash;
  unsigned int width;
  int style;
};

struct attrib {
  Dimension height;
  Dimension width;
  Dimension zero;
  int       min;
  int       max;
  int       range;
  int       num_pnts;
  long      daymin;
  long      dayrange;
  int       by_trans;
  int       scale;
  int       mov_window;
};

struct trans_value {
  double value[NUM_PLOTS];
};
