/*
 * Copyright (c) 1995, 1996, 1997, Mark Buser.
 * Copyright (c) 2003, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/askuser.c,v 2.3 2003/11/19 19:35:09 danny Exp $
 */
#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/MessageB.h>

#include "askuser.h"

/* ARGSUSED */
static void response ( Widget widget, 
                XtPointer client_data, 
                XtPointer call_data )
{
  int *answer = (int *) client_data;
  XmAnyCallbackStruct *cbs = (XmAnyCallbackStruct *) call_data;

  if (cbs->reason == XmCR_OK)
    *answer = YES;
  else if (cbs->reason == XmCR_CANCEL)
    *answer = NO;
}


int AskUser ( Widget parent,
              char   *question, 
              char   *ans1,
              char   *ans2,
              int    default_ans )
{
  static Widget dialog = NULL;
  XmString text, yes, no;
  static int answer;

  if (!dialog) {
    dialog = XmCreateQuestionDialog (parent, "alert", NULL, 0);
    XtVaSetValues ( dialog, XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
                    NULL );
    XtSetSensitive ( XmMessageBoxGetChild ( dialog, XmDIALOG_HELP_BUTTON),
                     False );
    XtAddCallback (dialog, XmNokCallback, response, &answer);
    XtAddCallback (dialog, XmNcancelCallback, response, &answer);
  }

  answer = 0;

  text = XmStringCreateLocalized ( question );
  yes = XmStringCreateLocalized ( ans1 );
  no = XmStringCreateLocalized ( ans2 );
  XtVaSetValues ( dialog, XmNmessageString,     text,
                          XmNokLabelString,     yes,
                          XmNcancelLabelString, no,
                          XmNdefaultButtonType, (default_ans == YES)?
                          XmDIALOG_OK_BUTTON : XmDIALOG_CANCEL_BUTTON,
                  NULL );
  XmStringFree ( text );
  XmStringFree ( yes );
  XmStringFree ( no );

  XtManageChild ( dialog );
  XtPopup ( XtParent (dialog), XtGrabNone );

  while (answer == 0)
   XtAppProcessEvent ( XtWidgetToApplicationContext(dialog), XtIMAll);

  XtUnmanageChild ( dialog );
  XtPopdown ( XtParent(dialog) );

  return answer;
}
