/* $Id: pante.c,v 4.1 1995/08/10 20:37:01 lupus Exp lupus $ */

#include <stdlib.h>
#include <string.h>
#include "xfinans.h"
#include "str.h"
#include "post.h"
#include "date.h"
#include "allocmem.h"

/* beregning af rente/afdrag paa amortisations-pantebreve */
/* tekst-format: rentefod,terminsstoerrelse. */

extern char *postString[];

long nextTermin(long termin) {  /* adderer 6 mnd. til datoen termin */
  return incrHalfyear(termin);
}
  
void renteTermin(char *post, double *rent, double *term) {
  char buf[256];
  char *termstr;
  int t=0;

  zeroAddStrncpy(buf,post,255);
  while(*(buf+t)!='\0' && *(buf+t)!=',')
    t++;
  termstr=buf+t+1;
  *(buf+t)='\0';
  *rent=atof(nocomma(buf));
  *term=atof(nocomma(termstr));
}

char **pantePostStrings(struct postering *p) {
  double rentefod, termin, rente, afdrag;
  long dato;
  double restgaeld;
  int i, j, si, k;
  char buf[256];

  renteTermin(p->tekst, &rentefod, &termin);
  restgaeld=p->bel;
  dato=p->dato;
  /* printf("%9.2f %9.2f %9.2f\n", rentefod, termin, restgaeld); */

  for(k=0;restgaeld>0.0 && k<200;k++) {
      sprintf(buf, "%s  %9.2f", dateString(dato), restgaeld );
      rente=restgaeld*rentefod/200.0;  /* halvaarlig renteberegning */
      afdrag=termin-rente;
      /* printf("%06D  %9.2f  %9.2f  %9.2f\n", dato, restgaeld, rente, afdrag ); */
      restgaeld-=afdrag;
      if(restgaeld<0) {
	afdrag+=restgaeld;
	restgaeld=0;
	termin=rente+afdrag;
      }
      dato=nextTermin(dato);
      sprintf(buf+strlen(buf), "  %9.2f  %9.2f  %9.2f  %9.2f", rente, afdrag, termin, restgaeld);
      if(postString[k])
	free(postString[k]);
      postString[k]=(char *)AllocateMemory(TRANSACTION_MAX_WIDTH);
      zeroAddStrncpy(postString[k], buf, TRANSACTION_MAX_WIDTH-1);
  }
  if(postString[k])
    free(postString[k]);
  postString[k]=0;

  return postString;
}
