/* $Id: newCategory.c,v 4.2 1996/01/16 21:50:45 lupus Exp lupus $ */

#include "programConfig.h"

#if CATEGORY_SUPPORT

#include <string.h>
#include <stdio.h>

#include "newCategoryp.h"
#include "newCategory.h"
#include "xfError.h"
#include "country.h"
#include "str.h"
#include "focus.h"
#include "window.h"
#include "category.h"
#include "categoryWindow.h"

#define BUTW 60
#define CAT_NAME_WIDTH 390
#define CAT_NUMBER_WIDTH BUTW
#define CAT_DEFINITION_WIDTH 440
#define CAT_DEFINITION_HEIGHT 120

static Widget newCategoryShell, newCategoryForm, 
  newCategoryNumbLabel, newCategoryNumbInput,
  newCategoryNumbIncr,  newCategoryNumbDecr, 
  newCategoryNameLabel, newCategoryNameInput,
  newCategoryDescLabel, newCategoryDescInput,
  newCategoryOk, newCategoryCancel;

static int popup=0;

void createNewCategoryWidgets(void) {
  static int done=0;
  
  if(done)
    return;
  done=1;

  newCategoryShell = XtVaCreatePopupShell (
				      "newCategoryShell",
				      transientShellWidgetClass,
				      topLevel,
				      XtNtitle, NEW_CATEGORY_TITLE,
				      NULL );
  
  newCategoryForm = XtVaCreateManagedWidget(
				       "newCategoryForm",
				       formWidgetClass,
				       newCategoryShell,
				       NULL);
  
  newCategoryNumbLabel = XtVaCreateManagedWidget(
				 "newCategoryNameLabel",
				 labelWidgetClass,
				 newCategoryForm,
				 XtNlabel, NUMBER_LABEL,
				 NULL);
  
  newCategoryNumbInput = XtVaCreateManagedWidget(
				     "newCategoryNameInput",
				     asciiTextWidgetClass,
				     newCategoryForm,
				     XtNeditType, XawtextEdit,
				     XtNwidth, CAT_NUMBER_WIDTH,
				     XtNfromHoriz, newCategoryNumbLabel,
				     NULL);

  newCategoryNumbIncr = XtVaCreateManagedWidget(
				     "newCategoryNumbIncr",
				     commandWidgetClass,
				     newCategoryForm,
				     XtNlabel, INCR,
				     XtNwidth, 35,
				     XtNfromHoriz, newCategoryNumbInput,
				     NULL);

  newCategoryNumbDecr = XtVaCreateManagedWidget(
				     "newCategoryNumbDecr",
				     commandWidgetClass,
				     newCategoryForm,
				     XtNlabel, DECR,
				     XtNwidth, 35,
				     XtNfromHoriz, newCategoryNumbIncr,
				     NULL);

  newCategoryNameLabel = XtVaCreateManagedWidget(
				     "newCategoryNameLabel",
				     labelWidgetClass,
				     newCategoryForm,
				     XtNlabel, NAME,
				     XtNfromVert, newCategoryNumbInput,
				     NULL);
  
  newCategoryNameInput = XtVaCreateManagedWidget(
				     "newCategoryNameInput",
				     asciiTextWidgetClass,
				     newCategoryForm,
				     XtNeditType, XawtextEdit,
				     XtNwidth, CAT_NAME_WIDTH,
 				     XtNfromVert, newCategoryNumbInput,
				     XtNfromHoriz, newCategoryNameLabel,
				     NULL);

  newCategoryDescLabel = XtVaCreateManagedWidget(
				     "newCategoryDescLabel",
				     labelWidgetClass,
				     newCategoryForm,
				     XtNlabel, DEFINITION_LABEL,
				     XtNfromVert, newCategoryNameInput,
				     NULL);
  
  newCategoryDescInput = XtVaCreateManagedWidget(
				     "newCategoryDescInput",
				     asciiTextWidgetClass,
				     newCategoryForm,
				     XtNeditType, XawtextEdit,
				     XtNwidth, CAT_DEFINITION_WIDTH,
				     XtNheight, CAT_DEFINITION_HEIGHT,
				     XtNfromVert, newCategoryDescLabel,
				     NULL);

  newCategoryOk = XtVaCreateManagedWidget(
				     "newCategoryOk",
				     commandWidgetClass,
				     newCategoryForm,
				     XtNlabel, CONFIRM_LABEL,
				     XtNwidth, BUTW,
				     XtNfromVert, newCategoryDescInput,
				     NULL);

  newCategoryCancel = XtVaCreateManagedWidget(
				     "newCategoryCancel",
				     commandWidgetClass,
				     newCategoryForm,
				     XtNlabel, CANCEL_LABEL,
				     XtNwidth, BUTW,
				     XtNfromVert, newCategoryDescInput,
				     XtNfromHoriz, newCategoryOk,
				     NULL);

  saveFocusInfo(newCategoryNumbInput, newCategoryNameInput, newCategoryForm, newCategoryOk, 1);
  saveFocusInfo(newCategoryNameInput, newCategoryDescInput, newCategoryForm, newCategoryOk, 0);
  saveFocusInfo(newCategoryDescInput, newCategoryNumbInput, newCategoryForm, newCategoryOk, 0);
  
  XtAddCallback(newCategoryCancel, XtNcallback, NewCategoryClose, topLevel);
  XtAddCallback(newCategoryOk, XtNcallback, NewCategoryOk, topLevel);
  XtAddCallback(newCategoryNumbIncr, XtNcallback, IncrNum, newCategoryNumbInput);
  XtAddCallback(newCategoryNumbDecr, XtNcallback, DecrNum, newCategoryNumbInput);

}

/* ========================================================== */     
void NewCategoryPopup(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  if( !popup ) {
    createNewCategoryWidgets();

    XtPopup(newCategoryShell, XtGrabNone);
    popup=1;
    jumpTo(newCategoryNumbInput);
  }
  else {
    XtPopdown(newCategoryShell);
    popup=0;
  }
}

void NewCategoryClose(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtPopdown(newCategoryShell);
  popup=0;
}

void NewCategoryOk(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  insertCategory(NewCategoryGetValue());
  updateCategoryWindowList();
  saveCategories();
/*
  XtPopdown(newCategoryShell);
  popup=0;
*/
}

void NewCategorySetValue(category *c) {
  char buf[256];

  createNewCategoryWidgets();

  sprintf(buf, "%d", c->number);
  XtVaSetValues(newCategoryNumbInput, 
		XtNstring, buf,
		NULL); 

  XtVaSetValues(newCategoryNameInput, 
		XtNstring, c->name,
		NULL); 
  
  XtVaSetValues(newCategoryDescInput, 
		XtNstring, c->definition,
		NULL); 
}

category *NewCategoryGetValue() {
  static category c;
  String p;
  int l;

  createNewCategoryWidgets();

  XtVaGetValues(newCategoryNumbInput, 
		XtNstring, &p,
		NULL); 

  c.number=atoi(p);

  XtVaGetValues(newCategoryNameInput, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(c.name,p,CAT_NAME_LENGTH-1);

  XtVaGetValues(newCategoryDescInput, 
		XtNstring, &p,
		NULL); 
  l=strlen(p);
  c.definition=(char *)AllocateMemory(l+1);
  zeroAddStrncpy(c.definition,p,l);

  return &c;
}

#endif
