/*	$NetBSD: wiconfig.c,v 1.25 2002/04/09 02:56:17 thorpej Exp $	*/
/*
 * Copyright (c) 1997, 1998, 1999
 *	Bill Paul <wpaul@ctr.columbia.edu>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Bill Paul.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY Bill Paul AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL Bill Paul OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 *	From: Id: wicontrol.c,v 1.6 1999/05/22 16:12:49 wpaul Exp $
 */

/*
 * $Id: wicontrol.c,v 1.5 2002/08/11 14:18:51 iseki Exp $
 *
 * NOTE:
 *	current version of wistumbler will not reset the interface flags
 *	when it terminate. if it reset the flags, it will make a very
 *	race condition in some environment (ex. running dhclient).
 */

/*
 * $Id: wicontrol.c,v 1.7 2003/11/23 03:15:17 pancake Exp $
 *
 * add autoget_wifi
 * recode wi_init
 */

#include <sys/types.h>
#include <sys/cdefs.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/ioctl.h>

#include <net/if.h>
#include <sys/sockio.h>
#include <net/if_media.h>
#include <ifaddrs.h>
#include "stumbler.h"

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <err.h>

#include "gpscontrol.h"

#if !defined(lint)
__COPYRIGHT(
"@(#) Copyright (c) 1997, 1998, 1999 \
	Bill Paul. All rights reserved.");
__RCSID("$NetBSD: wiconfig.c,v 1.25 2002/04/09 02:56:17 thorpej Exp $");
#endif

int wi_apscan			__P((char *));
static int  get_if_flags	__P((int, const char *));
static int  set_if_flags	__P((int, const char *, int));
static int  wi_setval		__P((char *, struct wi_req *));

struct access_point *access_points[MAX_APS];
static struct access_point *lookup_bssid	__P((struct wi_apinfo *));
void print_aps					__P((FILE *));
int keep_flags;			/* interface's flags, UP/DOWN */

char *autoget_wifi(void)
{
	struct ifaddrs *ifa=NULL;
	char *iface=0;
	struct ifmediareq ifmr;
	int s;

	getifaddrs(&ifa);
	s=socket(AF_INET,SOCK_DGRAM,0);
	do {
		memset(&ifmr,0,sizeof(ifmr));
		strncpy(ifmr.ifm_name,ifa->ifa_name,sizeof(ifmr.ifm_name));
		if (ioctl(s,SIOCGIFMEDIA,(caddr_t)&ifmr)!=-1)
		{
			if (ifmr.ifm_current&IFM_IEEE80211)
			{
			iface=ifa->ifa_name;
			ifa=0;
			}	
		}
		if (ifa)
			ifa=ifa->ifa_next;
	} while(ifa);
	close(s);

	return iface;
}

static int get_if_flags(s, name)
	int		s;
	const char	*name;
{
	struct ifreq	ifreq;

	strncpy(ifreq.ifr_name, name, sizeof(ifreq.ifr_name));
	if (ioctl(s, SIOCGIFFLAGS, (caddr_t)&ifreq) == -1)
	{
		if (App.devok)
		{
			perror("SIOCGIFFLAGS");
			wistumbler_gui_error("Device not found!");
		}
		App.devok = false;
		return -1;
	} else {
		App.devok = true;
	}

	return ifreq.ifr_flags;
}

static int set_if_flags(s, name, flags)
	int		s;
	const char	*name;
	int		flags;
{
	struct ifreq ifreq;

	ifreq.ifr_flags = flags;
	strncpy(ifreq.ifr_name, name, sizeof(ifreq.ifr_name));
	if (ioctl(s, SIOCSIFFLAGS, (caddr_t)&ifreq) == -1) {
		perror("SIOCSIFFLAGS");
		return -1;
	}

	return 0;
}

int wi_init(char *iface)
{
	int i,ret=0,s;

	if (iface==NULL) return 0;

	s = socket(AF_INET, SOCK_DGRAM, 0);
	if (s == -1) {
		perror("socket");
		return -1;
	}
	for (i=0,ret=1;i<3;i++)
	{
	  if (i) {
		printf("Sleeping a wifi...(%d)\n",ret);
		sleep(1); /* XXX NetBSD KERNEL SEGFAULT!! */
	  }
	  ret = get_if_flags(s, iface);
	  //if (ret==-1) continue; /* If can't get flags go up again */

	  if ( (ret!=-1) && ((ret & IFF_UP)==0) )
	  {
		printf("Setting iface up...\n");
		ret=set_if_flags(s, iface, ret | IFF_UP);
		sleep(4);
	  }
	  if (ret!=-1) {
		printf("All OK: Flags saved.\n");
		keep_flags=ret;
		ret=0;
		break;
	  }
	}
	close(s);

	return ret;
}

int wi_finish(iface)
	char			*iface;
{
	int		s;

	if (!iface) return 0;

	s = socket(AF_INET, SOCK_DGRAM, 0);
	if (s == -1) {
		perror("socket");
		return -1;
	}
	if (keep_flags != -1)
		set_if_flags(s, iface, keep_flags);

	/* DONE : close socket */
	close(s);
	return 0;
}

void nullize_aps()
{
	/* TODO : must be called: ERROR!! AND SHOW ANY ERROR! */
	int i;
	for ( i = 0; i<MAX_APS; i++ )
	{
			if (access_points[i]!=NULL)
			{
			access_points[i]->cur_receive = 0;
			access_points[i]->wi_apinfo.quality = 0;
			access_points[i]->wi_apinfo.signal = 0;
			}
	}
}

int wi_apscan(iface)
	char			*iface;
{
	struct wi_req		wreq;
	struct ifreq		ifr;
	int			s;
	int			naps;
	int			retries = 10;
	struct wi_apinfo	*w;
	int			i;
	int			fail;
	int			flags;

	s = socket(AF_INET, SOCK_DGRAM, 0);

	if (s == -1) {
		perror("socket");
		nullize_aps();
		return -1;
	}

	/*
	flags = get_if_flags(s, iface);
	if (flags == -1) {
		perror("GETIFFLAGS");
		nullize_aps();
		return -1;
	}
	*/

	/*
	if ((flags & IFF_UP) == 0 &&
	    set_if_flags(s, iface, flags | IFF_UP) == -1) {
	    	perror("IFUP");
		nullize_aps();
		return -1;
	}
	*/

	memset((char *)&wreq, 0, sizeof(wreq));

	wreq.wi_type = WI_RID_SCAN_APS;
	wreq.wi_len = 4;
	/* note chan. 1 is the least significant bit */
	wreq.wi_val[0] = 0x3fff;	/* 1 bit per channel, 1-14 */
	wreq.wi_val[1] = 0xf;		/* tx rate */

	/* write the request */
	if (wi_setval(iface, &wreq) < 0)
	{
		perror("WISETVAL");
		close(s); // DONE 
		nullize_aps();
		return -1;
	}

	/* now poll for a result */
	memset((char *)&wreq, 0, sizeof(wreq));

	wreq.wi_type = WI_RID_READ_APS;
	wreq.wi_len  = WI_MAX_DATALEN;

	/* we have to do this ourself as opposed to
	 * using getval, because we cannot bail if
 	 * the ioctl fails
	 */
	memset((char *)&ifr, 0, sizeof(ifr));
        strcpy(ifr.ifr_name, iface);
        ifr.ifr_data = (caddr_t)&wreq;

	while ( ioctl(s, SIOCGWAVELAN, &ifr) != 0)
	{
		if (retries--<0)
		{
			perror("SIOCGWAVELAN");
	//		if ((flags & IFF_UP) == 0)
	//	    	(void) set_if_flags(s, iface, flags | IFF_UP);
			close(s);
			nullize_aps();
			return -1;
			break;
		}

		if (errno==EINPROGRESS)
		{
			usleep(1000); // 300ms
			continue;
		}
	}

	naps = *(int *)wreq.wi_val;

	w =  (struct wi_apinfo *)(((char *)&wreq.wi_val) + sizeof(int));

	for (i=naps;i<MAX_APS;i++)
	{
		if (access_points[i]!=NULL)
		access_points[i]->cur_receive=0;
	}

	for ( i = 0; i < naps; i++, w++) 
	{
		struct	access_point *ap;
		int	new_ap = 0;
		int	j;

		ap = lookup_bssid(w);
		if ( ap == NULL )
		{
			printf("NEW ONE! :D\n");
			/* this is a new entry */
			new_ap = 1;
			// TODO beep on new APs :)
			for (j = 0; j < MAX_APS; j++)
			{
				if (access_points[j] == NULL)
				{
					ap = malloc(sizeof(struct access_point));
					bzero((char *)ap, sizeof(ap));
					access_points[j] = ap;
					access_points[j]->cur_receive=1;
					break;
				} 
			}
                }

		if (ap == NULL)
		{
			/* XXX should malloc instead of using array XXX */
			printf("3.3");
			fprintf(stderr, "Table full\n");
		//	if ((flags & IFF_UP) == 0)
		//	    (void) set_if_flags(s, iface, flags  | IFF_UP);
			close(s);
			return -1;
		}

		if (new_ap)
		{
			time((time_t *)&ap->first);
			ap->wi_apinfo.namelen = w->namelen;
			w->name[w->namelen]=0;
			strcpy(ap->wi_apinfo.name, w->name);//, w->namelen);

			printf("> %d %s\n",i,ap->wi_apinfo.name);

			for (j = 0; j < 6; j++)
				ap->wi_apinfo.bssid[j] = w->bssid[j];

			ap->wi_apinfo.channel = w->channel;
			ap->wi_apinfo.interval = w->interval;
			ap->wi_apinfo.capinfo = w->capinfo;
		}
		time((time_t *)&ap->last);
		ap->wi_apinfo.capinfo = w->capinfo; //
		ap->wi_apinfo.quality = w->quality;
		ap->wi_apinfo.signal = w->signal;
		ap->wi_apinfo.noise = w->noise;
		ap->wi_apinfo.rate = w->rate;
		ap->cur_receive = (w->signal)?1:0;

		/* copy current position from GPS receiver */
		if (Cfg.gps)
		{
			if (dir.Ndeg && dir.Edeg)
			{
				ap->dir.N = dir.N;
				ap->dir.Ndeg = dir.Ndeg;
				ap->dir.E = dir.E;
				ap->dir.Edeg = dir.Edeg;
			}
		}
	}

	close(s);

	return 0;
}

static int wi_setval(iface, wreq)
	char			*iface;
	struct wi_req		*wreq;
{
	struct ifreq		ifr;
	int			s;

	bzero((char *)&ifr, sizeof(ifr));

	strcpy(ifr.ifr_name, iface);
	ifr.ifr_data = (caddr_t)wreq;

	s = socket(AF_INET, SOCK_DGRAM, 0);

	if (s == -1) {
		perror("socket");
		return -1;
	}

	if (ioctl(s, SIOCSWAVELAN, &ifr) == -1) {
		perror("SIOCSWAVELAN");
		return -1;
	}

	close(s);

	return 0;
}

static struct access_point *
lookup_bssid(ap)
	struct wi_apinfo 	*ap;
{
	int i,j;

	for (i = 0; i < MAX_APS; i++)
	{
		if (access_points[i] == NULL)
			continue;
		for (j = 0; j < 6; j++)
		{
			if (access_points[i]->wi_apinfo.bssid[j] != ap->bssid[j])
				break;
		}
		if (j == 6)
			return(access_points[i]);
	}
	/* not found */
	return(NULL);
}

void
print_aps(file)
	FILE *file;
{
	int			i, j;
	float			rate;
	struct tm		*tm;
	struct access_point	*w;
	int    any=FALSE;

	if (file == stdout)
	printf("\e[2J");

	for (i = 0; i < MAX_APS; i++)
	{
		if (access_points[i] == NULL)
			continue;
		if (any==FALSE)
		{
		fprintf(file, "%-23s\t%-17s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\n",
			"SSID", "BSSID", "Channel", "Signal", "Interval", "Capinfo",
			"First", "Last", "Rate", "Position");
		any=TRUE;
		}
		w = access_points[i];

		for (j = 0; j < w->wi_apinfo.namelen; j++) {
			fprintf(file, "%c", w->wi_apinfo.name[j]);
		}
		while (j < 23)
			fputc(' ', file), j++;

		fprintf(file, "\t%02x:%02x:%02x:%02x:%02x:%02x",
			w->wi_apinfo.bssid[0]&0xff, w->wi_apinfo.bssid[1]&0xff,
			w->wi_apinfo.bssid[2]&0xff, w->wi_apinfo.bssid[3]&0xff,
			w->wi_apinfo.bssid[4]&0xff, w->wi_apinfo.bssid[5]&0xff);
		fprintf(file, "\t%d", w->wi_apinfo.channel);
		fprintf(file, "\t%d%%", w->wi_apinfo.signal);
		fprintf(file, "\t%dmS", w->wi_apinfo.interval); 

		if ((w->wi_apinfo.capinfo &
		    (IEEE80211_CAPINFO_ESS | IEEE80211_CAPINFO_PRIVACY)) ==
		    (IEEE80211_CAPINFO_ESS | IEEE80211_CAPINFO_PRIVACY))
			fprintf(file, "\t\tESS/WEP");
		else if (w->wi_apinfo.capinfo & IEEE80211_CAPINFO_ESS)
			fprintf(file, "\t\tESS");
		else if (w->wi_apinfo.capinfo & IEEE80211_CAPINFO_PRIVACY)
			fprintf(file, "\t\tWEP");
		else
			fprintf(file, "\t\tUnknown");

		tm = localtime((const time_t *)&w->first);
		fprintf(file, "\t%2.2d:%2.2d", tm->tm_hour, tm->tm_min);
		tm = localtime((const time_t *)&w->last);
		fprintf(file, "\t%2.2d:%2.2d", tm->tm_hour, tm->tm_min);

		rate=(float)w->wi_apinfo.rate;
#if 0
		switch (w->wi_apinfo.rate) {
		case WI_APRATE_1:
			rate = 1;
			break;
		case WI_APRATE_2:
			rate = 2;
			break;
		case WI_APRATE_5:
			rate = 5.5;
			break;
		case WI_APRATE_11:
			rate = 11;
			break;
		case WI_APRATE_0:
		default:
			rate = 0;
			break;
		}
#endif
		fprintf(file, "\t");

		if (rate != 0)
			fprintf(file, "%g", rate);
		else    fprintf(file, "--");

		if (Cfg.gps)
			fprintf(file, "\t%c %f\t%c %f",
				w->dir.N, w->dir.Ndeg, w->dir.E, w->dir.Edeg);
		fprintf(file, "\n");
	}
}
